/***************************************************************************
                    noslot.cpp - some no slot functions
                             -------------------                                         

    version              :                                   
    begin                : 20 Jul 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include "kdevelop.h"
#include <iostream.h>
#include <kmsgbox.h>


void KDevelop::refreshTrees(){
  if (!project){
    return; // no project
  }
  
  class_tree->refresh(&prj);
  refreshClassCombos();
  log_file_tree->refresh(&prj);
  real_file_tree->refresh(prj.dir);
  real_file_tree->setExpandLevel(1);
}
 

int KDevelop::getTabLocation(QString filename){
  
  if(filename.right(4) == ".cpp" || filename.right(3) == ".cc" || filename.right(2) == ".C"
     || filename.right(2) == ".c"){
    return CPP;
  }
  else{
    return HEADER;
  }
  
}
void KDevelop::switchToFile(QString filename){
  TEditInfo* info;
  TEditInfo* actual_info;

  // check if the file exists
  if(!QFile::exists(filename) && filename != "Untitled.h" && filename != "Untitled.cpp"){
    KMsgBox::message(this,"Attention",filename +"\n\nFile does not exist!");
    return;
  }
  

  // set the correct edit_widget
  if (getTabLocation(filename) == HEADER){
    edit_widget = header_widget;
    s_tab_view->setCurrentTab(HEADER);
    //output_widget->append("Aktuelles edit_widget = header_widget");
  }
  else{
    edit_widget = cpp_widget;
    s_tab_view->setCurrentTab(CPP);
    //output_widget->append("Aktuelles edit_widget = cpp_widget");
  }
  edit_widget->setFocus();

  if (filename == edit_widget->getName()){
    cerr << endl << "Filename:" << filename << "EDITNAME:" << edit_widget->getName() <<"NO aTCion---:";
    return;
  }
  
  // search the actual file which would be ausgewechselt
  for(actual_info=edit_infos.first();actual_info != 0;actual_info=edit_infos.next()){
    if (actual_info->filename == edit_widget->getName() ){
      break;
    }
  }
  
    // rescue the old file
  actual_info->text = edit_widget->text();
  actual_info->modified = header_widget->isModified();
  // output_widget->append("auszuwechseldes file:" + actual_info->filename);

  // schon in der Liste ?
  for(info=edit_infos.first();info != 0;info=edit_infos.next()){
    if (info->filename == filename ) { // if found in list
      
      edit_widget->setText(info->text);
      edit_widget->setName(filename);
      edit_widget->toggleModified(info->modified);
      
      //      output_widget->append ("File: war schon vorhanden");
      setCaption("KDevelop V" + version + ": " + filename);
      return;
    }
  }
 
  
  // not found -> generate a new edit_info,loading
  
  // build a new info
  QFileInfo fileinfo(filename);
  info = new TEditInfo;
  
  info->id = menu_buffers->insertItem(fileinfo.fileName(),-2,0); // insert at first index
  info->filename = filename;
  info->modified = false;

  // update the widget
  cerr << filename;
  edit_widget->clear();
  edit_widget->loadFile(filename,1);
  edit_widget->setName(filename);
  edit_widget->setFocus();
  info->text = edit_widget->text();
  edit_infos.append(info); // add to the list

  setCaption("KDevelop V" + version + ": " + filename);
 
}

void KDevelop::setToolMenuProcess(bool enable){
  int id;
  if (enable){
    // set the correct toolbar-item enable or disable
    toolBar()->setItemEnabled(TOOLBAR_STOP,false);
    toolBar()->setItemEnabled(TOOLBAR_RUN,true);
    toolBar()->setItemEnabled(TOOLBAR_MAKE,true);
    
    // set the popupmenus enable or disable
    id = file_menu->idAt(0);
    file_menu->setItemEnabled(id,true); // new file
    
    id = build_menu->idAt(0);
    build_menu->setItemEnabled(id,true); // run
    id = build_menu->idAt(1);
    build_menu->setItemEnabled(id,true); // make
    id = build_menu->idAt(2);
    build_menu->setItemEnabled(id,true); // rebuild all
    id = build_menu->idAt(3);
    build_menu->setItemEnabled(id,true); // clean
    id = build_menu->idAt(4);
    build_menu->setItemEnabled(id,false); // stop
    id = build_menu->idAt(6);
    build_menu->setItemEnabled(id,true); // make api
    id = build_menu->idAt(7);
    build_menu->setItemEnabled(id,true); // make user
  }
  else {
    
    // set the correct toolbar-item enable or disable
    toolBar()->setItemEnabled(TOOLBAR_STOP,true);
    toolBar()->setItemEnabled(TOOLBAR_RUN,false);
    toolBar()->setItemEnabled(TOOLBAR_MAKE,false);
    
    // set the popupmenus enable or disable
    
    id = file_menu->idAt(0);
    file_menu->setItemEnabled(id,false); // new file
    
    id = build_menu->idAt(0);
    build_menu->setItemEnabled(id,false); // run
    id = build_menu->idAt(1);
    build_menu->setItemEnabled(id,false); // make
    id = build_menu->idAt(2);
    build_menu->setItemEnabled(id,false); // rebuild all
    id = build_menu->idAt(3);
    build_menu->setItemEnabled(id,false); // clean
    id = build_menu->idAt(4);
    build_menu->setItemEnabled(id,true); // stop
    id = build_menu->idAt(6);
    build_menu->setItemEnabled(id,false); // make api
    id = build_menu->idAt(7);
    build_menu->setItemEnabled(id,false); // make user
  }
}
