/***************************************************************************
                   prjoptionsdlg.cpp - the setup DLG for a project  
                             -------------------                                         

    version              :                                   
    begin                : 10 Aug 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "prjoptionsdlg.h"
#include <iostream.h>

// OPTIONS DIALOG
PrjOptionsDlg::PrjOptionsDlg( QWidget *parent, const char *name,KDevelop* dev,CProjectInfo* prj )
    : QTabDialog( parent, name,TRUE )
{
  devel = dev;
  prj_info = prj;

  setFixedSize(412,328);
  

  setCaption( i18n("Project Options" ));
  
  // ****************** the General_Widget ********************
  QWidget *w = new QWidget( this, "page one" );
  
  prjname_edit = new QLineEdit( w, "prjname_edit" );
  prjname_edit->setGeometry( 120, 20, 100, 30 );
  prjname_edit->setText( prj_info->name );
  
  version_edit = new QLineEdit( w, "version_edit" );
  version_edit->setGeometry( 320, 20, 50, 30 );
  version_edit->setText( prj_info->version );
  
  author_edit = new QLineEdit( w, "author_edit" );
  author_edit->setGeometry( 120, 80, 250, 30 );
  author_edit->setText( prj_info->author );
   
  email_edit = new QLineEdit( w, "email_edit");
  email_edit->setGeometry( 120, 140, 250, 30 );
  email_edit->setText( prj_info->email );
  
  handbook_edit = new QLineEdit( w, "handbook_edit" );
  handbook_edit->setGeometry( 120, 200, 150, 30 );
  handbook_edit->setText( prj_info->sgml_file );

  QLabel* author_label;
  author_label = new QLabel( w, "author_label" );
  author_label->setGeometry( 10, 80, 100, 30 );
  author_label->setText( "Author:" );

  QLabel* email_label;
  email_label = new QLabel( w, "email_label" );
  email_label->setGeometry( 10, 140, 100, 30 );
  email_label->setText( "Email:" );

  QLabel* version_label;
  version_label = new QLabel( w, "version_label" );
  version_label->setGeometry( 250, 20, 70, 30 );
  version_label->setText( "Version:" );

  QLabel* prjname_label;
  prjname_label = new QLabel( w, "prjname_label" );
  prjname_label->setGeometry( 10, 20, 100, 30 );
  prjname_label->setText( "Projectname:" );
  
  QLabel* handbook_label;
  handbook_label = new QLabel( w, "handbook_label" );
  handbook_label->setGeometry( 10, 200, 100, 30 );
  handbook_label->setText( "Handbook:" );
  
  addTab( w, i18n("General"));
  
  
    // **************set the button*********************
  setOkButton(i18n("OK"));
  setCancelButton(i18n("Cancel"));
  connect( this, SIGNAL(applyButtonPressed()), SLOT(ok()) );
  show();
}



  

void PrjOptionsDlg::ok(){
  QString text;
  text = prjname_edit->text();
  prj_info->name = text;
  text = author_edit->text();
  prj_info->author = text;
  text = email_edit->text();
  prj_info->email = text;
  text = version_edit->text();
  prj_info->version = text;
  text = handbook_edit->text();
  prj_info->sgml_file = text;
  // write it to the disk
  prj_info->writeProject();
}

