#include	<qstrlist.h>
#include	<qwidget.h>
#include	<qtabdialog.h>
#include	<qmessagebox.h>
#include "kxident.h"
#include "kxserver.h"
#include "kxglobal.h"
#include "kxaccpre.h"

#include "kxaccpre.moc"
#include "kxaccpredata.moc"

#define Inherited KXAccPreData

KXAccPre::KXAccPre
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	initMetaObject();

	setCaption( klocale->translate( "Manage Accounts") );

	reload();
	oldname = new QString();

	connect(gEntryMgr, SIGNAL(changed()), this, SLOT(reload()));   
	connect(this, SIGNAL(changed()),gEntryList, SLOT(doEntryListChanged()));   
}


KXAccPre::~KXAccPre()
{
}

void KXAccPre::slotOk()
{
	QDialog::accept();
}

void KXAccPre::slotTabOk()
{
	identTab->writeConfig();

	if (entry->label()->isEmpty() == TRUE) {
		QMessageBox::information(this, klocale->translate("Account"),
			klocale->translate("You did not choose a name for this account"), 
			klocale->translate("Ok"));
		reject();
		return;
	}

	serverTab->writeConfig();

	if (oldname->isEmpty()) {
		gEntryMgr->create(*entry->label());
		entry->KXEntryConstructor((const char *) ((*gEntryMgr->accountPath() +
			QString("/") +
			*entry->label()).data()),
			(const char *) entry->label()->data());

		// hmm, silly but all entries must be reread (create sends "changed()")
		// and KXEntryConstructor just made the dirs where we can save
		// the config now
		identTab->writeConfig();
		serverTab->writeConfig();
		entry->writeConfig();
		gEntryMgr->create(*entry->label());
	}
	else if (oldname != entry->label())
		gEntryMgr->move(*oldname, *entry->label());

	entry->writeConfig();

	emit changed();
}

void KXAccPre::reload()
{
	const QStrList *accList;

	accList = gEntryMgr->getAccList();

	box->clear();
	box->insertStrList(accList);
}

void KXAccPre::slotChange(int)
{
	slotChange();
}

void KXAccPre::slotChange()
{
	if (box->currentItem() < 0) {
		return;
	}

	entry = new KXEntry(box->text(box->currentItem()));
	createTab();
}

void KXAccPre::slotNew()
{
	entry = new KXEntry();
	createTab();
}

void KXAccPre::createTab()
{
	tab = new QTabDialog(this,0, TRUE);
	connect(tab, SIGNAL(applyButtonPressed()), this, SLOT(slotTabOk()));
	tab->setOKButton(klocale->translate("Ok"));
	tab->setCancelButton(klocale->translate("Cancel"));

	oldname = new QString(*entry->label());

	tab->setCaption(klocale->translate("Settings"));
	tab->resize(500,500);

	identTab = new KXIdent(entry,tab);
	tab->addTab(identTab,"Identity");

	serverTab = new KXServer(entry,tab);
	tab->addTab(serverTab,"Server");

	tab->show();
}

void KXAccPre::slotDelete()
{
	QString file;

	 if (QMessageBox::information(this,klocale->translate("Delete"),
		 klocale->translate("Do you really want to delete this Account?"),
		 	klocale->translate("Yes"), klocale->translate("No"), 0, 1)) {
		 return;
	 }     

	if (gEntryMgr->del(QString(box->text(box->currentItem()))) != 0) {
		QMessageBox::information(this,"Delete",
			klocale->translate("Couldn't delete, there are files I don't know in the directory"),
			klocale->translate("Ok"));
	}	
}

