#include	<gdbm.h>
#include	<malloc.h>

#include	"kxarticledb.h"

static GDBM_FILE dbDesc;
static datum key,content;

void newKXArticleDb()
{
	extern GDBM_FILE articleDb;

	dbDesc = articleDb;
	content.dptr = 0;
}

void artDbClose()
{
	(void) gdbm_close(dbDesc);
}

bool artDbOrFlag(QString *id,artStatus stat)
{
	QString tmpId = *id + QString("\n");

	key.dptr = tmpId.data();
	key.dsize = tmpId.size()-1;

	content = gdbm_fetch(dbDesc,key);

	if (content.dptr == 0)
		return(FALSE);

	*content.dptr |= stat;

	if (gdbm_store(dbDesc, key, content, GDBM_REPLACE) < 0) 
		return(FALSE);
	
	free(content.dptr);
	return(TRUE);
}

bool artDbSetFlag(QString *id,artStatus stat)
{
	QString tmpId = *id + QString("\n");

	key.dptr = tmpId.data();
	key.dsize = tmpId.size()-1;

	content = gdbm_fetch(dbDesc,key);

	if (content.dptr == 0)
		return(FALSE);

	*content.dptr = stat;

	if (gdbm_store(dbDesc, key, content, GDBM_REPLACE) < 0) 
		return(FALSE);
	
	free(content.dptr);
	return(TRUE);
}

artStatus artDbGetFlag(QString *id)
{
	artStatus stat;
	QString tmpId = *id + QString("\n");

	key.dptr = tmpId.data();
	key.dsize = tmpId.size()-1;

	content = gdbm_fetch(dbDesc,key);

	if (content.dptr == 0)
		return(INIT);

	stat = (artStatus) *content.dptr;

	free(content.dptr);
	return(stat);
}

void artDbSetFree()
{
	if (content.dptr != 0)
		free(content.dptr);
}
