#include	<stdlib.h>
#include	<malloc.h>
#include	<qstrlist.h>
#include	<qstring.h>
#include	<kconfig.h>
#include	<algorithm>

#include	"kxglobal.h"
#include	"kxutil.h"
#include	"kxarticledb.h"
#include	"kxartsorter.h"

#define	ATT_SUBJECT	0
#define	ATT_FROM	1

static int _sortIdx, _revSort;


KXThreadNode::KXThreadNode()
{
	vec = new vector <KXThreadNode>;
}

KXThreadNode::KXThreadNode(int _level)
{
	level = _level;
	vec = new vector <KXThreadNode>;
}

KXArtElem::KXArtElem()
{
}

KXArtElem::~KXArtElem()
{
}

bool operator< (const KXThreadNode& a, const KXThreadNode& b)
{
	bool res;

	if (_sortIdx < 2) {
		// for the QStrings
		res = ((QString&) (*(a.art->att[_sortIdx])) < b.art->att[_sortIdx]->data());
	}
	else {
		// for the date
		if (_sortIdx == 2)
			res = a.art->date < b.art->date;
		else if (_sortIdx == 3)
			res = a.art->lines < b.art->lines;
		else
			res = a.art->bytes < b.art->bytes;
	}

	if (_revSort)
		return(!res);
	else
		return(res);
}

KXArtSorter::KXArtSorter()
{
	ancor = new KXThreadNode(0);
}

KXArtSorter::~KXArtSorter()
{
}

void KXArtSorter::_inSort(void *vecPtr,KXThreadNode *elem)
{
	vector <KXThreadNode> *p = static_cast<vector <KXThreadNode>*>(vecPtr);
	int idx,idx1;
	int sz;
	QString *refPtr = elem->art->ref;
	QString thisRef;
	uint i;

	sz = refPtr->size();
	idx = 0;
	idx1 = 0;

	for(int lev=0;;lev++) {
		idx = refPtr->find(' ', idx+1);

		// last ref ?
		if (idx < 0) {
			//debug("ende, level = %d", lev);
			idx = sz;
		}

		thisRef = refPtr->mid(idx1,idx - idx1);
		//debug("%s",thisRef.data());

		// search thread in current threadlevel
		for (i=0;i < p->size();i++) {
			if (*(*p)[i].art->ID == thisRef) {
				p = static_cast<vector <KXThreadNode>*>((*p)[i].vec);
				break;
			}
		}

		// not found, so put in actual level
		if (i == p->size()) {
			p->push_back(*elem);
			return;
		}

		idx1 = idx+1;
		// go into next level ...
	}
}

int KXArtSorter::inSort(int stByte,QStrList *sl)
{
	KConfig *config = app->getConfig();
	KXArtElem *ae;

	ae = new KXArtElem();
	
	ae->statusByte = stByte;
	ae->att[ATT_SUBJECT] = new QString(sl->at(1));
	ae->att[ATT_FROM] = new QString(normFrom(sl->at(2)));
	ae->lines = QString(sl->at(5)).toInt();
	ae->bytes = QString(sl->at(6)).toInt();
	ae->date = dateFromString(sl->at(3));

	ae->ID = new QString(sl->at(0));
	ae->ref = new QString(sl->at(4));

	KXThreadNode *newElem = new KXThreadNode(ancor->level+1);
	vector <KXThreadNode> &p = *(static_cast<vector <KXThreadNode>*>(ancor->vec));

	newElem->art = ae;

	if (config->readBoolEntry("ShowThreads",TRUE))
		_inSort(ancor->vec, newElem);
	else
		p.push_back(*newElem);

	return(0);
}

void KXArtSorter::_transfer(int _level,KTabListBox *tlb,void *vecPtr)
{
	QString row;
	QString l,b;
	QString sep("\t");
	QString levelSep = "";
	QString pic;
	vector <KXThreadNode> &p = *static_cast<vector <KXThreadNode>*>(vecPtr);

	for (int i=0;i < _level;i++)
		levelSep += "    ";

	for (uint i=0;i < p.size();i++) {
		l.setNum(p[i].art->lines);
		b.setNum(p[i].art->bytes);

		row = *p[i].art->att[ATT_SUBJECT] + sep;
		row += *p[i].art->att[ATT_FROM] + sep;
		row += QString(dateStr(p[i].art->date)) + sep;
		row += l + sep;
		row += b;

		pic = QString("{uncached} ");
		if (p[i].art->statusByte & CACHED)
			pic = QString("{cached} ");

		if (p[i].art->statusByte & READ)
			pic = QString("{read} ");

		tlb->appendItem(pic+levelSep+row);

		if (static_cast<vector <KXThreadNode>*> (p[i].vec)->size() > 0) {
			_transfer(_level+1,tlb,p[i].vec);
		}
	}
}

void KXArtSorter::transfer(KTabListBox *tlb)
{
	_transfer(0, tlb, ancor->vec);
}

KXArtElem *KXArtSorter::artAt(int idx)
{
	seqCount = 0;
	return(_artAt(idx,ancor->vec));
}

KXArtElem *KXArtSorter::_artAt(int idx,void *vecPtr)
{
	vector <KXThreadNode> &p = *(static_cast<vector <KXThreadNode>*>(vecPtr));
	int sz;
	KXArtElem *ret;

	for (uint i=0;i < p.size();i++) {
		sz = static_cast<vector <KXThreadNode>*> (p[i].vec)->size();

		if (idx == seqCount++)
			return(p[i].art);
			
		if (sz > 0) {
			if ((ret = _artAt(idx,p[i].vec)) != 0)
				return(ret);
		}
	}

	return((KXArtElem *)0);
}

void KXArtSorter::sortArtList(int key,bool rev)
{
	sortIdx = key;
	revSort = rev ? 1 : -1;

	// hmmm ... this globals don't make me happy
	// who can FIX ME ???
	_sortIdx = sortIdx;
	_revSort = rev;

	_sortArtList(0, ancor->vec);
}

void KXArtSorter::_sortArtList(int _level,void *vecPtr)
{
	vector <KXThreadNode> &p = *(static_cast<vector <KXThreadNode>*>(vecPtr));
	//debug("sort level %d",_level);

	stable_sort(p.begin(),p.end());

	for (uint i=0;i < p.size();i++) {
		if (static_cast<vector <KXThreadNode>*> (p[i].vec)->size() > 1) {
			_sortArtList(_level+1,p[i].vec);
		}
	}
}

void KXArtSorter::clear()
{
	vector <KXThreadNode> &p = *(static_cast<vector <KXThreadNode>*>(ancor->vec));

	p.erase(p.begin(),p.end());
	ancor = new KXThreadNode(0);
}
