#ifndef	KXARTSORTER_H
#define	KXARTSORTER_H

#include	<qstrlist.h>
#include	<ktablistbox.h>
#include	<vector>


class KXArtElem
{
public:
	KXArtElem();
	virtual ~KXArtElem();

	int statusByte;
	time_t date;
	int lines;
	int bytes;
	QString *ID;
	QString *ref;
	QString *att[2];
};

class KXThreadNode
{
public:
  KXThreadNode();
  KXThreadNode(int lev);
  ~KXThreadNode() { };

  int level;
  KXArtElem *art;
  void *vec;
};

class KXArtSorter
{
public:
	KXArtSorter();
	virtual ~KXArtSorter();

	KXThreadNode *ancor;
	int inSort(int,QStrList *);
	void transfer(KTabListBox *);
	void sortArtList(int,bool);
	void clear();
	void init();
	KXArtElem *artAt(int);
	
protected:
	void _inSort(void *,KXThreadNode *);
	void _transfer(int,KTabListBox *,void *);
	void _sortArtList(int,void *);
	KXArtElem *_artAt(int,void *);
	int sortIdx;
	int revSort;
	int seqCount;

};

#endif
