#include "kxcomposer.h"
#include <qstring.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qfile.h>

#include	<ktoolbar.h>
#include	<kiconloader.h>

#include "kxglobal.h"
#include "kxcomposer.moc"


#define Inherited KTopLevelWidget

KXComposer::KXComposer(KXMessage *m = 0)
	: Inherited(),mw(this),
	subjectFld(&mw),
	newsgrpFld(&mw),
	fuptoFld(&mw),
	editFld(app,&mw)
{
	initMetaObject();

	msg = m;

	readConfig();

	QString caption;

	caption.sprintf("%s (%s)",
		"kexpress composer", gEntryList->selEntry->label()->data());
	setCaption(caption);

	editFld.setWordWrap(1);
	editFld.setFillColumnMode(80,TRUE);

	composerInit();

	// mw is something to call setView for
	setView(&mw, FALSE); 

	initMenuBar();
	initToolBar();

	if (msg == (KXMessage *) 0)
		msg = new KXMessage();
	else {
		if (!msg->subject().isEmpty())
			subjectFld.setText(msg->subject());

		if (!msg->groups().isEmpty())
			newsgrpFld.setText(msg->groups());

		if (!msg->followupto().isEmpty())
			fuptoFld.setText(msg->followupto());

		if (!msg->body().isEmpty())
			editFld.setText(msg->body());
	}

	txtChgd = FALSE;
	connect(&editFld, SIGNAL(textChanged()), this, SLOT(slotTextChanged()));
}

KXComposer::~KXComposer()
{
	writeConfig();
}

void KXComposer::initToolBar()
{
  KIconLoader* loader = app->getIconLoader();
	KToolBar *toolBar;

  toolBar = new KToolBar(this);

  toolBar->insertButton(loader->loadIcon("send.xpm"),0,
      SIGNAL(clicked()),this,
      SLOT(slotSendNow()),TRUE,i18n("Send message"));
  toolBar->insertSeparator();
 
	addToolBar(toolBar);
}

void KXComposer::initMenuBar()
{
  QPopupMenu *menu;

	menuBar = new KMenuBar(this);
	menu = new QPopupMenu();
	menu->insertItem(i18n("&Send now"),this, SLOT(slotSendNow()), CTRL+Key_Return);
	menu->insertItem(i18n("S&end later"),this,SLOT(slotSendLater()));
	menuBar->insertItem(i18n("&File"),menu); 

	setMenu(menuBar);
}

void KXComposer::queueMesg()
{
	QString fromStrg;
	QString spoolName;

	spoolName.sprintf("%s/%s", gEntryList->selEntry->spoolPath->data(),msg->id().data());

	fromStrg.sprintf("%s <%s>", gEntryList->selEntry->fullName.data(),
		gEntryList->selEntry->emailAddress.data());
	msg->setFrom(fromStrg);

	msg->setSubject(subjectFld.text());
	msg->setNewsgrp(newsgrpFld.text());
	msg->setFollowupto(fuptoFld.text());

	if (editFld.numLines() == 0)
		msg->setBody("\n\n\n");
	else
		msg->setBodyEncoded(editFld.text());

//	msg->setTypeStr("text");
//	msg->setSubtypeStr("plain");
	msg->setCteStr("quoted-printable");

	debug("spooling to %s", spoolName.data());
	msg->toFile(spoolName);
}

void KXComposer::slotSendLater()
{
	queueMesg();
	txtChgd = FALSE;

	close();
}

void KXComposer::slotSendNow()
{
	queueMesg();
	txtChgd = FALSE;
	toplevel->slotSendPending();

	close();
}

void KXComposer::closeEvent(QCloseEvent *e)
{
	if (txtChgd == TRUE) {
		if (QMessageBox::information(this, klocale->translate("Composer"),
			klocale->translate("You did not send your message, really exit?"),
			klocale->translate("Yes"), klocale->translate("No"),0,1))
			return;
	}

	writeConfig();
	e->accept();
}

void KXComposer::writeConfig()
{
	KConfig *config = app->getConfig();
	QString str(80);

	config->setGroup("Geometry");

	str.sprintf("%d %d", width(), height());
	config->writeEntry("composer", str); 
}

void KXComposer::readConfig()
{
	KConfig *config = app->getConfig();
	QString str(80);
	int w,h;

	config->setGroup("Geometry");

	str = config->readEntry("composer", "525 440");
	sscanf(str.data(), "%d %d", &w, &h);
	if (w<400) w=400;
	if (h<400) h=400;
	setMinimumSize(400,400);
	resize(w, h);
}

void KXComposer::composerInit()
{
	int row;
	int numrow;

	numrow = 4;

	grid = new QGridLayout(&mw,numrow,2,4,4);

	grid->setColStretch(0, 1);
	grid->setColStretch(1, 50);
	grid->setRowStretch(3, 100);

	row = 0;
	fldInit(&subjectFld, QString("Subject:"),row);
	fldInit(&newsgrpFld, QString("Newsgroup:"),row);
	fldInit(&fuptoFld, QString("Followup-To:"),row);

	grid->addMultiCellWidget(&editFld, row, row,0,1);

	resize(this->size());
	repaint();

	grid->activate();
}

void KXComposer::fldInit(QLineEdit *le, QString labelText,int& row)
{
	QLabel *la = new QLabel(le,labelText,&mw);

	la->adjustSize();
	la->resize((int)la->sizeHint().width(),la->sizeHint().height() + 6);
	la->setMinimumSize(la->size());
	la->show(); 

	le->show();
	le->setMinimumSize(100, la->height()+2);
	le->setMaximumSize(1000, la->height()+2); 

	grid->addWidget(la, row,0);
	grid->addWidget(le, row,1);

	row++;
}

void KXComposer::slotTextChanged()
{
	txtChgd = TRUE;
}
