#include	<sys/stat.h>
#include	<sys/types.h>
#include	<fcntl.h>
#include	<unistd.h>
#include	<qdir.h>
#include	<qfile.h>
#include	<qlist.h>
#include	<qtextstream.h>
#include	<ksimpleconfig.h>

#include	"kxglobal.h"

#include	"kxentry.moc"


KXEntry::KXEntry(const char *fname) :
	KXEntryInherited()
{
	initMetaObject();

	KXEntryConstructor((*gEntryMgr->accountPath() + 
		QString("/") + QString(fname)).data(), fname);
}

KXEntry::KXEntry() :
	KXEntryInherited()
{
	initMetaObject();

	setLabel(new QString(""));
}

KXEntry::KXEntry(const char *absPath,const char *fname) :
	KXEntryInherited()
{
	initMetaObject();

	KXEntryConstructor(absPath,fname);
}

void KXEntry::KXEntryConstructor(const char *absPath,const char *fname)
{
	QString line;

	name = new QString(fname);
	path = new QString(absPath);

	QString str(absPath);

	activeFile = new QFile(str + "/active");
	ngFile = new QFile(str + "/newsgroups");

	configPtr = new KSimpleConfig(str + "/config");
	readConfig();

	infoPath = new QString(str + QString("/info"));
	mkdir (infoPath->data(), 0777);

	spoolPath = new QString(str + QString("/spool"));
	mkdir (spoolPath->data(), 0777);

	groupInfo = new QString(*infoPath + QString("/info-"));

	klapped = FALSE;

	actList = new QStrList(TRUE);

  // read active file

  if (activeFile->exists() == TRUE) {
    activeFile->open(IO_ReadOnly);
    QTextStream ts(activeFile);

    while (!ts.eof()) {
      line = ts.readLine();

      if (line.size() <= 1)
        continue;

    	actList->inSort(line.data());
		}
	}

	activeFile->close();      
}

KXEntry::~KXEntry()
{
	delete actList;
}

void KXEntry::setLabel(QString *l)
{
	name = new QString(*l);
}

QString *KXEntry::label()
{
	return name;
}

QString *KXEntry::basePath()
{
	return path;
}

void KXEntry::readConfig()
{
	configPtr->setGroup("Account");

	fullName = configPtr->readEntry("fullName", "");
	organisation = configPtr->readEntry("organisation", "");
	emailAddress = configPtr->readEntry("emailAddress", "");
	replyAddress = configPtr->readEntry("replyAddress", "");
	user = configPtr->readEntry("user", "");
	nntp = configPtr->readEntry("nntp", "news");
	port = configPtr->readEntry("port", "119");
	password = configPtr->readEntry("password", "");
}

void KXEntry::writeConfig()
{
	debug("writing config");
	configPtr->setGroup("Account");

	configPtr->writeEntry("fullName", fullName);
	configPtr->writeEntry("organisation", organisation);
	configPtr->writeEntry("emailAddress", emailAddress);
	configPtr->writeEntry("replyAddress", replyAddress);
	configPtr->writeEntry("user", user);
	configPtr->writeEntry("nntp", nntp);
	configPtr->writeEntry("port", port);
	configPtr->writeEntry("password", password);

	configPtr->sync();
}
