#include	<qdir.h>
#include	<qdialog.h>
#include	<qcolor.h>
#include	<kapp.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qmessagebox.h>

#include	"kxglobal.h"
#include	"kxentrylist.h"
#include	"kxentry.h"
#include	"kxentrymgr.h"
#include	"kxnewsclient.h"
#include	"kxngdialog.h"

#include	"kxentrylist.moc"

KXEntryList::KXEntryList(QWidget *parent, const char *name) :
	KXEntryListInherited(parent,name), eList()
{
	initMetaObject();

	setTableFlags (Tbl_smoothVScrolling | Tbl_autoVScrollBar | Tbl_autoHScrollBar);
				  
	connect(gEntryMgr, SIGNAL(changed()),
	    this, SLOT(doEntryListChanged()));

  connect(this, SIGNAL(highlighted(int)),
	    this, SLOT(doFolderSelected()));   

	setIndentSpacing(20);
	reload();
	redisplay();

	selEntry = (KXEntry *) 0;

	if (count() > 0)
		setCurrentItem(0);

	doFolderSelected();
}

KXEntryList::~KXEntryList()
{
}

void KXEntryList::reload()
{
  QDir      dir;
  QFileInfo* fileInfo;
  QFileInfoList* fiList;
  QString fname;
  QString fldPath;
	KXEntry *en;

	gNNTP->clientDisconnect();

	eList.clear();

  fldPath = *gEntryMgr->accountPath();

  //dir.setFilter(QDir::Files | QDir::Hidden);
  dir.setNameFilter("*");

  if (!dir.cd(fldPath, TRUE))
  {
    warning("Cannot enter directory '" + fldPath + "'.\n");
  }
  if (!(fiList=(QFileInfoList*)dir.entryInfoList()))
  {
    warning("Directory '" + fldPath + "' is unreadable.\n");
  }

  for (fileInfo=fiList->first(); fileInfo; fileInfo=fiList->next())
  {
    fname = fileInfo->fileName();

    if (fname[0]=='.') // skip table of contents files
      continue;
    else if (fileInfo->isDir()) // a directory
    {
      en = new KXEntry(fileInfo->absFilePath().data(),fname.data());
      inSort(en);
    }                                             
//		else {
//      en = new KXEntry(fileInfo->absFilePath().data(),fname.data());
//      inSort(en);
//		}
	}
}

void KXEntryList::inSort(KXEntry *entry)
{
	eList.append(entry);
}

void KXEntryList::doEntryListChanged()
{
	reload();
	redisplay();
}

void KXEntryList::doFolderSelected()
{
	int item = currentItem();

	debug("item=%d",item);

	if (item < 0)
		return;

	selEntry = getEntry(item);

	if (selEntry->ngFile->exists() == FALSE) {
		QDialog *dlg;

		dlg = new KXNgDialog(selEntry,toplevel);
		dlg->exec();

		reload();
		if (selEntry->ngFile->exists() == TRUE)
			redisplay();

		selEntry = getEntry(item);
	}

	if (itemAt(item)->getBranch() > 0) {
		emit folderSelected(selEntry, selEntry->actList->at(getSubEntry(item)));
	}
}

void KXEntryList::redisplay()
{
	uint idx,ngIdx;
	KXEntry *entry;

  clear();

	for (idx=0;idx < eList.count();idx++) {
		entry = eList.at(idx);
		insertItem(entry->label()->data(),0);

		for (ngIdx=0;ngIdx < entry->actList->count();ngIdx++) {
			addChildItem(entry->actList->at(ngIdx),0,idx);
		}
	}
}

int KXEntryList::getSubEntry(uint ix)
{
	uint eIdx,idx;
	int ngIdx;
	KXEntry *entry;

	eIdx = 0;
	ngIdx = 0;
	for (idx=0;idx <= ix;idx++) {
		if (itemAt(idx)->getBranch() > 0) {
			ngIdx++;
		}
		else {
			entry = eList.at(eIdx++);
			ngIdx = -1;
		}
	}

	return(ngIdx);
}

KXEntry *KXEntryList::getEntry(uint ix)
{
	uint eIdx,idx;
	KXEntry *entry = 0;

	eIdx = 0;
	for (idx=0;idx <= ix;idx++) {
		if (itemAt(idx)->getBranch() == 0) {
			entry = eList.at(eIdx++);
		}
	}

	return(entry);
}

const QString KXEntryList::selectedGroup()
{
	static QString res;
	KXEntry *selEntry;

	res = "";

	if (currentItem() < 0 || getSubEntry(currentItem()) < 0)
		return(res);
	
	selEntry = getEntry(currentItem());
	res = selEntry->actList->at(getSubEntry(currentItem()));

	return(res);
}
