#include	<stdio.h>
#include	<sys/stat.h>
#include	<sys/types.h>
#include	<fcntl.h>
#include	<unistd.h>

#include	<qdir.h>
#include	<qstrlist.h>
#include	<kapp.h>

#include	"kxentrymgr.h"
#include	"kxglobal.h"

#include	"kxentrymgr.moc"

KXEntryMgr::KXEntryMgr() :
	KXEntryMgrInherited()
{
	initMetaObject();

	lbasePath = QDir::homeDirPath() + QString("/.") + app->appName();
	mkdir (lbasePath.data(),0777);

	lgroupPath = lbasePath + QString("/groups");
	mkdir (lgroupPath.data(),0777);

	laccountPath = lbasePath + QString("/accounts");
	mkdir (laccountPath.data(),0777);

	ldataPath = lbasePath + QString("/data");
	mkdir (ldataPath.data(),0777);
}

KXEntryMgr::~KXEntryMgr()
{
}

const QStrList *KXEntryMgr::getAccList()
{
  QDir dir;
	QStrList *dirsl;
	static QStrList sl;

	sl.clear();

	dir.setPath(laccountPath.data());
	dir.setFilter(QDir::Dirs);
	dir.setSorting(QDir::Name);

	dirsl = (QStrList *) dir.entryList();

	for (uint i=0;i < dirsl->count();i++) {
		if (dirsl->at(i)[0] != '.')
			sl.append(dirsl->at(i));
	}

	return(&sl);
}    

bool KXEntryMgr::create(QString name)
{
	QString str;
	bool ret;

	str = laccountPath + QString("/") + name;
	ret = mkdir (str.data(), 0777);

	emit changed();
	return(ret);
}

bool KXEntryMgr::delfile(QString name)
{
	QString str;

	str = laccountPath + QString("/") + name;
	return(remove (str.data()));
}

bool KXEntryMgr::del(QString name)
{
	bool ret;
	QString str;

	str = "rm -r " + laccountPath + QString("/") + name;
	ret = system (str.data());

	emit changed();
	return(ret);
}

bool KXEntryMgr::move(QString oldName, QString newName)
{
	QString str1;
	QString str2;
	bool ret;

	str1 = laccountPath + QString ("/") + oldName;
	str2 = laccountPath + QString ("/") + newName;

	ret = rename(str1.data(),str2.data());
		
	emit changed();
	return (ret);
}
