#include	<gdbm.h>
#include	<time.h>
#include	<unistd.h>

#include	<qdir.h>
#include	<qlist.h>

#include	"kxexpire.h"
#include	"kxutil.h"
#include	"kxglobal.h"

extern GDBM_FILE articleDb;

void doExpire()
{
	QDir gr(gEntryMgr->groupPath()->data());
	QFileInfoList *fl = (QFileInfoList *) gr.entryInfoList();
	QFileInfo *fileInfo;

	for (fileInfo = fl->first();fileInfo;fileInfo = fl->next()) {
		if (!fileInfo->isDir() && fileInfo->fileName().data()[0] != '.')
			expireGroup(fileInfo);
	}

	expireDb(articleDb);

	gdbm_reorganize(articleDb);
	gdbm_sync(articleDb);
	gdbm_close(articleDb);

	toplevel->setMsg("Ready");
}

void expireGroup(QFileInfo *fileInfo)
{
	char *ptr,*ptr1;
	QString dateString;
	time_t tmDb, tmAct;
	QString line,id;
	QFile groupFile(fileInfo->absFilePath());
	QFile tmpFile(fileInfo->absFilePath() + QString(".tmp"));
	datum content,key;
	KConfig *config = app->getConfig();
	int days;
	long daysInSeconds;
	bool ok,hasDeleted;
	QList <QString> grpList;
	QString msg;
	
	msg.sprintf("expiring %s ...",fileInfo->fileName().data());
	toplevel->setMsg(msg);

	days = config->readEntry("ExpDays","10").toInt(&ok);
	(void) time(&tmAct);

	if (!ok){
		debug("convert-error in ExpDays");
		return;
	}

	daysInSeconds = days * 86400;
	groupFile.open(IO_ReadOnly);
	tmpFile.open(IO_WriteOnly);

	grpList.setAutoDelete(TRUE);

	QTextStream rs(&groupFile);

	hasDeleted = FALSE;

	while (!rs.eof()) {
		id = rs.readLine();
		line = id + QString("\n");

		// check if already there
		QString *listP;
		for(listP=grpList.first();listP!=0;listP=grpList.next()) {
			if (*listP == id) {
				debug("found %s more than once, deleted",id.data());
				hasDeleted = TRUE;
				break;
			}
		}

		if (listP != 0)
			continue;

		grpList.append(new QString(id));

		if (line.size() <= 2) {
			hasDeleted = TRUE;
			continue;
		}

		key.dptr = line.data();
		key.dsize = line.size()-1;  // no \0

		content = gdbm_fetch(articleDb, key);
		if (content.dptr == NULL) {
			debug("article is not in database");
			continue;
		}

		ptr = content.dptr+1;
		for (int i=0;i < 2;i++)
			ptr = index(ptr+1, '\n');

		ptr1 = index(ptr+1, '\n');
		tmDb = dateFromString(QString(ptr,ptr1-ptr+1).data());

		// we hold all IDs younger than daysInSeconds
		if (tmDb + daysInSeconds > tmAct)
			tmpFile.writeBlock(line.data(), line.size()-1);
		else
			hasDeleted = TRUE;

		free(content.dptr);
 	}

	tmpFile.close();
	groupFile.close();

	if (hasDeleted == TRUE) {
		unlink(groupFile.name());
		link(tmpFile.name(), groupFile.name());
		unlink(tmpFile.name());
	}
	else {
		unlink(tmpFile.name());
	}
}

void expireDb(GDBM_FILE f)
{
	char *ptr,*ptr1;
	QString dateString;
	QString dp = *gEntryMgr->dataPath() + QString("/");
	QString df;
	time_t tmDb, tmAct;
	QString line,id;
	QFile tmpFile(".artdb");
	datum content,key,nextkey;
	KConfig *config = app->getConfig();
	int days;
	long daysInSeconds;
	bool ok;
	int count;
	
	toplevel->setMsg("expiring DB ...");

	days = config->readEntry("ExpDays","10").toInt(&ok);
	(void) time(&tmAct);

	if (!ok){
		debug("convert-error in ExpDays");
		return;
	}

	daysInSeconds = days * 86400;

	if (tmpFile.open(IO_WriteOnly) == FALSE)
		return;

	count = 0;
	key = gdbm_firstkey(f);

	while (key.dptr) {
		count++;
		nextkey = gdbm_nextkey(f, key);

		content = gdbm_fetch(f, key);
		ptr = content.dptr+1;
		for (int i=0;i < 2;i++)
			ptr = index(ptr+1, '\n');

		ptr1 = index(ptr+1, '\n');
		tmDb = dateFromString(QString(ptr,ptr1-ptr+1).data());

		// we take all IDs older than daysInSeconds ...
		if (tmDb + daysInSeconds <= tmAct)
			tmpFile.writeBlock(key.dptr, key.dsize);

		free(content.dptr);
		key = nextkey;
 	}

	debug("%d articles in articleDb",count);

	tmpFile.close();

	tmpFile.open(IO_ReadOnly);

	QTextStream rs(&tmpFile);

	count = 0;

	while (!rs.eof()) {
		id = rs.readLine();

		if (id.size() == 1 && rs.eof())
			break;

		line = id + QString("\n");

		key.dptr = line.data();
		key.dsize = line.size()-1;  // no \0

		// ... and delete them now
		(void) gdbm_delete(f, key);
		count++;

		// inclusive cache
		df = dp + id + QString(".head");
		unlink(df.data());
		df = dp + id + QString(".body");
		unlink(df.data());
	}

	debug("%d articles deleted in articleDb",count);
	tmpFile.close();
	unlink(tmpFile.name());
}
