#include	<kconfig.h>

#include "kxgenopts.moc"
#include "kxgenoptsdata.moc"

#define Inherited KXGenOptsData

KXGenOpts::KXGenOpts
(
	KConfig *config,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	initMetaObject();

	readConfig(config);
}


KXGenOpts::~KXGenOpts()
{
}

void KXGenOpts::readConfig(KConfig *config)
{
	maxHeaders->setText(config->readEntry("MaxHeaders","300"));
	showThreads->setChecked(config->readBoolEntry("ShowThreads",TRUE));
	expDays->setText(config->readEntry("ExpDays","10"));

	includeSig->setChecked(config->readBoolEntry("IncludeSig",TRUE));
	replyPrefix->setText(config->readEntry("ReplyPrefix",">"));
}

void KXGenOpts::writeConfig(KConfig *config)
{
	config->writeEntry("MaxHeaders",maxHeaders->text());
	config->writeEntry("ShowThreads",showThreads->isChecked());
	config->writeEntry("ExpDays",expDays->text());

	config->writeEntry("IncludeSig",includeSig->isChecked());
	config->writeEntry("ReplyPrefix",replyPrefix->text());
}
