#include	<gdbm.h>
#include	<stdlib.h>

#include	<qdir.h>
#include	<qtextstream.h>
#include	<qpixmap.h>

#include	<kapp.h>
#include	<kiconloader.h>
#include	<kconfig.h>
#include	<ksimpleconfig.h>

#include	"kxglobal.h"
#include	"kxutil.h"
#include	"kxentry.h"
#include	"kxnewsclient.h"
#include	"kxentrylist.h"
#include	"kxviewport.h"
#include	"kxartsorter.h"

#include	"kxheaderlist.moc"

static char *colIndex[] = {
	"Subject",
	"From",
	"Date",
	"Lines",
	"Bytes"
};

KXHeaderList::KXHeaderList(QWidget *parent, const char *name) :
	KXHeaderListInherited(parent,name,5)
{
	int col;
	int j;
	QString str;
	KConfig *config = app->getConfig();
	static QPixmap pixCached,pixUnCached,pixRead;
	static bool isLoaded = FALSE;
	KIconLoader* loader = app->getIconLoader();

	initMetaObject();

	setTableFlags (Tbl_smoothVScrolling | Tbl_autoVScrollBar | Tbl_autoHScrollBar);

	config->setGroup("General");
	isReverse = config->readBoolEntry("SortRev",TRUE);
	sortKey = config->readNumEntry("SortKey",2);

  connect(gEntryList, SIGNAL(folderSelected(KXEntry *,char *)),
	    this, SLOT(reload(KXEntry *,char *)));   
	
	connect(this, SIGNAL(highlighted(int,int)),this, SLOT(doHeaderSelected()));
	connect(this, SIGNAL(headerClicked(int)),this, SLOT(setSortKey(int)));

	// reads the TabListViews Columnwidth
	readConfig();

	config->setGroup("Columns");
	str = config->readEntry("ColIndex","0,1,2,3,4");

	j = 0;
	for (int i=0;;j++) {
		col = (int) (str.data()[i] - '0');
		if (j == 0)
			setColumn(j, klocale->translate(colIndex[col]),columnWidth(col),
				KTabListBox::MixedColumn);
		else
			setColumn(j, klocale->translate(colIndex[col]),columnWidth(col));

		if (str.data()[i+1] != ',')
			break;
		
		i += 2;
	}

	if (!isLoaded)
	{
    isLoaded = TRUE;

    pixCached = loader->loadIcon("cached.xpm");
    pixUnCached = loader->loadIcon("uncached.xpm");
    pixRead = loader->loadIcon("read.xpm");
  }

  dict().insert("cached", &pixCached);
  dict().insert("uncached", &pixUnCached);
  dict().insert("read", &pixRead);

	setSeparator('\t');
}

KXHeaderList::~KXHeaderList()
{
}

void KXHeaderList::doHeaderSelected()
{
	int item = currentItem();
	KXArtElem *art;

	debug("item=%d",item);

	art = artAt(item);
	emit headerSelected(art);
}

void KXHeaderList::reload(KXEntry *entry,char *group)
{
	QString line;
	QString id;
	int idx,idx1;
	int lSize,max;
	QStrList qsl;
	datum content, key;
	int statusByte;
	KConfig *config = app->getConfig();

	extern GDBM_FILE articleDb;

	KXArtSorter::clear();
	KTabListBox::clear();

	config->setGroup("General");
	max = config->readNumEntry("MaxHeaders",300);

	gNNTP->newNews(entry,group,max);

	// read articles
	QFile groupFile(*gEntryMgr->groupPath() + QString("/") + QString(group));

	if (groupFile.exists() == TRUE) {
    groupFile.open(IO_ReadOnly);
    QTextStream ts(&groupFile);

		qsl.setAutoDelete(TRUE);

    while (!ts.eof()) {
      id = ts.readLine();
      line = id + QString("\n");

      if (line.size() <= 2)
        continue;

			key.dptr = line.data();
			key.dsize = line.size()-1;	// no \0

			content = gdbm_fetch(articleDb, key);
			if (content.dptr == NULL) {
				debug("article is not in database");
				continue;
			}

			qsl.append(id.data());

			statusByte = *content.dptr;
			line = decodeRFC1522String(QString(content.dptr+1, content.dsize-1));

			free(content.dptr);

			lSize = (int) line.size();

			idx1 = 0;
			for(idx=0;idx < lSize;) {
				idx = line.find('\n',idx+1);

				if (idx < 0)
					idx = lSize;

				qsl.append(line.mid(idx1,idx - idx1).data());

				idx1 = idx+1;
			}

			// qsl:
			// 0 == Id
			// 1 == Subject
			// 2 == From
			// 3 == Date
			// 4 == Ref
			// 5 == Lines
			// 6 == Bytes

			KXArtSorter::inSort(statusByte,&qsl);
			qsl.clear();
    }
  }

	groupFile.close();

	reDisplay();
}

void KXHeaderList::reDisplay()
{
	KTabListBox::clear();

	sortArtList(sortKey,isReverse);
	
	setAutoUpdate(FALSE);
	transfer(this);
	setAutoUpdate(TRUE);

	repaint();
	setCurrentItem(0);
}

void KXHeaderList::setSortKey(int col)
{
	KConfig *config = app->getConfig();

	if (col == sortKey)
		isReverse = !isReverse;
	else
		sortKey = col;

	config->setGroup("General");
	config->writeEntry("SortRev",isReverse);
	config->writeEntry("SortKey",sortKey);

	reDisplay();
}

void KXHeaderList::slotCurrentCached()
{
	QString itemText(text(currentItem(),0));
	int res;

	if ((res = itemText.find('}')) >= 0) {
		itemText.replace(0,res+1,"{cached}");
		changeItemPart(itemText.data(),currentItem(),0);
	}
}

void KXHeaderList::slotCurrentRead()
{
	QString itemText(text(currentItem(),0));
	int res;

	if ((res = itemText.find('}')) >= 0) {
		itemText.replace(0,res+1,"{read}");
		changeItemPart(itemText.data(),currentItem(),0);
	}
}
