#ifndef KXMAINWIN_H
#define KXMAINWIN_H

#include <ktopwidget.h>
#include <knewpanner.h>

#include	"kxgenopts.h"


class KXmainwin : public KTopLevelWidget
{
  Q_OBJECT

public:
  KXmainwin();
  virtual ~KXmainwin();
	void cleanup();

public slots:
  void setMsg(const char *text);
  void setTmpMsg(const char *text,int time);
  void disableCommand(int id);
  void enableCommand(int id);
	void slotSendPending();
	void slotDelPending();

protected slots:
	void slotAccount();
	void slotNewsgroups();
	void slotExit();
	void slotExchg();
	void slotGenOpts();
	void slotGenTabOk();
	void slotComposer();
	void slotReply();

private:
  // Child widgets

  KMenuBar *menu;
  KToolBar *toolbar; 
  KStatusBar *statusbar; 

  void initMenuBar();
  void initToolBar();
  void initStatusBar();

	void readConfig(void);
	void writeConfig(void);

protected:
	void doSendPending(bool);
	virtual void closeEvent(QCloseEvent *);
	KNewPanner	*mVertPanner, *mHorizPanner;
	int mVertPannerSep,mHorizPannerSep;
	KXGenOpts *opts;
};

#endif
