#include	<unistd.h>
#include	<sys/time.h>

#include	<kapp.h>

#include	<mimelib/mimepp.h>

#include	<qstring.h>
#include	<qregexp.h>
#include	<qfile.h>

#include	<qmessagebox.h>

#include	"../config.h"
#include	"kxglobal.h"
#include	"kxmessage.h"

static QString result;


KXMessage::KXMessage()
{
	QString Xtxt;

	Xtxt.sprintf("%s %s", PACKAGE, VERSION);

	msg = new DwMessage();

	needsAssembly = TRUE;

	setHeaderField("X-NewsReader", Xtxt);

	struct timeval tval;
	gettimeofday(&tval, NULL);

	msg->Headers().Date().FromUnixTime(tval.tv_sec);
	msg->Headers().Date().Assemble();
	msg->Headers().MimeVersion().FromString("1.0");
}


KXMessage::~KXMessage()
{
	delete msg;
}

const QString KXMessage::body(void) const
{
  QString str;
  str = msg->Body().AsString().c_str();
  return str;
}

const QString KXMessage::asQuotedString(const QString aHeader,const QString indentStr)
{
	QRegExp reNL("\\n");  
	QString nlIndentStr = "\n" + indentStr;

	result = 
		QString(bodyDecoded()).stripWhiteSpace().replace(reNL,nlIndentStr) + '\n';  
	
	result = aHeader + indentStr + result;
	return(result);
}

void KXMessage::setBody(const QString aStr)
{
  msg->Body().FromString((const char*)aStr);
  needsAssembly = TRUE;
}

void KXMessage::setReplyBody(KXMessage *m,const QString aHeader,const QString indentStr)
{
	setBody(m->asQuotedString(aHeader,indentStr));
}

const QString KXMessage::references(void) const
{
  DwHeaders& header = msg->Headers();

	if (header.HasReferences())
		return header.References().AsString().c_str();
	else return "";
}

void KXMessage::setReferences(const QString aStr)
{
  if (!aStr) return;
	msg->Headers().References().FromString(aStr);
	needsAssembly = TRUE;
}

const QString KXMessage::groups(void) const
{
  DwHeaders& header = msg->Headers();

	if (header.HasNewsgroups())
			return header.Newsgroups().AsString().c_str();
	else
		return "";
}

void KXMessage::setGroups(const QString aStr)
{
	if (!aStr) return;
	msg->Headers().Newsgroups().FromString(aStr);
	needsAssembly = TRUE;
}

void KXMessage::setFrom(const QString aValue)
{
	setHeaderField("From:", aValue);
}

const QString KXMessage::from(void) const
{
	DwHeaders& header = msg->Headers();

	if (header.HasSubject())
		return decodeRFC1522String(header.From().AsString().c_str());
	else
		return "";  
}

const QString KXMessage::subject(void) const
{
	DwHeaders& header = msg->Headers();

	if (header.HasSubject())
		return decodeRFC1522String(header.Subject().AsString().c_str());
	else
		return "";  
}

void KXMessage::setSubject(const QString aValue)
{
	setHeaderField("Subject:", aValue);
}

void KXMessage::setNewsgrp(const QString aValue)
{
	setHeaderField("Newsgroups:", aValue);
}

time_t KXMessage::date(void) const
{
  DwHeaders& header = msg->Headers();
  if (header.HasDate()) return header.Date().AsUnixTime();
  return (time_t)-1;
}

void KXMessage::setDateToday(void)
{
  struct timeval tval;
  gettimeofday(&tval, NULL);
  setDate((time_t)tval.tv_sec);
}

void KXMessage::setDate(time_t aDate)
{
  msg->Headers().Date().FromUnixTime(aDate);
  msg->Headers().Date().Assemble();
  needsAssembly = TRUE;
}

void KXMessage::setDate(const QString aStr)
{
  DwHeaders& header = msg->Headers();

  header.Date().FromString(aStr);
  header.Date().Parse();
  needsAssembly = TRUE;
}
 
const QString KXMessage::dateStr(void) const
{
	return headerField("Date").stripWhiteSpace();
}
	 
void KXMessage::setMessageId(const QString aValue)
{
	setHeaderField("Message-ID:", aValue);
}

const QString KXMessage::followupto(void) const
{
  DwHeaders& header = msg->Headers();

  if (header.HasFollowupTo())
    return decodeRFC1522String(header.FollowupTo().AsString().c_str());
  else
  {
    if (header.HasNewsgroups())
      return header.Newsgroups().AsString().c_str();
    else return "";
  }
} 

void KXMessage::setFollowupto(const QString aValue)
{
	setHeaderField("Followup-To:", aValue);
}

void KXMessage::fromString(const QString aStr)
{
	int i, j, len;

  if (msg) delete msg;
  msg = new DwMessage;

  // copy string and throw out obsolete control characters
  len = aStr.length();
  result.resize(len +1);
  for (i=0,j=0; i<len; i++)
  {
    if (aStr[i]>=' ' || aStr[i]=='\t' || aStr[i]=='\n' || aStr[i]<='\0')
      result[j++] = aStr[i];
  }
  result[j++] = '\0'; // terminate zero for casting
  msg->FromString((const char*)result);
  msg->Parse();

//  if (aSetStatus)
//    setStatus(headerField("Status"), headerField("X-Status"));

  needsAssembly = FALSE;  
}

const QString KXMessage::asString(void)
{
  if (needsAssembly)
  {
    needsAssembly = FALSE;
    msg->Assemble();
  }
  result = msg->AsString().c_str();
  return result;
} 

const QString KXMessage::headerField(const QString aName) const
{
  DwHeaders& header = msg->Headers();

  if (aName.isEmpty())
    result = "";
  else
    result = decodeRFC1522String(header.FieldBody((const char*)aName).
                                 AsString().c_str());
  result.detach();
  return result;
}

void KXMessage::setHeaderField(const QString aName, const QString aValue)
{
  DwHeaders& header = msg->Headers();
  DwString str;
  DwField* field;

  if (aName.isEmpty()) return;

  str = aName;
  if (str[str.length()-1] != ':') str += ": ";
  else str += " ";
  str += aValue;
  if (aValue.right(1)!="\n") str += "\n";

  field = new DwField(str, msg);
  field->Parse();

  header.AddOrReplaceField(field);
  needsAssembly = TRUE;
}  

void KXMessage::toFile(const QString aFileName)
{
	QFile msgFile(aFileName);
	QString msgStr = asString();

	if (msgFile.open(IO_WriteOnly) == FALSE) {
		QMessageBox::information(toplevel, klocale->translate("Composer"),
			klocale->translate("Could not store this Message, check if spool-directory exists"),
			klocale->translate("Ok"));
	}

	msgFile.writeBlock(msgStr.data(), msgStr.size());
	msgFile.close();
}

const QString KXMessage::id(void) const
{
  DwHeaders& header = msg->Headers();

	if (header.HasMessageId())
		return header.MessageId().AsString().c_str();
	else
		return "";
} 

const QString KXMessage::genId(void) const
{
	static QString i;

	srand((int)time(NULL));
	i.sprintf("<%d.%d@%s>",time(NULL),rand(),gEntryList->selEntry->nntp.data());

	return(i);
}

void KXMessage::genMessageId(void)
{
	setMessageId(genId());
}

const QString KXMessage::bodyDecoded(void) const
{
  DwString dwsrc, dwstr;

  dwsrc = msg->Body().AsString().c_str();
  switch (cte())
  {
  case DwMime::kCteBase64:
    DwDecodeBase64(dwsrc, dwstr);
    break;
  case DwMime::kCteQuotedPrintable:
    DwDecodeQuotedPrintable(dwsrc, dwstr);
    break;
  default:
    dwstr = dwsrc;
    break;
  }

  return QString(dwstr.c_str(), dwsrc.size());
} 

void KXMessage::setBodyEncoded(const QString aStr)
{
  int len = aStr.length();
  DwString dwSrc(aStr.data(), len);
  DwString dwResult;

	DwEncodeQuotedPrintable(dwSrc, dwResult);

  msg->Body().FromString(dwResult);
  needsAssembly = TRUE;
}

const QString KXMessage::typeStr(void) const
{
  DwHeaders& header = msg->Headers();
  if (header.HasContentType()) return header.ContentType().AsString().c_str();
  else return "";
}

int KXMessage::type(void) const
{
  DwHeaders& header = msg->Headers();
  if (header.HasContentType()) return header.ContentType().Type();
  else return DwMime::kTypeNull;
}

void KXMessage::setTypeStr(const QString aStr)
{
  msg->Headers().ContentType().SetTypeStr((const char*)aStr);
  msg->Headers().ContentType().Parse();
  needsAssembly = TRUE;
}

void KXMessage::setType(int aType)
{
  msg->Headers().ContentType().SetType(aType);
  needsAssembly = TRUE;
}

int KXMessage::subtype(void) const
{
  DwHeaders& header = msg->Headers();

  if (header.HasContentType()) return header.ContentType().Subtype();
  else return DwMime::kSubtypeNull;
}

void KXMessage::setSubtypeStr(const QString aStr)
{
  msg->Headers().ContentType().SetSubtypeStr((const char*)aStr);
  msg->Headers().ContentType().Parse();
  needsAssembly = TRUE;
}   

void KXMessage::setContentTransferEncodingStr(const QString aStr)
{
  msg->Headers().ContentTransferEncoding().FromString((const char*)aStr);
  msg->Headers().ContentTransferEncoding().Parse();
  needsAssembly = TRUE;
}

int KXMessage::contentTransferEncoding(void) const
{
  DwHeaders& header = msg->Headers();

	if (header.HasContentTransferEncoding())
	return header.ContentTransferEncoding().AsEnum();
	else return DwMime::kCteNull;
}

void KXMessage::setContentTransferEncoding(int aCte)
{
  msg->Headers().ContentTransferEncoding().FromEnum(aCte);
  needsAssembly = TRUE;
} 
