#ifndef	KXMESSAGE_H
#define	KXMESSAGE_H

#include	<qstring.h>
#include	<mimelib/mimepp.h>

#include	"kxmsgbase.h"

class KXMessage : public KXMsgBase
{

public:
	KXMessage();
	~KXMessage();

	const QString asString(void);
	void fromString(const QString);

	void setMessageId(const QString);

	void setSubject(const QString);
	const QString subject(void) const;

	const QString from(void) const;
	void setFrom(const QString);

	void setNewsgrp(const QString);

	time_t date(void) const;
	void setDateToday(void);
	void setDate(time_t aDate);
	void setDate(const QString aStr);

	const QString followupto(void) const;
	void setFollowupto(const QString);

	void toFile(const QString);

	const QString body(void) const;
	const QString asQuotedString(const QString,const QString);
	void setBody(const QString);
	void setBodyEncoded(const QString aStr);
	const QString bodyDecoded(void) const;
	//void setReplyBody(const QString,const QString);
	void setReplyBody(KXMessage *,const QString,const QString);

	const QString references(void) const;
	void setReferences(const QString);

	const QString groups(void) const;
	void setGroups(const QString);

	const QString dateStr(void) const;

	const QString genId(void) const;
	const QString id(void) const;
	void genMessageId(void);

	const QString typeStr(void) const;
	int type(void) const;
	void setTypeStr(const QString aStr);
	void setType(int aType);
	int subtype(void) const;
	void setSubtypeStr(const QString aStr);

	int cte(void) const { return contentTransferEncoding(); }
	void setCte(int aCte) { setContentTransferEncoding(aCte); } 
	void setCteStr(const QString aStr) { setContentTransferEncodingStr(aStr); }
	void setContentTransferEncodingStr(const QString aStr);
	void setContentTransferEncoding(int aCte);
	int contentTransferEncoding(void) const;

	void setHeaderField(const QString, const QString);
	const QString headerField(const QString aName) const;

protected:
	DwMessage *msg;
	bool needsAssembly;

};

#endif
