#include	<unistd.h>
#include	<mimelib/mimepp.h>
#include	<qdir.h>
#include	<qfile.h>
#include	<qdatetime.h>
#include	<qstring.h>
#include	<gdbm.h>
#include	<qmessagebox.h>
#include	<qregexp.h>
#include	<qprogressdialog.h>
#include	"kxglobal.h"
#include	"kxarticledb.h"
#include	"kfileio.h"
#include	"kxnewsclient.h"
#include	"kxnewsclient.moc"

extern GDBM_FILE articleDb;

static int progressCount;

NNTP::NNTP() : DwNntpClient()
{
	entry = 0;
	group = "";
	lConnected = FALSE;
	nntpObserver = new NNTPObserver(this);

	connect(nntpObserver, SIGNAL(adv()), this, SLOT(gotAdv()));
}

NNTP::NNTP(KXEntry *_entry) : DwNntpClient()
{
	entry = _entry;	
	group = "";
	lConnected = FALSE;
	nntpObserver = new NNTPObserver(this);

	connect(nntpObserver, SIGNAL(adv()), this, SLOT(gotAdv()));
}

NNTP::~NNTP()
{
	clientDisconnect();
	delete nntpObserver;
}

void NNTP::gotAdv()
{
	if (progress != 0)
		progress->setProgress(progressCount++);
}

void NNTP::setEntry(KXEntry *_entry)
{
	if (entry != 0) {
		if (_entry->label() != entry->label())
			clientDisconnect();
	}

	entry = _entry;	
}

int NNTP::appendResponseFile(const DwString *str)
{
	return(responseFile->writeBlock(str->c_str(), str->size()));
}

int NNTP::sendCommand(char *cmd)
{
	int ret;

	strcpy (mSendBuffer,cmd);
	strcat (mSendBuffer,"\r\n");

	ret = PSend(mSendBuffer, strlen(mSendBuffer));
	debug("sending: %s (%d)", mSendBuffer,ret);
	PGetStatusResponse();
	
	if (ret == (int)strlen(mSendBuffer))
		return(0);

	lConnected = FALSE;
	return(-1);
}

int NNTP::clientConnect()
{
	int ret;

	if (isConnected()) {
		debug("no need to connect");
		return(0);
	}

	lConnected = FALSE;
	group = "";

	(void) Close();

	ret = Open(entry->nntp, atoi(entry->port));
	hostname = entry->nntp;

	if (ret <= 0)
		return(-1);

	if (sendCommand("mode reader") < 0)
		return(-1);

	if (listOverview() < 0)
		return(-1);

	lConnected = TRUE;
	return(0);
}

int NNTP::clientDisconnect()
{
	int ret;

	group = "";

	if (!isConnected())
		return(0);

	lConnected = FALSE;

	ret = Quit();
	debug("clientDisconnect (%d)",ret);

	if (ret <= 0)
		return (-1);

	return(Close());
}

int NNTP::listOverview()
{
	int idx;
	QString resp;
	char str[255];

	debug("list overview");

  ofSubject = 1;
	ofFrom = 2;
	ofDate = 3;
	ofId = 4;
	ofRef = 5;
	ofBytes = -1;
	ofLines = 7;

	mReplyCode = -1;

	sprintf(str, "LIST overview.fmt");
	if (sendCommand(str) < 0) {
		debug("no list overview");
		return(0);
	}

	PGetTextResponse();
	resp = QString(TextResponse().data());
	debug("%s",resp.data());

	idx = resp.find("Subject");
	if (idx != -1) ofSubject = resp.left(idx).contains('\n') + 1;

	idx = resp.find("From");
	if (idx != -1) ofFrom = resp.left(idx).contains('\n') + 1;

	idx = resp.find("Date");
	if (idx != -1) ofDate = resp.left(idx).contains('\n') + 1;

	idx = resp.find("Message-ID");
	if (idx != -1) ofId = resp.left(idx).contains('\n') + 1;

	idx = resp.find("References");
	if (idx != -1) ofRef = resp.left(idx).contains('\n') + 1;

	idx = resp.find("Bytes");
	if (idx != -1) ofBytes = resp.left(idx).contains('\n') + 1;

	idx = resp.find("Lines");
	if (idx != -1) ofLines = resp.left(idx).contains('\n') + 1;

	return(0);
}

int NNTP::newNews(KXEntry *_entry,char *_group, int max=0)
{
	char str[255];
	KSimpleConfig *info;
	int lfirst,llast;

	setEntry(_entry);

	if (clientConnect() < 0) {
		debug("sorry, no connection");
		return(-1);
	}

	if (setGroup(_group) < 0)
		return(-1);

	info = new KSimpleConfig(*entry->groupInfo + QString(_group));
	lfirst = info->readNumEntry("FirstMessage",0);
	llast = info->readNumEntry("LastMessage",0);  
	
	if (llast == lastMess) {
		debug("no new messages on server");
		return(0);
	}

	if (lastMess - llast > max) {
		llast = lastMess - max;
		debug("reduced: reading only %d messages",max);
	}

	sprintf(str, "xover %d-%d", llast+1, lastMess);
	if (sendCommand(str) < 0)
		return(-1);

	progressCount=0;
	progress = new QProgressDialog(_group,"Cancel",
		lastMess - llast,toplevel,0,TRUE);

	responseFile = new QFile(*gEntryMgr->groupPath() + QString("/") + QString(group));
	responseFile->open(IO_Append | IO_WriteOnly | IO_Raw);

	(void) SetObserver(nntpObserver);
	nntpObserver->setFMode('x');

	PGetTextResponse();
	debug("ready");

	(void) SetObserver(0);

	progress->setProgress(lastMess-llast);
	progress->close();
	delete progress;

	gdbm_sync(articleDb);
	responseFile->close();

	// update the "last message" from the server
	// in our configuration after reading the headers.
	// This means, if we stopped reading the headers
	// in the observer, we will have them twice.
	// Might be better than loosing them forever (?)
	// Solution for later: update it after every read header.

	info->writeEntry("FirstMessage",firstMess);
	info->writeEntry("LastMessage",lastMess);
	info->sync();
	delete info;
	
	return(0);
}

int NNTP::newArticle(const DwString *str)
{
	QStrList qsl;
	QString row;
	int lSize,idx1,idx;
	QString s(str->data());
	char *id,*val;
	datum key, content;

//	debug("%s",str->data());

	qsl.setAutoDelete(TRUE);

	if (s.size() <= 1)
		return(0);

	lSize = (int) s.size();

	idx1 = 0;
	for(idx=0;idx < lSize;) {
		idx = s.find('\t',idx+1);

		if (idx < 0 || idx > lSize)
			idx = lSize;

		qsl.append((QString(s.mid(idx1,idx - idx1)) + QString("\n")).data());

		idx1 = idx+1;
	}

	id = qsl.at(ofId);
	// debug("got message-id=%s",id);

	// this becomes the status byte
	row = QString(" ");

	if (ofSubject < 0) row += QString("\n"); else row += QString(qsl.at(ofSubject));
	if (ofFrom < 0) row += QString("\n"); else row += QString(qsl.at(ofFrom));
	if (ofDate < 0) row += QString("\n"); else row += QString(qsl.at(ofDate));
	if (ofRef < 0) row += QString("\n"); else row += QString(qsl.at(ofRef));
	if (ofLines < 0) row += QString("\n"); else row += QString(qsl.at(ofLines));
	if (ofBytes < 0) row += QString("\n"); else row += QString(qsl.at(ofBytes));

	val = row.data();

	key.dptr = id;
	key.dsize = strlen(id);
	content.dptr = val;
	content.dsize = strlen(val);

	// status byte
	*content.dptr = '\0';

	if (gdbm_store(articleDb, key, content, GDBM_REPLACE) < 0) {
		debug("could not store article in DB");
		return(-1);
	}

	responseFile->writeBlock(id,strlen(id));

	return(0);
}

int NNTP::setGroup(char *name)
{
	QString str;
	int idx;
	int ret;

	group = "";

	if ((ret = Group(name)) == 0) {
		lConnected = FALSE;
		return(-1);
	}

	group = name;

	str=StatusResponse().data();
	debug("Group: >%s<",str.data());

	idx=str.find(' ');
	str=str.right(str.length()-idx-1);
	idx=str.find(' ');
	numMess=str.left(idx).toInt();

	str=str.right(str.length()-idx-1);
																																									idx=str.find(' ');
	firstMess=str.left(idx).toInt();

	str=str.right(str.length()-idx-1);
	idx=str.find(' ');
	lastMess=str.left(idx).toInt();    

	debug("group %s: first %d, last %d, num %d",name,firstMess, lastMess, numMess);
	return(0);
}

int NNTP::sendMsg(KXEntry *_entry,QString& msg)
{
	int ret;

	setEntry(_entry);

	ret = clientConnect();

	int errcode=Post();

    debug ("post/errcode-->%d",errcode);
    if (!errcode)
    {
        warning ("The server closed the connection!");
        return (-1);
    }
    if (errcode!=340)
    {
        warning("error posting, I said POST, and the server said:\n%s",
                 StatusResponse().data());
        return (-1);
    }
    errcode=SendData((const char *)msg);
    debug ("senddata/errcode-->%d",errcode);
    if (!errcode)
    {
        warning ("The server closed the connection!");
        return (-1);
    }
    if (errcode>240)
    {
        warning("error posting, I said DATA, and the server said:\n%s",
                 StatusResponse().data());
        return (-1);
    }

		return (0);
}

int NNTP::readNewsGroups(KXEntry *_entry)
{
	int ret;
	QString command;

	setEntry(_entry);

	ret = clientConnect();
	
	if (ret < 0) {
		QMessageBox::information(0,"Create Connection",
			klocale->translate("NNTP-Server does not response"),
			klocale->translate("Ok"));

		return(-1);
	}

	(void) SetObserver(nntpObserver);
	nntpObserver->setFMode('n');

	progress = 0;
	QString tmpName = QString(entry->ngFile->name())+".tmp";

	responseFile = new QFile(tmpName);
	responseFile->open(IO_WriteOnly);

	List();

	responseFile->close();

	(void) SetObserver(0);

	command="cut -d\" \" -f1 < " + tmpName +
		"|sort|uniq >"+QString(entry->ngFile->name())+"; rm "+tmpName;
	system (command.data()); 

	toplevel->setMsg(klocale->translate("Ready"));
	return(0);
}

MessageParts NNTP::isCached (const char *_id)
{
	QString path;
	QString id=saneID(_id);
	int result=0;

	path=*gEntryMgr->dataPath()+"/"+id;

	if (QFile::exists(path.data()))
			result=result | KXALL;

	path = *gEntryMgr->dataPath()+"/"+id+".head";
	
	if (QFile::exists(path.data()))
			result=result | KXHEAD;

	path = *gEntryMgr->dataPath()+"/"+id+".body";

	if (QFile::exists(path.data()))
			result=result | KXBODY;

	return((MessageParts)result);
}

QString *NNTP::article(const char *_id)
{
	QString id = saneID(_id);
	QString p = *gEntryMgr->dataPath();
	QString *data = new QString("");

	p = p + QString("/") +id;

	if (isCached (id) == KXALL) {
		debug ("completely cached");
		data->setStr(kFileToString(p+".head"));
		data->append("\n\n");
		data->append(kFileToString(p+".body"));
		return(data);
	}

	(void) clientConnect();

	if (group == "")
		setGroup(group.data());
	
	if (isCached (id)==KXNONE) {
		debug ("nothing cached");
		bool success=false;
		int status=Article (id);

		if (!status) {
			return data;
		}
        
		debug ("status = %d",status);
		if (status == 220) {
			QString a(TextResponse().c_str());
			int limit = a.find("\r\n\r\n");

			debug ("limit-->%d",limit);
			kStringToFile(a.left(limit),p+".head",FALSE,FALSE,TRUE);
			kStringToFile(a.right(a.length()-limit-4),p+".body",FALSE,FALSE,TRUE);
			delete data;

			data=article(id);
			success=true;
		}
		else if (status==223) {
			status=Head(id);
			if (status==221) {
				QString s(TextResponse().c_str());

				kStringToFile(s,p+".head",FALSE,FALSE,TRUE);
				status=Body(id);

				if (status == 222) {
					s=(TextResponse().c_str());
					kStringToFile(s,p+".body",FALSE,FALSE,TRUE);
				}
				else
					success=false;
			}
			else
				success=false;
		}
		if (!success) {
			warning ("error getting data\nserver said %s\n",StatusResponse().c_str());
			unlink (p.data());
		}
	}
	else if (isCached(id)==KXHEAD) {
		debug ("head cached");
		data=body(id);
		delete data;
		data=article(id);
	}

	else if (isCached(id)==KXBODY) {
		debug ("body cached");
		data=head(id);
		delete data;
		data=article(id);
	}
    
	artDbSetFlag(&id, CACHED);
	debug("marked cached");
	return(data);
}

QString *NNTP::head(const char *_id)
{
	QString id = saneID(_id);
	QString *data = new QString ("");
	QString p = *gEntryMgr->dataPath() + QString("/") + id;

	if (isCached(id) & KXHEAD)
		data->append(kFileToString(p+".head"));
	else {
		int status=Head(id);

		if (status==221) {
			data->append(TextResponse().c_str());
			kStringToFile(*data,p+".head",FALSE,FALSE,TRUE);
		}
	}

	return data;
}

QString *NNTP::body(const char *_id)
{
	QString id=saneID(_id);
	QString *data=new QString ("");
	QString p = *gEntryMgr->dataPath() + QString("/") + id;

	if (isCached(id) & KXBODY)
		data->append(kFileToString(p+".body"));
	else {
		int status=Body(id);

		if (status == 222) {
			data->append(TextResponse().c_str());
			kStringToFile(*data,p+".body",FALSE,FALSE,TRUE);
		}
	}

	return(data);
}

QString NNTP::saneID(const char *id)
{
	QString r(id);
	return r.replace (QRegExp("/"),"\\#slash#\\");
}

///////////////////////////////////////////
// Observer
///////////////////////////////////////////

NNTPObserver::NNTPObserver(NNTP *client)
{
	nntpClient = client;
}

void NNTPObserver::setFMode(char _what)
{
	what = _what;
	numBytes = 0;
	lastStep = QTime::currentTime();
	lastBytes = 0;

	qSize = 3;
	qRun = 0;

	for (int i=0;i < qSize;i++)
		avr[i] = 0.0;
}

void NNTPObserver::Notify()
{
	char str[100];
	QTime currentTime;
	int n;
	float avrAll = 0.0;

	currentTime = QTime::currentTime();
	if (abs(currentTime.msecsTo(lastStep)) > 1*1000) {
		avr[qRun] = ((float)lastBytes / 
					(float)abs(currentTime.msecsTo(lastStep))) * 1000.0;

		qRun = (qRun+1) % qSize;

		lastBytes = 0;
		lastStep = QTime::currentTime();
	}

	for (int i=0;i < qSize;i++)
		avrAll += avr[i];

	avrAll /= qSize;

	n = (&nntpClient->TextResponse())->size();
	numBytes += n;
	lastBytes += n;
	sprintf(str, "%d kb, %.2f kb/sec", numBytes/1024,avrAll/1024);
		
	toplevel->setMsg(str);

//	debug("--%s--",(&nntpClient->TextResponse())->data());

	if (what == 'n') {
		nntpClient->appendResponseFile(&nntpClient->TextResponse());
	}
	else if (what == 'x') {
		nntpClient->newArticle(&nntpClient->TextResponse());
	}

	emit adv();
	app->processEvents();
}

NNTPObserver::~NNTPObserver()
{
}
