#ifndef	KXNEWSCLIENT_H
#define	KXNEWSCLIENT_H

#include	<mimelib/mimepp.h>
#include	<qprogressdialog.h>
#include	<qdatetime.h>
#include	"kxentry.h"

class NNTP;

#define KXNONE 0
#define KXHEAD 1
#define KXBODY 2
#define KXALL (KXHEAD | KXBODY)

enum MessageParts {Nopart=KXNONE,Head=KXHEAD,Body=KXBODY,All=KXALL};


class NNTPObserver : public QObject , public DwObserver
{
	Q_OBJECT

public:

	NNTPObserver(NNTP *);
	virtual ~NNTPObserver();

	virtual void Notify();
	void setFMode(char);

private:
	NNTP *nntpClient;
	int numBytes;
	char what;
	int endProgress;
	QTime lastStep;
	int lastBytes;
	float avr[3];
	int qSize, qRun;

signals:
	void adv();

};

class NNTP : public QObject , public DwNntpClient
{
	Q_OBJECT

public:
	// let him see "response" and co
	friend class NNTPObserver;

	NNTP(KXEntry *);
	NNTP();
	~NNTP();

	void setEntry(KXEntry *);

	int readNewsGroups(KXEntry *);
	int sendMsg(KXEntry *,QString&);
	int newNews(KXEntry *, char *, int max = 0);

	int clientDisconnect();
	bool isConnected() { return(lConnected == TRUE); };
	QString hostName() { return hostname; };
	QString from() { return entry->fullName; };

	MessageParts isCached (const char *_id);
	QString *article(const char *_id);

	int numMess,firstMess,lastMess;

protected:
	int clientConnect();
	int listOverview();
	int setGroup(char *);
	int sendCommand(char *);
	int newArticle(const DwString *);

	QString hostname;
	QString *head(const char *_id);
	QString *body(const char *_id);
	QString saneID(const char *id);

	int appendResponseFile(const DwString *);

	QProgressDialog *progress;
	KXEntry *entry;
	NNTPObserver *nntpObserver;
	DwString *responseString;
	QFile *responseFile;
	QString group;

	int ofSubject, ofFrom, ofDate, ofId, ofRef, ofLines, ofBytes;

private:
	int lConnected;

protected slots:
	void gotAdv();
	
};

#endif
