#include	<string.h>
#include	<unistd.h>

#include	<qfile.h>
#include	<qstring.h>
#include	<qtextstream.h>
#include	<qlistbox.h>
#include	<qmessagebox.h>

#include "kxglobal.h"
#include "kxentrylist.h"
#include "kxentry.h"
#include "kxentrymgr.h"
#include "kxngdialog.h"
#include "kxnewsclient.h"
#include "kxngdialog.moc"
#include "kxngdialogdata.moc"

#define Inherited KXNgDialogData


KXNgDialog::KXNgDialog
(
	KXEntry *ent,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	initMetaObject();

	setCaption(klocale->translate("Choose Newsgroups"));

	if (gEntryList->currentItem() < 0)
		return;

	entry = ent;
	ngHasChanged = FALSE;

	connect(this, SIGNAL(ngChanged()),
		gEntryList, SLOT(doEntryListChanged())); 

	init();
}

void KXNgDialog::init()
{
	QString line;

	checkNewsgroups();

	orgList = new ngList();
	orgList->setAutoDelete(TRUE);

	activeList = new ngList();
	activeList->setAutoDelete(TRUE);

	if (entry->ngFile->exists() == FALSE) {
		warning("cannot open newsgroups-file");
		return;
	}

	// read newgroups file

	entry->ngFile->open(IO_ReadOnly);
	QTextStream ts(entry->ngFile);

	while (!ts.eof()) {
		line = ts.readLine();

		if (line.size() <= 1)
			continue;

		orgList->append(new QString(line));
	}

	entry->ngFile->close();

	// read active file

	if (entry->activeFile->exists() == TRUE) {
		entry->activeFile->open(IO_ReadOnly);
		QTextStream ts(entry->activeFile);

		while (!ts.eof()) {
			line = ts.readLine();

			if (line.size() <= 1)
				continue;

			activeList->append(new QString(line));
		}

		entry->activeFile->close();
	}

	sub = new QString("* ");
	noSub = new QString("  ");

	slotAllGroups();
}


KXNgDialog::~KXNgDialog()
{
	delete lbox;
	delete orgList;
	delete activeList;
}

// create new active-file if subscribe-list has changed
//
void KXNgDialog::slotOk()
{
	QString line;
	uint idx,maxIdx;
	const char *orgPtr;

	if (ngHasChanged == FALSE || entry->ngFile->exists() == FALSE) {
		accept();
		return;
	}

	entry->activeFile->open(IO_WriteOnly);
	maxIdx = activeList->count();

	for (idx=0;idx < maxIdx;idx++) {
		orgPtr = activeList->at(idx)->data();
		if (strlen(orgPtr) > 0) {
			entry->activeFile->writeBlock(orgPtr, strlen(orgPtr));
			entry->activeFile->putch('\n');
		}
	}

	entry->activeFile->close();
	
	emit ngChanged();
	accept();
}

// rebuild list with filter str
//
void KXNgDialog::slotSearchChanged(const char *str)
{
	uint adx,idx,maxAdx,maxIdx,res;
	char *orgPtr;
	bool found;
	static int status = 0;
	int localStatus;
	
	status++;
	localStatus = status;
	
	debug("searching %s, status == %d",str,status);

	lbox->setAutoUpdate(FALSE);

	maxIdx = orgList->count();
	maxAdx = activeList->count();

	lbox->clear();

	for (idx=0,res=0;idx < maxIdx;idx++) {
		// bug or feature ???
		if (localStatus != status)
			return;

		orgPtr = orgList->at(idx)->data();

		// is it in active list ?
		if (strstr(orgPtr, str) != (char *) NULL) {
			for (adx=0,found=FALSE;adx < maxAdx;adx++) {
				if (!strcmp(orgPtr, activeList->at(adx)->data())) {
					found = TRUE;
					break;
				}
			}

			if (strlen(orgPtr) > 0) {
				if (found == TRUE)
					lbox->insertItem(*sub + orgPtr, -1);
				else if (allGroups->isChecked() == TRUE)
					lbox->insertItem(*noSub + orgPtr, -1);

				res++;
			}
		}

		// process current searchstring-input
		if (idx % 100 == 0)
			app->processEvents();
	}

	debug("%d entries found", res);
	lbox->setAutoUpdate(TRUE);
	lbox->repaint();
}

void KXNgDialog::slotSelected(int item)
{
	QString *orgVal;
	QString *newVal;

	debug("%s selected", lbox->text(item));

	ngHasChanged = TRUE;
	orgVal = new QString(lbox->text(item));

	if (orgVal->find(sub->data(),0) == 0) {
		newVal = &orgVal->replace(0, sub->size()-1,noSub->data());
		lbox->changeItem(newVal->data(),item);
		outActive(&newVal->replace(0,noSub->size()-1,""));
	}
	else {
		newVal = &orgVal->replace(0, noSub->size()-1,sub->data());
		lbox->changeItem(newVal->data(),item);
		inActive(&newVal->replace(0,sub->size()-1,""));
	}
}

void KXNgDialog::slotSubscribed()
{
	allGroups->setChecked(FALSE);
	subscribed->setChecked(TRUE);

	slotSearchChanged(searchEdit->text());
}

void KXNgDialog::slotAllGroups()
{
	allGroups->setChecked(TRUE);
	subscribed->setChecked(FALSE);

	slotSearchChanged(searchEdit->text());
}

void KXNgDialog::inActive(QString *item)
{
	uint idx;

	debug("append active %s",item->data());

	for (idx=0;idx < activeList->count();idx++) {
		if (!strcmp(activeList->at(idx)->data(), item->data()))
			return;
	}

	activeList->append(item);
}

void KXNgDialog::outActive(QString *item)
{
	uint idx;

	debug("remove active %s",item->data());

	for (idx=0;idx < activeList->count();idx++) {
		if (!strcmp(activeList->at(idx)->data(), item->data())) {
			activeList->remove(idx);
			debug("deleted");
		}
	}
}

void KXNgDialog::getNewsgroups()
{
	debug("getting newsgroups for %s", entry->label()->data());

	if (gNNTP->readNewsGroups(entry) < 0)
		return;

	ngHasChanged = TRUE;
	(void) unlink(entry->activeFile->name());
}

void KXNgDialog::slotNewList()
{
	(void) unlink(entry->ngFile->name());
	getNewsgroups();

	init();
}

void KXNgDialog::checkNewsgroups()
{
	if (entry->ngFile->exists() == FALSE) {
    if (!QMessageBox::information(this,klocale->translate("Newsgroups"),
        klocale->translate("You don't have any newsgroups. Get them now?"),
				klocale->translate("Yes"), klocale->translate("No"))) {
			getNewsgroups();
    }
	}
}
