#ifndef KXNgDialog_included
#define KXNgDialog_included

#include	<qstring.h>

#include "kxentry.h"
#include "kxngdialogdata.h"

typedef QList<QString> ngList;

class KXNgDialog : public KXNgDialogData
{
    Q_OBJECT

public:

    KXNgDialog
    (
				KXEntry *ent,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~KXNgDialog();

protected slots:
	void slotOk();
	void slotSelected(int);
	void slotSearchChanged(const char *);
	void slotSubscribed();
	void slotAllGroups();
	void slotNewList();

protected:
	KXEntry *entry;
	void inActive(QString *);
	void outActive(QString *);
	void checkNewsgroups();
	void getNewsgroups();
	ngList *orgList;
	ngList *activeList;
	QString *sub;
	QString *noSub;
	bool ngHasChanged;
	  
private:
	void init();

signals:
	void ngChanged();

};
#endif // KXNgDialog_included
