#include	<qscrollbar.h>

#include	"kxglobal.h"
#include	"kxarticledb.h"
#include	"kxheaderlist.h"
#include	"kxnewsclient.h"
#include	"kxmessage.h"

#include	"kxviewport.moc"


KXViewPort::KXViewPort(QWidget *parent=0, const char *name=0) :
	KXViewPortInherited(parent, name)
{
	initMetaObject();

	htmlView = new KHTMLWidget(this);

	sBarVert = new QScrollBar(QScrollBar::Vertical,this,name);
	sBarHorz = new QScrollBar(QScrollBar::Horizontal,this,name);

	connect(gHeaderList, SIGNAL(headerSelected(KXArtElem *)),
		this, SLOT(reload(KXArtElem *)));

  connect(this, SIGNAL(doCurrentRead()),
	    gHeaderList, SLOT(slotCurrentRead()));   

	connect(htmlView, SIGNAL(scrollVert(int)), SLOT(slotScrollVert(int)));
  connect(htmlView, SIGNAL(scrollHorz(int)), SLOT(slotScrollHorz(int)));
  connect(sBarVert, SIGNAL(valueChanged(int)), htmlView, SLOT(slotScrollVert(int)));
  connect(sBarHorz, SIGNAL(valueChanged(int)), htmlView, SLOT(slotScrollHorz(int)));
  connect(htmlView, SIGNAL(documentChanged()), SLOT(slotDocumentChanged()));
  connect(htmlView, SIGNAL(documentDone()), SLOT(slotDocumentDone()));

	msg(0);
}


KXViewPort::~KXViewPort()
{
}

void KXViewPort::resizeEvent(QResizeEvent *)
{
  htmlView->setGeometry(0, 0, width()-16, height()-16);

	sBarHorz->setGeometry(0, height()-16, width()-16,16);
	sBarVert->setGeometry(width()-16, 0, 16, height()-16);

  sBarHorz->setSteps( 12, htmlView->width() - 12 );
  sBarVert->setSteps( 12, htmlView->height() - 12 );
} 

void KXViewPort::reload(KXArtElem *headerArt)
{
	QString *d = gNNTP->article(headerArt->ID->data());
	QString qid(*headerArt->ID);
	QString res;
	KXMessage *showMsg = new KXMessage();
	
	showMsg->fromString(*d);

	if (d->isEmpty()) {
		msg("<br>Sorry, article is not cached");
	}
	else {
		res = QString("<font size=+1>");

		res += showMsg->subject() + QString("<br>");

		res += QString("</font>");

		res += QString("From:\t\t") + showMsg->from() + QString("<br>");
		res += QString("Date:\t\t") + showMsg->dateStr() + QString("<br> <br> <br>");

		res += showMsg->bodyDecoded();

		msg(strToHtml(res).data());

		if (!(headerArt->statusByte & READ)) {
			emit doCurrentRead();
			artDbOrFlag(&qid, READ);
		}
	}

	delete d;
}

const QString KXViewPort::strToHtml(QString inPut)
{
	static QString res;
	QString encStr = decodeRFC1522String(inPut);
	char *p;

	res = "";

	for(p=encStr.data();*p;p++) {
		switch(*p) {
			case '\n':	res += "<br>";
				break;
			default:		res += *p;
				break;
		}
	}

	return(res);
}

void KXViewPort::msg(char *m)
{
	htmlView->begin();
	htmlView->parse();
	htmlView->write("<HTML><BODY BGCOLOR=\"#FFFFFF\">");

	if (m != 0)
		htmlView->write(m);

	htmlView->write("</BODY></HTML>");
	htmlView->end();
	htmlView->show();
}

void KXViewPort::slotScrollVert(int val)
{
	sBarVert->setValue(val);
}

void KXViewPort::slotScrollHorz(int val)
{
	sBarHorz->setValue(val);
}

void KXViewPort::slotDocumentChanged()
{
	debug("DocumentChanged");

	if (htmlView->docHeight() > (this->height()-16))
    sBarVert->setRange(0, htmlView->docHeight() -
        (this->height()-16));
  else
    sBarVert->setRange(0, 0);

  if (htmlView->docWidth() > (this->width()-16))
    sBarHorz->setRange(0, htmlView->docWidth() -
        (this->width()-16));
  else
    sBarHorz->setRange(0, 0);
}

void KXViewPort::slotDocumentDone()
{
	debug("DocumentDone");
}          
