#include <stdio.h>
#include <kapp.h>
#include <qlistbox.h>
#include <mimelib/mimepp.h>

#include "../config.h"
#include "kxglobal.h"
#include "kxmainwin.h"
#include "kxentrylist.h"
#include "kxviewport.h"
#include "kxheaderlist.h"
#include "kxentrymgr.h"
#include "kxarticledb.h"

KApplication *app = NULL;
KXEntryMgr *gEntryMgr;
NNTP *gNNTP;
KXEntryList *gEntryList;
KXHeaderList *gHeaderList;
KXViewPort *gViewPort;
QListBox *gMessageList;
KXmainwin *toplevel;

GDBM_FILE articleDb;

void usage()
{
  printf("%s %s (c) Peter Wichert 1998\n", PACKAGE,VERSION);
  printf( "Released under GPL\n");
}

int main(int argc, char **argv)
{
  if ((argc == 2) && (strcmp(argv[1], "-h") == 0)) {
    usage();
    exit(0);
  }

	DwInitialize();

  app = new KApplication(argc, argv, "kexpress");

	gEntryMgr = new KXEntryMgr();
	gNNTP = new NNTP();

	QString f = QString(*gEntryMgr->basePath() + QString("/article.gdbm"));

	articleDb = gdbm_open(f.data() , 0, GDBM_WRCREAT, 0644, 0);
	newKXArticleDb();

	if (!articleDb) {
		warning("you are not alone ...");
		exit(-1);
	}

  // Create top level window
  toplevel= new KXmainwin();

  app->setMainWidget(toplevel);
  toplevel->show();
  app->exec();

	exit (0);
}
