#include <stdio.h>
#include <malloc.h>
#include <string.h>

#define OUTNOW	fseek(stderr,0,SEEK_END)

long Endian(long in)
{
long out;
  out=in&0xFF;
  out<<=8;in>>=8;
  out|=(in&0xFF);
  out<<=8;in>>=8;
  out|=(in&0xFF);
  out<<=8;in>>=8;
  out|=(in&0xFF);
return out;
}

void FWRITE(unsigned char *buf,int size,int n,FILE *out)
{
int i,k;
  for(i=0,k=0;i<size;i++) {
    buf[k]=buf[i];
    if (buf[i]!=13) { k+=1; }
  }
  fwrite(buf,k,n,out);
}


long Offset(long in) { return Endian(in); }
long Size(long in)   { return Endian(in); }

typedef enum {
   RDMSG,
   EOFMSG
} state_t;


/*
   READ  offset==word, maxblocksize (0x00020000), blocklen, endofblock(offset)

   endofblock==0 ==> end of message
   maxblocksize==0 && blocklen==0 && endofblock==0 ==> search sequentiel for
                                                       next block

*/

void convert(FILE *in,FILE *out)
{
unsigned long word,offset,max_blocklen,blocklen,next_offset;
state_t s;
char *buf=(char *) malloc(10);

   fseek(in,0,SEEK_SET);
   offset=0;
   fread(&word,sizeof(word),1,in);

   while (!feof(in)) {
     if (Offset(word)==offset) {
       fprintf(stderr,"%08xl   %08xl  %08xl\n",offset,word,Offset(word));

       fread(&max_blocklen,sizeof(max_blocklen),1,in);
       fread(&blocklen,sizeof(blocklen),1,in);
       fread(&next_offset,sizeof(next_offset),1,in);

       /* start new message */

       s=RDMSG;
       while (!feof(in) && s!=EOFMSG) {
         fprintf(stderr,"%08xl   %08xl  %08xl\n",offset,word,Offset(word));

         if (Size(blocklen)!=0) {
           buf=(char *) realloc(buf,Size(blocklen));
           fread(buf,Size(blocklen),1,in);
           /*fprintf(out,"\n--newblock--\n");*/
           FWRITE(buf,Size(blocklen),1,out);
         }

         /* adjust on long boundaries */

         fprintf(stderr,"%08xl  %1d\n",ftell(in),ftell(in)%sizeof(word));
         while(ftell(in)%sizeof(word)!=0) { fgetc(in); }

         /* read next long */

         fread(&word,sizeof(word),1,in);
         if (Offset(word)==Offset(next_offset) && Offset(next_offset)!=0) {
           fread(&max_blocklen,sizeof(max_blocklen),1,in);
           fread(&blocklen,sizeof(blocklen),1,in);
           fread(&next_offset,sizeof(next_offset),1,in);
         }
         else if (Size(max_blocklen)==0 && Size(blocklen)==0 && 
                  Offset(next_offset)==0
                 ) {
             offset=ftell(in);
             fread(&word,sizeof(word),1,in);
             while(!feof(in) && Offset(word)!=offset) {
               offset=ftell(in);
               fread(&word,sizeof(word),1,in);
             }
         }
         else if (Offset(next_offset)==0) {
           s=EOFMSG;
         }
       }
     }
     offset=ftell(in);
     fread(&word,sizeof(word),1,in);
   }
}

void ConvertMessage(FILE *in,FILE *out,unsigned long start) 
{
unsigned long word,offset,max_blocklen,blocklen,next_offset;
char *buf=(char *) malloc(10);
state_t s;
int   FirstBlock=1;

   // This is for the mbox format (also used by kmail) 
   // to start the message.

   fprintf(out,"\n");
   fprintf(out,"From devil@hell Fri Jun 23 05:39:56 EDT 2000\n"); 

   fseek(in,start,SEEK_SET);
   offset=start;
   fread(&word,sizeof(word),1,in);

   if (Offset(word)!=offset) {
     fprintf(stderr,"HEY! This should not happen, can't read message here!\n");
   }
   else {
       fread(&max_blocklen,sizeof(max_blocklen),1,in);
       fread(&blocklen,sizeof(blocklen),1,in);
       fread(&next_offset,sizeof(next_offset),1,in);

       /* start reading message */

       s=RDMSG;
       while (s!=EOFMSG) {

         if (Size(blocklen)!=0) {int o=0;

           buf=(char *) realloc(buf,Size(blocklen));
           fread(buf,Size(blocklen),1,in);

/*
	   // For the first block, skip the Status Part (only OE5 compatible)
	   // Thus that is the first line if it has 'Status:' at the beginning.

	   if (FirstBlock) {
	     FirstBlock=0;
	     if (strncmp(buf,"Status:",7)==0) { // skip the status line
						// Hope this works always,
						// Maybe trouble with block
						// boundaries
	       while(buf[o]!='\n') { o+=1; }
	       o+=1;
	     }
	   }
*/
           FWRITE(buf+o,Size(blocklen)-o,1,out);
         }

         /* seek to next block and read next long */

	 fseek(in,Offset(next_offset),SEEK_SET);
         fread(&word,sizeof(word),1,in);

         if (Offset(word)==Offset(next_offset) && Offset(next_offset)!=0) {
           fread(&max_blocklen,sizeof(max_blocklen),1,in);
           fread(&blocklen,sizeof(blocklen),1,in);
           fread(&next_offset,sizeof(next_offset),1,in);
         }
         else if (Offset(next_offset)==0) {
           s=EOFMSG;
         }
	 else {
           fprintf(stderr,"HEY! This should not happen, can't read message here!\n");
	   s=EOFMSG;
	 }
       }
     }
     free(buf);
}

void forward(FILE *in,int steps)
{
unsigned long word;
  fseek(in,steps*sizeof(word),SEEK_CUR);
}

void GetMessageStarts(FILE *in,int *msgstarts)
{
unsigned long adress;
unsigned long messages;

  // First we seek to the beginning of the file.

  fseek(in,0,SEEK_SET);

  // The 13th long word catches the adress of the 
  // message header index. We read it and seek to it

  forward(in,12);
  fread(&adress,sizeof(adress),1,in);
  adress=Offset(adress);
  fseek(in,adress,SEEK_SET);
  fprintf(stderr,"Index starts at %08x\n",adress);OUTNOW;

  // Now we're in the index.
  // Start reading: The 5th long word, from second byte gives
  // us the right number of messages. Thus, we need only 3 bytes
  // of the 4 byte long.

  forward(in,4);
  fread(&messages,sizeof(messages),1,in);
  messages<<=8;messages=Endian(messages);
  fprintf(stderr,"%ld (0x%lx) messages in the index\n",messages,messages);OUTNOW;

  // Now we're going to read these messages index starts.
  // Forward to the first one right now.

  forward(in,1);
  {int i;
    for(i=0;i<messages;i++) {
      fread(&msgstarts[i],sizeof(msgstarts[i]),1,in);
      msgstarts[i]=Endian(msgstarts[i]);
      fprintf(stderr,"message index %d starts at %08x\n",i,msgstarts[i]);OUTNOW;
      forward(in,2);
    }
    msgstarts[i]=0;
  }

  // Now convert these message index starts to the real message
  // starts
  // Seek to the index position of msgstarts[]; and read the 7e
  // long word. Here also the first byte should be skipped.

  {int i;
    for(i=0;i<messages;i++) {unsigned long offset;
      fseek(in,msgstarts[i],SEEK_SET);
      forward(in,6);
      fread(&offset,sizeof(offset),1,in);
      offset<<=8;offset=Endian(offset);
      fprintf(stderr,"message %d (index %08x) starts at %08x\n",i,msgstarts[i],offset);OUTNOW;
      msgstarts[i]=offset;
    }
  }

  // Now we kan go seeking out the messages (they can be
  // fragmented, so we're going to read blocks here).
}

int main()
{
int msgstarts[10240];
int i;
  fprintf(stderr,"Reading message starts\n");OUTNOW;
  GetMessageStarts(stdin,msgstarts);
  for(i=0;msgstarts[i]!=0;i++) {
    fprintf(stderr,"Converting message at %08x\n",msgstarts[i]);OUTNOW;
    ConvertMessage(stdin,stdout,msgstarts[i]);
  }
}
