/*
    hexview.c
    
    Copyright (C) 6-2000  Hans Dijkema 
    See README and COPYING for more information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>

#define MAX  16

int main()
{
unsigned char bytes[MAX];
long offset=0;
int  i;
FILE *in=stdin,*out=stdout;

   while(!feof(in)) {
     for(i=0;i<MAX;i++) { bytes[i]=0; }
     fread(bytes,MAX,1,in);
     fprintf(out,"%08x  ",offset);
     for(i=0;i<MAX;i++) {
       if ((i%4)==0) { fprintf(out," "); }
       fprintf(out,"%02x ",bytes[i]);
     }
     for(i=0;i<MAX;i++) {
       if (bytes[i]>=' ' && bytes[i]<127) { fprintf(out,"%c",bytes[i]); }
       else { fprintf(out,"."); }
     }
     fprintf(out,"\n");
     offset+=MAX;
   }
}
