/* ****************************** -*-c++-*- *******************************/
/* ************************************************************************ 
 *         The Amulet User Interface Development Environment              *
 * ************************************************************************
 * This code was written as part of the Amulet project at                 *
 * Carnegie Mellon University, and has been placed in the public          *
 * domain.  If you are using this code or any part of Amulet,             *
 * please contact amulet@cs.cmu.edu to be put on the mailing list.        *
 * ************************************************************************/

#ifndef STANDARD_SLOTS_H
#define STANDARD_SLOTS_H

#include <am_inc.h>

#include OBJECT__H

// Object slots (0-99)
#define Am_NO_SLOT        0
#define Am_NO_INHERIT     2
//do not use 1 since true==1 as slot name has a special meaning for interactors
#define Am_OWNER          10
#define Am_PROTOTYPE      11
#define Am_SOURCE_OF_COPY 12

enum Am_Standard_Slot_Keys {
  //////
  // Graphical Object slots
  //////
  Am_LEFT = 100, Am_TOP, Am_WIDTH, Am_HEIGHT, 
  Am_WINDOW, Am_VISIBLE, 
  Am_FILL_STYLE, Am_LINE_STYLE, 

  // Windows, Screens
  Am_TITLE, Am_ICON_TITLE, 
  Am_MAX_WIDTH, Am_MAX_HEIGHT, Am_MIN_WIDTH, Am_MIN_HEIGHT, 
  Am_USE_MAX_WIDTH, Am_USE_MAX_HEIGHT, Am_USE_MIN_WIDTH, Am_USE_MIN_HEIGHT, 
  Am_ICONIFIED, Am_QUERY_POSITION, Am_QUERY_SIZE, Am_OMIT_TITLE_BAR,
  Am_LEFT_BORDER_WIDTH, Am_TOP_BORDER_WIDTH, Am_RIGHT_BORDER_WIDTH, 
  Am_BOTTOM_BORDER_WIDTH, 
  Am_CURSOR, Am_SAVE_UNDER, Am_CLIP_CHILDREN, Am_CLIP, Am_GRAPHICAL_PARTS,
  Am_PRETEND_TO_BE_LEAF, Am_RANK, 
  Am_OWNER_DEPTH, // Num owners from this obj up to window
  Am_IS_COLOR, // boolean for Am_Window and Am_Screen: color screen? 
  Am_OFFSCREEN_DRAWONABLE, // Am_Screen: store an offscreen drawonable
  Am_DESTROY_WINDOW_METHOD, //Am_Window: user asked for destroy
  Am_DOUBLE_BUFFER, // Am_Window: double buffered? bool.

  // Lines
  Am_X1, Am_Y1, Am_X2, Am_Y2,
  
  // Layout directions
  Am_LAYOUT, Am_H_SPACING, Am_V_SPACING, Am_H_ALIGN, Am_V_ALIGN,
  Am_FIXED_WIDTH, Am_FIXED_HEIGHT, Am_INDENT, Am_MAX_RANK, Am_MAX_SIZE,
  
  // Am_Map 
  Am_ITEMS, Am_ITEM, Am_ITEM_METHOD, Am_ITEM_PROTOTYPE,
  
  Am_HIT_THRESHOLD, //how close need to be to count as a hit
  
  // Arcs
  Am_ANGLE1, Am_ANGLE2,
  
  // Roundtangle
  Am_RADIUS, Am_DRAW_RADIUS,
  
  // Text
  Am_TEXT, Am_FONT, Am_CURSOR_INDEX, Am_CURSOR_OFFSET,
  Am_INVERT,
  
  // Bitmap
  Am_IMAGE,

  // Polygon
  Am_POINT_LIST,

  Am_CENTER_X_OBJ, //for center_x_is_center_of formula
  Am_CENTER_Y_OBJ, //for center_y_is_center_of formula
  Am_SELECT_OUTLINE_ONLY,
  Am_SELECT_FULL_INTERIOR,

  /////
  // Interactor Slots
  /////

  Am_START_WHEN, Am_START_WHERE_TEST,
  
  Am_RUNNING_WHERE_OBJECT, Am_RUNNING_WHERE_TEST,

  Am_ABORT_WHEN, Am_STOP_WHEN,

  Am_INTER_START_METHOD, Am_INTER_RUNNING_METHOD, Am_INTER_OUTSIDE_METHOD, 
  Am_INTER_BACK_INSIDE_METHOD, Am_INTER_STOP_METHOD,
  Am_INTER_OUTSIDE_STOP_METHOD, Am_INTER_ABORT_METHOD,

  Am_COMMAND, 
  Am_IMPLEMENTATION_COMMAND, //inter allocates this command for undo

  Am_START_DO_METHOD, Am_INTERIM_DO_METHOD, Am_ABORT_DO_METHOD, Am_DO_METHOD,

  Am_CONTINUOUS, Am_ACTIVE,
  
  Am_PRIORITY,

  Am_GRID_X, Am_GRID_Y, Am_GRID_ORIGIN_X, Am_GRID_ORIGIN_Y, Am_GRID_METHOD,
  
  Am_INTER_BEEP_ON_ABORT, //whether beeps when abort, default is true

  ///// slots of specific interactors

  // choice interactor
  Am_HOW_SET, Am_FIRST_ONE_ONLY, // whether like button or menu

  // move grow interactor
  Am_WHERE_ATTACH, Am_MINIMUM_WIDTH, Am_MINIMUM_HEIGHT, Am_MINIMUM_LENGTH,
  Am_GROWING, Am_AS_LINE,
  Am_FEEDBACK_OBJECT,
  // NIY  Am_SLOTS_TO_SET, //which slots of obj to set

  // new points interactor
  Am_CREATE_NEW_OBJECT_METHOD, Am_HOW_MANY_POINTS, Am_FLIP_IF_CHANGE_SIDES,
  Am_ABORT_IF_TOO_SMALL,

  // text edit interactor
  Am_EDIT_TRANSLATION_TABLE, Am_TEXT_EDIT_METHOD,
  Am_PENDING_DELETE, //of the text object
  Am_WANT_PENDING_DELETE, //in the text_interactor

  ///// "Advanced" interactor slots sometimes used externally
    
  Am_MULTI_OWNERS,  // when multi-window interactor, put win list here
  Am_MULTI_FEEDBACK_OWNERS, //multi-window feedback owners for move- and new-
  Am_CURRENT_OBJECT,  // set with object currently over
  Am_START_OBJECT,   //first object over
  Am_START_CHAR,    // first am_input_char that started the interactor

  Am_RUN_ALSO, // whether other interactors can also run
  Am_X_OFFSET, // move-grow X offset for points
  Am_Y_OFFSET, // move-grow Y offset for points
  Am_FIRST_X, //initial point where hit
  Am_FIRST_Y, //set for all interactors

  ///// Internal slots of Interactors (do not set or access)
  Am_CURRENT_STATE,
  Am_INTER_LIST, // list of interactors for a window
  Am_WHERE_HIT_WHERE_ATTACH,  // move-grow real attach for where-hit
  Am_DEPENDS_ON_PRIORITY, //formula in here maintains inter_list
  Am_DEPENDS_ON_RANK_DEPTH, //formula in here maintains inter_list
  Am_DEPENDS_ON_MULTI_OWNERS, //formula in here maintains inter_list
  Am_LAST_WINDOW,  //inter_list window
  Am_LAST_WINDOWS,  //inter_list window in more than one
  Am_REAL_RUN_ALSO,  // text_inter: copy of run_also
  Am_SET_COMMAND_OLD_OWNER, // formula: sets Am_SAVED_OLD_OWNER of
                           // cmd to the inter or widget
  Am_INITIAL_REF_OBJECT, //new_points
  //Gesture Interactor: features of a gesture
  Am_START_X, Am_START_Y, Am_INITIAL_SIN, Am_INITIAL_COS,
  Am_DX2, Am_DY2, Am_MAGSQ2, Am_END_X, Am_END_Y, 
  Am_MIN_X, Am_MAX_X, Am_MIN_Y, Am_MAX_Y,
  Am_TOTAL_LENGTH, Am_TOTAL_ANGLE, Am_ABS_ANGLE, Am_SHARPNESS,
  Am_CLASSIFIER, Am_NONAMBIGUITY_PROB, Am_DIST_TO_MEAN,
  Am_MIN_NONAMBIGUITY_PROB, Am_MAX_DIST_TO_MEAN,


  //////
  // Slots of Command Objects
  //////
  
  // Am_DO_METHOD, // defined with interactors
  Am_UNDO_METHOD, Am_REDO_METHOD, Am_SELECTIVE_UNDO_METHOD,
  Am_SELECTIVE_REPEAT_SAME_METHOD, Am_SELECTIVE_REPEAT_ON_NEW_METHOD,
  Am_SELECTIVE_UNDO_ALLOWED, Am_SELECTIVE_REPEAT_SAME_ALLOWED,
  Am_SELECTIVE_REPEAT_NEW_ALLOWED,
  
  Am_SHORT_HELP, // one-line or balloon help message
  Am_LONG_HELP, // long help message to put into a window 
  // Am_ACTIVE, // defined with interactors.
  
  Am_LABEL, // used for menu's label and for "UNDO -" 
  Am_SHORT_LABEL, // used for menu's label and for "UNDO -" 
  Am_ACCELERATOR, // event to also execute this
  Am_ID, // if non-zero, identified the cmd instead of label

  Am_IMPLEMENTATION_PARENT,
  Am_COMPOSITE_PARENT,

  // internal slots of command objects (do not set)
  Am_COMMAND_IS_ABORTING,
  Am_IMPLEMENTATION_CHILD,
  Am_COMPOSITE_CHILDREN,

  ///// slots of specific kinds of command objects

  Am_VALUE, // main value
  Am_INTERIM_VALUE, // interim (running) value
  Am_OLD_INTERIM_VALUE, // old interim (running) value for choice
  Am_OLD_VALUE, // used to store old value for UNDO
  Am_OBJECT_MODIFIED, // actual obj being modified
  Am_TOO_SMALL, // new-point: true if object is too small
  Am_HAS_BEEN_UNDONE, // new-point: true if new object removed
  Am_SAVED_OLD_OWNER, // old owner (inter or widget for command)
  Am_SAVED_OLD_OBJECT_OWNER, // new_points: new_obj's old owner
  
  // slots set into the actual objects
  Am_SELECTED, // set in objects that are selected
  Am_INTERIM_SELECTED, // set in objects that mouse is over


  // Slots of Undo Objects (450-499)
  
  Am_UNDO_HANDLER, // slot of Window or Appl holding undo obj
  Am_REGISTER_COMMAND, // slot of undo obj holding func to accept
                       // new commands that have been executed
  Am_PERFORM_UNDO, // slot of undo obj holding func for undo
  Am_PERFORM_REDO, // slot of undo obj holding func for redo
  Am_UNDO_ALLOWED, // if can undo now, contains the command
		   // object that will be undone, otherwise
		   // contains 0
  Am_REDO_ALLOWED, // command object to be redone or 0
  // Am_SELECTIVE_UNDO_METHOD 
  // Am_SELECTIVE_REPEAT_SAME_METHOD  
  // Am_SELECTIVE_REPEAT_ON_NEW_METHOD
  // Am_SELECTIVE_UNDO_ALLOWED  
  // Am_SELECTIVE_REPEAT_SAME_ALLOWED 
  // Am_SELECTIVE_REPEAT_NEW_ALLOWED 
  
  // internal slots of undo objects
  Am_LAST_UNDONE_COMMAND,   //used by the multiple_undo_object

  /////
  ///// Widget Slots
  /////

  Am_FINAL_FEEDBACK_WANTED, // whether show final feedback for buttons
  Am_KEY_SELECTED, 	  // true on the widget the keyboard is on 
  Am_ACTIVE_2, 		  // only for interactive tools
  Am_ITEM_OFFSET,		  // vertical and horizontal border around
                                     // object or text in button
  Am_WIDGET_LOOK,		  // motif, windows or mac

  Am_VALUE_1,		  // scroll bar value 1
  Am_VALUE_2,		  // scroll bar value 2
  Am_SMALL_INCREMENT,	  // scroll bar Incr on arrows
  Am_LARGE_INCREMENT,	  // scroll bar page Incr
  Am_PERCENT_VISIBLE,	  // percent of size that is visible

  Am_BOX_ON_LEFT,            // checkbox boolean where to put box
  Am_BOX_HEIGHT,             // checkbox box height
  Am_BOX_WIDTH,              // checkbox box width
  Am_TEXT_OFFSET,            // space on sides of text in menu item

  Am_H_SCROLL_BAR,		   //scrolling group, has Horiz scroll bar?
  Am_V_SCROLL_BAR,		   //scrolling group, has vert scroll bar?
  Am_H_SCROLL_BAR_ON_TOP,	   //scrolling group
  Am_V_SCROLL_BAR_ON_LEFT,	   //scrolling group
  Am_INNER_WIDTH,		   //scrolling group: total size of inside
  Am_INNER_HEIGHT,		   //scrolling group: total area to inside
  Am_INNER_FILL_STYLE,	   //scrolling group: inside of clip window

  Am_LABEL_FONT,              //text_input: label's font

  Am_OPERATES_ON,		   //selections handles: group of sel objs
  Am_MOVE_GROW_COMMAND,	   //selections handles: cmd when move/grow
  Am_SELECTION_WIDGET,	   //set into commands to tell
				      //where selections handles widget is 
  Am_GET_WIDGET_VALUE_METHOD,  //property command
  Am_GET_OBJECT_VALUE_METHOD,  //property command, for old val: undo
  Am_SET_OBJECT_VALUE_METHOD,  //property command
  Am_SLOT_FOR_VALUE,   	    //property command, for default methods
  Am_CLIPBOARD,		    //cut,copy,paste command
  
  Am_VALID_INPUT,  // in a text input dialog box, is the text input valid

  Am_LIST_OF_TEXT_WIDGETS, //Am_Tab_To_Next_Widget_Command: list of textwidgets

  ///// internal slots of widgets (do not change)

  Am_INTERACTOR,		  // interactor that makes the widget work
  Am_STYLE_RECORD,		  // colors computed based on foreground
  Am_REAL_STRING_OR_OBJ,	  
  Am_LABEL_OR_ID,		  //formula that is id of cmd or label
  Am_ITEM_TO_COMMAND,	  // formula to map ITEM to COMMAND slots
  Am_SCROLL_ARROW_DIRECTION,  // direction arrow points
  Am_SCROLL_AREA_MIN,        // top or left of scroll area of scrollbar
  Am_SCROLL_AREA_MAX,	  // scrollbar max coordinate
  Am_SCROLL_AREA_SIZE,       // scrollbar indicator area
  Am_SCROLL_ARROW1,	  // parts of scrollbar
  Am_SCROLL_ARROW2,	  // parts of scrollbar
  Am_SCROLL_INDICATOR,	  // parts of scrollbar
  Am_ARROW_INTERACTOR,	  // scrollbar arrow inter
  Am_BACKGROUND_INTERACTOR,  // scrollbar page inter
  Am_H_SMALL_INCREMENT,	   //scrolling group
  Am_H_LARGE_INCREMENT,	   //scrolling group
  Am_V_SMALL_INCREMENT,	   //scrolling group
  Am_V_LARGE_INCREMENT,	   //scrolling group
  Am_CLIP_LEFT,		   //scrolling group: top of clip area
  Am_CLIP_TOP,		   //scrolling group: left of clip area
  Am_CLIP_WIDTH,		   //scrolling group: size of clip area
  Am_CLIP_HEIGHT,		   //scrolling group: size of clip area
  Am_H_SCROLLER,		   //scrolling group: the H scroll object
  Am_V_SCROLLER,		   //scrolling group: the V scroll object
  Am_ATTACHED_OBJECT,	   //used to attach objects to buttons
  Am_ATTACHED_COMMAND,	   //used to note attached command objects

  Am_REAL_WIDTH,             // for menu items: calculated width
  Am_REAL_HEIGHT,            //  of the button
  Am_SUB_MENU,               // for menu_bars: slot to hold sub-menu
  Am_FOR_ITEM,               // for menu_bars: sub-menu's main item
  Am_COMPUTE_INTER_VALUE,    //option buttons
  
  Am_WEB_CONSTRAINT,         //holds web constraint for button panels
  Am_TEXT_WIDGET_BOX_LEFT,   //text_input widget: left of entry box
  Am_TEXT_WIDGET_TEXT_OBJ,   //text_input widget: text value part
  Am_LAST_TEXT_WIDGET,       //Tab_To_Next_Widget_Command: last text_input

  Am_SELECTIONS_HANDLES_USE_LT_RB,  //selection handles
  Am_MOVE_INTERACTOR,        //selection handles
  Am_GROW_INTERACTOR,        //selection handles
  Am_LINE_FEEDBACK_OBJECT,   //selection handles
  Am_RECT_FEEDBACK_OBJECT,   //selection handles
  Am_MOVED_ENOUGH,  	  //selection handles
  Am_FAKE_GROUP,  	 	  //selection handles
  Am_ACCELERATOR_STRING, 	  // string for accel char in a menu
  Am_ACCELERATOR_INTER, 	  // inter for accel in a window
  Am_ACCELERATOR_LIST, 	  // list for accel in a window
  Am_OBJECT_MODIFIED_PLACES, //set into cmd with where 
				      //OBJECT_MODIFIED used to be in group
  Am_OLD_CLIPBOARD_OBJECTS, //set into cmd for old value
  Am_CREATED_GROUP, //set into group if created by GROUP cmd
  Am_WIDGET_START_METHOD, //method slot to for Am_Start_Widget 
  Am_WIDGET_ABORT_METHOD, //method slot to for Am_Abort_Widget 
  Am_WIDGET_STOP_METHOD,   //method slot to for Am_Stop_Widget 

  Am_DIALOG_BUTTONS, //parts slots for the dialog box widgets
  Am_TEXT_WIDGET, Am_DIALOG_GROUP, Am_ICON_IN_ABOUT_DB

};
// Internal opal slot range (2000-9999)
#define Am_FIRST_OPAL_INTERNAL_SLOT 2000

// User Specified Slot Range (10000-29999)
#define Am_MINIMUM_USER_SLOT_KEY 10000
#define Am_MAXIMUM_USER_SLOT_KEY 29999

// Registered Slot Range (30000-65535)

// Register a specific key for the slot name.  Allows explicit assignment
// of name/key pairs.
extern void Am_Register_Slot_Key (Am_Slot_Key key, const char* string);

// Generates a new slot key given a string for a slot name.  Returns the same
// key for a given name.
extern Am_Slot_Key Am_Register_Slot_Name (const char* string);

// Returns the name of a slot key.  Returns NULL if the key is not defined.
extern const char* Am_Get_Slot_Name (Am_Slot_Key key);

// Returns true if the slot name has been assigned a key.
// Returns false, otherwise
extern bool Am_Slot_Name_Exists (const char* string);

#endif

