/**********************************************************************
** $Id: qlined.h,v 2.18 1997/09/22 17:38:25 paul Exp $
**
** Definition of QLineEdit widget class
**
** Created : 941011
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.31.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#ifndef QLINED_H
#define QLINED_H

#include "qwidget.h"
#include "qstring.h"

class QComboBox;
class QValidator;

class QLineEdit : public QWidget
{
    Q_OBJECT
public:
    QLineEdit( QWidget *parent=0, const char *name=0 );
   ~QLineEdit();

    const char *text() const;
    int		maxLength()	const;
    void	setMaxLength( int );

    void	setFrame( bool );
    bool	frame() const;

    enum	EchoMode { Normal, NoEcho, Password };
    void	setEchoMode( EchoMode );
    EchoMode 	echoMode() const;

    void	setValidator( QValidator * );
    QValidator * validator() const;

    QSize	sizeHint() const;

public slots:
    void	setText( const char * );
    void	selectAll();
    void	deselect();

    void	clearValidator();

signals:
    void	textChanged( const char * );
    void	returnPressed();

protected:
    void	mousePressEvent( QMouseEvent * );
    void	mouseMoveEvent( QMouseEvent * );
    void	mouseReleaseEvent( QMouseEvent * );
    void	mouseDoubleClickEvent( QMouseEvent * );
    void	keyPressEvent( QKeyEvent * );
    void	focusInEvent( QFocusEvent * );
    void	focusOutEvent( QFocusEvent * );
    void	paintEvent( QPaintEvent * );
    void	timerEvent( QTimerEvent * );
    void	resizeEvent( QResizeEvent * );

    bool	hasMarkedText() const;
    QString	markedText() const;

private slots:
    void	clipboardChanged();

private:
    void	paint( const QRect& clip, bool frame = FALSE );
    void	pixmapPaint( const QRect& clip );
    void	paintText( QPainter *, const QSize &, bool frame = FALSE );
    void	cursorLeft( bool mark, int steps = 1 );
    void	cursorRight( bool mark, int steps = 1 );
    void	backspace();
    void	del();
    void	home( bool mark );
    void	end( bool mark );
    void	newMark( int pos, bool copy=TRUE );
    void	markWord( int pos );
    void	copyText();
    int		lastCharVisible() const;
    int		minMark() const;
    int		maxMark() const;

    QString	tbuf;
    QPixmap    *pm;
    int		cursorPos;
    int		offset;
    int		maxLen;
    int		markAnchor;
    int		markDrag;
    bool	cursorOn;
    bool	dragScrolling;
    bool	scrollingLeft;

private:	// Disabled copy constructor and operator=
    QLineEdit( const QLineEdit & ) {}
    QLineEdit &operator=( const QLineEdit & ) { return *this; }

    friend class QComboBox;
};


#endif // QLINED_H
