/*
 * PixmapWnd is a subclass of QFrame. It contains the following widgets: 
 * - Menubar
 * - Pixmap Toolbar
 * - Pixmap Previewer (only for pixmap up to 32x32)
 * - Pixmap drawing area (PixmapDraw)
 * - Color indicator
 */

#ifndef PixmapWnd_included
#define PixmapWnd_included

#include <qframe.h>
#include <qmenubar.h>
#include <qstring.h>
#include <qlayout.h>
#include <qscrbar.h>

#include "Toolbar.h"
#include "StatusBar.h"

#include "PixmapDraw.h"

class Pixmap;
class ProjectWnd;
class ColorFrame;

#define SCRBAR_DIMENSION 15

class Previewer : public QFrame
{
  Q_OBJECT
public:
  Previewer( QWidget * );

  void SetPixmap( QPixmap * );

  void Resize();

private slots:
  void ScrBar( int );

private:
  virtual void drawContents( QPainter * );
  virtual void resizeEvent( QResizeEvent * );

private:
  QPixmap *contents;

  QScrollBar *horScr, *verScr;

  bool noPreview;
};

class PixmapWnd : public QFrame
{
  Q_OBJECT;

public: // ctor, dtor
  PixmapWnd( Pixmap *, ProjectWnd *, const char * = NULL );
 
  ~PixmapWnd();

public: // methods
  PixmapDraw *GetPixmapDraw();


    void SetCaption( const QString&	captionStr );
    // Set the caption on the window

public slots:
  void MouseTracking( int, int, int, int );
  void ColorChanged( int, const QColor & );
  void ZoomChanged( int );

signals:
  void Closed();

private: // methods
  void closeEvent( QCloseEvent * );
  // Override to prevent Qt from acting...

  void resizeEvent( QResizeEvent * );

private slots: // methods
  void Import();
  void Export();
  void Close();
  void SetOptions();
  void Rotate();
  void ModeChange( int );
  void PixelSize( int );
  void LineStyles( int );
  void ShowToolTip( const char* );
  void RemoveToolTip();
  void UseGrid();
  void Select();
  void Deselect();
  void Clip();
  void Cut();
  void Copy();
  void CPAvailable();

private: // attributes
  PixmapDraw *itsPixmapDraw; 
  // Its drawing area

  QBoxLayout	itsLayout;
  // geometry layout manager

  QMenuBar		itsMenu;
  // the menu

  Toolbar itsToolbar;
  // The toolbar

  Pixmap *pixmap;
  // Its master class

  StatusBar	itsStatusBar;
  // status bar of the window

  int deselectEntry;
  int clipEntry;
  int cutEntry;
  int copyEntry;
  int pasteEntry;
  // Some menu entries from the edit menu which had to be disabled sometimes

  uint	itsStatusMsg;
  uint	itsStatusZoom;
  uint	itsStatusPSize;
  uint	itsStatusPos;
  uint	itsStatusSize;
  // identifiers for status bar regions

  int useGridMenu;
  // Identifier for the use grid menu entry

  QString	itsLastStatusMsg;
  // the last status message that was not a tool tip

  ProjectWnd *theProjectWnd;
  // The application

  QPopupMenu *edit;
  QPopupMenu *tools;
  QPopupMenu *modes;
  QPopupMenu *sizes;
  QPopupMenu *styles;
  // Different drawing styles

  ColorFrame *itsColorArea;
  // Area for choosing colors, etc.

  Previewer *itsPreviewArea;
  // Area for showing pixmap previews in
};

inline PixmapDraw *PixmapWnd::GetPixmapDraw()
{
  return itsPixmapDraw;
}

inline void PixmapWnd::SetCaption
(
    const QString&	captionStr
)
{
    setCaption( "Qt Architect : " + captionStr );
    setIconText( caption() );
}


#endif
