#ifndef DlgLabel_included
#define DlgLabel_included

#include <qstring.h>

#include "widget/DlgWidget.h"
#include "widget/Label.h"

class DlgLabel : public DlgWidget
{

public:

    DlgLabel
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgLabel();
    
    virtual QWidget* GetWidget( void ) const;
    // return the DlgLabel's widget

    virtual void GetPropertyPages
    (
	QWidget*		parent,
	QList<QWidget>&		pages,
	QStrList&		labels
    );
    // Get the property pages and their labels for the widget

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QLabel *
    );
    // Used by original Qt subclasses

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QLabel *
    );
    // Used by original Qt subclasses

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source


private:

    Label*	itsWidget;

    static int itsNextWidgetNum;
    // number of the next widget

};


inline QWidget* DlgLabel::GetWidget( void ) const
{
    return itsWidget;
}


inline QString DlgLabel::GetHeaderFilename() const
{
    return "<qlabel.h>";
}

inline QString DlgLabel::GetWidgetClass() const
{
    return "QLabel";
}


inline void DlgLabel::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}


#endif // DlgLabel_included
