#include "widget/DlgScrollBar.h"
#include "widget/DlgFrame.h"

#include "prop/ScrollBarPage.h"

#include "GuiTools.h"

#define Inherited DlgWidget

QStrList DlgScrollBar::itsSignals;
int DlgScrollBar::itsNextWidgetNum = 1;

DlgScrollBar::DlgScrollBar
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_ScrollBar, parent )
{
    itsWidget = new ScrollBar( parent, CreateName( "ScrollBar", name, 
						   itsNextWidgetNum ));
    
    itsWidget->setMinimumSize( 10, 10 );
}

DlgScrollBar::~DlgScrollBar()
{
}


void DlgScrollBar::GetPropertyPages
(
    QWidget*		parent,
    QList<QWidget>&	pages,
    QStrList&		labels
)
{
    pages.append( new ScrollBarPage( this, parent, "Scroll Bar" ) );

    labels.append( "Scroll Bar" );
}


void DlgScrollBar::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nScrollBar {";
  
    DlgScrollBar::SaveQt( stream, (const QScrollBar *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgScrollBar::SaveQt
(
   QTextStream &stream,
   const QScrollBar *widget
 )
{
  QString aStr;

  stream << "\n\t\tOrientation {";
  if( widget->orientation() == QScrollBar::Horizontal )
      stream << "Horizontal";
  else
      stream << "Vertical";
  stream << "}";

  if( widget->minValue() != 0 )
  stream << "\n\t\tMinValue {" << aStr.setNum( widget->minValue() ) << "}";
  if( widget->maxValue() != 99 )
  stream << "\n\t\tMaxValue {" << aStr.setNum( widget->maxValue() ) << "}";
  if( widget->value() != 0 )
  stream << "\n\t\tInitial {" << aStr.setNum( widget->value() ) << "}";
  if( widget->lineStep() != 1 )
  stream << "\n\t\tLineStep {" << aStr.setNum( widget->lineStep() ) << "}";
  if( widget->pageStep() != 10 )
  stream << "\n\t\tPageStep {" << aStr.setNum( widget->pageStep() ) << "}";
}

bool DlgScrollBar::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( key == "Name" )
  {
      // Update the widget number so that no duplicate names are created
      UpdateNextWidgetNumber( value, itsNextWidgetNum );
  }

  if( ! DlgScrollBar::RestoreQt( key, value, (QScrollBar *) itsWidget ) )
  {  
    // At last DlgWidget catch the rest
    retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgScrollBar::RestoreQt
(
   const QString &key,
   const QString &value,
   QScrollBar *widget
)
{
  // Compare to known keys
  if( key == "Orientation" )
  {
    if( value == "Horizontal" )
      widget->setOrientation( QScrollBar::Horizontal );
    else
      widget->setOrientation( QScrollBar::Vertical );
  } else if( key == "MinValue" )
  {
    int max = widget->maxValue();
    widget->setRange( value.toInt(), max );
  } else if( key == "MaxValue" )
  {
    int min = widget->minValue();
    widget->setRange( min, value.toInt() );
  } else if( key == "Initial" )
  {
    widget->setValue( value.toInt() );
  } else if( key == "LineStep" )
  {
    int page = widget->pageStep();
    widget->setSteps( value.toInt(), page );
  } else if( key == "PageStep" )
  {
    int line = widget->lineStep();
    widget->setSteps( line, value.toInt() );
  } else
  {
    // Key unknown
    return FALSE;
  }
  return TRUE;
}  


void DlgScrollBar::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgWidget::GenSrc( dlgWidget, stream, varName, zOrdering );

    const QScrollBar* widget = (const QScrollBar*)dlgWidget.GetWidget();

    if( widget->orientation() == QScrollBar::Horizontal )
    {
	stream << varName << "setOrientation( QScrollBar::Horizontal );\n";
    }
    
    if( (widget->minValue() != 0) || (widget->maxValue() != 99) )
    {
	stream << varName << "setRange( " << widget->minValue() << ", " <<
	    widget->maxValue() << " );\n";
    }

    if( (widget->lineStep() != 1) || (widget->pageStep() != 10) )
    {
	stream << varName << "setSteps( " << widget->lineStep() << ", " <<
	    widget->pageStep() << " );\n";
    }
    
    if( widget->value() != 0 )
    {
	stream << varName << "setValue( " << widget->value() << " );\n";
    }
}


void DlgScrollBar::AddSignalsToList( QStrList&	signalList ) const
{
    Inherited::AddSignalsToList( signalList );
    GuiTools::QStrListAppendAll( signalList, GetSignalList() );
}


const QStrList& DlgScrollBar::GetSignalList( void )
{
    if( itsSignals.isEmpty() )
    {
	itsSignals.append( "valueChanged(int)" );
	itsSignals.append( "sliderPressed()" );
	itsSignals.append( "sliderMoved(int)" );
	itsSignals.append( "sliderReleased()" );
	itsSignals.append( "nextLine()" );
	itsSignals.append( "prevLine()" );
	itsSignals.append( "nextPage()" );
	itsSignals.append( "prevPage()" );
    }

    return itsSignals;
}

