/*
 *  ifold - Indented folding
 *
 *  AUTHOR: Thomas Spahni (thomas@spahni.ch)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "ifold.h"

unsigned char cbuf[BUFSIZE+1];

int
main (int argc, char *argv[])
{
    int indent = DEFAULT_INDENT, screenwidth = SCREEN;
    int i, j, k;
    const int newline = '\n';
    const int creturn = '';
    int pointer = 0;
    char *string;
    int c;

    if (argc >= 2) {
        indent = atoi(argv[1]);
    }
    
    if (argc >= 3) {
        screenwidth = atoi(argv[2]);
    }

    /* printf("Commandline Arguments = %s, %s\n", argv[1], argv[2]); */

    if (screenwidth <= (indent + MIN_LINELENGTH) ||
        screenwidth > BUFSIZE ) {
        fprintf(stderr, "Illegal arguments %d %d\n", indent, screenwidth);
        exit(2);
    }

    while ((c = getchar()) != EOF) {
	if (c == newline) {
	    cbuf[pointer] = '\0';
	    printf("%s\n", cbuf);
	    pointer=0;
	} else if (c == '\r') {
	    cbuf[pointer] = '\0';
	    printf("%s\n", cbuf);
	    for (j=0; j<indent; j++) {
		cbuf[j] = ' ';
	    }
	    pointer = indent;
	} else {
	cbuf[pointer++] = (char) c;
	if (pointer == screenwidth) {
	    cbuf[pointer--] = '\0';
	    i = pointer;

	    /* backtrack and look for a space to break the line */
	    while (cbuf[i] != ' ' && i >= (indent + MIN_LINELENGTH)) {
		--i;
	    }

	    if (cbuf[i] == ' ') {
		/* found a space to break */
		for (j=0; j<=i; j++) {
		    putchar(cbuf[j]);
		}
		putchar(newline);
		for (j=0; j<indent; j++) {
		    cbuf[j] = ' ';
		}
		for (k=i+1; k<=pointer; k++) {
		    cbuf[j++] = cbuf[k];
		}
		pointer = j;
	    } else {
		/* cannot break this line at a space position */
		for (j=0; j<=pointer; j++) {
		    putchar(cbuf[j]);
		}
		putchar(newline);
		for (j=0; j<indent; j++) {
		    cbuf[j] = ' ';
		}
		pointer = indent;
	    }
	}
	}
    }
    cbuf[pointer] = '\0';
    printf("%s\n", cbuf);
    fflush(stdout);
    exit(EXIT_SUCCESS);
}
