/*
 *  ifold - Idented folding
 *
 *  AUTHOR: Thomas Spahni (thomas@spahni.ch)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


/*
 * BUFSIZE sets the maximum permissible line length.
 */

#define BUFSIZE 2048

/*
 * MIN_LINELENGTH sets the minimum length a line must have not
 *                including indent space. 1 character is a bare
 *                minimum: this will print vertically.
 */

#define MIN_LINELENGTH 1

/*
 * SCREEN sets the default screen width, normally 80 characters
 */

#define SCREEN 80

/*
 * DEFAULT_INDENT sets the amount of indentation
 */

#define DEFAULT_INDENT 10

/*
 * Includes for ifold
 */

#include <stdio.h>
#include <stdlib.h>

