#!/bin/bash
# This script will take a filename as argument
# File is a '*.csv' format as exported by Excel
# result is file '*.sql' ready to be loaded

CSVPATH='../ifold'

if test -z "$1" ; then
   echo "usage: csv2sql <infile.csv>"
   exit 1
fi

$CSVPATH/csv <$1 >csv2sql.tmp

TABLE=$(echo $1 | sed -e "s/\\.[^.]*$//")
DESTINATION=${TABLE}.sql

echo "# conversion to sql from $1" > $DESTINATION
echo "# pipe into mysql to load" >> $DESTINATION
echo "#" >> $DESTINATION
echo "DROP TABLE IF EXISTS $TABLE;" >> $DESTINATION
echo "" >> $DESTINATION
echo "#" >> $DESTINATION
echo "# Table structure for table '$TABLE'" >> $DESTINATION
echo "#" >> $DESTINATION
echo "CREATE TABLE $TABLE (" >> $DESTINATION

head -n 1 csv2sql.tmp | sed -e 's/ /_/g' -e 's/-/_/g' \
-e "s/	/ varchar(255) DEFAULT '' NOT NULL,\\
/g" -e "$ s/$/ varchar(255) DEFAULT '' NOT NULL\\
/" | sed -e "/^$/d" >> $DESTINATION

echo ");" >> $DESTINATION
echo >> $DESTINATION
echo >> $DESTINATION
echo "#" >> $DESTINATION
echo "# Dumping data for table '$TABLE'" >> $DESTINATION
echo "#" >> $DESTINATION

cat csv2sql.tmp | sed \
   -e "1 d" \
   -e "/^$/d" \
   -e "s/'/\\\\'/g" \
   -e "s/^/INSERT INTO $TABLE VALUES ('/" \
   -e "s/	/','/g" \
   -e "s/$/');/" >> $DESTINATION

rm -f csv2sql.tmp
sync
exit
