CREATE FUNCTION plpgsql_call_handler () RETURNS OPAQUE AS
  '/usr/local/pgsql/lib/plpgsql.so' LANGUAGE 'C';
CREATE TRUSTED PROCEDURAL LANGUAGE 'plpgsql'
  HANDLER plpgsql_call_handler LANCOMPILER 'PL/pgSQL';

DROP FUNCTION select_images (int);

CREATE FUNCTION select_images (int) 
RETURNS text 
AS
    'DECLARE
	    id ALIAS FOR $1;
	    ret text;
	    rec record;
	    recc record;
	    i int;
    BEGIN
	ret := '''';
	i := 0;
	SELECT INTO recc count(*) FROM images_tbl
	    WHERE images_subsection_id = id;
	WHILE i<recc.count LOOP
	    SELECT INTO rec images_image
		FROM images_tbl
		WHERE images_subsection_id = id LIMIT 1,i;
	    IF i>0 THEN
		ret := ret || '','';
	    END IF;
	    ret := ret || rec.images_image;
	    i:=i+1;
	END LOOP;

	RETURN ret;
    END;' 
LANGUAGE 'plpgsql';

DROP FUNCTION select_section_images (int);

CREATE FUNCTION select_section_images (int) 
RETURNS text 
AS
    'DECLARE
	    id ALIAS FOR $1;
	    ret text;
	    rec record;
	    recc record;
	    i int;
    BEGIN
	ret := '''';
	i := 0;
	SELECT INTO recc count(*) FROM subsection_tbl
	    WHERE subsection_section_id = id;
	WHILE i<recc.count LOOP
	    SELECT INTO rec subsection_id
		FROM subsection_tbl
		WHERE subsection_section_id = id LIMIT 1,i;
	    IF i>0 THEN
		ret := ret || '','';
	    END IF;
	    ret := ret || select_images(rec.subsection_id);
	    i:=i+1;
	END LOOP;
	RETURN ret;

    END;' 
LANGUAGE 'plpgsql';

DROP FUNCTION select_section (int);

CREATE FUNCTION select_section (int) 
RETURNS text 
AS
    'DECLARE
	    id ALIAS FOR $1;
	    ret text;
	    rec record;
	    recc record;
	    i int;
    BEGIN
	ret := '''';
	i := 0;
	SELECT INTO recc count(*) FROM subsection_tbl
	    WHERE subsection_section_id = id;
	WHILE i<recc.count LOOP
	    SELECT INTO rec subsection_id,subsection_name
		FROM subsection_tbl
		WHERE subsection_section_id = id LIMIT 1,i;
	    IF i>0 THEN
		ret := ret || '','';
	    END IF;
	    ret := ret || rec.subsection_id || '','' || rec.subsection_name;
	    i:=i+1;
	END LOOP;
	RETURN ret;

    END;' 
LANGUAGE 'plpgsql';

DROP VIEW subsection_view;
CREATE VIEW subsection_view 
(subsection_id,subsection_section_id,subsection_name,subsection_comment,
subsection_user,subsection_date_input,select_images)
AS SELECT
subsection_id,subsection_section_id,subsection_name,subsection_comment,
subsection_user,subsection_date_input,select_images(subsection_id)
FROM subsection_tbl;

GRANT ALL ON subsection_view TO PUBLIC;

DROP VIEW section_view;
CREATE VIEW section_view 
(section_id,section_name,section_comment,
section_user,section_date_input,select_section_images,select_section)
AS SELECT
section_id,section_name,section_comment,
section_user,section_date_input,select_section_images(section_id),select_section(section_id)
FROM section_tbl;

GRANT ALL ON section_view TO PUBLIC;
