<?php
//*****************************************************************************
// PHP Generator Modified v 2.4 2000-11-04
// Copyright Nickolas Grebnev (nick@sptl.org)
// This code is distributed under GPL 
//*****************************************************************************

echo "<HTML><HEAD><TITLE>PHP basic application generator for SQL databases</TITLE></HEAD><BODY>";

$THEMEDIR = "themes"; // Directory to write output to
$OUTPUTDIR = "output"; // Directory to write output to
$NLSDIR = "NLS";       // Directory with NLS files
$SEPARATOR = "/";      // Filesystem path separator
$OVERWRITE = true;     // Set this to false to prohibit overwriting of output file
$TTFDIR = "ttf"; // Directory with TTF files
$BUTTONSDIR = "buttons"; // Directory with graphical buttons
$IMAGESDIR = "images"; // Directory for images
$IMAGESSMALLDIR = "images_small"; // Directory for small(scaled) images
$INCDIR = "inc"; // Directory for include files
$max_demo_mode = 4;
#$full_path = true;
if(strstr($SERVER_SOFTWARE,"thttpd"))$thttpd_path = true;

if($thttpd_path)$full_path=true;
if($full_path)
{ 
    $path=exec("pwd");
    if($thttpd_path)
    {
	$path.=dirname($REQUEST_URI).$SEPARATOR;
    }
    else $path.=$SEPARATOR;
    $OUTPUTDIR=$path.$OUTPUTDIR;
    echo "path=$path OUTPUTDIR=$OUTPUTDIR<P>";
}	

//*************** Display an exit message.
function message_and_exit($title,$text) {
  echo "<p>&nbsp;</p>\n".
    "<center>\n".
    "<h3>$title</h3>\n$text\n".
    "</center>\n".
    "</BODY>\n</HTML>\n";
  exit;
}

function split2array($what,$f) {
    $s = explode(",", $what);
    for ($i = 0; $i < count($s); $i++) {
	$x = explode(":",$s[$i]); 
	fputs($f,"\"" . $x[0] . "\" => \"" . $x[1] ."\"");
	fputs($f, ($i == (count($s)-1))?"\n":",\n");
    }
}

function on2true($val) 
{
    if(	$val=="on" ||
	$val=="1" ||
	$val=="true" ||
	$val==1 ||
	$val==true ) return 1;
    else return 0;
}

function start_form()
{
    global $path;
    echo "<H3 ALIGN=CENTER>PHP basic application generator for SQL databases</H3>\n";
    echo "<FORM ACTION=\"phpgem.php3\" METHOD=\"POST\">\n";
    echo "<CENTER><TABLE><TR><TD><B>Select globals (host-oriented) file:</B></TD>\n";
    echo "<TD><SELECT NAME=\"globalfile\">\n";
    $f = opendir($path."themes");
    $fn = readdir($f);
    while ($fn)
    {
	if (ereg("^work.global$",$fn))
#	if (ereg("^localhost.global$",$fn))
		$selected = " SELECTED";
	else
		$selected = "";
	if (ereg("global$",$fn)) echo "\t\t<OPTION VALUE='$fn'$selected> $fn\n";
	$fn = readdir($f);
    }
    echo "</SELECT></TD></TR><TR><TD><B>Select theme file:</B></TD>\n";
    echo "<TD><SELECT NAME=\"themefile\">\n";
    $f = opendir($path."themes");
    $fn = readdir($f);
    while ($fn)
    {
	if (ereg("^jsdemo.pgtheme$",$fn))
#	if (ereg("^normal.pgtheme$",$fn))
		$selected = " SELECTED";
	else
		$selected = "";
	if (ereg("pgtheme$",$fn)) echo "\t\t<OPTION VALUE='$fn'$selected> $fn\n";
	$fn = readdir($f);
    }
    echo "</SELECT></TD></TR><TR>\n";
    echo "<TD><B>Select table file:</B></TD><TD><SELECT NAME=\"tablefile\">\n";
    $f = opendir($path.".");
    $fn = readdir($f);
    while ($fn)
    {
	if (ereg("table$",$fn)) echo "\t\t<OPTION VALUE='$fn'$selected> $fn\n";
	$fn = readdir($f);
    }
    echo "</SELECT></TD></TR><TR>\n";
    echo "<TD COLSPAN=9 ALIGN=CENTER>\n";
    echo "<INPUT TYPE=\"submit\" NAME=\"START\" VALUE=\"Generate\">&nbsp;&nbsp;\n";
    echo "</TD></TR></TABLE></CENTER></FORM>\n</BODY>\n</HTML>\n";
    exit;
}

function open_file($outputfile,$mode,$ext)
{	
    global $OUTPUTDIR,$SEPARATOR,$OVERWRITE;
    if (!isset($outputfile) || trim($outputfile) == "") {
      message_and_exit("You <i>must</i> enter a filename for the resulting PHP script!",
	  "Please edit file of table description");
    } 
    if (!eregi("^.*\.$ext.?$",$outputfile)) {
	message_and_exit("Invalid resulting PHP filename",
	       "Should get something of form <tt>*.$ext</tt> or <tt>*.$ext3</tt>,".
	       "<br>\nbut got: <tt>$outputfile</tt>.<p>\n".
	       "Please edit file of table description and modify ".
	       "<tt>Resulting $ext filename</tt>.");
    }
    if (isset($OUTPUTDIR) && trim($OUTPUTDIR) != "") {
	$file_for_open=$OUTPUTDIR.$SEPARATOR.$outputfile;
    } else $file_for_open=$outputfile;
    if (file_exists($file_for_open) && !$OVERWRITE) {
	message_and_exit("File <tt>$file_for_open</tt> exists",
	    "Please select another filename for the resulting $ext filename.");
    } else if (!($f = fopen($file_for_open,$mode))) {
	message_and_exit("Cannot write <tt>$file_for_open</tt>",
	    "Write permission denied.");
    }
    return $f;
}

function create_dir($dir,$mode)
{	
    global $OUTPUTDIR,$SEPARATOR,$OVERWRITE;
    $dir = $OUTPUTDIR.$SEPARATOR.$dir;
    if (!is_dir($dir))
	if ( !mkdir($dir,$mode) )
	{
	    message_and_exit("Cannot make directory <tt>$dir</tt>","Write permission denied.");
	    exit;
	}
}

function copy_file($filename1,$filename2)
{	
    copy($filename1,$filename2);
    chmod($filename2,0644);
}

function copy_inc_file($filename)
{	
    global $path,$SEPARATOR,$OINCDIR;
    copy_file($path."inc".$SEPARATOR.$filename,$OINCDIR.$filename);
}

function file2vars($filename)
{
    global $tnum,$modnum,$tablename;

    $a = 1;
    $field = 0;
    $table = 0;
    $tf = fopen($filename,"r");
    while (!feof($tf))
    {
	$r = chop(fgets($tf,500));
	$r = ereg_replace("^[\t ]+","",$r);
	if ((substr($r,0,1) != "#") && ($r != ""))
	{
		$vstr = chop(strstr($r,"="));
		$kstr = chop(substr($r,0,strlen($r)-strlen($vstr)));
		$vstr = substr($vstr,1,999);
		$vstr = ereg_replace("^[\t ]+","",$vstr);
		$kstr = ereg_replace("^[\t ]+","",$kstr);
		if ($kstr != "")
		{
		    if($module==0 && $kstr=="MODULE_START"){$module=1;continue;}
		    if($module==1 && $kstr=="MODULE_END"){$module=0;$modnum++;continue;}
		    if($table==0 && $kstr=="TABLE_START"){$table=1;$field=0;$a=1;continue;}
		    if($table==1 && $kstr=="TABLE_END")
		    {
			$table=0;$field=0;
			if($module==1){$GLOBALS[modules][$tablename[$tnum]]=$GLOBALS[modulename][$modnum];}
			$tnum++;$a=1;continue;
		    }
		    if($field==0 && $kstr=="FIELD_START"){$field=1;continue;}
		    if($field==1 && $kstr=="FIELD_END"){$field=0;$a++;continue;}
		    if($field==1) {$kstr=$kstr.$a; $GLOBALS[$kstr][$tnum]=$vstr;continue;}
		    if($field==0 && $table==1) {$GLOBALS[$kstr][$tnum]=$vstr;continue;}
		    if($field==0 && $table==0 && $module==1) {$GLOBALS[$kstr][$modnum]=$vstr;continue;}
		    $GLOBALS[$kstr] = $vstr;
		}
	}
    }
    fclose($tf);
}

function inc_files($incfile)
{	
    global $OUTPUTDIRS,$path;
    if(!empty($incfile))
    {
	$incfiles=explode(",",$incfile);
	$incfile_str="";
	for($i=0;$i<count($incfiles);$i++)
	{
	    $incftmp=$incfiles[$i];
	    if($incftmp[0]!="/")$incftmp=$path.$incftmp;
	    $incftmpb=basename($incftmp);
	    if(file_exists($incftmp))
	    {
		$incfile_str.="include \$path.\"$incftmpb\";\n";
		copy_file($incftmp,$OUTPUTDIRS.$incftmpb);
	    }	
	}
    }
    return $incfile_str;
}

function ComputeParent($table) {
    global $level,$tablename,$top_table,$tnum,$nyckname,$linkname;
    $level_current = $level[$table];
    $res = "";
    if($level_current>0)
    {
	for($i=1;$i<$tnum;$i++)
	{
	    if($level[$i] == ($level_current-1) && $top_table[$table] == $tablename[$i])
	    {
		$res = "&".$nyckname[$i]."=\$".$nyckname[$i].ComputeParent($i);
#		$sst = "SELECT ".$nyckname[$i].",".$linkname[$i] FROM
	    }
	}
    }
    return $res;	    
}
    
//*************** Parse theme-file , table file , language-file
$tnum=1;$modnum=1;

if(empty($themefile)) $themefile = "normal.pgtheme";
file2vars($path.$THEMEDIR.$SEPARATOR.$themefile);

if(empty($globalfile)) $globalfile = "localhost.global";
file2vars($path.$THEMEDIR.$SEPARATOR.$globalfile);

if (empty($tablefile)) start_form();
file2vars($path.$tablefile);

//If some NLS tag not defined, will be used English.
file2vars($path.$NLSDIR.$SEPARATOR."English.NLS");
if(!empty($language)) file2vars($path.$NLSDIR.$SEPARATOR.$language.".NLS");

//*************** Check for neccesary defaults
if(empty($db_type)) $db_type="PostgreSQL";
if(empty($date_format)) $date_format="dmy";
if(empty($sql_date_format)) $sql_date_format="mdy";
if(empty($sql_text_str))$sql_text_str="text";
if(empty($sql_blob_text_str))$sql_blob_text_str="text";
if(!isset($sql_count_add))$sql_count_add="";
if(!isset($sql_count_cnt))$sql_count_cnt="count";
if($auto_increment == "")$auto_increment=1;

if(empty($php_ext)) $php_ext="php";
if($php_ext=="php")
{ 
    $php4enable=1;
    if($checktime == "")$checktime="1";
    if(empty($maxtimeout))$maxtimeout=180;
}
if(empty($php_end)) $php_end="?>";
if(empty($php_start)) $php_start="<?php";

if(empty($sql_debug)) $sql_debug="false";
if(empty($uri_debug)) $uri_debug="false";
if(empty($callbacktype)) $callbacktype="meta";

if(!isset($convert_to_small))$convert_to_small="/usr/X11R6/bin/convert -sample ";
if(!isset($convert_to_jpeg))$convert_to_jpeg="/usr/X11R6/bin/convert -quality 95 ";
if(empty($max_small_image_height))$max_small_image_height=100;
if(empty($max_small_image_width))$max_small_image_width=100;

if ($link_color == "") $link_color="#336699";
if ($body_tag == "") $body_tag="<BODY>";
if (empty($list_color1)) $list_color1="#FFFFFF";
if (empty($list_color2)) $list_color2="#EEFFFF";
if (empty($menu_bg_color)) $menu_bg_color="#EEFFFF";
if (empty($title_menu_bg_color)) $title_menu_bg_color=$menu_bg_color;
if (empty($float_menu_bg_color)) $float_menu_bg_color=$menu_bg_color;
if (empty($float_menu_button_bg_color)) $float_menu_button_bg_color="#999999";
if ($error_color == "") $error_color="#FF0000";
if ($button_out_border == "") $button_out_border="0";
if ($button_in_size_border == "") $button_in_size_border="2";
if ($button_in_interval_border == "") $button_in_interval_border="0";
if ($button_in_color_border == "") $button_in_color_border="navy";
if ($button_in_color_text == "") $button_in_color_text="navy";
if ($button_in_ttf_font_size == "") $button_in_ttf_font_size="16";
if ($button_in_color_ground == "") $button_in_color_ground="white";
if ($button_active_in_size_border == "") $button_active_in_size_border="2";
if ($button_active_in_interval_border == "") $button_active_in_interval_border="0";
if ($button_active_in_color_border == "") $button_active_in_color_border="yellow";
if ($button_active_in_color_text == "") $button_active_in_color_text="navy";
if ($button_active_in_ttf_font_size == "") $button_active_in_ttf_font_size="16";
if ($button_active_in_color_ground == "") $button_active_in_color_ground="white";
if ($menu_table_tag == "") $menu_table_tag="<TABLE>";
if ($title_menu_table_tag == "") $title_menu_table_tag=$menu_table_tag;
if ($float_menu_table_tag == "") $float_menu_table_tag=$menu_table_tag;
if ($list_table_tag == "") $list_table_tag="<TABLE>";
if ($form_table_tag == "") $form_table_tag="<TABLE>";
if ($standard_table_tag == "") $standard_table_tag="<TABLE>";
if ($end_table_tag == "") $end_table_tag="</TABLE>";
if ($table_tr_start == "") $table_tr_start="<TR>\\n";
if ($table_tr_end == "") $table_tr_end="</TR>\\n";
if ($table_td_start == "") $table_td_start="\\t<TD VALIGN=\\\"TOP\\\">";
if ($table_td_menu_start == "") $table_td_menu_start="\\t<TD>";
if ($table_td_end == "") $table_td_end="</TD>\\n";
if ($table_th_start == "") $table_th_start="\\t<TH>";
if ($table_th_end == "") $table_th_end="</TH>\\n";
if ($link_type == "") $link_type="form";
if ($link_menu_type == "") $link_menu_type="href";
if ($link_table_menu_type == "") $link_table_menu_type="href";
if ($link_table_type == "") $link_table_type="href";
if ($link_header_table_type == "") $link_header_table_type="href";
if ($link_detail_table_type == "") $link_detail_table_type="href_u";
if ($demo_mode == "") $demo_mode="0";
if ($NLSTTFFile == "") $ttffile="timesk8.ttf";
else $ttffile = $NLSTTFFile;
if($buttons_dir == "")$buttons_dir="standart";
if($separ_array == "")$separ_array=",";
if($transaction == "")$transaction="false";
if($ssl_port == "")$ssl_port=443;

if(empty($center_start))$center_start = "<CENTER>";
if(empty($center_end))$center_end = "</CENTER>";

//************** Set the path of the output file
if (isset($project_name))
{
    if (isset($OUTPUTDIR) && trim($OUTPUTDIR) != "") {
	$project_dir = $OUTPUTDIR.$SEPARATOR.$project_name;
    }else $project_dir = $project_name;
    if (!is_dir($project_dir))
    {	
	if ( !mkdir($project_dir,0755) )
	{
	    message_and_exit("Cannot make directory <tt>$project_dir</tt>","Write permission denied.");
	    exit;
	}
    }
    $OUTPUTDIR =$project_dir;
}
if (isset($OUTPUTDIR) && trim($OUTPUTDIR) != "") {
    $OUTPUTDIRS = $OUTPUTDIR.$SEPARATOR;
}
    $outputfile = $OUTPUTDIRS.$filename;
    $OINCDIR = $OUTPUTDIRS.$INCDIR.$SEPARATOR;

    create_dir($INCDIR,0755);
    create_dir($IMAGESDIR,0755); //0644
    create_dir($IMAGESSMALLDIR,0755);
    create_dir("sql",0755);

    copy_inc_file("sql.inc");
    copy_inc_file("connect.inc");
    copy_inc_file("lib_util.inc");
    copy_inc_file("datecode.inc");
    copy_inc_file("colors.inc");
    copy_inc_file("phpgem.inc.js");
    copy_file($path."inc".$SEPARATOR."ibutton.php3",$OINCDIR."ibutton.$php_ext");
    copy_file($path.$THEMEDIR.$SEPARATOR.$style_sheet,$OUTPUTDIRS.$style_sheet);
    copy_file($path.$TTFDIR.$SEPARATOR.$ttffile,$OUTPUTDIRS.$ttffile);
    if(!empty($ground_image))
	copy_file($path.$THEMEDIR.$SEPARATOR.$ground_image,$OUTPUTDIRS.$ground_image);
    if(!empty($bg_image1))
 	copy_file($path.$THEMEDIR.$SEPARATOR.$bg_image1,$OUTPUTDIRS.$bg_image1);
    if(!empty($bg_image2))
 	copy_file($path.$THEMEDIR.$SEPARATOR.$bg_image2,$OUTPUTDIRS.$bg_image2);

    if(is_dir($path.$BUTTONSDIR.$SEPARATOR.$buttons_dir) && 
	file_exists($path.$BUTTONSDIR.$SEPARATOR.$buttons_dir.$SEPARATOR."buttons.lst"))
    {
	$bdir = $OUTPUTDIRS.$buttons_dir;
	create_dir($buttons_dir,0755);

	$f = opendir($path.$BUTTONSDIR.$SEPARATOR.$buttons_dir);
	while ($fb = readdir($f))
	{
	    if ($fb != "." && $fb != "..")
		copy_file($path.$BUTTONSDIR.$SEPARATOR.$buttons_dir.$SEPARATOR.$fb,$bdir.$SEPARATOR.$fb);
	}
    }
    $incfile_str=inc_files($incfile);
    $end_incfile_str=inc_files($end_incfile);

//*************** Generate output
$filename=ereg_replace("\.php.*",".".$php_ext,$filename);
$outputfile_index = eregi_replace("\.php.*","",$filename)."_index.$php_ext";
$outputfile_logout = eregi_replace("\.php.*","",$filename)."_logout.$php_ext";
$outputfile_theme = eregi_replace("\.php.*","",$filename)."_theme.inc";
$outputfile_global = eregi_replace("\.php.*","",$filename)."_global.inc";
$outputfile_names = eregi_replace("\.php.*","",$filename)."_names.inc";
$outputfile_ct = eregi_replace("\.php.*","",$filename)."_ct.inc";
$outputfile_module = eregi_replace("\.php.*","",$filename)."_module.inc";
$outputfile_perm_table = eregi_replace("\.php.*","",$filename)."_perm.table";

//********************** check type and insert defaults **********************
$permissions=on2true($permissions);
$secure=on2true($secure);
for($table=1;$table<$tnum;$table++)
{
    $images[$table]=0;
    for($i=1;;$i++)
    {
	$vf = "FIELD$i";$vtype = "TYPE$i";$vhtype = "HTYPE$i";$vdata = "DATA$i";
	if(${$vf}[$table] =="") break;
        if(empty(${$vtype}[$table])) ${$vtype}[$table]="str";
	if(empty(${"PRINTNOTNULL$i"}[$table]))${"PRINTNOTNULL$i"}[$table]="off";
        if(empty(${$vhtype}[$table]))
	{	
	    if(${$vtype}[$table]=="int" || 
		${$vtype}[$table]=="float" || 
		${$vtype}[$table]=="decimal")
		    ${$vhtype}[$table]="str";
	    else if(${$vtype}[$table]=="str")${$vhtype}[$table]="str";
	    else if(${$vtype}[$table]=="date")${$vhtype}[$table]="date";
	    else if(${$vtype}[$table]=="datetime")${$vhtype}[$table]="datetime";
	    else if(${$vtype}[$table]=="time")${$vhtype}[$table]="str";
	    else if(${$vtype}[$table]=="user")${$vhtype}[$table]="str";
	}
        if(${$vtype}[$table]=="time" || ${$vtype}[$table]=="datetime")
	{	
	    if(empty(${"I$i"}[$table]))${"I$i"}[$table]=9;
	    if(empty(${"M$i"}[$table]))${"M$i"}[$table]=20;
	}
        if(${$vhtype}[$table]=="str" 
	    || ${$vhtype}[$table]=="image"
	    || ${"CAINPUTFIELD$i"}[$table]=="on")
	{	
	    if(empty(${"I$i"}[$table]))${"I$i"}[$table]=50;
	    if(empty(${"M$i"}[$table]))${"M$i"}[$table]=50;
	    if(empty(${"FP$i"}[$table]))${"FP$i"}[$table]=2;
    	    if(${$vhtype}[$table]=="image") $images[$table]=1;
	}
        if(${$vhtype}[$table]=="blob")
	{	
	    if(empty(${"BCOLS$i"}[$table]))${"BCOLS$i"}[$table]=50;
	    if(empty(${"BROWS$i"}[$table]))${"BROWS$i"}[$table]=3;
	    if(empty(${"M$i"}[$table]))
		${"M$i"}[$table]=${"BCOLS$i"}[$table]*${"BROWS$i"}[$table]*2;
	}
        if(${$vhtype}[$table] == "rlist" || ${$vhtype}[$table] == "plist") 
	{
	    if (empty(${$vdata}[$table])) 
		${$vdata}[$table] = "0:Value 0,1:Value 1";
	}
        if(${$vhtype}[$table] == "checkbox") 
	{
	    if (empty(${$vdata}[$table])) 
		${$vdata}[$table] = "0:None,1:Checked";
	}
        if(${$vhtype}[$table] == "date" || ${$vhtype}[$table] == "datetime") 
	{
	    if (empty(${$vdata}[$table])) 
		${$vdata}[$table] = "ttp";
	}
        if(${$vhtype}[$table]=="child_array"||${"SRCHMULTI$i"}[$table]=="on")
	{	
	    if(empty(${"SELSIZE$i"}[$table]))${"SELSIZE$i"}[$table]=5;
	}
    }
}
//****************************************************************************

//********************************** files names and child tables ************
$fname = open_file($outputfile_names,"w","inc");
$fct = open_file($outputfile_ct,"w","inc");
fputs($fname,"$php_start\n\n");
fputs($fct,"$php_start\n\n");
for($table=1;$table<$tnum;$table++)
{
    if(empty($table_title[$table]))$table_title[$table]=$tablename[$table];
    fputs($fct,"\$index_var[\"".$tablename[$table]."\"]=\"".$nyckname[$table]."\";\n");
}
for($table=1;$table<$tnum;$table++)
{
    fputs($fname,"\$names[\"".$tablename[$table]."\"][]=\"".$table_title[$table]."\";\n");
    for($i=1;;$i++)
    {
	$vf = "FIELD$i";$vt = "TITLE$i";$vhtype = "HTYPE$i";$vdata = "DATA$i";$vplt = "PLT$i";
	if(empty(${$vf}[$table])) break;
	fputs($fname,"\$names[\"".$tablename[$table]."\"][\"".${$vf}[$table]."\"]=\"".${$vt}[$table]."\";\n");
        if(${$vhtype}[$table] == "rlist" || ${$vhtype}[$table] == "plist"
	    || ${$vhtype}[$table] == "checkbox") 
	{
	    $pdata=${$vdata}[$table];
            fputs($fname,"\$".$tablename[$table]."_".${$vf}[$table]."_arr = array(\n");
            split2array($pdata,$fname);
	    fputs($fname,");\n");
	}
        if(${$vhtype}[$table] == "plistdb") 
	{
	    $plt=${$vplt}[$table];
            fputs($fct,"\$child_table[\"$plt\"][\"".$tablename[$table]."\"][]=\"".${$vf}[$table]."\";\n");
	}
    }
    fputs($fname,"\n\n");
}
fputs($fname,"\n$php_end");
fputs($fct,"\n$php_end");
fclose($fname);
fclose($fct);
//****************************************************************************

$outputfile_sql = eregi_replace("\.php.*","",$filename).".sql";
$openfiles[$filename]=open_file($filename,"w","php");
$openfiles[$outputfile_logout]=open_file($outputfile_logout,"w","php");
$sql_openfiles[$filename]=open_file("sql".$SEPARATOR.$outputfile_sql,"w","sql");
//********************************** module file *****************************
$fm = open_file($outputfile_module,"w","inc");
fputs($fm,"$php_start\n\n");
fputs($fm,"\$module[\"list_tables\"]=\"$filename\";\n");
fputs($fm,"\$module[\"logout\"]=\"".$outputfile_logout."\";\n");
fputs($fm,"\$module[\"index\"]=\"".$outputfile_index."\";\n");
for($table=1;$table<$tnum;$table++)
{
    $modules[$tablename[$table]]=ereg_replace("\.php.*",".".$php_ext,$modules[$tablename[$table]]);
    if(empty($modules[$tablename[$table]]))
    {
	$modules[$tablename[$table]]=$filename;
    }
    else 
    {
	if(!isset($openfiles[$modules[$tablename[$table]]]))
	{
	    $openfiles[$modules[$tablename[$table]]]=
		open_file($modules[$tablename[$table]],"w","php");
	    $sql_openfiles[$modules[$tablename[$table]]]=
		open_file("sql".$SEPARATOR.eregi_replace("\.php.*","",$modules[$tablename[$table]]).".sql","w","sql");
	}
    }
    fputs($fm,"\$module[\"".$tablename[$table]."\"]=\"".$modules[$tablename[$table]]."\";\n");
}
fputs($fm,"\n$php_end");
fclose($fm);
//****************************************************************************

//********************************** sql file ********************************
if(!empty($first_line_in_sql))
{
    $fl_sql = explode(".",$first_line_in_sql);
    for ($i = 0; $i < count($fl_sql); $i++) {
	if($fl_sql[$i][0]=="$") $fl_sql[$i]=${substr($fl_sql[$i],1)}; 
    }
    $first_line_in_sql=implode("",$fl_sql);
    reset($sql_openfiles);
    while(list($fname,$file)=each($sql_openfiles))
    {
	fputs($file,$first_line_in_sql."\n");
    }   
}
for($table=1;$table<$tnum;$table++)
{
    $fs=$sql_openfiles[$modules[$tablename[$table]]];
    if(empty($tablename_for_update[$table]))$tablename_for_update[$table]=$tablename[$table];
    if(empty($top_table_for_update[$table]))$top_table_for_update[$table]=$top_table[$table];

    $otn=$tablename_for_update[$table];
    if($create_seq=="on") 
    {
	fputs($fs,"CREATE SEQUENCE ".$otn."_seq start 1\n");
	fputs($fs,$sql_separator."\n");
    }
    if($create_gen=="on") 
    {
	fputs($fs,"CREATE GENERATOR ".$otn."_gen\n");
	fputs($fs,$sql_separator."\n");
    }	
    if($droptables=="yes")
    {
	fputs($fs,"DROP TABLE ".$otn."\n");
	fputs($fs,$sql_separator."\n");
    }
    fputs($fs,"CREATE TABLE ".$otn." (\n");

    fputs($fs,$nyckname[$table]." ");
    $sql_ffd = explode(".",$sql_first_field_define);
    for ($i = 0; $i < count($sql_ffd); $i++) {
	if(strstr($sql_ffd[$i],"\$tablename")) $sql_ffd[$i]=$otn; 
    }
    fputs($fs,implode("",$sql_ffd));

    if($primary_key=="on") fputs($fs,",\nPRIMARY KEY (".$nyckname[$table].")");

    if(!empty($field_eq_top[$table]))
    {
	fputs($fs,",\n".$field_eq_top[$table]." ".$sql_foreign_key_type);
	if($foreign_key=="on")
	    fputs($fs,",\nFOREIGN KEY (".$field_eq_top[$table].") references ".$top_table_for_update[$table]);
    }
    for($a=1;;$a++)
    {
	$vf = "FIELD$a"; $vtype = "TYPE$a"; $vhtype = "HTYPE$a"; $vonlyvis = "ONLYVIS$a";
	$fp = "FP$a"; $fpi = "I$a"; $fpm = "M$a"; $plt="PLT$a"; $fpd = "D$a";
	if(empty(${$vf}[$table]))break;
	if(${$vf}[$table]==$nyckname[$table])continue;
	if(!empty(${"SQLQUERYSELECT".$a}[$table]))
	{
	    ${"SRCH".$a}[$table] = false;
	    ${"NOSORT".$a}[$table] = "on";
	    ${"ONLYVIS".$a}[$table] = "on";
	    ${"NONEDITABLE".$a}[$table] = "on";
	}
	if(${$vonlyvis}[$table]=="on")
	{
#	    ${"NONEDITABLE$a"}[$table]="on";
	}else{
	    fputs($fs,",\n".${$vf}[$table]);
	    if(${$vhtype}[$table]=="blob" || ${$vtype}[$table]=="str" || 
		${$vtype}[$table]=="user")
	    {
		if(${$vhtype}[$table]=="blob") $txt_sql = $sql_blob_text_str;
		else if(${$vtype}[$table]=="user") $txt_sql = $sql_user_str;
		else $txt_sql = $sql_text_str;
		if(strstr($txt_sql,"\$M")) 
		{
		    $cpm = ${$fpm}[$table];
		    if(strstr($txt_sql,"char"))
		        if($cpm>$sql_max_char_size)$cpm=$sql_max_char_size;
		    $txt_sql=str_replace("\$M",$cpm,$txt_sql);
		    ${$fpm}[$table]=$cpm;
		}
		if(strstr($txt_sql,"text"))
		    if(!$sql_allow_sort_blob_text_fields)${"NOSORT".$a}[$table]="on";
		fputs($fs," ".$txt_sql);
	    }	
	    else if(${$vtype}[$table]=="decimal")
	    {
		fputs($fs," decimal(".${$fpi}[$table].",".${$fp}[$table].")");
		${$fpi}[$table]++;${$fpm}[$table]=${$fpi}[$table];
	    }
	    else if(${$vtype}[$table]=="datetime") fputs($fs," ".$sql_datetime_str);
	    else if(${$vtype}[$table]=="date") fputs($fs," ".$sql_date_str);
	    else if(${$vtype}[$table]=="time") fputs($fs," ".$sql_time_str);
	    else if($foreign_key=="on" && ${$vhtype}[$table]=="plistdb")
	    {
		fputs($fs," ".$sql_foreign_key_type);
		fputs($fs,",\nFOREIGN KEY (".${$vf}[$table].") references ".${$plt}[$table]);
	    }
	    else fputs($fs," ".${$vtype}[$table]);
	    if(${$fpd}[$table]!="")
	    {
		if(ereg_replace("[0-9]*","",${$fpd}[$table]))${$fpd}[$table]="'".${$fpd}[$table]."'";
		fputs($fs," DEFAULT ".${$fpd}[$table]);
	    }
	}    
    }
    fputs($fs,")\n".$sql_separator."\n");
    if($create_grant=="on") 
    {
	fputs($fs,"GRANT ALL ON ".$otn." TO PUBLIC\n");
	fputs($fs,$sql_separator."\n");
    }
    if($create_gen=="on") 
    {
	fputs($fs,"CREATE TRIGGER ".$otn."_tr FOR ".$otn." ACTIVE BEFORE INSERT AS BEGIN NEW.".$nyckname[$table]." = GEN_ID(".$otn."_gen,1); END\n");
	fputs($fs,$sql_separator."\n");
    }	
    fputs($fs,"\n");
}
reset($sql_openfiles);
while(list($fname,$file)=each($sql_openfiles))
{
    fclose($file);
}   
//****************************************************************************

//********************************** permissions files ***********************
if($permissions){
$fpt = open_file($outputfile_perm_table,"w","table");
fputs($fpt,"db_name=$db_name\n");
fputs($fpt,"filename=".eregi_replace("\.php.*","",$filename)."_perm.$php_ext"."\n");
fputs($fpt,"language=$language\n");
fputs($fpt,"project_name=$project_name\n");
for($table=1;$table<$tnum;$table++)
{
    $permt="perm_".$tablename[$table];
    fputs($fpt,"\nTABLE_START\n");
    fputs($fpt,"tablename = $permt\n");
    fputs($fpt,"table_title = $NLSPermFor ".$table_title[$table]." (".$tablename[$table].")\n");
    fputs($fpt,"nyckname = ".$permt."_id\n");
    fputs($fpt,"linkname = ".$permt."_id\n");
    fputs($fpt,"limit = 0\n");

    fputs($fpt,"\nFIELD_START\n");
    fputs($fpt,"TITLE = User Login Name\n");
    fputs($fpt,"FIELD = username\n");
    fputs($fpt,"TYPE = str\n");
    fputs($fpt,"HTYPE = str\n");
    fputs($fpt,"M = 20\n");
    fputs($fpt,"I = 8\n");
    fputs($fpt,"SRCH = on\n");
    fputs($fpt,"VISIBLEFIRST = on\n");
    fputs($fpt,"MUSTDEFINE = on\n");
    fputs($fpt,"FIELD_END\n");
    fputs($fpt,"\nFIELD_START\n");
    fputs($fpt,"TITLE = ".$table_title[$table]."\n");
    fputs($fpt,"FIELD = ".$tablename[$table]."\n");
    fputs($fpt,"TYPE = int\n");
    fputs($fpt,"HTYPE = plist\n");
    fputs($fpt,"DATA = 0:NONE,1:SELECT,2:INSERT,3:UPDATE,4:DELETE\n");
    fputs($fpt,"D = 0\n");
    fputs($fpt,"SRCH = on\n");
    fputs($fpt,"SRCHMULTI = on\n");
    fputs($fpt,"VISIBLEFIRST = on\n");
    fputs($fpt,"FIELD_END\n");
    for($a=1;;$a++)
    {
	$vf = "FIELD$a"; $vt = "TITLE$a";
	if(empty(${$vf}[$table]))break;
	fputs($fpt,"\nFIELD_START\n");
	fputs($fpt,"TITLE = ".${$vt}[$table]."\n");
	fputs($fpt,"FIELD = ".${$vf}[$table]."\n");
	fputs($fpt,"TYPE = int\n");
	fputs($fpt,"HTYPE = plist\n");
	fputs($fpt,"DATA = 0:NONE,1:SELECT,2:UPDATE\n");
	fputs($fpt,"D = 0\n");
	fputs($fpt,"SRCH = on\n");
	fputs($fpt,"SRCHMULTI = on\n");
	fputs($fpt,"FIELD_END\n");
    }
    fputs($fpt,"\nTABLE_END\n");
}
fclose($fpt);
copy($OUTPUTDIR.$SEPARATOR.$outputfile_perm_table,$outputfile_perm_table);
chmod($outputfile_perm_table,0644);
}
//****************************************************************************

//********************************** global file *****************************
$fg = open_file($outputfile_global,"w","inc");
fputs($fg,"$php_start\n\n");
fputs($fg,"\$dbtype=\"$db_type\";\n");
fputs($fg,"\$db_server=\"$db_server\";\n");
fputs($fg,"\$db_name=\"$db_name\";\n");
fputs($fg,"\$db_user = \"$db_user\";\n");
fputs($fg,"\$db_passwd = \"$db_passwd\";\n");
fputs($fg,"\$secure=$secure;\n");
fputs($fg,"\$php_ext=\"$php_ext\";\n");
fputs($fg,"\$php4enable=$php4enable;\n");
fputs($fg,"\$checktime=$checktime;\n");
fputs($fg,"if(\$php4enable)\n");
fputs($fg,"{\n");
fputs($fg,"	session_start();\n");
fputs($fg,"	\$sess_id=SID;\n");
fputs($fg,"	if(\$checktime)\n");
fputs($fg,"	{\n");
fputs($fg,"		\$maxtimeout=$maxtimeout;\n");
fputs($fg,"		session_register(\"last_visit_time\");\n");
fputs($fg,"		if(empty(\$last_visit_time))\$last_visit_time=time();\n");
fputs($fg,"	}\n");
fputs($fg,"}\n");
fputs($fg,"\$ssl_on=\"$ssl_on\";\n");
fputs($fg,"\$ssl_port=$ssl_port;\n");
fputs($fg,"\$callbacktype=$callbacktype;\n");
fputs($fg,"\$INCDIR=\"$INCDIR\";\n");
fputs($fg,"include \$path.\"$outputfile_theme\";\n");
fputs($fg,"include \$path.\$INCDIR.\$SEPARATOR.\"sql.inc\";\n");
fputs($fg,"include \$path.\$INCDIR.\$SEPARATOR.\"connect.inc\";\n");
fputs($fg,"include \$path.\"$outputfile_module\";\n");
fputs($fg,"include \$path.\"$outputfile_names\";\n");
fputs($fg,"include \$path.\$INCDIR.\$SEPARATOR.\"lib_util.inc\";\n");
fputs($fg,$incfile_str);
fputs($fg,"\$date_format=\"$date_format\";\n");
fputs($fg,"\$sql_date_format=\"$sql_date_format\";\n");
fputs($fg,"\$auto_increment=$auto_increment;\n");
fputs($fg,"\$transaction = $transaction;\n");
fputs($fg,"\$images_dir = \"$IMAGESDIR\";\n");
fputs($fg,"\$images_small_dir = \"$IMAGESSMALLDIR\";\n");
fputs($fg,"\$convert_to_small = \"$convert_to_small\";\n");
fputs($fg,"\$convert_to_jpeg = \"$convert_to_jpeg\";\n");
fputs($fg,"\$convert_all_to_jpeg = 1;\n");
fputs($fg,"\$max_small_image_height = $max_small_image_height;\n");
fputs($fg,"\$max_small_image_width = $max_small_image_width;\n");
fputs($fg,"include \$path.\$INCDIR.\$SEPARATOR.\"datecode.inc\";\n");
include $path."inc".$SEPARATOR."datecode.inc";
fputs($fg,"\$MONTHS = ". makeMonthArray($NLSMonths) .";\n"); 
if (isset($NLSLocale)) {
    fputs($fg,"setlocale(\"LC_ALL\",\"$NLSLocale\");\n"); 
}

fputs($fg,"echo \"<HTML>\\n<HEAD>\\n\";\n");
fputs($fg,"echo \"<META HTTP-EQUIV=\\\"Content-Type\\\" CONTENT=\\\"text/html;\";\n");
if($NLSCharset!="")fputs($fg,"echo \"charset=$NLSCharset\";\n");
fputs($fg,"echo \"\\\">\\n\";\n");
//*** Insert Style sheet ?
fputs($fg,"if(empty(\$table_name)){\n");
fputs($fg,"	if(!empty(\$style_sheet))include \$path.\"\$style_sheet\";\n");
fputs($fg,"	if(\$js) echo \"<SCRIPT LANGUAGE=\\\"JavaScript\\\" SRC=\\\"\".\$INCDIR.\$SEPARATOR.\"phpgem.inc.js\\\"></SCRIPT>\";\n");
fputs($fg,"}\n");
fputs($fg,"if(\$buttons_dir!=\"\")\n");
fputs($fg,"{\n");
fputs($fg,"	file2var(\$path.\$buttons_dir.\"\$SEPARATOR\".\"buttons.lst\");\n");
fputs($fg,"}\n");
fputs($fg,"\n$php_end");
fclose($fg);
//****************************************************************************

$path_analyze="\$SEPARATOR=\"$SEPARATOR\";\n";
$path_analyze.="if(strstr(\$SERVER_SOFTWARE,\"thttpd\"))\n";
$path_analyze.="{\n";
$path_analyze.="	\$thttpd_path=true;\n";
$path_analyze.="	\$full_path=true;\n";
$path_analyze.="}\n";
$path_analyze.="else \$full_path=\"$full_path\";\n";
$path_analyze.="if(\$full_path)\n";
$path_analyze.="{\n";
$path_analyze.="    \$path=exec(\"pwd\");\n";
$path_analyze.="    if(\$thttpd_path)\n";
$path_analyze.="    {\n";
$path_analyze.="	\$path.=dirname(\$REQUEST_URI).\$SEPARATOR;\n";
$path_analyze.="    }\n";
$path_analyze.="    else \$path.=\$SEPARATOR;\n";
$path_analyze.="}else \$path=\"\";\n";

//********************************** index file ******************************
$fi = open_file($outputfile_index,"w","php");
fputs($fi,"$php_start\n");
if(empty($logo_off))
{
    fputs($fi,"//** Generated by PHPGem $today\n");
    fputs($fi,"//** $author_name $author_email\n\n");
}
fputs($fi,"\$scriptname=eregi_replace(\"\\?.*\",\"\",\$REQUEST_URI);\n");
fputs($fi,$path_analyze);
fputs($fi,"include \$path.\"$outputfile_global\";\n");
fputs($fi,"if(\$js!=1) echo \"<script language=\\\"JavaScript\\\">
<!-- 
window.location=\\\"\$scriptname?\$sess_id&js=1\\\";
// -->
</script>\";\n");
fputs($fi,"echo \"<TITLE>\$scriptname - $db_name</TITLE>\\n\";\n");
fputs($fi,"echo \"</HEAD>\\n\$body_tag\\n\";\n");
fputs($fi,"echo print_uri();\n");
fputs($fi,"echo \"\$title_menu_table_tag\\n\";\n");
for($a=0;$a<=$max_demo_mode;$a++)
{
    fputs($fi,"echo \"\$table_tr_start\$table_td_start\$center_start\";\n");
    if($a==0)$debug_mess="(".$NLSSQLDebug.")";
    else if($a==2)$debug_mess="(".$NLSRecommend.")"; 
    else $debug_mess="";
    fputs($fi,"if(\$js==1) echo print_link(\"javascript:popup_win(\\\"\".\$module[\"list_tables\"].\"?\$sess_id&demo_mode=$a&js=\$js\\\")\",\" $NLSMode $a $debug_mess\",\$link_table_menu_type);\n");
    fputs($fi,"echo \"<noscript>\".print_link(\$module[\"list_tables\"].\"?\$sess_id&demo_mode=$a&js=\$js\",\" $NLSMode $a \",\$link_table_menu_type).\"</noscript>\";\n");
    fputs($fi,"echo \"\$center_end\$table_td_end\$table_tr_end\";\n");
}
fputs($fi,"	echo \"\$end_table_tag\\n\";\n");
fputs($fi,"echo \"\\n</BODY></HTML>\";\n\n");
fputs($fi,$end_incfile_str);
fputs($fi,"\n$php_end");
fclose($fi);
//****************************************************************************

//********************************** theme file ******************************
$ft = open_file($outputfile_theme,"w","inc");
fputs($ft,"$php_start\n\n");
fputs($ft,"\$separ_array = \"$separ_array\";\n");
fputs($ft,"\$buttons_dir = \"$buttons_dir\";\n");

fputs($ft,"if(!isset(\$printable))\$printable=0;\n");
fputs($ft,"if(!isset(\$sql_debug))\$sql_debug=$sql_debug;\n");
fputs($ft,"if(!isset(\$uri_debug))\$uri_debug=$uri_debug;\n");
fputs($ft,"\$search_case = \"$search_case\";\n");
fputs($ft,"if(!isset(\$global_limit))\$global_limit=\"off\";\n");

fputs($ft,"\$style_sheet = \"$style_sheet\";\n");
fputs($ft,"\$ground_image = \"$ground_image\";\n");
fputs($ft,"\$bg_image1 = \"$bg_image1\";\n");
fputs($ft,"\$bg_image2 = \"$bg_image2\";\n");
fputs($ft,"\$link_color = \"$link_color\";\n");
fputs($ft,"\$list_color1 = \"$list_color1\";\n");
fputs($ft,"\$list_color2 = \"$list_color2\";\n");
fputs($ft,"\$menu_bg_color = \"$menu_bg_color\";\n");
fputs($ft,"\$title_menu_bg_color = \"$title_menu_bg_color\";\n");
fputs($ft,"\$error_color = \"$error_color\";\n");
fputs($ft,"\$float_menu_button_bg_color = \"$float_menu_button_bg_color\";\n");
fputs($ft,"\$float_menu_bg_color = \"$float_menu_bg_color\";\n");

fputs($ft,"\$link_type = \"$link_type\";\n");
fputs($ft,"\$link_menu_type = \"$link_menu_type\";\n");
fputs($ft,"\$link_table_type = \"$link_table_type\";\n");
fputs($ft,"\$link_table_menu_type = \"$link_table_menu_type\";\n");
fputs($ft,"\$link_header_table_type = \"$link_header_table_type\";\n");
fputs($ft,"\$link_detail_table_type = \"$link_detail_table_type\";\n");

fputs($ft,"if(!isset(\$demo_mode))\$demo_mode=$demo_mode;\n");
fputs($ft,"if(\$demo_mode==0)\n");
fputs($ft,"{\n");
fputs($ft,"	\$ground_image = \"\";\n");
fputs($ft,"	\$bg_image1 = \"\";\n");
fputs($ft,"	\$bg_image2 = \"\";\n");
fputs($ft,"	\$link_type = \"form\";\n");
fputs($ft,"	\$link_menu_type = \"href\";\n");
fputs($ft,"	\$link_table_type = \"href\";\n");
fputs($ft,"	\$link_table_menu_type = \"href\";\n");
fputs($ft,"	\$link_header_table_type = \"href\";\n");
fputs($ft,"	\$link_detail_table_type = \"href_u\";\n");
fputs($ft,"	\$sql_debug=true;\n");
fputs($ft,"	\$uri_debug=true;\n");
fputs($ft,"}else if(\$demo_mode==1)\n");
fputs($ft,"{\n");
fputs($ft,"	\$ground_image = \"\";\n");
fputs($ft,"	\$bg_image1 = \"\";\n");
fputs($ft,"	\$bg_image2 = \"\";\n");
fputs($ft,"	\$link_type = \"form\";\n");
fputs($ft,"	\$link_menu_type = \"href\";\n");
fputs($ft,"	\$link_table_type = \"href\";\n");
fputs($ft,"	\$link_table_menu_type = \"href\";\n");
fputs($ft,"	\$link_header_table_type = \"href\";\n");
fputs($ft,"	\$link_detail_table_type = \"href_u\";\n");
fputs($ft,"	\$sql_debug=false;\n");
fputs($ft,"	\$uri_debug=false;\n");
fputs($ft,"}else if(\$demo_mode==2)\n");
fputs($ft,"{\n");
fputs($ft,"	\$ground_image = \"\";\n");
fputs($ft,"	\$bg_image1 = \"\";\n");
fputs($ft,"	\$bg_image2 = \"\";\n");
fputs($ft,"	\$menu_bg_color = \"\";\n");
fputs($ft,"	\$link_type = \"form\";\n");
fputs($ft,"	\$link_menu_type = \"buttonimage\";\n");
fputs($ft,"	\$link_table_type = \"buttonimage\";\n");
fputs($ft,"	\$link_table_menu_type = \"href\";\n");
fputs($ft,"	\$link_header_table_type = \"href\";\n");
fputs($ft,"	\$link_detail_table_type = \"href_u\";\n");
fputs($ft,"	\$sql_debug=false;\n");
fputs($ft,"	\$uri_debug=false;\n");
fputs($ft,"}else if(\$demo_mode==3)\n");
fputs($ft,"{\n");
fputs($ft,"	if(!empty(\$bg_image1))\$list_color1 = \"\";\n");
fputs($ft,"	if(!empty(\$bg_image2))\$list_color2 = \"\";\n");
fputs($ft,"	if(!empty(\$ground_image)){\$menu_bg_color = \"\";\$title_menu_bg_color = \"\";}\n");
fputs($ft,"	\$link_type = \"form\";\n");
fputs($ft,"	\$link_menu_type = \"buttonimage\";\n");
fputs($ft,"	\$link_table_type = \"buttonimage\";\n");
fputs($ft,"	\$link_table_menu_type = \"image\";\n");
fputs($ft,"	\$link_header_table_type = \"image\";\n");
fputs($ft,"	\$link_detail_table_type = \"href_u\";\n");
fputs($ft,"	\$float_menu_bg_color = \"\";\n");
fputs($ft,"	\$sql_debug=false;\n");
fputs($ft,"	\$uri_debug=false;\n");
fputs($ft,"}else if(\$demo_mode==4)\n");
fputs($ft,"{\n");
fputs($ft,"	if(!empty(\$bg_image1))\$list_color1 = \"\";\n");
fputs($ft,"	if(!empty(\$bg_image2))\$list_color2 = \"\";\n");
fputs($ft,"	if(!empty(\$ground_image))\$menu_bg_color = \"\";\$title_menu_bg_color = \"\";\n");
fputs($ft,"	\$link_type = \"javascriptimage\";\n");
fputs($ft,"	\$link_menu_type = \"buttonimage\";\n");
fputs($ft,"	\$link_table_type = \"buttonimage\";\n");
fputs($ft,"	\$link_table_menu_type = \"javascriptimage\";\n");
fputs($ft,"	\$link_header_table_type = \"javascriptimage\";\n");
fputs($ft,"	\$link_detail_table_type = \"href_u\";\n");
fputs($ft,"	\$float_menu_bg_color = \"\";\n");
fputs($ft,"	\$sql_debug=false;\n");
fputs($ft,"	\$uri_debug=false;\n");
fputs($ft,"}\n");
fputs($ft,"if(\$printable)\n");
fputs($ft,"{\n");
fputs($ft,"	\$ground_image = \"\";\n");
fputs($ft,"	\$bg_image1 = \"\";\n");
fputs($ft,"	\$bg_image2 = \"\";\n");
fputs($ft,"	\$link_color = \"\";\n");
fputs($ft,"	\$list_color1 = \"\";\n");
fputs($ft,"	\$list_color2 = \"\";\n");
fputs($ft,"	\$menu_bg_color = \"\";\n");
fputs($ft,"	\$title_menu_bg_color = \"\";\n");
fputs($ft,"	\$float_menu_bg_color = \"\";\n");
fputs($ft,"	\$error_color = \"\";\n");
fputs($ft,"}\n");

fputs($ft,"if(\$js&&\$func==\"imagedetail\")\$bodyload=\"Onload=\\\"bodyload();\\\"\";\n");
fputs($ft,"\$body_tag = \"".$body_tag."\";\n");
fputs($ft,"\$menu_table_tag = \"$menu_table_tag\";\n");
fputs($ft,"\$title_menu_table_tag = \"$title_menu_table_tag\";\n");
fputs($ft,"\$float_menu_table_tag = \"$float_menu_table_tag\";\n");
fputs($ft,"\$list_table_tag = \"$list_table_tag\";\n");
fputs($ft,"\$form_table_tag = \"$form_table_tag\";\n");
fputs($ft,"\$standard_table_tag = \"$standard_table_tag\";\n");
fputs($ft,"\$end_table_tag = \"$end_table_tag\";\n");
fputs($ft,"\$table_tr_start = \"$table_tr_start\";\n");
fputs($ft,"\$table_tr_end = \"$table_tr_end\";\n");
fputs($ft,"\$table_td_start = \"$table_td_start\";\n");
fputs($ft,"\$table_td_menu_start = \"$table_td_menu_start\";\n");
fputs($ft,"\$table_td_end = \"$table_td_end\";\n");
fputs($ft,"\$table_th_start = \"$table_th_start\";\n");
fputs($ft,"\$table_th_end = \"$table_th_end\";\n");
fputs($ft,"\$center_start = \"$center_start\";\n");
fputs($ft,"\$center_end = \"$center_end\";\n");

fputs($ft,"\$ttffile = \$path.\"$ttffile\";\n");

fputs($ft,"\$button_out_border = \"$button_out_border\";\n");
fputs($ft,"\$button_in_size_border = \"$button_in_size_border\";\n");
fputs($ft,"\$button_in_interval_border = \"$button_in_interval_border\";\n");
fputs($ft,"\$button_in_color_border = \"$button_in_color_border\";\n");
fputs($ft,"\$button_in_ttf_font_size = \"$button_in_ttf_font_size\";\n");
fputs($ft,"\$button_in_color_text = \"$button_in_color_text\";\n");
fputs($ft,"\$button_in_color_ground = \"$button_in_color_ground\";\n");
fputs($ft,"\$button_active_in_size_border = \"$button_active_in_size_border\";\n");
fputs($ft,"\$button_active_in_interval_border = \"$button_active_in_interval_border\";\n");
fputs($ft,"\$button_active_in_color_border = \"$button_active_in_color_border\";\n");
fputs($ft,"\$button_active_in_ttf_font_size = \"$button_active_in_ttf_font_size\";\n");
fputs($ft,"\$button_active_in_color_text = \"$button_active_in_color_text\";\n");
fputs($ft,"\$button_active_in_color_ground = \"$button_active_in_color_ground\";\n");
fputs($ft,"\n$php_end");
fclose($ft);
//****************************************************************************

$today = Date($php_date_format);
while(list($fname,$file)=each($openfiles))
{
    fputs($file,"$php_start\n");
if(empty($logo_off))
{
    fputs($file,"//** Generated by PHPGem $today\n");
    fputs($file,"//** $author_name $author_email\n\n");
}
    fputs($file,"\$scriptname=eregi_replace(\"\\?.*\",\"\",\$REQUEST_URI);\n");
    fputs($file,"if(!isset(\$only_full_list))\$only_full_list=0;\n");
    fputs($file,"if(!\$only_full_list)\n");
    fputs($file,"{\n");
    fputs($file,$path_analyze);
    fputs($file,"	include \$path.\"$outputfile_global\";\n");
    fputs($file,"}\n");
    fputs($file,"else \$scriptname=\$module[\$table_name];\n\n");
}   

//********************************** List tables *****************************
$f=$openfiles[$filename];
fputs($f," /******************** List tables ****************/\n");
fputs($f,"if(empty(\$table_name))\n{\n");
fputs($f,"	echo \"<TITLE>$NLSListOfTables / $db_name - \$scriptname</TITLE>\\n\";\n");
fputs($f,"	echo \"</HEAD>\\n\$body_tag\\n\";\n");
fputs($f,"	echo print_uri();\n");
fputs($f,"	echo \"\$title_menu_table_tag\\n\";\n");
for($table=1;$table<$tnum;$table++)
{
    if(empty($level[$table]))$level[$table]=0;
    if($level[$table] == 0){
if($permissions){
	$permt="perm_".$tablename[$table];
	fputs($f,"	\$presult = SQL_query(\"SELECT * FROM $permt WHERE username = '\".\$db_user.\"'\",\$f);\n");
	fputs($f,"	if(\$perm_field=SQL_fetch_object(\$presult,0)){\n");
	fputs($f,"	   \$perm_table=\$perm_field->".$tablename[$table].";\n");
	fputs($f,"	   if(\$perm_table>=1)\n");
}
	fputs($f,"		echo \"\$table_tr_start \$table_td_menu_start\$center_start\".print_link(\$module[\"".$tablename[$table]."\"].\"?\$sess_id&func=lista&table_name=".$tablename[$table]."&visible_all_fields=\$visible_all_fields&show_child_tables=\$show_child_tables&global_limit=\$global_limit&limit=&demo_mode=\$demo_mode&sql_debug=\$sql_debug&uri_debug=\$uri_debug&js=\$js&printable=\$printable\",\$names[\"".$tablename[$table]."\"][0],\$link_table_menu_type).\"\$center_end\$table_td_end\$table_tr_end\";\n");
if($permissions){
	fputs($f,"	}\n");
}
}}
fputs($f,"	echo \"\$end_table_tag\\n\";\n");
fputs($f,"}\n\n");
//****************************************************************************

//*************************************** logout file ************************
$f=$openfiles[$outputfile_logout];
fputs($f," /******************** Logout *********************/\n");
fputs($f,"if(empty(\$logoutyes))\n{\n");
fputs($f,"	echo \"<TITLE>$NLSLogout / $db_name - \$scriptname</TITLE>\\n\";\n");
fputs($f,"	echo \"</HEAD>\\n\$body_tag\\n\";\n");
fputs($f,"	echo print_uri();\n");
fputs($f,"	echo \"\$title_menu_table_tag\\n\";\n");
if ($center) fputs($f,"	echo \"\$center_start\";\n");
fputs($f,"	echo \"<H1>$NLSLogout.</H1>\";\n");
fputs($f,"	echo \"\$standard_table_tag \$table_tr_start \$table_td_start\";\n");
fputs($f,"	echo print_link(\"\$scriptname?\$sess_id&logoutyes=1&table_name=logout&js=\$js\",\"$NLSYes\",\$link_type);\n");
fputs($f,"	echo \"\$table_td_end \$table_td_start\";\n");
fputs($f,"	echo print_link(\$module[\$table_name].\"?\".ereg_replace(\".*\\?\",\"\",\$REQUEST_URI),\"$NLSNo\",\$link_type);\n");
fputs($f,"	echo \"\$table_td_end \$table_tr_end \$end_table_tag\";\n");
if ($center) fputs($f,"	echo \"\$center_end\";\n");

fputs($f,"}else{\n");
fputs($f,"	SQL_logout(\$f);\n");
fputs($f,"if(\$js) echo \"<script language=\\\"JavaScript\\\">
<!-- 
self.close();
close();
// -->
</script>\";\n");
fputs($f,"	callback(\$module[\"index\"].\"?\$sess_id&\");\n");
fputs($f,"}\n\n");

//****************************************************************************

for($table=1;$table<$tnum;$table++)
{
if ($limit[$table] == "")$limit[$table]=25;
$f=$openfiles[$modules[$tablename[$table]]];
if ($level[$table] == "") $level[$table]=0;
fputs($f,"\n\n /******************".$table_title[$table]."********************/\n");
fputs($f,"if(\$table_name == \"".$tablename[$table]."\")\n{\n");
fputs($f,"	\$table_name_for_update=\"".$tablename_for_update[$table]."\";\n");
if($permissions){
    $permt="perm_".$tablename[$table];
    fputs($f,"\$presult = SQL_query(\"SELECT * FROM $permt WHERE username = '\".\$db_user.\"'\",\$f);\n");
    fputs($f,"if(!(\$perm_field=SQL_fetch_object(\$presult,0))){echo \"User \$db_user Access Denied\";exit;}\n"); 
    fputs($f,"\$perm_table=\$perm_field->\$table_name;\n");
    fputs($f,"if(\$perm_table>=1){\n");
}
fputs($f,"if(strcasecmp(\$global_limit,\"off\")) \$limit=\$global_limit;\n");
fputs($f,"else if(!strlen(\$limit))\$limit=".$limit[$table].";\n");

fputs($f,"if(empty(\$limit)||\$limit==0) \$lim_str=\"\";\n");
fputs($f,"else \$lim_str=\"$lim_str\";\n");
fputs($f,"if(empty(\$lim_str))\$limit = 0;\n");

fputs($f,"\nif(!\$only_full_list)echo \"<TITLE>\".\$names[\"".$tablename[$table]."\"][0].\" / $db_name - \$scriptname</TITLE>\\n\";\n");
fputs($f,"\$c=\"\";\$order_field=\"\";\n");

$level_current = $level[$table];
###!!!
$link_to_parent = ComputeParent($table);
$link_to_child = "";
for($i=1;$i<$tnum;$i++)
{
    if($level[$i] == ($level_current+1) && $top_table[$i] == $tablename[$table])
    {
	$link_to_child= " ";
    }
    if($level[$i] == ($level_current-1) && $top_table[$table] == $tablename[$i])
    {
	$top_nyckname = $nyckname[$i];
    }
}

echo "Table number: ".$table." 
<UL>
<LI>Name: ".$tablename[$table]." 
<LI>Title: ".$table_title[$table]." 
<LI>Module: ".$modules["".$tablename[$table].""]." 
<LI>Level: ".$level[$table];
echo "</UL><p>";

flush();

if($nycknamenumeric[$table])$idquotes="";
else $idquotes="'";

if($level_current>0){
    $sql_level = "\$table_name.".$field_eq_top[$table]."=$idquotes\$".$top_nyckname."$idquotes ";
    $sql_level_and = "AND ".$sql_level;
}
else{$sql_level_and="";$sql_level="";}

if($linkname[$table]=="")$linkfield=$FIELD1[$table]; 
else $linkfield=$linkname[$table];
$a = 1;
$vf = "FIELD1"; $vtype = "TYPE1";
fputs($f,"if(\$only_full_list){\$forder_up=\$forder;\$forder=\"\";}\n");

fputs($f,"\$order_str=\$names[\$table_name][\$forder];\n");
fputs($f,"if(\$forder==\"\"||\$order_str==\"\")\$forder=\"$linkfield\";\n");
fputs($f,"\$order_str=\$names[\$table_name][\$forder];\n");
fputs($f,"if(\$order_str==\"\")\$order_str=\$forder;\n");
fputs($f,"\$prev=0;\n");
fputs($f,"\$mustdefine=\"\";\n");

while (${$vf}[$table] !=""){
	if(${$vtype}[$table] == "date" || ${$vtype}[$table] == "datetime") 
	{	
	    fputs($f,"processDateFields(\"".${$vf}[$table]."\");\n"); 
	    fputs($f,"if(empty(\$sv_". ${$vf}[$table] ."))\n"); 
	    fputs($f,"{\n");
	    fputs($f,"	processDateFields(\"sv_". ${$vf}[$table] ."\");\n"); 
	    fputs($f,"	processDateFields(\"sv_". ${$vf}[$table] ."_top\");\n"); 
	    fputs($f,"}\n");
	}
	$a++;
	$vf = "FIELD" . $a;
	$vtype = "TYPE" . $a;
}
fputs($f,"if(\$visible_all_fields==\"\")\$visible_all_fields=0;\n\n");
fputs($f,"if(\$sort_desc==\"\")\$sort_desc=0;\n\n");
fputs($f,"if(empty(\$forward_func)||\$func==\"lista\")\$forward_func=\"lista\";\n");
fputs($f,"if(\$func==\"search\")\$forward_func=\"search\";\n");
fputs($f,"\$global_vars=\"demo_mode=\$demo_mode&visible_all_fields=\$visible_all_fields&show_child_tables=\$show_child_tables&global_limit=\$global_limit&limit=\$limit&forder=\$forder&sort_desc=\$sort_desc&sql_debug=\$sql_debug&uri_debug=\$uri_debug&js=\$js&printable=\$printable&forward_func=\$forward_func\";\n\n");

fputs($f,"if(!is_array(\$whichfield))if(!empty(\$whichfield))\$whichfield=explode(\",\",\$whichfield);\n");
fputs($f,"if(count(\$whichfield)){\n");
fputs($f,"  \$global_s_vars =\"whichfield=\".url_encode(implode(\",\",\$whichfield));\n");
fputs($f,"  \$sql_search=\"\";\n");
fputs($f,"  \$name_search=\"\";\n");
fputs($f,"  for (\$i = 0; \$i < count(\$whichfield); \$i++) {\n");
fputs($f,"	\$wf=\$whichfield[\$i];\n");
fputs($f,"	\$wf_str=\$names[\$table_name][\$wf];\n");
fputs($f,"	if(empty(\$wf_str))\$wf_str=\$wf;\n");
fputs($f,"	\$sv=\${\"sv_\".\$wf};\n");
fputs($f,"	\$sv_print=\$sv;\n");
fputs($f,"	\$sv_top=\${\"sv_\".\$wf.\"_top\"};\n");
fputs($f,"	\$st=\${\"st_\".\$wf};\n");
fputs($f,"	\$sf=\${\"sf_\".\$wf};\n");
$visible_not_all=0;
fputs($f,"	if(is_array(\$sv)) \$sv=implode(\",\",\$sv);\n");
for($a=1;;$a++)
{
	$vf = "FIELD" . $a;
	if(empty(${$vf}[$table]))break;
	$vhtype = "HTYPE" . $a;
	$vvis = "VISIBLEFIRST" . $a;
	$plt = "PLT" . $a;
	$plid = "PLID" . $a;
	$plnv = "PLNV" . $a;
	$plfieldalias = "PLFIELDALIAS" . $a;
	fputs($f,"	if(\$wf==\"".${$vf}[$table]."\"){\n");
	if (${$vhtype}[$table] == "checkbox")
	{
	    fputs($f,"		if(strlen(\$sv_".${$vf}[$table]."))\n");
	    fputs($f,"			next(\${\$table_name.\"_".${$vf}[$table]."_arr\"});\n");
	    fputs($f,"		\$sv_".${$vf}[$table]."=key(\${\$table_name.\"_".${$vf}[$table]."_arr\"});\n");
	}
	if (${$vhtype}[$table] == "plist" || ${$vhtype}[$table] == "rlist"
	    || ${$vhtype}[$table] == "checkbox")
	{	
	    fputs($f,"		\$sv_ex=explode(\",\",\$sv);\n");
	    fputs($f,"		if(count(\$sv_ex)){\n");
	    fputs($f,"		    \$sv_print=\"\";\n");
	    fputs($f,"		    for (\$j=0;\$j<count(\$sv_ex);\$j++){\n");
	    fputs($f,"			\$sv_print[\$j]=\${\$table_name.\"_".${$vf}[$table]."_arr\"}[\$sv_ex[\$j]];\n");
	    fputs($f,"		    }\n");
	    fputs($f,"		    \$sv_print=implode(\",\",\$sv_print);\n");
	    fputs($f,"		}\n");
	}else if (${$vhtype}[$table] == "plistdb") 
	{
	    fputs($f,"		\$sv_ex=explode(\",\",\$sv);\n");
	    fputs($f,"		if(count(\$sv_ex)){\n");
	    fputs($f,"		    \$sv_print=\"\";\n");
	    fputs($f,"		    for (\$j=0;\$j<count(\$sv_ex);\$j++){\n");
	    fputs($f,"			\$sstp = \"SELECT ".${$plnv}[$table]." FROM ".${$plt}[$table]." WHERE ".${$plid}[$table]." = $idquotes\".\$sv_ex[\$j].\"$idquotes\";\n");
	    fputs($f,"			\$resp = SQL_query(\$sstp,\$f);\n");
	    fputs($f,"			if(empty(\$resp)) echo SQL_error(\$f,\$sstp).\"<BR>\";\n"); 
	    fputs($f,"			\$tmprow=SQL_fetch_object(\$resp,0);\n");
	    fputs($f,"			\$sv_print[\$j]=\$tmprow->".${$plnv}[$table].";\n");
	    fputs($f,"		    }\n");
	    fputs($f,"		    \$sv_print=implode(\",\",\$sv_print);\n");
	    fputs($f,"		}\n");
	}
	fputs($f,"	}\n");
	if(${$vvis}[$table] != "on") $visible_not_all=1;
}
fputs($f,"	\$global_s_vars.=\"&sv_\$wf=\".url_encode(\$sv);\n");
fputs($f,"	\$global_s_vars.=\"&sv_\".\$wf.\"_top=\".url_encode(\$sv_top);\n");
fputs($f,"	\$global_s_vars.=\"&st_\$wf=\$st\";\n");
fputs($f,"	\$global_s_vars.=\"&sf_\$wf=\$sf\";\n");
fputs($f,"	\$wf=\$table_name.\".\".\$wf;\n");
fputs($f,"	if((\$sf==\"date\")||(\$sf==\"numeric\")){\n");
fputs($f,"		if(empty(\$st)) \$sql_search .= \"AND (\$wf ='\".\$sv.\"') \";\n");
fputs($f,"		else\n");
fputs($f,"		{\n");
fputs($f,"			\$sql_search .= \"AND (\$wf between '\".\$sv.\"' and '\".\$sv_top.\"') \";\n");
fputs($f,"			\$sv_print=\$sv.\" - \".\$sv_top;\n");
fputs($f,"		}\n");
fputs($f,"	}\n");
fputs($f,"	else if(\$sf==\"select\")\$sql_search .= \"AND (\$wf IN ('\".str_replace(\",\",\"','\",\$sv).\"')) \";\n");
fputs($f,"	else\n");
fputs($f,"	{\n");
fputs($f,"		\$sv=trim(\$sv);\n");
fputs($f,"		if(\$search_case==\"upper\")\$sv=strtoupper(\$sv);\n");
fputs($f,"		else if(\$search_case==\"lower\") \$sv=strtolower(\$sv);\n");
fputs($f,"		\$sql_search .= \"AND (\".\$search_case.\"(\$wf) LIKE '%\".\$sv.\"%') \";\n");
fputs($f,"	}\n");
fputs($f,"  	\$name_search.=\", $NLSQuot\".print_sp(\$sv_print).\"$NLSQuot $NLSSearchIn \".\$wf_str;\n");
fputs($f,"  }\n");
fputs($f,"}else{\$global_s_vars=\"\";}\n");
fputs($f,"if(\$func==\"lista\")\$sql_search=\"\";\n");
fputs($f,"\$sql_search.=\"".$sql_level_and."\";\n");
fputs($f,"if(\$sql_search){\$sql_search=substr(\$sql_search,4);\n");
fputs($f,"	\$name_search=substr(\$name_search,1);}\n");
fputs($f,"if(!count(\$whichfield)&&\$func==\"search\")\$func=\"searchform\";\n");

fputs($f,"\n /********** Delete *****".$table_title[$table]."***********************************/ \n");
fputs($f,"if (\$func == \"erase\"){\n");
if($permissions){
fputs($f,"if(\$perm_table>=4){\n");
}

for($a=1;;$a++)
{
	$vf = "FIELD" . $a;
	if(${$vf}[$table] =="")break;
	$vtype = "TYPE" . $a;
	$vhtype = "HTYPE" . $a;
	if (${$vhtype}[$table] == "image")
	{
fputs($f,"	\$sst = \"SELECT  ".${$vf}[$table]." FROM \$table_name WHERE ".$nyckname[$table]."=$idquotes\$par$idquotes\";\n");
fputs($f,"	\$result = SQL_query(\$sst,\$f);\n");
fputs($f,"	if(empty(\$result)) echo SQL_error(\$f,\$sst).\"<BR>\";\n"); 
fputs($f,"	\$tmprow=SQL_fetch_object(\$result,0);\n");
fputs($f,"	\$tmp_img_file = \$tmprow->".${$vf}[$table].";\n");

fputs($f,"	if(!empty(\$tmp_img_file))\n");
fputs($f,"	{\n");
fputs($f,"		unlink(\$images_dir.\$SEPARATOR.\$tmp_img_file);\n");
fputs($f,"		unlink(\$images_small_dir.\$SEPARATOR.\$tmp_img_file);\n");
fputs($f,"	}\n");
	}
}

fputs($f,"	\$sql_string=\"DELETE FROM \$table_name_for_update WHERE ".$nyckname[$table]."=$idquotes\$par$idquotes\";\n");
fputs($f,"	\$result = SQL_query(\$sql_string,\$f);\n");
fputs($f,"	if(!empty(\$result)) callback(\"\$scriptname?\$sess_id&func=\$forward_func".$link_to_parent."&start=0&\$global_vars&\$global_s_vars&table_name=\$table_name\");\n");
fputs($f,"	else{echo SQL_error(\$f,\$sql_string).\"<BR>\"; \$func=\"warnerase\";}\n"); 
if($permissions){
fputs($f,"} # permissions DELETE for ".${$vf}[$table]."\n");
}
fputs($f,"} # Delete\n");

fputs($f,"\n /********** Store New * Save edited ***".$table_title[$table]."****************/\n");
fputs($f,"if (\$func == \"storenew\" || \$func == \"save\"){\n");
if($permissions){
fputs($f,"if( (\$perm_table>=2&&\$func == \"storenew\")\n");
fputs($f,"  ||(\$perm_table>=3&&\$func == \"save\")){\n");
}
fputs($f,"	if(\$transaction)SQL_query(\"$transaction_start\",\$f);\n");

fputs($f,"	\$ok = 1;\n");
fputs($f,"	\$bad_str=\"\";\n"); 
fputs($f,"	\$fields=\"\";\n"); 
fputs($f,"	\$values=\"\";\n"); 
fputs($f,"	\$sql_upd=\"\";\n");
if($level_current>0){
	fputs($f,"	\$fields.=\",".$field_eq_top[$table]."\";\n"); 
	fputs($f,"	\$values.=\",$idquotes\$".$top_nyckname."$idquotes\";\n"); 
}

for($a=1;;$a++)
{
	$vf = "FIELD" . $a;
	if(empty(${$vf}[$table])) break;
	$vtype = "TYPE" . $a;
	$vhtype = "HTYPE" . $a;
	$vmustdef = "MUSTDEFINE" . $a;
	$noneditable = "NONEDITABLE" . $a;
	$plt = "PLT" . $a;
	$plid = "PLID" . $a;
	$plnv = "PLNV" . $a;
	if(${$noneditable}[$table]!="on" 
	    && ${$vhtype}[$table]!="child_array")
	{
if($permissions){
    fputs($f,"if(\$perm_field->".${$vf}[$table].">=2){\n");
}
	    if (${$vhtype}[$table] == "checkbox")
	    {
		fputs($f,"	if(strlen(\$".${$vf}[$table]."))\n");
		fputs($f,"		next(\${\$table_name.\"_".${$vf}[$table]."_arr\"});\n");
		fputs($f,"	\$".${$vf}[$table]."=key(\${\$table_name.\"_".${$vf}[$table]."_arr\"});\n");
	    }else if (${$vhtype}[$table] == "plistdb")
	    {
fputs($f,"if(!empty(\$".${$vf}[$table]."_inputfield))\n");
fputs($f,"{\n");
fputs($f,"	\$val=\$".${$vf}[$table]."_inputfield;\n");
fputs($f,"	\$sql_string=\"SELECT * FROM ".${$plt}[$table]." WHERE ".${$plnv}[$table]."='\".trim(\$val).\"'\";\n");
fputs($f,"	\$ress=SQL_query(\$sql_string,\$f);\n");
fputs($f,"	if(\$tmprow=SQL_fetch_object(\$ress,0))\n");
fputs($f,"  	{\n");
fputs($f,"  		\$".${$vf}[$table]."=\$tmprow->".${$plid}[$table].";\n");
fputs($f,"  	}else{\n");
fputs($f,"		\$if_fields=\"".${$plnv}[$table]."\";\n");
fputs($f,"		\$if_values=\"'\".trim(\$val).\"'\";\n");
fputs($f,"		if(\$auto_increment)\$sql_string=\"INSERT INTO ".${$plt}[$table]." (\$if_fields) VALUES (\$if_values)\";\n");
fputs($f,"		else \$sql_string=\"INSERT INTO  ".${$plt}[$table]." (".${$plid}[$table].",\$if_fields) SELECT VALUE(MAX(".${$plid}[$table]."),0)+1,\$if_values FROM ".${$plt}[$table]."\";\n");
fputs($f,"		\$resp=SQL_query(\$sql_string,\$f);\n");
fputs($f,"		if(empty(\$resp))\$ok=0;\n");
fputs($f,"  		else\n");
fputs($f,"  		{\n");
fputs($f,"			\$para=SQL_get_inserted_id(\$f,\$resp,".${$plt}[$table].",".${$plid}[$table].");\n");
fputs($f,"			\$".${$vf}[$table]."=\$para;\n");
fputs($f,"  		}\n");
fputs($f,"  	}\n");
fputs($f,"}\n");
	    }else if (${$vhtype}[$table] == "image")
	    {
		fputs($f,"   if(\$".${$vf}[$table]."!=\"none\")\n");
		fputs($f,"   {\n");
		fputs($f,"   	if(\$func==\"save\")\n");
		fputs($f,"	{\n");
		fputs($f,"		\$sst = \"SELECT ".${$vf}[$table]." FROM \$table_name WHERE ".$nyckname[$table]."=$idquotes\$par$idquotes\";\n");
		fputs($f,"		\$result = SQL_query(\$sst,\$f);\n");
		fputs($f,"		if(empty(\$result)) echo SQL_error(\$f,\$sst).\"<BR>\";\n"); 
		fputs($f,"		\$tmprow=SQL_fetch_object(\$result,0);\n");
		fputs($f,"		\$tmp_img_file = \$tmprow->".${$vf}[$table].";\n");
		fputs($f,"		if(!empty(\$tmp_img_file))\n");
		fputs($f,"		{\n");
		fputs($f,"			unlink(\$images_dir.\$SEPARATOR.\$tmp_img_file);\n");
		fputs($f,"			unlink(\$images_small_dir.\$SEPARATOR.\$tmp_img_file);\n");
		fputs($f,"		}\n");
		fputs($f,"	}\n");
		fputs($f,"	\$".${$vf}[$table]."=put_image(\$".${$vf}[$table].",\$".${$vf}[$table]."_name,\$".${$vf}[$table]."_type);\n");
		fputs($f,"   }\n");
		fputs($f,"   else \$".${$vf}[$table]."=\"\";\n");
	    }else{
		fputs($f,"	\$".${$vf}[$table]."=chop(\$".${$vf}[$table].");\n");
		if(${$vmustdef}[$table] == "on")
		{
		    fputs($f,"	if (\$" . ${$vf}[$table] . "==\"\"){\n");
		    fputs($f,"		\$ok=0;\$bad_str.=\",".${$vf}[$table]."\";\n");
		    fputs($f,"	}\n");
		}
	    }	
	    fputs($f,"	if((\$".${$vf}[$table]."!=\$".${$vf}[$table]."_old)||\$func==\"storenew\")\n");
	    fputs($f,"	{\n");
	    if (${$vtype}[$table] == "int" || 
		${$vtype}[$table]=="float" || 
		${$vtype}[$table]=="decimal" ) 
	    {
		fputs($f,"		if(empty(\$".${$vf}[$table]."))\$".${$vf}[$table]."=0;\n");
		$numquotes="";
	    }else $numquotes="'";

	    if (${$vhtype}[$table] == "image") 
		fputs($f,"		if(!empty(\$".${$vf}[$table]."))\n"); 
	    fputs($f,"		{\$fields.=\",".${$vf}[$table]."\";\n"); 
	    fputs($f,"		\$values.=\",$numquotes\$".${$vf}[$table]."$numquotes\";\n"); 
	    fputs($f,"		\$sql_upd.=\",".${$vf}[$table]."=$numquotes\$".${$vf}[$table]."$numquotes\";}\n");
	    fputs($f,"	}\n");
if($permissions){
    fputs($f,"} # permission INSERT for ".${$vf}[$table]."\n");
}
	}
}
fputs($f,"	\$bad_str=substr(\$bad_str,1,strlen(\$bad_str)-1);\n"); 
fputs($f,"	\$fields=substr(\$fields,1,strlen(\$fields)-1);\n"); 
fputs($f,"	\$values=substr(\$values,1,strlen(\$values)-1);\n"); 
fputs($f,"	if(\$ok){\n");
fputs($f,"		if(\$func==\"storenew\")\n");
fputs($f,"		{\n");
fputs($f,"			if(\$auto_increment)\$sql_string=\"INSERT INTO \$table_name_for_update (\$fields) VALUES (\$values)\";\n");
fputs($f,"			else \$sql_string=\"INSERT INTO \$table_name_for_update (".$nyckname[$table].",\$fields) SELECT VALUE(MAX($nyckname[$table]),0)+1,\$values FROM \$table_name\";\n");
fputs($f,"		}else{\n");
fputs($f,"			if(!empty(\$sql_upd))\n");
fputs($f,"			{\n");
fputs($f,"				\$sql_upd=substr(\$sql_upd,1,strlen(\$sql_upd)-1);\n"); 
fputs($f,"				\$sql_string=\"UPDATE \$table_name_for_update SET \".\$sql_upd.\" WHERE ".$nyckname[$table]."=$idquotes\$par$idquotes \";\n");
fputs($f,"			}else \$sql_string=\"\";\n");
fputs($f,"		}\n");
fputs($f,"		if(!empty(\$sql_string))\$result=SQL_query(\$sql_string,\$f);\n");
fputs($f,"		if(!empty(\$result)||empty(\$sql_string))\n");
fputs($f,"		{\n");
fputs($f,"			if(\$func==\"storenew\")\$par=SQL_get_inserted_id(\$f,\$result,\$table_name_for_update,".$nyckname[$table].");\n");

for($a=1;;$a++)
{
	$vf = "FIELD" . $a;
	if(${$vf}[$table] =="")break;
	$vhtype = "HTYPE" . $a;
	$noneditable = "NONEDITABLE" . $a;
	$catable = "CATABLE$a";
	$cafieldid = "CAFIELDID$a";
	$cafieldtop = "CAFIELDTOP$a";
	$cafieldarray = "CAFIELDARRAY$a";
	$plt = "PLT" . $a;
	$plid = "PLID" . $a;
	$plnv = "PLNV" . $a;
    if(${$noneditable}[$table]!="on" && ${$vhtype}[$table]=="child_array")
    {
if($permissions){
    fputs($f,"if(\$perm_field->".${$vf}[$table].">=2){\n");
}
fputs($f,"\$val=substr(\$".${$vf}[$table]."_old,1,strlen(\$".${$vf}[$table]."_old)-2);\n");
fputs($f,"if(\$func==\"save\" && !empty(\$val))\n");
fputs($f,"{\n");
fputs($f,"	\$sql_string=\"DELETE FROM ".${$catable}[$table]." WHERE ".${$cafieldtop}[$table]."=$idquotes\$par$idquotes\";\n");
fputs($f,"	\$resd=SQL_query(\$sql_string,\$f);\n");
fputs($f,"	if(empty(\$resd))\$ok=0;\n");
fputs($f,"}\n");
fputs($f,"if(!is_array(\$".${$vf}[$table]."))if(!empty(\$".${$vf}[$table]."))\$".${$vf}[$table]."=explode(\",\",\$".${$vf}[$table].");\n");
fputs($f,"if(!empty(\$".${$vf}[$table]."_inputfield))\$tmp_arr=explode(\$separ_array,\$".${$vf}[$table]."_inputfield);\n");
fputs($f,"else unset(\$tmp_arr);\n");
fputs($f,"if(count(\$tmp_arr)&&\$ok){\n");
fputs($f,"  for (\$i=0;(\$i<count(\$tmp_arr))&&\$ok;\$i++)\n");
fputs($f,"  {\n");
fputs($f,"	\$val=\$tmp_arr[\$i];\n");
fputs($f,"	\$sql_string=\"SELECT * FROM ".${$plt}[$table]." WHERE ".${$plnv}[$table]."='\".trim(\$val).\"'\";\n");
fputs($f,"	\$ress=SQL_query(\$sql_string,\$f);\n");
fputs($f,"	if(\$tmprow=SQL_fetch_object(\$ress,0))\n");
fputs($f,"  	{\n");
fputs($f,"  		\$".${$vf}[$table]."[]=\$tmprow->".${$plid}[$table].";\n");
fputs($f,"  	}else{\n");
fputs($f,"		\$if_fields=\"".${$plnv}[$table]."\";\n");
fputs($f,"		\$if_values=\"'\".trim(\$val).\"'\";\n");
fputs($f,"		if(\$auto_increment)\$sql_string=\"INSERT INTO ".${$plt}[$table]." (\$if_fields) VALUES (\$if_values)\";\n");
fputs($f,"		else \$sql_string=\"INSERT INTO  ".${$plt}[$table]." (".${$plid}[$table].",\$if_fields) SELECT VALUE(MAX(".${$plid}[$table]."),0)+1,\$if_values FROM ".${$plt}[$table]."\";\n");
fputs($f,"		\$resp=SQL_query(\$sql_string,\$f);\n");
fputs($f,"		if(empty(\$resp))\$ok=0;\n");
fputs($f,"  		else\n");
fputs($f,"  		{\n");
fputs($f,"			\$para=SQL_get_inserted_id(\$f,\$resp,".${$plt}[$table].",".${$plid}[$table].");\n");
fputs($f,"			\$".${$vf}[$table]."[]=\$para;\n");
fputs($f,"  		}\n");
fputs($f,"  	}\n");
fputs($f,"  }\n");
fputs($f,"}\n");
fputs($f,"if(count(\$".${$vf}[$table].")&&\$ok){\n");
fputs($f,"  for(\$i=0;(\$i<count(\$".${$vf}[$table]."))&&\$ok;\$i++){\n");
fputs($f,"	\$val=\$".${$vf}[$table]."[\$i];\n");
fputs($f,"	\$fields=\"".${$cafieldtop}[$table].",".${$cafieldarray}[$table]."\";\n");
fputs($f,"	\$values=\"'\$par',\$val\";\n");
fputs($f,"	if(\$auto_increment)\$sql_string=\"INSERT INTO ".${$catable}[$table]." (\$fields) VALUES (\$values)\";\n");
fputs($f,"	else \$sql_string=\"INSERT INTO  ".${$catable}[$table]." (".${$cafieldid}[$table].",\$fields) SELECT VALUE(MAX(".${$cafieldid}[$table]."),0)+1,\$values FROM ".${$catable}[$table]."\";\n");
fputs($f,"	\$resc=SQL_query(\$sql_string,\$f);\n");
fputs($f,"	if(empty(\$resc))\$ok=0;\n");
fputs($f,"  }\n");
fputs($f,"}\n");
if($permissions){
    fputs($f,"} # permission INSERT for ".${$vf}[$table]."\n");
}
    }
}

fputs($f,"		}\n");
fputs($f,"	}\n");
fputs($f,"	if(\$ok)\n");
fputs($f,"	{\n");
fputs($f,"		if(\$transaction)SQL_query(\"$transaction_commit\",\$f);\n");
#fputs($f,"		sleep(10);\n");
fputs($f,"	   	callback(\"\$scriptname?\$sess_id&func=detail&\$global_s_vars".$link_to_parent."&start=0&\$global_vars&table_name=\$table_name&par=\".url_encode(\$par));\n");
if($db_type=="Interbase")fputs($f,"		\$only_full_list=1;\n"); //For Interbase and transactions
fputs($f,"	}else{\n");
fputs($f,"		if(!empty(\$sql_string))echo SQL_error(\$f,\$sql_string).\"<BR>\";\n"); 
fputs($f,"		if(\$transaction)SQL_query(\"$transaction_rollback\",\$f);\n");
fputs($f,"		if(\$func==\"storenew\")\$func=\"new\";\n");
fputs($f,"		else \$func=\"edit\";\n");
fputs($f,"		\$prev=1;\n");
fputs($f,"	}\n");

if($permissions){
fputs($f,"} # permissions\n");
}
fputs($f,"} # Store New; Save edited\n");

fputs($f,"if(\$func!=\"erase\" && \$func!=\"storenew\" && \$func!=\"save\"){\n");
fputs($f,"	if(!empty(\$style_sheet))include \$path.\"\$style_sheet\";\n");
fputs($f,"	echo \"<SCRIPT LANGUAGE=\\\"JavaScript\\\" SRC=\\\"\".\$INCDIR.\$SEPARATOR.\"phpgem.inc.js\\\"></SCRIPT>\";\n");
fputs($f,"}\n");

fputs($f,"\n /********** Menu *****".$table_title[$table]."*****************************/\n\n");

fputs($f,"\nif(!\$only_full_list)\n{\n");

fputs($f,"echo \"</HEAD>\\n\$body_tag\\n\";\n");
fputs($f,"echo print_uri();\n");
fputs($f,"\$top_menu=\"\$table_tr_start\";\n");

fputs($f,"\$sst = \"SELECT COUNT(*) $sql_count_add FROM \$table_name \".(\$sql_search?\"WHERE \":\"\").\"\$sql_search\";\n");
fputs($f,"if(empty(\$found))\n");
fputs($f,"{\n");
fputs($f,"	\$result = SQL_query(\$sst,\$f);\n");
fputs($f,"	if(empty(\$result)) echo SQL_error(\$f,\$sst).\"<BR>\";\n"); 
fputs($f,"	\$tmprow=SQL_fetch_object(\$result,0);\n");
fputs($f,"	\$found = \$tmprow->".$sql_count_cnt.";\n");
fputs($f,"}\n");
fputs($f,"if (empty(\$start)) \$start=0;\n");
fputs($f,"if (\$start>\$found) \$start=\$found;\n");
#fputs($f,"echo \$global_vars.\"<BR>\".\$func.\"<BR>\".\$selectfield.\"<BR>\";\n");
#fputs($f,"echo \"f: \$found s: \$start l: \$limit <BR>\";\n");

fputs($f,"\$links = \"func=\$func&table_name=\$table_name&\$global_vars&\$global_s_vars".$link_to_parent."\";\n");
fputs($f,"if(\$func==\"imagedetail\")\$links.=\"&view_mode=\$view_mode&img_file=\".url_encode(\$img_file);\n");
fputs($f,"\$links.=\"&par=\".url_encode(\$par);\n\n");
fputs($f,"\$link = \"\$scriptname?\$sess_id&\".\$links;\n");

fputs($f,"if (empty(\$limit)){\$p_s=0;\$p_e=0;}\n");
fputs($f,"else{\n");
fputs($f,"	\$p_s = (\$start>0);\n");
fputs($f,"	\$p_e = (\$start+\$limit<\$found);\n");
fputs($f,"}\n");

fputs($f,"if (\$func == \"lista\" || \$func == \"search\" /*|| \$func == \"detail\"*/) {\n");
#fputs($f,"	if (\$func == \"detail\")\$link.=\"par=\".\n");

fputs($f,"   if (\$p_s || \$p_e || \$limit==0){\n");
fputs($f,"	\$top_menu.=\"\$table_td_menu_start\";\n");
fputs($f,"     if (\$limit){\n");
fputs($f,"	if (\$p_s) \$a_s=1; else \$a_s=0;\n");
fputs($f,"	\$top_menu.=print_link(\$link.\"&found=\$found&start=0\",\"$NLSListStart\",\$link_menu_type,\$a_s,\$BListStart,\"$NLSListStart\").\" \\n\";\n");
fputs($f,"	\$top_menu.=print_link(\$link.\"&found=\$found&start=\".max(\$start-\$limit,0),\"<<< \$limit\",\$link_menu_type,\$a_s,\$BPreviousM,\"<<<$NLSPrevious \$limit\").\" \\n\";\n");
fputs($f,"	\$top_menu.=print_link(\$link.\"&found=\$found&start=\".max(\$start-1,0),\"<\",\$link_menu_type,\$a_s,\$BPrevious,\"<$NLSPrevious\").\" \\n\";\n\n");

fputs($f,"	if (\$p_e) \$a_e=1; else \$a_e=0;\n");
fputs($f,"	\$top_menu.=print_link(\$link.\"&found=\$found&start=\".(\$start+1),\">\",\$link_menu_type,\$a_e,\$BNext,\">$NLSNext\").\" \\n\";\n");
fputs($f,"	\$top_menu.=print_link(\$link.\"&found=\$found&start=\".min(\$start+\$limit,\$found-\$limit),\">>> \".min(\$found-\$start+\$limit,\$limit),\$link_menu_type,\$a_e,\$BNextM,\">>>$NLSNext \".min(\$found-\$start+\$limit,\$limit)).\" \\n\";\n");
fputs($f,"	\$top_menu.=print_link(\$link.\"&found=\$found&start=\".(\$found-\$limit),\"$NLSListEnd\",\$link_menu_type,\$a_e,\$BListEnd,\"$NLSListEnd\").\"\\n\";\n\n");
fputs($f,"     }\n");

fputs($f,"	if(\$limit<\$found)\$top_menu.=print_link(\$link.\"&found=\$found&start=\$start&limit=\".(\$limit?0:\"\"),(\$limit?\"$NLSLimit0\":\"$NLSLimit\"),\$link_menu_type,1,(\$limit?\$BLimit0:\$BLimit));\n");
fputs($f,"	\$top_menu.=\" \$table_td_end\";\n");
fputs($f,"   }\n");
fputs($f,"}\n");

fputs($f,"if(\$func==\"edit\"||\$func==\"duplicate\"||\$func==\"warnerase\")\n");
fputs($f,"{\n");
fputs($f,"	\$top_menu.=\"\$table_td_menu_start\".print_link(\$link.\"&func=detail\",\"$NLSUP\",\$link_menu_type,1,\$BUP).\"\$table_td_end\";\n");
/*fputs($f,"}else if(\$func==\"detail\"||\$func==\"new\"||\$func==\"searchform\")\n");
fputs($f,"{\n");
fputs($f,"	\$top_menu.=\"\$table_td_menu_start\".print_link(\$link.\"&found=\$found&start=\$start&func=\$forward_func\",\"$NLSUP\",\$link_menu_type,1,\$BUP).\"\$table_td_end\";\n");
fputs($f,"}else if(\$func==\"search\")\n");
fputs($f,"{\n");
fputs($f,"	\$top_menu.=\"\$table_td_menu_start\".print_link(\$link.\"&found=\$found&start=\$start&func=lista\",\"$NLSUP\",\$link_menu_type,1,\$BUP).\"\$table_td_end\";\n");
*/fputs($f,"}else{\n");
if($level_current>0){
    fputs($f,"	\$top_menu.=\"\$table_td_menu_start\".print_link(\$module[\"".$top_table[$table]."\"].\"?\$sess_id&func=detail".$link_to_parent."&table_name=".$top_table[$table]."&\$global_vars&par=\$".$top_nyckname."\",\"$NLSUP\",\$link_menu_type,1,\$BUP).\"\$table_td_end\";\n\n");
}
fputs($f,"}\n");

fputs($f,"if (\$func!=\"search\" && !empty(\$whichfield)) {
    \$top_menu.=\"\$table_td_menu_start\".print_link(\$link.\"&func=search\",\"$NLSListSearch\",\$link_menu_type,1,\$BListSearch).\"\$table_td_end\";
}\n");

fputs($f,"if (\$func!=\"lista\") {
    if(empty(\$whichfield)) \$f_str=\"&found=\$found&start=\$start&\";
    else \$f_str=\"\";
    \$top_menu.=\"\$table_td_menu_start\".print_link(\$link.\"&func=lista\".\$f_str,\"$NLSListAll\",\$link_menu_type,1,\$BListAll).\"\$table_td_end\";
}\n");

fputs($f,"\$top_menu.=\"\$table_td_menu_start\".print_link(\$link.\"&found=\$found&start=\$start&func=searchform\",\"$NLSSearch\",\$link_menu_type,1,\$BSearch).\"\$table_td_end\";\n");
if($permissions){
fputs($f,"if(\$perm_table>=2){\n");
}
#fputs($f,"if(\$func!=\"lista\"&&func!=\"search\")\n");
fputs($f,"	\$top_menu.=\"\$table_td_menu_start\".print_link(\$link.\"&found=\$found&start=\$start&func=new\",\"$NLSNew\",\$link_menu_type,1,\$BNew).\"\$table_td_end\";\n");
if($permissions){
fputs($f,"} # permissions INSERT\n");
}
fputs($f,"\$top_menu.=\"\$table_td_menu_start\".print_link(\$module[\"list_tables\"].\"?\$sess_id&\$global_vars\",\"$NLSListOfTables\",\$link_menu_type,1,\$BListOfTables).\"\$table_td_end\";\n");
fputs($f,"\$top_menu.=\"\$table_td_menu_start\".print_link(\$link.\"&found=\$found&start=\$start&printable=\".(\$printable?0:1),(\$printable?\"$NLSPrintInactive\":\"$NLSPrint\"),\$link_menu_type,1,(\$printable?\$BPrintInactive:\$BPrint)).\"\$table_td_end\";\n");
fputs($f,"\$top_menu.=\"\$table_td_menu_start\".print_link(\$link.\"&found=\$found&start=\$start&demo_mode=\".(\$demo_mode>=$max_demo_mode?0:\$demo_mode+1),\"$NLSDemoSwitch\",\$link_menu_type,1,\$BSwitch).\"\$table_td_end\";\n");
fputs($f,"\$top_menu.=\"\$table_td_menu_start\".print_link(\$module[\"logout\"].\"?\$sess_id&\$links\",\"$NLSLogout\",\$link_menu_type,1,\$BLogout).\"\$table_td_end\";\n");
fputs($f,"\$top_menu.=\"\$table_tr_end\";\n");
fputs($f,"echo \"\$menu_table_tag\\n\$top_menu\\n\$end_table_tag\";\n");
fputs($f,"} # only_full_list\n\n");

fputs($f,"if(empty(\$limit)||\$limit==0) \$lim_str=\"\";\n");
fputs($f,"else \$lim_str=\"$lim_str\";\n");

fputs($f,"\n /********** Warn Delete *****".$table_title[$table]."***********************/\n");
fputs($f,"if (\$func == \"warnerase\"){\n");
if($permissions){
fputs($f,"if(\$perm_table>=4){\n");
}
if ($center) fputs($f,"	echo \"\$center_start\";\n");
fputs($f,"	echo \"<H1>$NLSAreYouSure</H1>\";\n");
fputs($f,"	echo \"\$standard_table_tag \$table_tr_start \$table_td_start\";\n");
fputs($f,"	echo print_link(\"\$scriptname?\$sess_id&func=erase".$link_to_parent."&\$global_vars&\$global_s_vars&table_name=\$table_name&par=\".url_encode(\$par),\"$NLSYes\",\$link_type);\n");
fputs($f,"	echo \"\$table_td_end \$table_td_start\";\n");
fputs($f,"	echo print_link(\"\$scriptname?\$sess_id&func=detail".$link_to_parent."&found=\$found&start=\$start&\$global_vars&\$global_s_vars&table_name=\$table_name&par=\".url_encode(\$par),\"$NLSNo\",\$link_type);\n");
#fputs($f,"	echo print_link(\"javascript:history.back()\",\"$NLSNo\",\$link_type);\n");
fputs($f,"	echo \"\$table_td_end \$table_tr_end \$end_table_tag\";\n");
if ($center) fputs($f,"	echo \"\$center_end\";\n");
if($permissions){
fputs($f,"} # permissions\n");
}
fputs($f,"} # Warn Delete\n");
fputs($f,"\n /****** Global SQL definitions ****".$table_title[$table]."*****************/\n");
$a = 0;
$list_fields="\$table_name.".$nyckname[$table];
$list_tables="\$table_name ";
$list_where="";
$list_fields_all=$list_fields;
$list_tables_all=$list_tables;
$list_where_all="";
$first_where=1;
fputs($f,"\$order_field=\$forder;\n");
for($a=1;;$a++)
{
	$vf = "FIELD" . $a;
	if(empty(${$vf}[$table]))break;
	$vtype = "TYPE" . $a;
	$vhtype = "HTYPE" . $a;
	$vvis = "VISIBLEFIRST" . $a;
	$vpre = "P" . $a;
	$plt = "PLT" . $a;
	$pltalias = "PLTALIAS" . $a;
	$plid = "PLID" . $a;
	$plnv = "PLNV" . $a;
	$plfieldalias = "PLFIELDALIAS" . $a;
	$vsqlf = "SQLFIELD" . $a;

	if(!empty(${"SQLQUERYSELECT".$a}[$table])) continue;
	if(!empty(${"ONLYVIS".$a}[$table])) continue;
	if(empty(${$vsqlf}[$table]))$field_name=${$vf}[$table];
	else $field_name=${$vsqlf}[$table];
	$visible=!strcmp(${$vvis}[$table],"on");
	if(${$vhtype}[$table] == "plistdb")
	{
	    if(${$pltalias}[$table]!=""){$plta=${$pltalias}[$table].".";}
	    else $plta=${$plt}[$table].".";
	    if(${$plfieldalias}[$table]!=""){$plfa=" AS ".${$plfieldalias}[$table];}
	    else $plfa="";
	    $list_fields_all.=",$plta".${$plnv}[$table].$plfa;
	    if($visible) $list_fields.=",$plta".${$plnv}[$table].$plfa;
	    $list_tables_add=${$plt}[$table]." ".${$pltalias}[$table];
	    if($first_where){$first_where=0;$sql_and="";}
	    else $sql_and=" AND ";
	    if(!strstr($list_tables_all,",".$list_tables_add))
	    {
		$list_where_all.=$sql_and.$plta.${$plid}[$table]."=\$table_name.".$field_name;
		$list_tables_all.=",".$list_tables_add;
	    }	
	    if(!strstr($list_tables,",".$list_tables_add) && $visible)
	    {
		$list_where.=$sql_and.$plta.${$plid}[$table]."=\$table_name.".$field_name;
		$list_tables.=",".$list_tables_add;
	    }
	    if(empty($plfa))$plo=${$plnv}[$table];
	    else $plo=${$plfieldalias}[$table];
	    fputs($f,"if(\$forder==\"$field_name\")\$order_field=$plo;\n");
	}
	else {
	    $list_fields_all.=",\$table_name.".$field_name;
	    if($visible)$list_fields.=",\$table_name.".$field_name;
	}    
}

if($first_where || !strlen($sql_level)){$first_where=0;$sql_and="";}
else $sql_and=" AND ";
$list_where.=$sql_and.$sql_level;
$list_where_all.=$sql_and.$sql_level;
if(strlen($list_where))$list_where=" WHERE ".$list_where;
if(strlen($list_where_all))$list_where_all=" WHERE ".$list_where_all;

$sql_select="SELECT $list_fields FROM $list_tables $list_where ";
$sql_select_all="SELECT $list_fields_all FROM $list_tables_all $list_where_all ";

if($list_where_all==""){$sql_add="WHERE ";}
else $sql_add=" AND ";

fputs($f,"if(\$sort_desc==1){\$sort_char=\">\";\$sql_desc=\"DESC\";}\n");
fputs($f,"else {\$sort_char=\"<\";\$sql_desc=\"\";}\n");
fputs($f,"\n /********** Search *****".$table_title[$table]."****************************/\n");
fputs($f,"if (\$func == \"search\"){\n");
fputs($f,"	\$sst = \"$sql_select_all $sql_add \$sql_search ORDER BY \$order_field \$sql_desc \$lim_str\";\n");
fputs($f,"} /* search */\n");

fputs($f,"\n /********** Show all *****".$table_title[$table]."*****************************/\n");
fputs($f,"if (\$func == \"lista\"){\n");
fputs($f,"	if(\$visible_all_fields)\n");
fputs($f,"		\$sst = \"$sql_select_all ORDER BY \$order_field \$sql_desc \$lim_str\";\n");
fputs($f,"	else	\$sst = \"$sql_select ORDER BY \$order_field \$sql_desc \$lim_str\";\n");
fputs($f,"} /* Show all */\n\n");

fputs($f,"if (\$func == \"lista\" || \$func == \"search\"){\n");
fputs($f,"	\$result = SQL_query(\$sst,\$f);\n");
fputs($f,"	if(empty(\$result)) echo SQL_error(\$f,\$sst).\"<BR>\";\n"); 

if($permissions){
fputs($f,"if(\$perm_table>=1){\n");
}

fputs($f,"	\$c1 = \"BGCOLOR=\\\"\$list_color1\\\" BACKGROUND=\\\"\$bg_image1\\\"\";\n");
fputs($f,"	\$c2 = \"BGCOLOR=\\\"\$list_color2\\\" BACKGROUND=\\\"\$bg_image2\\\"\";\n");
fputs($f,"	\$table_header=\"\";\n");
fputs($f,"	\$table_body=\"\";\n");
fputs($f,"	\$table_header.=\$table_tr_start;\n");
fputs($f,"	\$link = \"\$scriptname?\$sess_id&func=\$func".$link_to_parent."&start=0&found=\$found&\$global_vars&\$global_s_vars&table_name=\$table_name\";\n");
fputs($f,"	if(!\$printable)\n");
fputs($f,"	{\n");
fputs($f,"		\$table_header.=\"\$table_th_start\";\n");
if($visible_not_all)
{
fputs($f,"		{\n");
fputs($f,"		 if (\$visible_all_fields){\$nls_str=\"$NLSShowMainFields\"; \$b_str=\$BShowMainFields;}\n");
fputs($f,"		 else{\$nls_str=\"$NLSShowAllFields\"; \$b_str=\$BShowAllFields;}\n");
fputs($f,"		 \$table_header.=print_link(\$link.\"&start=\$start&visible_all_fields=\".!\$visible_all_fields,\"\$nls_str\",\$link_menu_type,1,\$b_str);\n");
fputs($f,"		}\n");
}
fputs($f,"		\$table_header.=\"\$table_th_end\";\n");
fputs($f,"	}\n");

$a = 0;
do {
	$a++;
	$vf = "FIELD" . $a;
	$vvis = "VISIBLEFIRST" . $a;
	$vnosort = "NOSORT" . $a;
	if(${$vf}[$table]=="")break;

	$field_name=${$vf}[$table];
	$visible=!strcmp(${$vvis}[$table],"on");
if($permissions){
    fputs($f,"if(\$perm_field->".$field_name.">=1){\n");
}
	if(!$visible) fputs($f,"		if(\$visible_all_fields)\n");
	fputs($f,"	{\$linka=\"&forder=$field_name\";\n");
	fputs($f,"	if(\$forder==\"$field_name\")\$linka.=\"&sort_desc=\".(!\$sort_desc);\n");
	fputs($f,"	else \$linka.=\"&sort_desc=0\";\n");
	if(${$vnosort}[$table]=="on")$active=0;else $active=1;
	fputs($f,"	\$table_header.=\"\$table_th_start\".print_link(\$link.\$linka,\$names[\$table_name][\"".$field_name."\"].((\$forder==\"$field_name\")?\" \$sort_char\":\"\"),\$link_header_table_type,$active);\n");
	fputs($f,"	\$table_header.=\"\$table_th_end\";}\n");
if($permissions){
    fputs($f,"} # permission SELECT for ".$field_name."\n");
}
}while (1);
if($permissions){
fputs($f,"if(\$perm_table>=2){\n");
}
fputs($f,"	if(!\$printable){\n");
fputs($f,"	 \$table_header.=\"\$table_th_start\".print_link(\"\$scriptname?\$sess_id&func=new".$link_to_parent."&found=\$found&start=\$start&\$global_vars&\$global_s_vars&table_name=\$table_name\",\"$NLSNew[0]\",\$link_menu_type,1,\$BNew,\"$NLSNew\").\"\$table_td_end\";\n");
fputs($f,"	}\n");
if($permissions){
fputs($f,"} # permissions INSERT\n");
}

fputs($f,"	\$table_header.=\"\$table_tr_end\";\n");

fputs($f,"	\$num=0;\n");
fputs($f,"	while(\$currval=SQL_fetch_object(\$result,\$num)){\n");
fputs($f,"		\$i=0;\$num++;\n");
fputs($f,"		if (\$c == \$c1) \$c = \$c2;\n");
fputs($f,"		else \$c = \$c1;\n");
fputs($f,"		\$table_body.=\"<TR \$c>\\n\";\n");
fputs($f,"		\$currpar=\$currval->".$nyckname[$table].";\n");
fputs($f,"		\$currlink=\"\$scriptname?\$sess_id&".$link_to_parent."&found=\$found&start=\$start&\$global_vars&\$global_s_vars&table_name=\$table_name&par=\".url_encode(\$currpar);\n");
fputs($f,"		\$currlink_to_parent=\"$link_to_parent\";\n");
if($permissions){
fputs($f,"if(\$perm_table>=3){\n");
}
fputs($f,"		if(!\$printable){\n");
fputs($f,"		  \$table_body.=\"\$table_td_start\".print_link(\"\$currlink&func=edit\",\"$NLSEdit[0]\",\$link_table_type,1,\$BEdit,\"$NLSEdit\").\"\$table_td_end\";\n");
fputs($f,"		}\n");
if($permissions){
fputs($f,"} # permissions UPDATE\n");
}
for($a=1;;$a++)
{
	$vf = "FIELD" . $a;
	if(${$vf}[$table]=="")break;
	$vtype = "TYPE" . $a;
	$vhtype = "HTYPE" . $a;
	$vfuncdisplay = "FUNCDISPLAY" . $a;
	$vvis = "VISIBLEFIRST" . $a;
	$vpre = "P" . $a;
	$plt = "PLT" . $a;
	$plid = "PLID" . $a;
	$plnv = "PLNV" . $a;
	$plfieldalias = "PLFIELDALIAS" . $a;
	$vsqlf = "SQLFIELD" . $a;
	$vsqlsel = "SQLQUERYSELECT" . $a;
	$valign = "ALIGN$a";
	if(empty(${$vsqlf}[$table]))$field_name=${$vf}[$table];
	else $field_name=${$vsqlf}[$table];

if($permissions){
    fputs($f,"if(\$perm_field->".${$vf}[$table].">=1){\n");
}
	$th_s_i="\\t\$table_td_start";
	$th_s_o="\$table_td_end";
	if(${$valign}[$table]){$th_s_i.="<div align=\\\"".${$valign}[$table]."\\\">";$th_s_o="</div>".$th_s_o;}
	if(${$vpre}[$table]=="on"){$th_s_i.="<PRE>";$th_s_o="</PRE>".$th_s_o;}

	if(${$vvis}[$table] != "on")
	    fputs($f,"	if(\$visible_all_fields)\n\t{\n");
	fputs($f,"		\$table_body.=\"$th_s_i\";\n");

	if (${$vhtype}[$table] == "plistdb") 
	{ 
		if(${$plfieldalias}[$table]!=""){$plfieldname=${$plfieldalias}[$table];}
		else $plfieldname=${$plnv}[$table];
		$field_name=$plfieldname;
	} 
	if(!empty(${$vsqlsel}[$table])) 
	{
		fputs($f,"		\$sstq=\"".${$vsqlsel}[$table]."\";\n");
		fputs($f,"		\$resultq = SQL_query(\$sstq,\$f);\n");
		fputs($f,"		if(empty(\$resultq)) echo SQL_error(\$f,\$sstq).\"<BR>\";\n"); 
		fputs($f,"		\$currvalq=SQL_fetch_object(\$resultq,0);\n");
		fputs($f,"		\$val=\$currvalq->".$field_name.";\n");
	}else fputs($f,"		\$val=\$currval->".$field_name.";\n");

	if(!empty(${$vfuncdisplay}[$table]))
	{ 
	    fputs($f,"		\$val = ".${$vfuncdisplay}[$table].";\n");
	}else if (${$vtype}[$table] == "date"){
	    fputs($f,"		\$val=displayDate(\$val);\n");
	}
	else if (${$vtype}[$table] == "datetime")
	{	
	    fputs($f,"		\$val=displayDate(substr(\$val,0,10)).substr(\$val,10);\n");
	}
	else if (${$vhtype}[$table] == "plist" || ${$vhtype}[$table] == "rlist"
	    || ${$vhtype}[$table] == "checkbox")
	{	
	    fputs($f,"		\$val=\${\$table_name.\"_".${$vf}[$table]."_arr\"}[\$val];\n");
	}else if (${$vhtype}[$table] == "image")
	{ 
	    fputs($f,"		\$val = displayimgsm(\$val,\"\$currlink&func=imagedetail&img_file=\".url_encode(\$val));\n");
	}else if(${$vf}[$table]!=$linkfield)
	{
	    fputs($f,"		\$val = print_sp(\$val);\n");
	}

	if(${$vf}[$table]==$linkfield)
	    fputs($f,"		\$table_body.=print_link(\"\$currlink&func=detail\",\$val,\$link_detail_table_type);\n");
	else fputs($f,"		\$table_body.=\$val;\n");

	fputs($f,"		\$table_body.=\"$th_s_o\";\n");

	if(${$vvis}[$table] != "on") fputs($f,"	}\n");
if($permissions){
    fputs($f,"} # permission SELECT for ".${$vf}[$table]."\n");
}
}
if($permissions){
fputs($f,"if(\$perm_table>=4){\n");
}
fputs($f,"		if(!\$printable){\n");
fputs($f,"		  \$table_body.=\"\$table_td_start\".print_link(\"\$currlink&func=warnerase\",\"$NLSDelete[0]\",\$link_table_type,1,\$BDelete,\"$NLSDelete\").\"\$table_td_end\";\n");
fputs($f,"		}\n");
if($permissions){
fputs($f,"} # permissions DELETE\n");
}

fputs($f,"		\$table_body.=\"\$table_tr_end\";\n");
fputs($f,"	}\n");
fputs($f,"	if(\$num>1)\$table_body.=ereg_replace(\"'i\",\"'image\",ereg_replace(\"im0i\",\"im0image\",ereg_replace(\"im1i\",\"im1image\",ereg_replace(\"name=\\\"i\",\"name=\\\"image\",\$table_header))));\n");

fputs($f,"if (\$func == \"search\"){\n");
fputs($f,"	echo \"<H3 ALIGN=center>$NLSSearchFor \".\$name_search;\n");
fputs($f,"	echo \" $NLSSearchReturned \$found $NLSSearchHits</H3>\\n\";\n");
fputs($f,"}\n");
fputs($f,"if (\$func == \"lista\"){\n");
fputs($f,"	if(!\$only_full_list)echo \"<H3 ALIGN=center>$NLSRecordsSortedBy \$order_str</H3>\";\n");
fputs($f,"}\n");

if ($center) fputs($f,"	echo \"\$center_start\";\n");
fputs($f,"	echo \"\$list_table_tag\$table_header\$table_body\$end_table_tag\";\n");
if ($center) fputs($f,"	echo \"\$center_end\";\n");


if($permissions){
fputs($f,"} # permissions\n");
}
fputs($f,"} /* Show Records */\n");

fputs($f,"\n /********** Show detail *****".$table_title[$table]."*********************/\n");
fputs($f,"if ((\$func == \"detail\") || (\$func == \"warnerase\")){\n");
if($permissions){
fputs($f,"if(\$perm_table>=1){\n");
}
fputs($f,"	\$sst=\"$sql_select_all $sql_add \$table_name.".$nyckname[$table]."=$idquotes\$par$idquotes\";\n");
fputs($f,"	\$result = SQL_query(\$sst,\$f);\n");
fputs($f,"	if(empty(\$result)) echo SQL_error(\$f,\$sst).\"<BR>\";\n"); 
fputs($f,"	\$rowa = SQL_fetch_object(\$result,0);\n");
if ($center) fputs($f,"	echo \"\$center_start\";\n");
fputs($f,"	\$currpar=\$par;\n");
fputs($f,"	\$currlink=\"\$scriptname?\$sess_id&".$link_to_parent."&found=\$found&start=\$start&\$global_vars&\$global_s_vars&table_name=\$table_name&par=\".url_encode(\$currpar);\n");
fputs($f,"	\$currlink_to_parent=\"$link_to_parent\";\n");
fputs($f,"	echo \"<H2 ALIGN=center>\".\$rowa->".$linkfield.".\"</H2>\";\n");
#fputs($f,"	echo \"<H2 ALIGN=center>$NLSID: \$currpar</H2>\";\n");
fputs($f,"	echo \"\$standard_table_tag\";\n");

for($a=1;;$a++)
{
	$vf = "FIELD" . $a;
	if(empty(${$vf}[$table])) break;
	$vtype = "TYPE" . $a;
	$vprint = "PRINTNOTNULL" . $a;
	$vfuncdisplay = "FUNCDISPLAY" . $a;
	$vhtype = "HTYPE" . $a;
	$plt = "PLT" . $a;
	$plid = "PLID" . $a;
	$plnv = "PLNV" . $a;
	$plfieldalias = "PLFIELDALIAS" . $a;
	$vsqlsel = "SQLQUERYSELECT" . $a;
	$vsqlf = "SQLFIELD" . $a;
	if(empty(${$vsqlf}[$table]))$field_name=${$vf}[$table];
	else $field_name=${$vsqlf}[$table];

if($permissions){
    fputs($f,"if(\$perm_field->".${$vf}[$table].">=1){\n");
}
	if (${$vhtype}[$table] == "plistdb")
	{
		if(${$plfieldalias}[$table]!=""){$plfieldname=${$plfieldalias}[$table];}
		else $plfieldname=${$plnv}[$table];
		$field_name=$plfieldname;
	}
	if(!empty(${$vsqlsel}[$table])) 
	{
		fputs($f,"		\$sstq=\"".${$vsqlsel}[$table]."\";\n");
		fputs($f,"		\$resultq = SQL_query(\$sstq,\$f);\n");
		fputs($f,"		if(empty(\$resultq)) echo SQL_error(\$f,\$sstq).\"<BR>\";\n"); 
		fputs($f,"		\$rowq=SQL_fetch_object(\$resultq,0);\n");
		fputs($f,"		\$val=\$rowq->".$field_name.";\n");
	}else fputs($f,"	\$val = \$rowa->".$field_name.";\n");
	    if(!empty(${$vfuncdisplay}[$table]))
	    { 
		fputs($f,"	\$val = ".${$vfuncdisplay}[$table].";\n");
	    }else if (${$vtype}[$table] == "date")
	    { 
		fputs($f,"	\$val = displayDate(\$val);\n");
	    }else if (${$vtype}[$table] == "datetime")
	    {	
		fputs($f,"	\$val = displayDate(substr(\$val,0,10)).substr(\$val,10);\n");
	    }else if (${$vhtype}[$table] == "plist" || ${$vhtype}[$table] == "rlist"
		|| ${$vhtype}[$table] == "checkbox")
	    {	
		fputs($f,"	\$val = \${\$table_name.\"_".${$vf}[$table]."_arr\"}[\$val];\n");
	    }else if (${$vhtype}[$table] == "blob")
	    { 
		fputs($f,"	if(!empty(\$val))\$val = \"<PRE>\".print_html(\$val).\"</PRE>\";\n");
	    }else if (${$vhtype}[$table] == "image")
	    { 
		fputs($f,"	\$val = displayimgsm(\$val,\"\$currlink&func=imagedetail&img_file=\".url_encode(\$val));\n");
	    }else if (${$vhtype}[$table] == "str")
	    {
		fputs($f,"	\$val = print_sp(\$val);\n");
	    }    
	if(${$vprint}[$table] == "on")
	{
	    fputs($f,"	if(!(empty(\$val)||\$val==\"&nbsp;\"))\n");
	    fputs($f,"	{\n");
	}
	fputs($f,"		echo \"\$table_tr_start\$table_td_start<B>\".\$names[\$table_name][\"".${$vf}[$table]."\"].\": </B> \$table_td_end \";\n");
	fputs($f,"		echo \"\$table_td_start\";\n");
	fputs($f,"		echo \$val;\n");
	fputs($f,"		echo \"\$table_td_end \$table_tr_end\";\n");
	if(${$vprint}[$table] == "on")
	{
	    fputs($f,"	}\n");
	}

if($permissions){
    fputs($f,"} # permission SELECT for ".${$vf}[$table]."\n");
}
}

fputs($f,"	echo \"\$end_table_tag\";\n");
fputs($f,"	if (\$func == \"detail\"){\n");
fputs($f,"   if (!\$printable){\n");
fputs($f,"	echo \"\$standard_table_tag \$table_tr_start \$table_td_start\";\n");
if($permissions){
fputs($f,"if(\$perm_table>=3){\n");
}
fputs($f,"	echo print_link(\"\$currlink&func=edit\",\"$NLSEdit\",\$link_type);\n");
if($permissions){
fputs($f,"} # permissions UPDATE\n");
fputs($f,"if(\$perm_table>=4){\n");
}
fputs($f,"	echo \"\$table_td_end \$table_td_start\";\n");
fputs($f,"	echo print_link(\"\$currlink&func=warnerase\",\"$NLSDelete\",\$link_type);\n");
if($permissions){
fputs($f,"} # permissions DELETE\n");
fputs($f,"if(\$perm_table>=2){\n");
}
fputs($f,"	echo \"\$table_td_end \$table_td_start\";\n");
fputs($f,"	echo print_link(\"\$currlink&func=duplicate\",\"$NLSDuplicate\",\$link_type);\n");
if($permissions){
fputs($f,"} # permissions Duplicate\n");
}
fputs($f,"	echo \"\$table_td_end \$table_tr_end \$end_table_tag\";\n");
fputs($f,"   }\n");
##fputs($f,"	while(list($fname,$file)=each(\$child_table[\$table_name]))\n");
##fputs($f,"	{\n");
##    fputs($file,"$php_end\n");
##    fclose($file);
##}

if(!empty($link_to_child))
{
    fputs($f,"if (empty(\$show_child_tables)) \$show_child_tables=0;
	if (\$show_child_tables){ \$nls_str=\"$NLSCloseChildTables\";\$b_str=\$BCloseChildTables;}
	else{ \$nls_str=\"$NLSShowChildTables\"; \$b_str=\$BShowChildTables;}
	echo print_link(\"\$currlink&func=detail&show_child_tables=\".!\$show_child_tables,\"\$nls_str\",\$link_menu_type,1,\$b_str);\n");

    fputs($f,"	\$table_name_old=\"\$table_name\";\n");
    fputs($f,"	\$func=\"lista\";\n");
    fputs($f,"	\$limit=0;\$lim_str=\"\";\n");
    fputs($f,"	\$only_full_list=1;\n");
    fputs($f,"	\$".$nyckname[$table]."=\$currpar;\n");
    for($i=1;$i<$tnum;$i++)
    {
	if($level[$i] == ($level_current+1) && $top_table[$i] == $tablename[$table])
	{
	    $link_to_child="print_link(\$module[\"".$tablename[$i]."\"].\"?\$sess_id&func=lista&\$global_vars$link_to_parent&".$nyckname[$table]."=\".url_encode(\$par).\"&table_name=".$tablename[$i]."\",\$names[\"".$tablename[$i]."\"][0],\$link_menu_type)";
	    fputs($f,"	echo \"<HR>\$center_start\".".$link_to_child.".\"\$center_end<BR>\";\n");
	    fputs($f,"	if(\$show_child_tables)\n\t{\n");
	    fputs($f,"		\$table_name=\"".$tablename[$i]."\";\n");
	    fputs($f,"		include(\$path.\$module[\"".$tablename[$i]."\"]);\n");
	    fputs($f,"	}\n");
	}
    }
    fputs($f,"	\$table_name=\$table_name_old;\n");
    fputs($f,"	\$only_full_list=0;\n");
    fputs($f,"	\$func=\"detail\";\n");
}
fputs($f,"	}\n");
if ($center) fputs($f,"	echo \"\$center_end\";\n");
if($permissions){
fputs($f,"} # permissions\n");
}
fputs($f,"} /* Show detail */\n");

fputs($f,"\n /********** Show image detail *****".$table_title[$table]."***************/\n");
fputs($f,"if (\$func == \"imagedetail\"){\n");
if($permissions){
fputs($f,"if(\$perm_table>=1){\n");
}

fputs($f,"	if(empty(\$view_mode))\$view_mode=\"screenh\";\n");
fputs($f,"	\$link=\"\$scriptname?\$sess_id&found=\$found&start=\$start".$link_to_parent."&\$global_vars&\$global_s_vars&table_name=\$table_name&par=\".url_encode(\$par);\n");
fputs($f,"	\$im_link_type=\$link_menu_type;\n");
fputs($f,"	\$float_table=\"\";\n");
fputs($f,"	\$float_table.=\"\$table_tr_start\";\n");
fputs($f,"	\$float_table.=\"\$table_td_menu_start\".print_link(\"\$link&func=detail\",\"$NLSUP\",\$im_link_type,1,\$BUP,\"\",1).\"\$table_td_end\";\n");
fputs($f,"	if(file_exists(\$path.\$images_dir.\$SEPARATOR.\$img_file))\n");
fputs($f,"	{\n");
fputs($f,"		\$link.=\"&func=imagedetail&img_file=\".url_encode(\$img_file);\n");
fputs($f,"		\$float_table.=\"\$table_td_menu_start\".print_link(\"\$link&view_mode=screenh\",\"$NLSScreen H\",\$im_link_type,1,\"\",\"\",1).\"\$table_td_end\";\n");
fputs($f,"		\$float_table.=\"\$table_td_menu_start\".print_link(\"\$link&view_mode=screenw\",\"$NLSScreen W\",\$im_link_type,1,\"\",\"\",1).\"\$table_td_end\";\n");
fputs($f,"		\$float_table.=\"\$table_td_menu_start\".print_link(\"\$link&view_mode=r4\",\"1:4\",\$im_link_type,1,\"\",\"\",1).\"\$table_td_end\";\n");
fputs($f,"		\$float_table.=\"\$table_td_menu_start\".print_link(\"\$link&view_mode=r3\",\"1:3\",\$im_link_type,1,\"\",\"\",1).\"\$table_td_end\";\n");
fputs($f,"		\$float_table.=\"\$table_td_menu_start\".print_link(\"\$link&view_mode=r2\",\"1:2\",\$im_link_type,1,\"\",\"\",1).\"\$table_td_end\";\n");
fputs($f,"		\$float_table.=\"\$table_td_menu_start\".print_link(\"\$link&view_mode=1\",\"1:1\",\$im_link_type,1,\"\",\"\",1).\"\$table_td_end\";\n");
fputs($f,"		\$float_table.=\"\$table_td_menu_start\".print_link(\"\$link&view_mode=2\",\"2:1\",\$im_link_type,1,\"\",\"\",1).\"\$table_td_end\";\n");
fputs($f,"		\$float_table.=\"\$table_td_menu_start\".print_link(\"\$link&view_mode=3\",\"3:1\",\$im_link_type,1,\"\",\"\",1).\"\$table_td_end\";\n");
fputs($f,"		\$float_table.=\"\$table_td_menu_start\".print_link(\"\$link&view_mode=4\",\"4:1\",\$im_link_type,1,\"\",\"\",1).\"\$table_td_end\";\n");
fputs($f,"		\$float_table.=\"\$table_tr_end\";\n");
fputs($f,"		echo \"<div id=\\\"imagemenu\\\" style=\\\"position:absolute;visibility:show;left:0px;  z-index:1\\\">\";\n");
fputs($f,"		echo \"\$float_menu_table_tag \$float_table \$end_table_tag\";\n");
fputs($f,"		echo \"</div>\";\n");
fputs($f,"		echo \"<BR><BR>\".displayimg(\$img_file,\$view_mode);\n");
fputs($f,"	}\n");

if($permissions){
fputs($f,"} # permissions\n");
}
fputs($f,"} /* Show image detail */\n");

fputs($f,"\n /********** New/Edit *****".$table_title[$table]."************************/\n");
fputs($f,"if ((\$func == \"new\") || (\$func == \"edit\") || (\$func == \"duplicate\")){\n");
if($permissions){
fputs($f,"if((\$perm_table>=2 && (\$func == \"new\" || \$func == \"duplicate\")) || (\$perm_table>=3 && \$func == \"edit\")){\n");
}
if ($center) fputs($f,"	echo \"\$center_start\";\n");
fputs($f,"	if ((\$func == \"edit\") || (\$func == \"duplicate\")){\n");
fputs($f,"	   if (!\$prev){\n");
fputs($f,"		\$sst=\"SELECT * FROM \$table_name WHERE ".$nyckname[$table]."=$idquotes\$par$idquotes\";\n");
fputs($f,"		\$result = SQL_query(\$sst,\$f);\n");
fputs($f,"		if(empty(\$result)) echo SQL_error(\$f,\$sst).\"<BR>\";\n"); 
fputs($f,"		\$rowa = SQL_fetch_object(\$result,0);\n");
for($a=1;;$a++)
{
	$vf = "FIELD" . $a;
	if(empty(${$vf}[$table]))break;
	$noneditable = "NONEDITABLE" . $a;
	$vhtype = "HTYPE" . $a;
	$catable = "CATABLE$a";
	$cafieldid = "CAFIELDID$a";
	$cafieldtop = "CAFIELDTOP$a";
	$cafieldarray = "CAFIELDARRAY$a";
	if(${$noneditable}[$table] != "on")
	{
	    if(${$vhtype}[$table]=="child_array")
	    {
		fputs($f,"		\$sst = \"SELECT ".${$cafieldarray}[$table]." FROM ".${$catable}[$table]." WHERE ".${$cafieldtop}[$table]."=$idquotes\$par$idquotes\";\n");
		fputs($f,"		\$res = SQL_query(\$sst,\$f);\n");
		fputs($f,"		if(empty(\$res)) echo SQL_error(\$f,\$sst).\"<BR>\";\n"); 
		fputs($f,"		\$".${$vf}[$table]."=SQL_fetch_col(\$res,\"".${$cafieldarray}[$table]."\");\n");
	    }
	    else fputs($f,"		\$".${$vf}[$table]."=\$rowa->".${$vf}[$table].";\n");
	}
}

fputs($f,"	   }\n");
fputs($f,"		echo \"<H2 ALIGN=center>\".((\$func==\"edit\")?\"$NLSEdit\":\"$NLSDuplicate\").\" \".\$rowa->".$linkfield.".\"</H2>\";\n");
fputs($f,"	}else{\n");
for($a=1;;$a++)
{
	$vf = "FIELD$a"; $vd = "D$a";
	if(empty(${$vf}[$table]))break;
	$noneditable = "NONEDITABLE" . $a;
	if(${$noneditable}[$table] != "on")
	{
	    fputs($f,"		if(!isset(\$".${$vf}[$table]."))\$".${$vf}[$table]."=\"".${$vd}[$table]."\";\n");
	}
}
fputs($f,"		echo \"<H2 ALIGN=center>$NLSNew</H2>\";\n");

fputs($f,"	}\n");
if($images[$table])$enc_type="ENCTYPE=\\\"multipart/form-data\\\"";
else $enc_type="";
fputs($f,"	if ((\$func == \"new\") || (\$func == \"duplicate\")){\n");
fputs($f,"		echo \"<FORM $enc_type ACTION=\\\"\$scriptname?\$sess_id&func=storenew".$link_to_parent."&\$global_vars&\$global_s_vars&table_name=\$table_name\\\" METHOD=POST>\";\n");
fputs($f,"	}else{\n");
fputs($f,"		echo \"<FORM $enc_type ACTION=\\\"\$scriptname?\$sess_id&func=save".$link_to_parent."&\$global_vars&\$global_s_vars&table_name=\$table_name&par=\".url_encode(\$par).\"\\\" METHOD=POST>\";\n");
fputs($f,"	}\n");
fputs($f,"	echo \"\$form_table_tag\";\n");

fputs($f,"	\$tabindex=1;\n");
if($tabindex[$table]) $tabind="tabindex=\\\"\".\$tabindex++.\"\\\"";
else $tabind="";

for($a=1;;$a++)
{
	$vf = "FIELD" . $a;
	if(${$vf}[$table]=="")break;
	$vhtype = "HTYPE" . $a;
	$vbcols = "BCOLS" . $a;
	$vbrows = "BROWS" . $a;
	$vbwrap = "WRAP" . $a;
	$vi = "I" . $a;
	$vm = "M" . $a;
	$plt = "PLT" . $a;
	$plid = "PLID" . $a;
	$plnv = "PLNV" . $a;
	$plno = "PLNO" . $a;
	$mustdef = "MUSTDEFINE" . $a;
	$noneditable = "NONEDITABLE" . $a;
	$plinputfield = "PLINPUTFIELD" . $a;
	$cainputfield = "CAINPUTFIELD" . $a;
    if(	${$noneditable}[$table] != "on")
    {
	if (${$mustdef}[$table] != "on"){$mustdefline = "";$optionaldefline = "$NLSOptional";}
	else 
	{
	    $mustdefline = "$NLSMustDefine ";
	    $optionaldefline = "";
	    fputs($f,"	if(strstr(\$bad_str,\"".${$vf}[$table]."\"))\$mustdefine=\"<BR>$NLSMustBeSpecified\";\n");
	    fputs($f,"	else \$mustdefine=\"\";\n");
	}    
if($permissions){
    fputs($f,"if(\$perm_field->".${$vf}[$table].">=2){\n");
}
	fputs($f,"	echo \"\$table_tr_start \$table_td_start\";\n");
	fputs($f,"	echo \"<B>$mustdefline\".\$names[\$table_name][\"".${$vf}[$table]."\"].\": $optionaldefline \$mustdefine</B>\";\n");
	fputs($f,"	echo \"\$table_td_end \$table_td_start\";\n");
	if (${$vhtype}[$table] == "plistdb") 
	{
		fputs($f,"	\$sst = \"SELECT * FROM ".${$plt}[$table]." ORDER BY ".${$plno}[$table]."\";\n");
		fputs($f,"	\$res = SQL_query(\$sst,\$f);\n");
		fputs($f,"	if(empty(\$res)) echo SQL_error(\$f,\$sst).\"<BR>\";\n"); 
		fputs($f,"	array2select(\"".${$vf}[$table]."\",SQL_fetch_cols(\$res,\"".${$plid}[$table]."\",\"".${$plnv}[$table]."\"),0,\",\".\$".${$vf}[$table].".\",\");\n");
		if(${$plinputfield}[$table]=="on")
		{
		    fputs($f,"	echo \"\$table_td_end \$table_tr_end\";\n");
		    fputs($f,"	echo \"\$table_tr_start \$table_td_start\";\n");
		    fputs($f,"	echo \"<B>$NLSOrNew \".\$names[\$table_name][\"".${$vf}[$table]."\"].\": </B>\";\n");
		    fputs($f,"	echo \"\$table_td_end \$table_td_start\";\n");
		    fputs($f,"	echo \"<INPUT NAME=".${$vf}[$table]."_inputfield SIZE=".${$vi}[$table]." MAXLENGTH=".${$vm}[$table]." VALUE=\\\"\".print_html(\$".${$vf}[$table]."_inputfield).\"\\\">\";\n");
		}
	}else if (${$vhtype}[$table] == "child_array") 
	{
		fputs($f,"	if(is_array(\$".${$vf}[$table]."))\$".${$vf}[$table]."=\",\".implode(\",\",\$".${$vf}[$table].").\",\";\n");
		fputs($f,"	\$sst = \"SELECT * FROM ".${$plt}[$table]." ORDER BY ".${$plno}[$table]."\";\n");
		fputs($f,"	\$res = SQL_query(\$sst,\$f);\n");
		fputs($f,"	if(empty(\$res)) echo SQL_error(\$f,\$sst).\"<BR>\";\n"); 
		fputs($f,"	array2select(\"".${$vf}[$table]."[]\",SQL_fetch_cols(\$res,\"".${$plid}[$table]."\",\"".${$plnv}[$table]."\"),".${"SELSIZE$a"}[$table].",\$".${$vf}[$table].");\n");
		if(${$cainputfield}[$table]=="on")
		{
		    fputs($f,"	echo \"\$table_td_end \$table_tr_end\";\n");
		    fputs($f,"	echo \"\$table_tr_start \$table_td_start\";\n");
		    fputs($f,"	echo \"<B>$NLSAndNew \".\$names[\$table_name][\"".${$vf}[$table]."\"].\": </B>\";\n");
		    fputs($f,"	echo \"\$table_td_end \$table_td_start\";\n");
		    fputs($f,"	echo \"<INPUT NAME=".${$vf}[$table]."_inputfield SIZE=".${$vi}[$table]." MAXLENGTH=".${$vm}[$table]." VALUE=\\\"\".print_html(\$".${$vf}[$table]."_inputfield).\"\\\">\";\n");
		}
	}else if (${$vhtype}[$table] == "str")
	{ 
		fputs($f,"	echo \"<INPUT $tabind NAME=".${$vf}[$table]." SIZE=".${$vi}[$table]." MAXLENGTH=".${$vm}[$table]." VALUE=\\\"\".print_html(\$".${$vf}[$table].").\"\\\">\";\n");
	}else if (${$vhtype}[$table] == "image")
	{ 
		fputs($f,"	echo \"<INPUT NAME=\\\"MAX_FILE_SIZE\\\" TYPE=\\\"hidden\\\" VALUE=\\\"20971520\\\">\";\n");
		fputs($f,"	echo \"<INPUT $tabind NAME=".${$vf}[$table]." SIZE=".${$vi}[$table]." MAXLENGTH=".${$vm}[$table]." TYPE=\\\"file\\\" VALUE=\\\"\".print_html($".${$vf}[$table].").\"\\\">\";\n");
	}else if (${$vhtype}[$table] == "blob") 
	{
		$textcols=${$vbcols}[$table];
		$textrows=${$vbrows}[$table];
		$textwrap=${$vbwrap}[$table];
		if($textwrap)$textwrap="WRAP=\\\"".$textwrap."\\\"";
		fputs($f,"	echo \"<TEXTAREA $tabind NAME=".${$vf}[$table]." COLS=$textcols ROWS=$textrows $textwrap>\".print_html($".${$vf}[$table].").\"</TEXTAREA>\";\n");
	}else if (${$vhtype}[$table] == "date")
	{
		fputs($f,"	echo dateSelection(\"".${$vf}[$table]."\",\$".${$vf}[$table].",\"".${"DATA$a"}[$table]."\");\n");
	}else if (${$vhtype}[$table] == "datetime")
	{
		fputs($f,"	echo dateSelection(\"".${$vf}[$table]."\",substr(\$".${$vf}[$table].",0,10),\"".${"DATA$a"}[$table]."\");\n");
		fputs($f,"	echo \"<INPUT $tabind NAME=".${$vf}[$table]."_time SIZE=".${$vi}[$table]." MAXLENGTH=".${$vm}[$table]." VALUE=\\\"\".substr(\$".${$vf}[$table].",11).\"\\\">\";\n");
	}else if (${$vhtype}[$table] == "time")
	{
		fputs($f,"	echo \"<INPUT $tabind NAME=".${$vf}[$table]." SIZE=".${$vi}[$table]." MAXLENGTH=".${$vm}[$table]." VALUE=\\\"$".${$vf}[$table]."\\\">\";\n");
	}else if (${$vhtype}[$table] == "rlist") 
	{
	    fputs($f,"	array2radio(\${\$table_name.\"_".${$vf}[$table]."_arr\"},\"".${$vf}[$table]."\",\$".${$vf}[$table].");\n");
	}else if (${$vhtype}[$table] == "plist") 
	{
	    fputs($f,"	array2select(\"".${$vf}[$table]."\",\${\$table_name.\"_".${$vf}[$table]."_arr\"},0,\",\".\$".${$vf}[$table].".\",\");\n");
	}else if (${$vhtype}[$table] == "checkbox") 
	{
	    fputs($f,"	mk_checkbox(\"".${$vf}[$table]."\",\$".${$vf}[$table].",key(\${\$table_name.\"_".${$vf}[$table]."_arr\"}));\n"); 
	}
	fputs($f,"	echo \"\$table_td_end \$table_tr_end\";\n");
	fputs($f,"	echo \"<INPUT TYPE=\\\"HIDDEN\\\" NAME=".${$vf}[$table]."_old VALUE=\\\"\".print_html(\$prev?\$".${$vf}[$table]."_old:\$".${$vf}[$table].").\"\\\">\";\n");
	if (${$mustdef}[$table] == "on") fputs($f,"	\$mustdefine=\"\";\n");
if($permissions){
    fputs($f,"} # permission UPDATE (INSERT New) for ".${$vf}[$table]."\n");
} 
    }
}


fputs($f,"	echo \"\$end_table_tag\";\n");
fputs($f,"	echo \"<INPUT TYPE=submit NAME=\\\"Save\\\" VALUE=\\\"$NLSSave\\\">&nbsp;<INPUT TYPE=reset VALUE=\\\"$NLSClearAll\\\">\";\n");
fputs($f,"	echo \"</FORM>\";\n");
if ($center) fputs($f,"	echo \"\$center_end\";\n");
if($permissions){
fputs($f,"} # permissions\n");
}
fputs($f,"} /* New/edit */\n");

fputs($f,"\n /********** Search form *****".$table_title[$table]."*****************/\n");
fputs($f,"if (\$func == \"searchform\"){\n");
if($permissions){
fputs($f,"if(\$perm_table>=1){\n");
}
if ($center) fputs($f,"	echo \"\$center_start\";\n");
fputs($f,"	echo \"\$form_table_tag\";\n");
fputs($f,"	echo \"<FORM METHOD=\\\"POST\\\" ACTION=\\\"\$scriptname?\$sess_id&func=search".$link_to_parent."&start=0&\$global_vars&table_name=\$table_name\\\">\\n\";\n");
for ($i = 1; ; $i++) {
	$vf = "FIELD" . $i;
	if (${$vf}[$table] == "")
		break;
	$vtype = "TYPE" . $i;
	$vhtype = "HTYPE" . $i;
	$fsrch = "SRCH$i";
	$vsrchmulti = "SRCHMULTI$i";
	$vi = "I" . $i;
	$vm = "M" . $i;
if($permissions){
    fputs($f,"if(\$perm_field->".${$vf}[$table].">=1){\n");
}
    if (${$fsrch}[$table] == "on")
    {
	fputs($f,"	echo \"\$table_tr_start \$table_td_start<B>\".\$names[\$table_name][\"".${$vf}[$table]."\"].\": </B>\$table_td_end\$table_td_start\";\n");
	fputs($f,"	mk_checkbox(\"whichfield[]\",\"".${$vf}[$table]."\",\"".${$vf}[$table]."\");\n");
	fputs($f,"	echo \"\$table_td_end\$table_td_start\";\n");
	if (${$vsrchmulti}[$table] == "on"){ $multi = ${"SELSIZE$i"}[$table];$multia="[]";}
	else{ $multi = 0;$multia="";}
	if (${$vhtype}[$table] == "plistdb")
	{
		$plt = "PLT" . $i;
		$plid = "PLID" . $i;
		$plnv = "PLNV" . $i;
		$plno = "PLNO" . $i;
		fputs($f,"	\$sst = \"SELECT * FROM ".${$plt}[$table]." ORDER BY ".${$plno}[$table]."\";\n");
		fputs($f,"	\$res = SQL_query(\$sst,\$f);\n");
		fputs($f,"	if(empty(\$res)) echo SQL_error(\$f,\$sst).\"<BR>\";\n"); 
		fputs($f,"	array2select(\"sv_".${$vf}[$table]."$multia\",SQL_fetch_cols(\$res,\"".${$plid}[$table]."\",\"".${$plnv}[$table]."\"),$multi,\"\");\n");
		fputs($f,"	\$searchfield=\"select\";\n");
	}else if (${$vhtype}[$table] == "date")
	{
		fputs($f,"	echo dateSelection(\"sv_".${$vf}[$table]."\",date(\"\$php_date_format\"),\"".${"DATA$i"}[$table]."\").\"<BR>\";\n");
		fputs($f,"	mk_checkbox(\"st_".${$vf}[$table]."\",1,2);\n"); 
		fputs($f,"	echo dateSelection(\"sv_".${$vf}[$table]."_top\",date(\"\$php_date_format\"),\"".${"DATA$i"}[$table]."\").\"\";\n");
		fputs($f,"	\$searchfield=\"date\";\n");
	}else if (${$vhtype}[$table] == "datetime")
	{
		fputs($f,"	echo dateSelection(\"sv_".${$vf}[$table]."\",date(\"\$php_date_format\"),\"".${"DATA$i"}[$table]."\").\"\";\n");
		fputs($f,"	echo \"<INPUT NAME=sv_".${$vf}[$table]."_time SIZE=".${$vi}[$table]." MAXLENGTH=".${$vm}[$table]."><BR>\";\n");
		fputs($f,"	mk_checkbox(\"st_".${$vf}[$table]."\",1,2);\n"); 
		fputs($f,"	echo dateSelection(\"sv_".${$vf}[$table]."_top\",date(\"\$php_date_format\"),\"".${"DATA$i"}[$table]."\").\"\";\n");
		fputs($f,"	echo \"<INPUT NAME=sv_".${$vf}[$table]."_top_time SIZE=".${$vi}[$table]." MAXLENGTH=".${$vm}[$table]." VALUE=\\\"23:59\\\">\";\n");
		fputs($f,"	\$searchfield=\"date\";\n");
	}else if (${$vhtype}[$table] == "plist")
	{
	    fputs($f,"	array2select(\"sv_".${$vf}[$table]."$multia\",\${\$table_name.\"_".${$vf}[$table]."_arr\"},$multi,\"\");\n");
	    fputs($f,"	\$searchfield=\"select\";\n");
	}else if (${$vhtype}[$table] == "rlist")
	{
	    fputs($f,"	array2radio(\${\$table_name.\"_".${$vf}[$table]."_arr\"},\"sv_".${$vf}[$table]."\",\"\");\n");
	    fputs($f,"	\$searchfield=\"select\";\n");
	}else if (${$vhtype}[$table] == "checkbox")
	{
	    fputs($f,"	mk_checkbox(\"sv_".${$vf}[$table]."\",key(\${\$table_name.\"_".${$vf}[$table]."_arr\"}),key(\${\$table_name.\"_".${$vf}[$table]."_arr\"}));\n"); 
	    fputs($f,"	\$searchfield=\"select\";\n");
	}else if (${$vtype}[$table] == "int" 
	    || ${$vtype}[$table] == "float"
	    || ${$vtype}[$table] == "time"
	    || ${$vtype}[$table] == "decimal")
	{
		fputs($f,"	echo \"<INPUT NAME=\\\"sv_".${$vf}[$table]."\\\" SIZE=".${$vi}[$table]." MAXLENGTH=".${$vm}[$table]."><BR>\\n\";\n");
		fputs($f,"	mk_checkbox(\"st_".${$vf}[$table]."\",1,2);\n"); 
		fputs($f,"	echo \"<INPUT NAME=\\\"sv_".${$vf}[$table]."_top\\\" SIZE=".${$vi}[$table]." MAXLENGTH=".${$vm}[$table].">\\n\";\n");
		fputs($f,"	\$searchfield=\"numeric\";\n");
	}else
	{
		fputs($f,"	echo \"<INPUT NAME=\\\"sv_".${$vf}[$table]."\\\">\\n\";\n");
		fputs($f,"	\$searchfield=\"\";\n");
	}
	fputs($f,"	echo \"<INPUT TYPE=\\\"HIDDEN\\\" NAME=\\\"sf_".${$vf}[$table]."\\\" VALUE=\\\"\$searchfield\\\">\\n\";\n");
	fputs($f,"	echo \"\$table_td_end\$table_tr_end\";\n");
    }
if($permissions){
    fputs($f,"} # permission SELECT for ".${$vf}[$table]."\n");
} 
}

fputs($f,"	echo \"\$table_tr_start\$table_td_start\$table_td_end\$table_td_start\$table_td_end\$table_td_start\";\n");
fputs($f,"	echo \"<INPUT TYPE=\\\"SUBMIT\\\" VALUE=\\\"$NLSSearchForm\\\">\\n\";\n");
fputs($f,"	echo \"\$table_td_end\$table_tr_end\";\n");
fputs($f,"	echo \"</FORM>\";\n");
fputs($f,"	echo \"\$end_table_tag\";\n");
if ($center) fputs($f,"	echo \"\$center_end\";\n");
if($permissions){
fputs($f,"} # permissions Search\n");
}
fputs($f,"} # Search form\n");
if($permissions){
    fputs($f,"} # permissions ".$tablename[$table]."\n");
}
fputs($f,"if(\$only_full_list){\$forder=\$forder_up;}\n");
fputs($f,"else echo \"\\n</BODY></HTML>\";\n\n");
fputs($f,"} # ".$tablename[$table]."\n\n");
}

reset($openfiles);
while(list($fname,$file)=each($openfiles))
{
fputs($file,"\nif(!\$only_full_list)\n");
fputs($file,"{\n");
    fputs($file,$end_incfile_str);
fputs($file,"}\n");
    fputs($file,"$php_end\n");
    fclose($file);
}   

echo "Ok ! Run <A HREF=\"".($path?str_replace($path,"",$OUTPUTDIR):$OUTPUTDIR)."$SEPARATOR$outputfile_index\"><B>$outputfile_index</B></A>";
if($ssl_on) echo "<BR>Run over SSL <A HREF=\"https://$SERVER_NAME".dirname($REQUEST_URI).$SEPARATOR.($path?str_replace($path,"",$OUTPUTDIR):$OUTPUTDIR)."$SEPARATOR$outputfile_index\"><B>$outputfile_index</B></A>";

echo "</BODY></HTML>";
?>