#include "common_includes.h"

#ifndef NO_COLOR_CURSES
extern struct colours cols;
#endif /* NO_COLOR_CURSES */

int normal;
int menuselected;
int menu;
int noteselected;
int note;
int topline;
int bottomline;
int manualbold;
int manualitalic;
int url;
int urlselected;
int infohighlight;

void
initcolors ()
{
#ifndef NO_COLOR_CURSES
  if (has_colors ())
    {
      start_color ();

      normal = COLOR_PAIR (NORMAL);	/* normal text */
      init_pair (NORMAL, cols.normal_fore, cols.normal_back);
      if (cols.normal_bold)
	normal |= A_BOLD;

      menuselected = COLOR_PAIR (MENUSELECTED);		/* selected menu */
      init_pair (MENUSELECTED, cols.menuselected_fore, cols.menuselected_back);
      if (cols.menuselected_bold)
	menuselected |= A_BOLD;

      menu = COLOR_PAIR (MENU);	/* just menu */
      init_pair (MENU, cols.menu_fore, cols.menu_back);
      if (cols.menu_bold)
	menu |= A_BOLD;

      noteselected = COLOR_PAIR (NOTESELECTED);		/* selected note */
      init_pair (NOTESELECTED, cols.noteselected_fore, cols.noteselected_back);
      if (cols.noteselected_bold)
	noteselected |= A_BOLD;

      note = COLOR_PAIR (NOTE);	/* just note */
      init_pair (NOTE, cols.note_fore, cols.note_back);
      if (cols.note_bold)
	note |= A_BOLD;

      topline = COLOR_PAIR (TOPLINE);	/* topline color */
      init_pair (TOPLINE, cols.topline_fore, cols.topline_back);
      if (cols.topline_bold)
	topline |= A_BOLD;

      bottomline = COLOR_PAIR (BOTTOMLINE);	/* bottomline color */
      init_pair (BOTTOMLINE, cols.bottomline_fore, cols.bottomline_back);
      if (cols.bottomline_bold)
	bottomline |= A_BOLD;

      manualbold = COLOR_PAIR (MANUALBOLD);	/* manual bold color */
      init_pair (MANUALBOLD, cols.manualbold_fore, cols.manualbold_back);
      if (cols.manualbold_bold)
	manualbold |= A_BOLD;

      manualitalic = COLOR_PAIR (MANUALITALIC);		/* manual italic color */
      init_pair (MANUALITALIC, cols.manualitalic_fore, cols.manualitalic_back);
      if (cols.manualitalic_bold)
	manualitalic |= A_BOLD;

      url = COLOR_PAIR (URL);	/* url (http, ftp) color */
      init_pair (URL, cols.url_fore, cols.url_back);
      if (cols.url_bold)
	url |= A_BOLD;

      urlselected = COLOR_PAIR (URLSELECTED);	/* selected url */
      init_pair (URLSELECTED, cols.urlselected_fore, cols.urlselected_back);
      if (cols.urlselected_bold)
	urlselected |= A_BOLD;

      infohighlight = COLOR_PAIR (INFOHIGHLIGHT);	/* highlight for info quotes */
      init_pair (INFOHIGHLIGHT, cols.infohighlight_fore, cols.infohighlight_back);
      if (cols.infohighlight_bold)
	infohighlight |= A_BOLD;
    }
  else
    {
#endif /* NO_COLOR_CURSES */
      normal = A_NORMAL;
      menu = A_BOLD;
      note = A_BOLD;
      url = A_BOLD;
      menuselected = A_REVERSE;
      noteselected = A_REVERSE;
      urlselected = A_REVERSE;
      topline = A_REVERSE;
      bottomline = A_REVERSE;
      manualbold = A_BOLD;
      manualitalic = A_BOLD;
      infohighlight = A_BOLD;
#ifndef NO_COLOR_CURSES
    }
#endif /* NO_COLOR_CURSES */
}
