#include "common_includes.h"

char *httpviewer = "lynx";
char *ftpviewer = "lynx";
char *maileditor = "mail";
char *manlinks = "1:8:2:2:4:5:6:7:9:n:l:p:o:3X11:3Xt:3X:3x";

char *tmpfilename1 = 0;
char *tmpfilename2 = 0;

SearchAgain searchagain;

HyperObject *hyperobjects = 0;
int hyperobjectcount = 0;

Indirect *indirect = 0;
TagTable *tag_table = 0;
int IndirectEntries = 0;
int TagTableEntries = 0;
int maxx, maxy;
int CutManHeaders = 0;
int CutEmptyManLines = 0;
int ForceManualTagTable = 0;
int LongManualLinks = 0;
char *ManOptions = "";
char *StderrRedirection = "2> /dev/null";

InfoHistory infohistory;

int npos = -1;
int ncursor = -1;
int use_apropos = 0;
int use_manual = 0;
int use_raw_filename = 0;

void
inithistory ()
{
  infohistory.length = 0;
  infohistory.node = 0;
  infohistory.file = 0;
  infohistory.pos = 0;
  infohistory.cursor = 0;
}

void
addinfohistory (char *file, char *node, int cursor, int pos)	/*
								 * Add history
								 * entry
								 */
{
  if (!infohistory.length)
    {
      infohistory.length++;
      infohistory.node = xmalloc (sizeof (char *) * 2);
      infohistory.node[0] = 0;
      infohistory.file = xmalloc (sizeof (char *) * 2);
      infohistory.file[0] = 0;
      infohistory.pos = xmalloc (sizeof (int) * 2);
      infohistory.cursor = xmalloc (sizeof (int) * 2);
    }
  else
    {
      infohistory.length++;
      infohistory.node = xrealloc (infohistory.node, sizeof (char *) * (infohistory.length + 1));
      infohistory.file = xrealloc (infohistory.file, sizeof (char *) * (infohistory.length + 1));
      infohistory.pos = xrealloc (infohistory.pos, sizeof (int) * (infohistory.length + 1));
      infohistory.cursor = xrealloc (infohistory.cursor, sizeof (int) * (infohistory.length + 1));
    }
  infohistory.node[infohistory.length] = xmalloc (strlen (node) + 1);
  strcpy (infohistory.node[infohistory.length], node);
  infohistory.file[infohistory.length] = xmalloc (strlen (file) + 1);
  strcpy (infohistory.file[infohistory.length], file);
  infohistory.pos[infohistory.length] = pos;
  infohistory.cursor[infohistory.length] = cursor;
}

void
dellastinfohistory ()		/* Delete last history entry */
{
  if (infohistory.length)
    {
      if (infohistory.node[infohistory.length])
	{
	  xfree (infohistory.node[infohistory.length]);
	  infohistory.node[infohistory.length] = 0;
	}
      if (infohistory.file[infohistory.length])
	{
	  xfree (infohistory.file[infohistory.length]);
	  infohistory.file[infohistory.length] = 0;
	}
      if (infohistory.length)
	infohistory.length--;
      if (infohistory.length)
	{
	  infohistory.node = xrealloc (infohistory.node, sizeof (char *) * (infohistory.length + 1));
	  infohistory.file = xrealloc (infohistory.file, sizeof (char *) * (infohistory.length + 1));
	  infohistory.pos = xrealloc (infohistory.pos, sizeof (int) * (infohistory.length + 1));
	  infohistory.cursor = xrealloc (infohistory.cursor, sizeof (int) * (infohistory.length + 1));
	}
      else
	{
	  if (infohistory.node)
	    {
	      xfree (infohistory.node);
	      infohistory.node = 0;
	    }
	  if (infohistory.file)
	    {
	      xfree (infohistory.file);
	      infohistory.file = 0;
	    }
	  if (infohistory.pos)
	    {
	      xfree (infohistory.pos);
	      infohistory.pos = 0;
	    }
	  if (infohistory.cursor)
	    {
	      xfree (infohistory.cursor);
	      infohistory.cursor = 0;
	    }
	}
    }
}
