#ifndef __DATATYPES_H
#define __DATATYPES_H

#define HIGHLIGHT 1000

typedef struct
  {
    char lastsearch[256];
    char type;
    int search;
  }
SearchAgain;

typedef struct
  {
    char filename[256];
    long offset;
  }
Indirect;

typedef struct
  {
    char nodename[256];
    long offset;
  }
TagTable;

typedef struct
  {
    int length;
    char **node;		/* array of history of nodes */
    char **file;		/* array of history of files, associated with given nodes */
    int *pos;			/* history of pos offsets in viewed nodes */
    int *cursor;		/* history of cursor offsets in viewed nodes */
  }
InfoHistory;

typedef struct
  {
    int line;			/* line number of the place where the link is */
    int row;			/* row number ----||---- */
    int breakpos;		/* row number, where the links breaks to next line */
    int type;			/* type of link: 0 -  * menu::,
				   1 -  * Comment: menu.
				   2 -  *note note::
				   3 -  *note Comment: note. 
				   4 -  http url
				   5 -  ftp url
				   6 -  mailto url */
    char node[256];		/* name of the referenced node */
    char file[256];		/* name of the referenced file -- none=this file */
    int tagtableoffset;		/* offset in tag table */
  }
HyperObject;

extern char *httpviewer;
extern char *ftpviewer;
extern char *maileditor;
extern char *manlinks;

extern char *tmpfilename1;
extern char *tmpfilename2;

extern SearchAgain searchagain;	/* a structure for "search again" feature */

extern HyperObject *hyperobjects;	/* an array of references for info */
extern int hyperobjectcount;
extern Indirect *indirect;	/* an array of indirect entries [1 to n] */
extern int IndirectEntries;	/* number of indirect entries */
extern TagTable *tag_table;	/* an array of tag table entries [1 to n] */
extern int TagTableEntries;	/* number of tag table entries */
extern int maxx, maxy;		/* maximum dimensions of screen */
extern InfoHistory infohistory;
extern int npos;		/* position to by set when moving via history */
extern int ncursor;		/* cursor pos to be set when..... as above */
extern int use_apropos;		/* determines if the apropos should be called
				   if searching for aproprimate document fails */
extern int CutManHeaders;	/* determines if man handling routines should
				   try to cut off the repeating headers */
extern int CutEmptyManLines;	/* determines if man loading routines should
				   try to cut out the repeating empty 
				   double-newlines */
extern int ForceManualTagTable;	/* Determines if you wish to initialize the
				   tag table automaticaly, or you wish
				   that pinfo does it alone. Some info pages
				   may have corrupt tag table (i.e. some
				   versions of jed pages */
extern int LongManualLinks;	/* Causes manual link sections to be treated
				   as long names (i.e. 3x11 instead of 3) */
extern char *ManOptions;	/* options passed to the `man' program */
extern char *StderrRedirection;	/* shell code to redirect stderr output */

void inithistory ();
void addinfohistory (char *file, char *node, int cursor, int pos);
void dellastinfohistory ();

#endif
