#ifndef __FILEHANDLING_FUNCTIONS_H
#define __FILEHANDLING_FUNCTIONS_H

#define INFO_TAG 0x1f
#define INDIRECT_TAG 0x7f

void initpaths ();

void seeknode (int tag_table_pos, FILE ** Id);	/* 
					         * seek to a node in certain
						 * info file 
						 */

void freeitem (char **type, char ***buf, long *lines);	/* free allocated memory */

void read_item (FILE * id, char **type, char ***buf, long *lines);	
/*  
 * reads a node from 'id' to 'buf', and the header of node to 'type'. It sets
 * the numer of read lines to *lines. Warning! First line of 'buf' is left
 * empty.
 */
int seek_indirect (FILE * id);	/* searches for indirect entry of info file */
int seek_tag_table (FILE * id);	/* as above, but with tag table entry */
void load_indirect (char **message, long lines);	/* loads indirect table */
void load_tag_table (char **message, long lines);	/* loads tag table */
FILE *openinfo (char *filename, int number);	/* opens info file */

void create_tag_table(FILE *id);	/* creates tag table for info file */
void create_indirect_tag_table();	/* creates tag table for indirect info */

#endif
