#include "common_includes.h"

#define MENU_DOT 0
#define NOTE_DOT 1

int
calculate_len (char *start, char *end)	/*
					 * calculates the length of string
					 * between start and end, counting
					 * `\t' as 8 chars.
					 */
{
  int len = (int) (end - start);
  while (start <= end)
    {
      if (*start == '\t')
	len += 7;
      start++;
    }
  return len;
}

void
freelinks ()			/* frees space allocated previously by node-links */
{
  if (hyperobjects)
    {
      xfree (hyperobjects);
      hyperobjects = 0;
    }
  hyperobjectcount = 0;
}

char *
findurlend (char *str)		/*
				 * Finds url end.
				 * It is recognized by an invalid character.
				 */
{
  char *end;
  char *allowedchars = "QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm1234567890-_/~.%=|:@";
  end = str;
  while (strchr (allowedchars, *end) != NULL)
    ++end;
  if (end > str)
    {
      if (*(end - 1) == '.')
	end--;
    }
  return end;
}

char *
finddot (char *str, int note)	/*
				 * Searchs for a note/menu delimiter.
				 * it may be dot, comma, tab, or newline.
				 */
{
  char *end[4] =
  {0, 0, 0, 0};
  char *closest = 0;
  int i;
  if (strlen (str) < 2)
    return 0;			/* avoid checking i.e * Menu:\n */
  end[0] = strchr (str, '.');	/* nodename entry may end with dot, comma */
  end[1] = strchr (str, ',');	/* tabulation, or newline */
  if (!note)
    {
      end[2] = strchr (str, '\t');
      end[3] = strchr (str, '\n');
    }
  else
    note = 2;
  if (end[0])
    closest = end[0];
  else if (end[1])
    closest = end[1];
  else if (end[2])
    closest = end[2];
  else if (end[3])
    closest = end[3];
  for (i = 1; i < note; i++)
    {
      if ((end[i] < closest) && (end[i]))
	closest = end[i];
    }
  return closest;
}

char *
findemailstart (char *str)	/*
				 * Moves you to the beginning of username
				 * in email address.
				 * If username has length=0, NULL is returned.
				 */
{
  char *allowedchars = "QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm1234567890-_/~.%=|:";
  char *at = strchr (str, '@');
  char *emailstart = 0;
  if (at)
    {
      emailstart = str;
      while (at > str)
	{
	  at--;
	  if (strchr (allowedchars, *at) == NULL)
	    {
	      if (*(at + 1) != '@')
		return at + 1;
	      else
		return 0;
	    }
	}
      if (*at != '@')
	return at;
      else
	return 0;
    }
  return 0;
}

void
initializelinks (char *line1, char *line2, int line)
{
  char *tmp;
  char *notestart, *urlstart, *urlend;
  char *quotestart, *quoteend;
  char *buf = xmalloc (strlen (line1) + strlen (line2) + 1);
  int i, changed;
  int hobjectcnt = hyperobjectcount;
  int line1len = strlen (line1);
  strcpy (buf, line1);		/* copy two lines into one */
  if (strlen (line1))
    buf[strlen (line1) - 1] = ' ';	/* replace trailing '\n' with ' ' */
  strcat (buf, line2);
/******************************************************************************
* First scan for some highlights ;) -- words enclosed with quotes             *
******************************************************************************/
  quoteend = buf;
  do
    {
      changed = 0;
      if ((quotestart = strchr (quoteend, '`')) != NULL)	/* find start of quoted text */
	{
	  if (quotestart < buf + line1len)
	    if ((quoteend = strchr (quotestart, '\'')) != NULL)		/* find the end of quoted text */
	      {
		if (quoteend - quotestart > 1)
		  {
		    while (!strncmp (quoteend - 1, "n't", 3))	/* if this apostrophe is not a part of "haven't", "wouldn't", etc. */
		      {
			quoteend = strchr (quoteend + 1, '\'');
			if (!quoteend)
			  break;
		      }
		    if (quoteend)
		      {
			changed = 1;
			if (!hyperobjectcount)
			  hyperobjects = xmalloc (sizeof (HyperObject));
			else
			  hyperobjects = xrealloc (hyperobjects, sizeof (HyperObject) * (hyperobjectcount + 1));
			hyperobjects[hyperobjectcount].line = line;
			hyperobjects[hyperobjectcount].row = calculate_len (buf, quotestart + 1);
			hyperobjects[hyperobjectcount].breakpos = -1;	/* default */
			if (quoteend > buf + line1len)
			  {
			    hyperobjects[hyperobjectcount].breakpos = buf + line1len - quotestart - 1;
			  }
			hyperobjects[hyperobjectcount].type = HIGHLIGHT;
			strncpy (hyperobjects[hyperobjectcount].node, quotestart + 1, quoteend - quotestart - 1);
			hyperobjects[hyperobjectcount].node[quoteend - quotestart - 1] = 0;
			strcpy (hyperobjects[hyperobjectcount].file, "");
			hyperobjects[hyperobjectcount].tagtableoffset = -1;
			hyperobjectcount++;
		      }
		  }
	      }
	}
    }
  while (changed);
/******************************************************************************
* Look for e-mail url's                                                       *
******************************************************************************/
  urlend = line1;
  do
    {
      changed = 0;
      if ((urlstart = findemailstart (urlend)) != NULL)
	{
	  urlend = findurlend (urlstart);	/* always successful */
	  if (!hyperobjectcount)
	    hyperobjects = xmalloc (sizeof (HyperObject));
	  else
	    hyperobjects = xrealloc (hyperobjects, sizeof (HyperObject) * (hyperobjectcount + 1));
	  hyperobjects[hyperobjectcount].line = line;
	  hyperobjects[hyperobjectcount].row = calculate_len (line1, urlstart);
	  hyperobjects[hyperobjectcount].breakpos = -1;
	  hyperobjects[hyperobjectcount].type = 6;
	  strncpy (hyperobjects[hyperobjectcount].node, urlstart, urlend - urlstart);
	  hyperobjects[hyperobjectcount].node[urlend - urlstart] = 0;
	  strcpy (hyperobjects[hyperobjectcount].file, "");
	  hyperobjects[hyperobjectcount].tagtableoffset = -1;
	  if (strchr (hyperobjects[hyperobjectcount].node, '.') == NULL)
	    {
	      if (!hyperobjectcount)
		xfree (hyperobjects);
	    }
	  else
	    hyperobjectcount++;
	  changed = 1;
	}

    }
  while (changed);
/******************************************************************************
* First try to scan for menu. Use as many security mechanisms, as possible    *
******************************************************************************/

  if ((line1[0] == '*') && (line1[1] == ' '))	/* menu */
    {
/******************************************************************************
* Scan for normal menu of kind "* (infofile)reference:: comment",  where      *
* the infofile parameter is optional, and indicates, that a reference         *
* matches different info file.                                                *
******************************************************************************/
      tmp = strstr (line1, "::");	/* "* menulink:: comment" */
      if (tmp != NULL)
	{
	  if (!hyperobjectcount)
	    hyperobjects = xmalloc (sizeof (HyperObject));
	  else
	    hyperobjects = xrealloc (hyperobjects, sizeof (HyperObject) * (hyperobjectcount + 1));
	  if (line1[2] == '(')	/* if cross-info link */
	    {
	      char *end = strchr (line1, ')');
	      if ((end != NULL) && (end < tmp))		/* if the ')' char was found, and was before '::' */
		{
		  long FilenameLen = (long) (end - line1 - 3);
		  long NodenameLen = (long) (tmp - end - 1);
		  strncpy (hyperobjects[hyperobjectcount].file,
			   line1 + 3, FilenameLen);
		  hyperobjects[hyperobjectcount].file[FilenameLen] = 0;
		  strncpy (hyperobjects[hyperobjectcount].node,
			   end + 1, NodenameLen);
		  hyperobjects[hyperobjectcount].node[NodenameLen] = 0;
		  hyperobjects[hyperobjectcount].type = 0;
		  hyperobjects[hyperobjectcount].line = line;
		  hyperobjects[hyperobjectcount].row = 2;
		  hyperobjects[hyperobjectcount].breakpos = -1;
		  hyperobjectcount++;
		}
	    }
	  else
	    /* if not cross-info link */
	    {
	      long NodenameLen = (long) (tmp - line1 - 2);
	      strcpy (hyperobjects[hyperobjectcount].file, "");
	      strncpy (hyperobjects[hyperobjectcount].node,
		       line1 + 2, NodenameLen);
	      hyperobjects[hyperobjectcount].node[NodenameLen] = 0;
	      hyperobjects[hyperobjectcount].type = 0;
	      hyperobjects[hyperobjectcount].line = line;
	      hyperobjects[hyperobjectcount].row = 2;
	      hyperobjects[hyperobjectcount].breakpos = -1;
	      for (i = 1; i <= TagTableEntries; i++)
		{
		  if (strcmp (tag_table[i].nodename,
			      hyperobjects[hyperobjectcount].node) == 0)
		    {
		      hyperobjectcount++;	/* yep, this was a good hit */
		      break;	/* we can increase the objectcount */
		    }
		}
	    }
	}
/******************************************************************************
* Scan for menu references of form                                            *
* "* Comment:[spaces](infofile)reference."                                    *
******************************************************************************/
      else if ((tmp = strstr (line1, ":")) != NULL)
	{
	  char *start = 0, *end = 0, *dot = 0;
	  dot = finddot (tmp + 1, MENU_DOT);	/* find the trailing dot */
	  if (dot != NULL)
	    if (dot + 7 < dot + strlen (dot))
	      {
		if (strncmp (dot, ".info)", 6) == 0)	/* skip possible '.info' filename suffix when searching for ending dot */
		  dot = finddot (dot + 1, MENU_DOT);
	      }
	  if (((start = strchr (tmp, '(')) != NULL) && (dot != NULL))
	    {
	      if (start < dot)	/* security mechanism ;) */
		{
		  end = strchr (start, ')');	/* find end of file name */
		  if (end < dot)	/* security mechanism ;)) */
		    {
		      long FilenameLen = (long) (end - start - 1);
		      long NodenameLen = (long) (dot - end - 1);
		      if (!hyperobjectcount)
			hyperobjects = xmalloc (sizeof (HyperObject));
		      else
			hyperobjects = xrealloc (hyperobjects, sizeof (HyperObject) * (hyperobjectcount + 1));
		      strncpy (hyperobjects[hyperobjectcount].file,
			       start + 1, FilenameLen);
		      hyperobjects[hyperobjectcount].file[FilenameLen] = 0;
		      strncpy (hyperobjects[hyperobjectcount].node,
			       end + 1, NodenameLen);
		      hyperobjects[hyperobjectcount].node[NodenameLen] = 0;
		      hyperobjects[hyperobjectcount].type = 1;
		      hyperobjects[hyperobjectcount].line = line;
		      hyperobjects[hyperobjectcount].row = calculate_len (line1, start);
		      hyperobjects[hyperobjectcount].breakpos = -1;
		      hyperobjectcount++;
		    }
		}
	      else
		{
		  goto handle_no_file_menu_label;
		}
	    }
	  else if (dot != NULL)	/* if not cross-info reference */
	    {
	    handle_no_file_menu_label:
	      {
		long NodenameLen;
		if (!hyperobjectcount)
		  hyperobjects = xmalloc (sizeof (HyperObject));
		else
		  hyperobjects = xrealloc (hyperobjects, sizeof (HyperObject) * (hyperobjectcount + 1));

		start = tmp + 1;	/* move after the padding spaces */
		while (*start == ' ')
		  start++;
		NodenameLen = (long) (dot - start);
		strcpy (hyperobjects[hyperobjectcount].file, "");
		strncpy (hyperobjects[hyperobjectcount].node,
			 start, NodenameLen);
		hyperobjects[hyperobjectcount].node[NodenameLen] = 0;
		hyperobjects[hyperobjectcount].type = 1;
		hyperobjects[hyperobjectcount].line = line;
		hyperobjects[hyperobjectcount].row = calculate_len (line1, start);
		hyperobjects[hyperobjectcount].breakpos = -1;
		for (i = 1; i <= TagTableEntries; i++)
		  {
		    if (strcmp (tag_table[i].nodename,
				hyperobjects[hyperobjectcount].node) == 0)
		      {
			hyperobjectcount++;	/* yep, this was a good hit */
			break;	/* we can increase the objectcount */
		      }
		  }
	      }
	    }
	}
    }
/******************************************************************************
* Handle notes. In similar way as above.                                      *
******************************************************************************/
  else if ((notestart = strstr (buf, "*note")) != NULL)
    goto handlenote;
  else if ((notestart = strstr (buf, "*Note")) != NULL)
    {
    handlenote:
/******************************************************************************
* Scan for normal note of kind "* (infofile)reference:: comment", where       *
* the infofile parameter is optional, and indicates, that a reference         *
* matches different info file.                                                *
******************************************************************************/
      if ((long) (notestart - buf) < strlen (line1))	/* make sure that we don't handle notes, which fit in the second line */
	{			/* we can handle only those, who are in the first line, or who are split up into two lines */
	  tmp = strstr (notestart, "::");	/* "*note notelink:: comment" */
	  if (tmp != NULL)
	    {
	      if (!hyperobjectcount)
		hyperobjects = xmalloc (sizeof (HyperObject));
	      else
		hyperobjects = xrealloc (hyperobjects, sizeof (HyperObject) * (hyperobjectcount + 1));
	      if (notestart[6] == '(')	/* if cross-info link */
		{
		  char *end = strchr (notestart, ')');
		  if ((end != NULL) && (end < tmp))	/* if the ')' char was found, and was before '::' */
		    {
		      long FilenameLen = (long) (end - notestart - 7);
		      long NodenameLen = (long) (tmp - end - 1);
		      strncpy (hyperobjects[hyperobjectcount].file,
			       notestart + 7, FilenameLen);
		      hyperobjects[hyperobjectcount].file[FilenameLen] = 0;
		      strncpy (hyperobjects[hyperobjectcount].node,
			       end + 1, NodenameLen);
		      hyperobjects[hyperobjectcount].node[NodenameLen] = 0;
		      hyperobjects[hyperobjectcount].type = 2;
		      if (notestart + 7 - buf < strlen (line1))
			{
			  hyperobjects[hyperobjectcount].line = line;
			  hyperobjects[hyperobjectcount].row = calculate_len (buf, notestart + 7);
			  if (tmp - buf < strlen (line1))	/* if the note highlight fits int first line */
			    hyperobjects[hyperobjectcount].breakpos = -1;	/* we don't need to break highlighting int several lines */
			  else
			    hyperobjects[hyperobjectcount].breakpos = strlen (line1) - (long) (notestart + 7 - buf);	/* otherwise we need it */
			}
		      else
			{
			  hyperobjects[hyperobjectcount].line = line + 1;
			  hyperobjects[hyperobjectcount].row = calculate_len (buf + strlen (line1), notestart + 7);
			  if (tmp - buf < strlen (line1))	/* as above */
			    hyperobjects[hyperobjectcount].breakpos = -1;
			  else
			    hyperobjects[hyperobjectcount].breakpos = strlen (line1) - (long) (notestart + 7 - buf);
			}
		      hyperobjectcount++;
		    }
		}
	      else
		/* if not cross-info link */
		{
		  long NodenameLen = (long) (tmp - notestart - 6);
		  strcpy (hyperobjects[hyperobjectcount].file, "");
		  strncpy (hyperobjects[hyperobjectcount].node,
			   notestart + 6, NodenameLen);
		  hyperobjects[hyperobjectcount].node[NodenameLen] = 0;
		  hyperobjects[hyperobjectcount].type = 2;
		  if (notestart + 7 - buf < strlen (line1))
		    {
		      hyperobjects[hyperobjectcount].line = line;
		      hyperobjects[hyperobjectcount].row = calculate_len (buf, notestart + 7) - 1;
		      if (tmp - buf < strlen (line1))	/* if the note highlight fits int first line */
			hyperobjects[hyperobjectcount].breakpos = -1;	/* we don't need to break highlighting int several lines */
		      else
			hyperobjects[hyperobjectcount].breakpos = strlen (line1) - (long) (notestart + 7 - buf);	/* otherwise we need it */
		    }
		  else
		    {
		      hyperobjects[hyperobjectcount].line = line + 1;
		      hyperobjects[hyperobjectcount].row = calculate_len (buf + strlen (line1), notestart + 7) - 1;
		      if (tmp - buf < strlen (line1))	/* as above */
			hyperobjects[hyperobjectcount].breakpos = -1;
		      else
			hyperobjects[hyperobjectcount].breakpos = strlen (line1) - (long) (notestart + 7 - buf);
		    }
		  for (i = 1; i <= TagTableEntries; i++)
		    {
		      if (strstr (tag_table[i].nodename,
			       hyperobjects[hyperobjectcount].node) != NULL)
			{
			  hyperobjectcount++;	/* yep, this was a good hit */
			  break;	/* we can increase the objectcount */
			}
		    }
		}
	    }
/******************************************************************************
* Scan for note references of form                                            *
* "* Comment:[spaces](infofile)reference."                                    *
******************************************************************************/
	  else if ((tmp = strstr (notestart, ":")) != NULL)
	    {
	      char *start = 0, *end = 0, *dot = 0;
	      dot = finddot (tmp + 1, NOTE_DOT);	/* find the trailing dot */
	      if (dot != NULL)
		if (dot + 7 < dot + strlen (dot))
		  {
		    if (strncmp (dot, ".info)", 6) == 0)
		      dot = finddot (dot + 1, NOTE_DOT);
		  }
	      if (((start = strchr (tmp, '(')) != NULL) && (dot != NULL))
		{
		  if (start < dot)	/* security mechanism ;) */
		    {
		      end = strchr (start, ')');	/* find end of file name */
		      if (end < dot)	/* security mechanism ;)) */
			{
			  long FilenameLen = (long) (end - start - 1);
			  long NodenameLen = (long) (dot - end - 1);
			  if (!hyperobjectcount)
			    hyperobjects = xmalloc (sizeof (HyperObject));
			  else
			    hyperobjects = xrealloc (hyperobjects, sizeof (HyperObject) * (hyperobjectcount + 1));
			  strncpy (hyperobjects[hyperobjectcount].file,
				   start + 1, FilenameLen);
			  hyperobjects[hyperobjectcount].file[FilenameLen] = 0;
			  strncpy (hyperobjects[hyperobjectcount].node,
				   end + 1, NodenameLen);
			  hyperobjects[hyperobjectcount].node[NodenameLen] = 0;
			  hyperobjects[hyperobjectcount].type = 3;
			  if (start - buf < strlen (line1))
			    {
			      hyperobjects[hyperobjectcount].line = line;
			      hyperobjects[hyperobjectcount].row = calculate_len (buf, start);
			      if (dot - buf < strlen (line1))	/* if the note highlight fits in first line */
				hyperobjects[hyperobjectcount].breakpos = -1;	/* we don't need to break highlighting int several lines */
			      else
				hyperobjects[hyperobjectcount].breakpos = strlen (line1) - (long) (start - buf);	/* otherwise we need it */
			    }
			  else
			    {
			      hyperobjects[hyperobjectcount].line = line + 1;
			      hyperobjects[hyperobjectcount].row = calculate_len (buf + strlen (line1), start);
			      hyperobjects[hyperobjectcount].breakpos = -1;
			    }
			  hyperobjectcount++;
			}
		    }
		  else
		    {
		      goto handle_no_file_note_label;
		    }
		}
	      else if (dot != NULL)	/* if not cross-info reference */
		{
		handle_no_file_note_label:
		  {
		    long NodenameLen;
		    if (!hyperobjectcount)
		      hyperobjects = xmalloc (sizeof (HyperObject));
		    else
		      hyperobjects = xrealloc (hyperobjects, sizeof (HyperObject) * (hyperobjectcount + 1));

		    start = tmp + 1;	/* move after the padding spaces */
		    while (*start == ' ')
		      start++;
		    NodenameLen = (long) (dot - start);
		    strcpy (hyperobjects[hyperobjectcount].file, "");
		    strncpy (hyperobjects[hyperobjectcount].node,
			     start, NodenameLen);
		    hyperobjects[hyperobjectcount].node[NodenameLen] = 0;
		    hyperobjects[hyperobjectcount].type = 3;
		    if (start - buf < strlen (line1))
		      {
			hyperobjects[hyperobjectcount].line = line;
			hyperobjects[hyperobjectcount].row = calculate_len (buf, start);
			if (dot - buf < strlen (line1))		/* if the note highlight fits in first line */
			  hyperobjects[hyperobjectcount].breakpos = -1;		/* we don't need to break highlighting int several lines */
			else
			  hyperobjects[hyperobjectcount].breakpos = strlen (line1) - (long) (start - buf);	/* otherwise we need it */
		      }
		    else
		      {
			hyperobjects[hyperobjectcount].line = line + 1;
			hyperobjects[hyperobjectcount].row = calculate_len (strlen (line1) + buf, start);
			hyperobjects[hyperobjectcount].breakpos = -1;
		      }
		    for (i = 1; i <= TagTableEntries; i++)
		      {
			if (strstr (tag_table[i].nodename,
			       hyperobjects[hyperobjectcount].node) != NULL)
			  {
			    hyperobjectcount++;		/* yep, this was a good hit */
			    break;	/* we can increase the objectcount */
			  }
		      }
		  }
		}
	    }
	}
    }
  if (notestart)
    if (notestart + 6 < buf + strlen (buf) + 1)
      {
	tmp = notestart;
	if ((notestart = strstr (notestart + 6, "*Note")) != NULL)
	  goto handlenote;
	notestart = tmp;
	if ((notestart = strstr (notestart + 6, "*note")) != NULL)
	  goto handlenote;
      }
/******************************************************************************
 * Try to scan for some url-like objects in single line; mainly               *
 * http://[address][space|\n|\t]                                              * 
 * ftp://[address][space|\n|\t]                                               *
 * username@something.else[space|\n|\t]                                       *
 *****************************************************************************/
  /* http:// */
  if ((urlstart = strstr (line1, "http://")) != NULL)
    {
      urlend = findurlend (urlstart);	/* always successful */
      if (!hyperobjectcount)
	hyperobjects = xmalloc (sizeof (HyperObject));
      else
	hyperobjects = xrealloc (hyperobjects, sizeof (HyperObject) * (hyperobjectcount + 1));
      hyperobjects[hyperobjectcount].line = line;
      hyperobjects[hyperobjectcount].row = calculate_len (line1, urlstart);
      hyperobjects[hyperobjectcount].breakpos = -1;
      hyperobjects[hyperobjectcount].type = 4;
      strncpy (hyperobjects[hyperobjectcount].node, urlstart, urlend - urlstart);
      hyperobjects[hyperobjectcount].node[urlend - urlstart] = 0;
      strcpy (hyperobjects[hyperobjectcount].file, "");
      hyperobjects[hyperobjectcount].tagtableoffset = -1;
      hyperobjectcount++;
    }
  /* ftp:// */
  if ((urlstart = strstr (line1, "ftp://")) != NULL)
    {
      urlend = findurlend (urlstart);	/* always successful */
      if (!hyperobjectcount)
	hyperobjects = xmalloc (sizeof (HyperObject));
      else
	hyperobjects = xrealloc (hyperobjects, sizeof (HyperObject) * (hyperobjectcount + 1));
      hyperobjects[hyperobjectcount].line = line;
      hyperobjects[hyperobjectcount].row = calculate_len (line1, urlstart);
      hyperobjects[hyperobjectcount].breakpos = -1;
      hyperobjects[hyperobjectcount].type = 5;
      strncpy (hyperobjects[hyperobjectcount].node, urlstart, urlend - urlstart);
      hyperobjects[hyperobjectcount].node[urlend - urlstart] = 0;
      strcpy (hyperobjects[hyperobjectcount].file, "");
      hyperobjects[hyperobjectcount].tagtableoffset = -1;
      hyperobjectcount++;
    }
  if (buf)
    {
      xfree (buf);
      buf = 0;
    }
}
