#include "common_includes.h"
#include <regex.h>
#include <sys/stat.h>

#define HTTPSECTION 100
#define FTPSECTION 101
#define MAILSECTION 102

void loadmanual (FILE * id);	/* load manual */
int manualwork ();		/* handle keyboard */
void rescan_selected ();	/* scan for potential link to select on
				   viewed manual page */
void showmanualscreen ();	/* self explainig */
void mvaddstr_manual (int y, int x, char *str);		/* mvaddstr with bold/italic */
void add_highlights ();		/* adds highlights to a painted screen */
void strip_manual (char *buf);	/* strips line from formatting characters */
void man_initializelinks (char *line);	/* initialize links in a line */
int is_in_manlinks (char *in, char *find);

char **manual = 0;		/* line by line stored manual */
int ManualLines = 0;		/* number of lines in manual */
int selected = -1;		/* number of selected link (offset in 'manuallinks',
				   bellow) */
int manualpos = 0;		/* number of the first line, which is painted on
				   screen */

typedef struct
  {
    char name[256];		/* name of a manual */
    char sect[32];		/* section */
    int selected;		/* what was last selected on this page */
    int pos;			/* what was the last manualpos */
  }
manhistory;

manhistory *manualhistory = 0;
int manualhistorylength = 0;	/* length of the above table - 1 */

typedef struct
  {				/* struct for hypertext references */
    int line;			/* line of the manpage, where the reference
				   is */
    int row;			/* row of that line */
    char *name;			/* name of the reference */
    char section[32];		/* section of the reference */
    int section_mark;
  }
manuallink;

manuallink *manuallinks = 0;	/* a set of manual references of man page */

int ManualLinks = 0;		/* number of found manual references in man page */

int historical = 0;		/* semaphore for checking if it's a history (left
				   arrow) call */


void
manual_free_buffers ()
{
  int i;
  if (manual)			/* first free previously allocated memory */
    {				/* for the manual itself... */
      for (i = 0; i < ManualLines; i++)
	{
	  xfree (manual[i]);
	}
      xfree (manual);
      manual = 0;
      ManualLines = 0;
    }
  if (manuallinks)		/* ...and for the list of manual hypertext */
    {				/* links */
      for (i = 0; i < ManualLinks; i++)
	{
	  xfree (manuallinks[i].name);
	}
      xfree (manuallinks);
      manuallinks = 0;
      ManualLinks = 0;
      selected = -1;
    }
}

void
set_initial_history (char *name)
{
  manualhistory = xmalloc (sizeof (manhistory));	/* one object of
							   array */
  strcpy (manualhistory[0].name, name);		/* filename->name */
  strcpy(manualhistory[0].sect,"");	/* section unknown */
  manualhistory[0].selected = -1;	/* selected unknown */
  manualhistory[0].pos = 0;	/* pos=0 */
}

int
handlemanual (char *name)
{
  int return_value = 0;
  struct stat statbuf;
  char cmd[256];
  FILE *id;
  if (tmpfilename1)
    {
      unlink (tmpfilename1);
      xfree (tmpfilename1);
    }
  tmpfilename1 = tempnam ("/tmp", NULL);
  snprintf (cmd, 255, "man %s %s %s > %s", 
            ManOptions, 
            name, 
            StderrRedirection,
            tmpfilename1);
  if (system (cmd) != 0)
    {
      printf (_ ("Error: No manual page found either.\n"));
      if (use_apropos)
	{
	  printf (_ ("Appropriate pages:\n"));
	  snprintf (cmd, 255, "apropos %s|cat %s", name, StderrRedirection);
	  system (cmd);
	}
      return 1;
    }
  id = fopen (tmpfilename1, "r");
  init_curses ();
  loadmanual (id);		/* load manual to memory */
  fclose (id);
  set_initial_history (name);
  do
    {
      return_value = manualwork ();	/* manualwork handles all
					   actions when viewing man
					   page */
      if (return_value != -1)	/* -1 is quit key */
	{
	  if (tmpfilename2)
	    {
	      unlink (tmpfilename2);
	      xfree (tmpfilename2);
	    }
	  tmpfilename2 = tempnam ("/tmp", NULL);
	  if (return_value != -2)	/* key_back is not pressed;
					   and return_value is an
					   offset to manuallinks */
	    snprintf (cmd, 255, "man %s %s %s %s > %s",
	    	      ManOptions,
		      manuallinks[return_value].section,
		      manuallinks[return_value].name,
		      StderrRedirection,
		      tmpfilename2);
	  else
	    /* key_back was pressed */
	    {
	      manualhistorylength--;
	      if (manualhistory[manualhistorylength].sect[0] == 0)
		snprintf (cmd, 255, "man %s %s %s > %s",
			  ManOptions,
			  manualhistory[manualhistorylength].name,
			  StderrRedirection,
			  tmpfilename2);
	      else
		snprintf (cmd, 255, "man %s %s %s %s > %s",
			  ManOptions,
			  manualhistory[manualhistorylength].sect,
			  manualhistory[manualhistorylength].name,
			  StderrRedirection,
			  tmpfilename2);
	      historical = 1;	/* flag to make sure, that
				   manualwork will refresh
				   the variables manualpos
				   and selected when going
				   back to this page */
	    }
	  system (cmd);
	  stat (tmpfilename2, &statbuf);
	  if (statbuf.st_size > 0)
	    {
	      snprintf (cmd, 255, "mv %s %s",
			tmpfilename2,
			tmpfilename1);
	      system (cmd);	/* create tmp file 
				   containing man page */
	      id = fopen (tmpfilename1, "r");	/* open man page */
	      if (id != NULL)
		{
		  if (!historical)	/* now we create history entry for new page */
		    {
		      manualhistorylength++;
		      manualhistory = xrealloc (manualhistory, (manualhistorylength + 2) * sizeof (manhistory));
		      strcpy (manualhistory[manualhistorylength].name, manuallinks[return_value].name);
		      strcpy(manualhistory[manualhistorylength].sect,manuallinks[return_value].section);
		    }
		  loadmanual (id);	/* loading manual page and its defaults... */
		  fclose (id);
		  if (!historical)	/* continuing with creation of history */
		    {
		      manualhistory[manualhistorylength].pos = manualpos;
		      manualhistory[manualhistorylength].selected = selected;
		    }
		  else
		    historical = 0;
		}
	      else
		return_value = -1;
	    }
	}
    }
  while (return_value != -1);
  return 0;
}

void
loadmanual (FILE * id)
{
  int i;
  char prevlinechar = 0;
  int cutheader = 0;		/* tmp variable, set after reading first
				   nonempty line of input */
  manualpos = 0;
  manual_free_buffers ();
  manual = xmalloc (sizeof (char *));
  manuallinks = xmalloc (sizeof (manuallinks));
  manual[ManualLines] = xmalloc (1024);
  while (!feof (id))		/* we read until eof */
    {
      char *tmp;
      char *link;
      int tmpcnt = 0;
      if (fgets (manual[ManualLines], 1024, id) == NULL)	/* it happens 
								   sometimes, 
								   that the last 
								   line is 
								   weird */
	manual[ManualLines][0] = 0;	/* and causes 
					   sigsegvs by 
					   not entering 
					   anything to 
					   buffer, what 
					   confuses 
					   strlen */
      if (cutheader)
	{
	  if (strcmp (manual[cutheader], manual[ManualLines]) == 0)
	    {
	      manual[ManualLines][0] = '\n';
	      manual[ManualLines][1] = 0;
	    }
	}
      if (CutManHeaders)
	if (!cutheader)
	  {
	    if (strlen (manual[ManualLines]) > 1)
	      {
		cutheader = ManualLines;
	      }
	  }
      if ((CutEmptyManLines) && ((manual[ManualLines][0]) == '\n') &&
	  (prevlinechar == '\n'))
	{
	  ;			/* do nothing :)) */
	}
      else
	{
	  manual[ManualLines] = xrealloc (manual[ManualLines],
					  strlen (manual[ManualLines]) + 10);

	  tmp = xmalloc (strlen (manual[ManualLines]) + 10);	/* temporary 
								   variable for 
								   determining 
								   hypertextuality
								   of fields */

	  strcpy (tmp, manual[ManualLines]);

	  strip_manual (tmp);	/* remove formatting chars */
	  man_initializelinks (tmp);
	  xfree (tmp);		/* free temporary buffer */
	  prevlinechar = manual[ManualLines][0];
	  ManualLines++;	/* increase the number of man lines */
	  manual = xrealloc (manual, (ManualLines + 1) * sizeof (char *));
	  /* and realloc manual to add an empty
	     space for next entry of manual line */
	  manual[ManualLines] = xmalloc (1024);
	}
    }
}

void
man_initializelinks (char *tmp)
{
  int tmpcnt = strlen (tmp) + 1;	/* set tmpcnt to the trailing zero of tmp */
  char *link = tmp;
  char *urlstart, *urlend;
  int i,b;
/******************************************************************************
 * handle url refrences                                                       *
 *****************************************************************************/
  if ((urlstart = strstr (tmp, "http://")) != NULL)
    {
      urlend = findurlend (urlstart);	/* always successfull */
      manuallinks = xrealloc (manuallinks, sizeof (manuallink) * (ManualLinks + 3));
      manuallinks[ManualLinks].line = ManualLines;
      manuallinks[ManualLinks].row = urlstart - tmp;
      strcpy(manuallinks[ManualLinks].section,"HTTPSECTION");
      manuallinks[ManualLinks].section_mark=HTTPSECTION;
      manuallinks[ManualLinks].name = xmalloc (urlend - urlstart + 10);
      strncpy (manuallinks[ManualLinks].name, urlstart, urlend - urlstart);
      manuallinks[ManualLinks].name[urlend - urlstart] = 0;
      ManualLinks++;
    }
  if ((urlstart = strstr (tmp, "ftp://")) != NULL)
    {
      urlend = findurlend (urlstart);	/* always successfull */
      manuallinks = xrealloc (manuallinks, sizeof (manuallink) * (ManualLinks + 3));
      manuallinks[ManualLinks].line = ManualLines;
      manuallinks[ManualLinks].row = urlstart - tmp;
      strcpy(manuallinks[ManualLinks].section,"FTPSECTION");
      manuallinks[ManualLinks].section_mark=FTPSECTION;
      manuallinks[ManualLinks].name = xmalloc (urlend - urlstart + 10);
      strncpy (manuallinks[ManualLinks].name, urlstart, urlend - urlstart);
      manuallinks[ManualLinks].name[urlend - urlstart] = 0;
      ManualLinks++;
    }
  if ((urlstart = findemailstart (tmp)) != NULL)
    {
      urlend = findurlend (urlstart);	/* always successfull */
      manuallinks = xrealloc (manuallinks, sizeof (manuallink) * (ManualLinks + 3));
      manuallinks[ManualLinks].line = ManualLines;
      manuallinks[ManualLinks].row = urlstart - tmp;
      strcpy(manuallinks[ManualLinks].section, "MAILSECTION");
      manuallinks[ManualLinks].section_mark=MAILSECTION;
      manuallinks[ManualLinks].name = xmalloc (urlend - urlstart + 10);
      strncpy (manuallinks[ManualLinks].name, urlstart, urlend - urlstart);
      manuallinks[ManualLinks].name[urlend - urlstart] = 0;
      if (strchr (manuallinks[ManualLinks].name, '.') != NULL)
	ManualLinks++;
    }
/******************************************************************************
* handle normal manual refrences -- reference (section)                       *
******************************************************************************/
  do
    {
      link = strchr (link, '(');	/* we look for '(', since manual link */
      if (link != NULL)		/* has form of  'blah (x)' */
	{
	  char *temp;
	  if ((temp = strchr (link, ')')))	/* look for the closing bracket */
	    {
	      char *p_t1, *p_t;
	      p_t = p_t1 = xmalloc ((strlen (link) + 1) * sizeof (char));
	      for (++link; link != temp; *p_t++ = *link++);
	      *p_t = '\0';
	      link -= (strlen (p_t1) + sizeof (char));

	      if ((!strchr (p_t1, '(')) && (!is_in_manlinks (manlinks, p_t1)))
		{
		  char tempchar;
		  int breakpos;
		  i = link - tmp - 1;
		  if (i < 0)
		    i++;
		  for (; i > 0; --i)
		    {
		      if (tmp[i] != ' ')
			/* ignore spaces between linkname and '(x)' */
			break;
		    }
		  breakpos = i + 1;	/* we'll put zero on the last non-textual character of link */
		  tempchar = tmp[breakpos];	/* but remember the cleared char for the future */
		  tmp[breakpos] = 0;
		  for (i = breakpos; i > 0; --i)	/* scan to the first space sign or to 0 -- that means go to the beginning of the scanned token */
		    {
		      if (tmp[i] == ' ')
			{
			  i++;
			  break;
			}
		    }
		  /* now we have needed string in i..breakpos. We need now to realloc the manuallinks table to make free space for new entry */
		  manuallinks = xrealloc (manuallinks, sizeof (manuallink) * (ManualLinks + 3));
		  manuallinks[ManualLinks].line = ManualLines;
		  manuallinks[ManualLinks].row = i;
		  if(LongManualLinks)
		    {
  		      for(b=1;link[b]!=')';b++)
  		        manuallinks[ManualLinks].section[b-1] = tolower(link[b]);
  		      manuallinks[ManualLinks].section[b-1]=0;
  		    }
  		  else
  		    {
  		      manuallinks[ManualLinks].section[0]=link[1];
  		      manuallinks[ManualLinks].section[1]=0;
  		    }
  		  manuallinks[ManualLinks].section_mark=0;
		  manuallinks[ManualLinks].name = xmalloc ((breakpos - i) + 10);
		  strcpy (manuallinks[ManualLinks].name, tmp + i);
		  tmp[breakpos] = tempchar;
		  ManualLinks++;	/* increase the number of entries */
		}
	      xfree ((void *) p_t1);
	    }
	}
      if (link)
	link++;
      if (link > (tmp + tmpcnt))
	{
	  break;
	}
    }
  while (link != NULL);		/* do this line until strchr() won't
				   find a '(' in string */
}

int
manualwork ()
{
  FILE *pipe;			/* for user's shell commands */
  char *token;			/* a temporary buffer */
  char *tmp;			/* again the same */
  int key = 0;			/* key, which contains the value entered by user */
  int i, selectedchanged;	/* tmp values */
#ifdef getmaxyx
  getmaxyx (stdscr, maxy, maxx);	/* if ncurses, get maxx and maxy */
#else
  maxx = 80;
  maxy = 25;			/* otherwise hardcode 80x25... */
#endif /* getmaxyx */
  manualpos = manualhistory[manualhistorylength].pos;	/* get manualpos
							   from history.
							   it is set in
							   handlemanual() */
  if (manualhistory[manualhistorylength].selected != -1)	/* if there
								   was a valid
								   selected entry, 
								   apply it */
    selected = manualhistory[manualhistorylength].selected;
  else
    rescan_selected ();		/* otherwise scan for
				   selected on currently
				   viewed page */
  erase ();			/* clean screen */
  while (key != keys.quit_1)	/* user events loop. finish when
				   key_quit */
    {
      nodelay (stdscr, TRUE);	/* make getch not wait for user */
      key = pinfo_getch ();		/* action -- return ERR */
      if (key == ERR)		/* if there was nothing in buffer */
	{
	  showmanualscreen ();	/* then show screen */
	  nodelay (stdscr, FALSE);
	  key = pinfo_getch ();
	}
      else
	nodelay (stdscr, FALSE);

/************************ keyboard handling **********************************/
      if (key != 0)
	{
/*===========================================================================*/
	  if ((key == keys.shellfeed_1) ||
	      (key == keys.shellfeed_2))
	    {
	      /* get command name */
	      leaveok (stdscr, FALSE);
	      attrset (bottomline);
	      move (maxy - 1, 0);
	      echo ();
	      token = getstring (_ ("Enter command: "));	/* get users cmd */
	      noecho ();
	      move (maxy - 1, 0);
	      clrtoeol ();
	      attrset (normal);

	      endwin ();
	      system ("clear");
	      pipe = popen (token, "w");	/* open pipe */
	      if (pipe != NULL)
		{
		  for (i = 0; i < ManualLines; i++)	/* and flush the msg to stdin */
		    fprintf (pipe, "%s", manual[i]);
		  pclose (pipe);
		}
	      getchar ();
	      doupdate ();
	      leaveok (stdscr, HIDECURSOR);
	    }
/*===========================================================================*/
	  if ((key == keys.refresh_1) ||
	      (key == keys.refresh_2))
	    {
	      endwin ();
	      doupdate ();
	      refresh ();
	      leaveok (stdscr, HIDECURSOR);
	    }
/*===========================================================================*/
	  if ((key == keys.search_1) ||		/* search in current node */
	      (key == keys.search_2))
	    {
	      move (maxy - 1, 0);	/* procedure of getting regexp string */
	      attrset (bottomline);
	      echo ();
	      leaveok (stdscr, FALSE);
	      if (!searchagain.search)	/* 
					 * searchagain handler. see
					 * keys.totalsearch at mainfunction.c
					 * for comments
					 */
		{
		  token = getstring (_ ("Enter regexp: "));
		  strcpy (searchagain.lastsearch, token);
		  searchagain.type = key;
		}
	      else
		{
		  token = xmalloc (strlen (searchagain.lastsearch) + 1);
		  strcpy (token, searchagain.lastsearch);
		  searchagain.search = 0;
		}		/* end of searchagain handler */
	      if (strlen (token) == 0)
		{
		  token = xrealloc (token, 2);
		  strcpy (token, " ");
		}
	      leaveok (stdscr, HIDECURSOR);
	      noecho ();
	      move (maxy - 1, 0);
	      clrtoeol ();
	      attrset (normal);
	      pinfo_re_comp (token);	/* compile regexp expression */
	      for (i = manualpos + 1; i < ManualLines - 1; i++)
		/* and search for it in all subsequential lines */
		{
		  tmp = xmalloc (strlen (manual[i]) + strlen (manual[i + 1]) + 10);
		  strcpy (tmp, manual[i]);	/*
						 * glue two following lines
						 * together, to find expres-
						 * sions split up into two 
						 * lines
						 */
		  strcat (tmp, manual[i + 1]);
		  strip_manual (tmp);

		  if (pinfo_re_exec (tmp))	/* execute search */
		    {		/* if found, enter here... */
		      strcpy (tmp, manual[i + 1]);
		      strip_manual (tmp);
		      if (pinfo_re_exec (tmp))	/* 
						 * if it was found in the second line 
						 * of the glued expression.
						 */
			manualpos = i + 1;
		      else
			manualpos = i;
		      xfree (tmp);
		      break;
		    }
		  xfree (tmp);
		}
	      xfree (token);
	      rescan_selected ();
	    }
/*===========================================================================*/
	  if ((key == keys.search_again_1) ||	/* search again */
	      (key == keys.search_again_2))	/* see mainfunction.c for comments */
	    {
	      if (searchagain.type != 0)
		{
		  searchagain.search = 1;
		  ungetch (searchagain.type);
		}
	    }
/*===========================================================================*/
	  if ((key == keys.up_1) ||
	      (key == keys.up_2))
	    {
	      selectedchanged = 0;
	      if (selected != -1)	/* if there are links at all */
		{
		  if (selected > 0)	/* if one is selected */
		    for (i = selected - 1; i >= 0; i--)		/* 
								 * scan for a next
								 * visible one, which
								 * is above the current.
								 */
		      {
			if ((manuallinks[i].line >= manualpos) &&
			    (manuallinks[i].line < manualpos + (maxy - 1)))
			  {
			    selected = i;
			    selectedchanged = 1;
			    break;
			  }
		      }
		}
	      if (!selectedchanged)	/* if new link not found */
		{
		  if (manualpos > 1)	/* move one position up */
		    manualpos--;
		  for (i = 0; i < ManualLinks; i++)	/* 
							 * and scan for selected
							 * again :)
							 */
		    {
		      if (manuallinks[i].line == manualpos)
			{
			  selected = i;
			  break;
			}
		    }
		}
	    }
/*===========================================================================*/
	  if ((key == keys.end_1) ||
	      (key == keys.end_2))
	    {
	      manualpos = ManualLines - (maxy - 1);
	      rescan_selected ();
	    }
/*===========================================================================*/
	  if ((key == keys.pgdn_1) ||
	      (key == keys.pgdn_2))
	    {
	      if (manualpos + (maxy - 2) < ManualLines - (maxy - 1))
		manualpos += (maxy - 2);
	      else if (ManualLines - (maxy - 1) >= 1)
		manualpos = ManualLines - (maxy - 1);
	      else
		manualpos = 0;
	      rescan_selected ();
	    }
/*===========================================================================*/
	  if ((key == keys.home_1) ||
	      (key == keys.home_2))
	    {
	      manualpos = 0;
	      rescan_selected ();
	    }
/*===========================================================================*/
	  if ((key == keys.pgup_1) |
	      (key == keys.pgup_2))
	    {
	      if (manualpos > (maxy - 1))
		manualpos -= (maxy - 1);
	      else
		manualpos = 1;
	      rescan_selected ();
	    }
/*===========================================================================*/
	  if ((key == keys.down_1) ||
	      (key == keys.down_2))	/* top+bottom line \|/ */
	    {			/* see keys.up for comments */
	      selectedchanged = 0;
	      if (selected < ManualLinks)
		for (i = selected + 1; i < ManualLinks; i++)
		  {
		    if ((manuallinks[i].line >= manualpos) &&
			(manuallinks[i].line < manualpos + (maxy - 2)))
		      {
			selected = i;
			selectedchanged = 1;
			break;
		      }
		  }
	      if (!selectedchanged)
		{
		  if (manualpos < ManualLines - (maxy - 1))
		    manualpos++;
		  if (selected < ManualLinks)
		    for (i = selected + 1; i < ManualLinks; i++)
		      {
			if ((manuallinks[i].line >= manualpos) &&
			    (manuallinks[i].line < manualpos + (maxy - 2)))
			  {
			    selected = i;
			    selectedchanged = 1;
			    break;
			  }
		      }
		}
	    }
/*===========================================================================*/
	  if ((key == keys.back_1) ||
	      (key == keys.back_2))
	    {
	      if (manualhistorylength)
		return -2;
	    }
/*===========================================================================*/
	  if ((key == keys.followlink_1) ||
	      (key == keys.followlink_2))
	    {
	      manualhistory[manualhistorylength].pos = manualpos;
	      manualhistory[manualhistorylength].selected = selected;
	      if ((manuallinks[selected].line >= manualpos) &&
		  (manuallinks[selected].line < manualpos + (maxy - 1)))
		{
		      if (!strncmp(manuallinks[selected].section,"HTTPSECTION",11))
			{
			  char *tempbuf = xmalloc (strlen (manuallinks[selected].name) + strlen (httpviewer) + 10);
			  strcpy (tempbuf, httpviewer);
			  strcat (tempbuf, " ");
			  strcat (tempbuf, manuallinks[selected].name);
			  endwin ();
			  system (tempbuf);
			  doupdate ();
			  xfree (tempbuf);
			}
		      else if (!strncmp(manuallinks[selected].section,"FTPSECTION",10))
			{
			  char *tempbuf = xmalloc (strlen (manuallinks[selected].name) + strlen (ftpviewer) + 10);
			  strcpy (tempbuf, httpviewer);
			  strcat (tempbuf, " ");
			  strcat (tempbuf, manuallinks[selected].name);
			  endwin ();
			  system (tempbuf);
			  doupdate ();
			  xfree (tempbuf);
			}
		      else if (!strncmp(manuallinks[selected].section,"MAILSECTION",11))
			{
			  char *tempbuf = xmalloc (strlen (manuallinks[selected].name) + strlen (maileditor) + 10);
			  strcpy (tempbuf, maileditor);
			  strcat (tempbuf, " ");
			  strcat (tempbuf, manuallinks[selected].name);
			  endwin ();
			  system ("clear");
			  system (tempbuf);
			  doupdate ();
			  xfree (tempbuf);
			}
		      else
		        {
		          return selected;
		        }
		}
	    }
/*===========================================================================*/
/*********************** end of keyboard handling ***************************/
/********************************* mouse handler *****************************/
#ifdef NCURSES_MOUSE_VERSION
	  if (key == KEY_MOUSE)
	    {
	      MEVENT mouse;
	      int done = 0;
	      getmouse (&mouse);
	      if (mouse.bstate == BUTTON1_CLICKED)
		{
		  if ((mouse.y > 0) && (mouse.y < maxy - 1))
		    {
		      for (i = selected; i > 0; i--)
			{
			  if (manuallinks[i].line == mouse.y + manualpos - 1)
			    {
			      if (manuallinks[i].row <= mouse.x - 1)
				{
				  if (manuallinks[i].row + strlen (manuallinks[i].name) >= mouse.x - 1)
				    {
				      selected = i;
				      done = 1;
				      break;
				    }
				}
			    }
			}
		      if (!done)
			for (i = selected; i < ManualLinks; i++)
			  {
			    if (manuallinks[i].line == mouse.y + manualpos - 1)
			      {
				if (manuallinks[i].row <= mouse.x - 1)
				  {
				    if (manuallinks[i].row + strlen (manuallinks[i].name) >= mouse.x - 1)
				      {
					selected = i;
					done = 1;
					break;
				      }
				  }
			      }
			  }
		    }		/* end: mouse not on top/bottom line */
		  if (mouse.y == 0)
		    ungetch (keys.up_1);
		  if (mouse.y == maxy - 1)
		    ungetch (keys.down_1);
		}		/* end: button_clicked */
	      if (mouse.bstate == BUTTON1_DOUBLE_CLICKED)
		{
		  if ((mouse.y > 0) && (mouse.y < maxy - 1))
		    {
		      for (i = selected; i > 0; i--)
			{
			  if (manuallinks[i].line == mouse.y + manualpos - 1)
			    {
			      if (manuallinks[i].row <= mouse.x - 1)
				{
				  if (manuallinks[i].row + strlen (manuallinks[i].name) >= mouse.x - 1)
				    {
				      selected = i;
				      done = 1;
				      break;
				    }
				}
			    }
			}
		      if (!done)
			for (i = selected; i < ManualLinks; i++)
			  {
			    if (manuallinks[i].line == mouse.y + manualpos - 1)
			      {
				if (manuallinks[i].row <= mouse.x - 1)
				  {
				    if (manuallinks[i].row + strlen (manuallinks[i].name) >= mouse.x - 1)
				      {
					selected = i;
					done = 1;
					break;
				      }
				  }
			      }
			  }
		      if (done)
			ungetch (keys.followlink_1);
		    }		/* end: mouse not at top/bottom line */
		  if (mouse.y == 0)
		    ungetch (keys.pgup_1);
		  if (mouse.y == maxy - 1)
		    ungetch (keys.pgdn_1);
		}		/* end: button doubleclicked */
	    }
#endif
/*****************************************************************************/
	}
      if (key == keys.quit_2)
	break;
    }
  closeprogram ();
  return -1;
}

void
rescan_selected ()
{
  int i;
  for (i = 0; i < ManualLinks; i++)
    {
      if ((manuallinks[i].line >= manualpos) &&
	  (manuallinks[i].line < manualpos + (maxy - 1)))
	{
	  selected = i;
	  break;
	}
    }
}

void
showmanualscreen ()
{
  int i;
#ifdef getmaxyx
  getmaxyx (stdscr, maxy, maxx);	/* refresh maxy, maxx values */
#endif
  for (i = manualpos; (i < manualpos + (maxy - 2)) && (i < ManualLines); i++)
    /* print all visible text lines */
    {
      mvaddstr_manual ((i - manualpos) + 1, 0, manual[i]);
      clrtoeol ();
    }
  clrtobot ();			/* and clear to bottom */
  add_highlights ();		/* add highlights */
  attrset (bottomline);		/* draw bottomline with user informations */
  mymvhline (0, 0, ' ', maxx);
  mymvhline (maxy - 1, 0, ' ', maxx);
  move (maxy - 1, 0);
  if ((manualpos < ManualLines) && (ManualLines > maxy - 2))
    printw (_ ("Viewing line %d/%d, %d%%"), (manualpos - 1 + maxy), ManualLines, ((manualpos - 1 + maxy) * 100) / ManualLines);
  else
    printw (_ ("Viewing line %d/%d, 100%%"), ManualLines, ManualLines);
  move (maxy - 1, 0);
  attrset (normal);
}
void
mvaddstr_manual (int y, int x, char *str)	/* print a manual line */
{
  int i, len = strlen (str);
  move (y, x);
  for (i = 0; i < len; i++)
    {
      if ((i > 0) && (i < len - 1))
	{
	  if ((str[i] == 8) && (str[i - 1] == '_'))	/* handle bold highlight */
	    {
	      attrset (manualbold);
	      addch (str[i] & A_CHARTEXT);
	      addch (str[i + 1] & A_CHARTEXT);
	      attrset (normal);
	      i++;
	      goto label_skip_other;
	    }
	  else if (i < len - 3)	/* 
				 * if it wasn't bold, check italic, before 
				 * default, unhighlighted line will be painted.
				 * We can do it only if i<len-3.
				 */
	    goto label_check_italic;
	  else
	    /* unhighlighted */
	    {
	      addch (str[i] & A_CHARTEXT);
	      goto label_skip_other;
	    }
	}
      if (i < len - 3)		/* italic highlight */
	{
	label_check_italic:
	  if ((str[i + 1] == 8) && (str[i + 2] == str[i]))
	    {
	      attrset (manualitalic);
	      addch (str[i] & A_CHARTEXT);
	      i += 2;
	      attrset (normal);
	    }
	  else
	    {
	      addch (str[i] & A_CHARTEXT);
	    }
	}
    label_skip_other:
    }
}
void
add_highlights ()		/* add hyperobject highlights */
{
  int i;
  for (i = 0; i < ManualLinks; i++)	/* scan through the visible objects */
    {
      if ((manuallinks[i].line >= manualpos) &&
	  (manuallinks[i].line < manualpos + (maxy - 2)))
	{
	  if (manuallinks[i].section_mark < HTTPSECTION)
	    {
	      if (i == selected)
		attrset (noteselected);
	      else
		attrset (note);
	    }
	  else
	    {
	      if (i == selected)
		attrset (urlselected);
	      else
		attrset (url);
	    }
	  mvaddstr (1 + manuallinks[i].line - manualpos, manuallinks[i].row, manuallinks[i].name);
	  attrset (normal);
	}
    }
}
void
strip_manual (char *buf)	/* all variables passed here must have, say 10 bytes of overrun buffer */
{
  int i, tmpcnt = 0;
  for (i = 0; i < strlen (buf); i++)	/* in general, tmp buffer will hold a line stripped from highlight marks */
    {
      if ((buf[i] == '_') && (buf[i + 1] == 8))		/* so we strip the line from "'_',0x8" -- bold marks */
	{
	  buf[tmpcnt++] = buf[i + 2];
	  i += 2;
	}
      else if ((buf[i + 1] == 8) && (buf[i + 2] == buf[i]))	/* and 0x8 -- italic marks */
	{
	  buf[tmpcnt++] = buf[i];
	  i += 2;
	}
      else
	buf[tmpcnt++] = buf[i];	/* else we don't do anything */
    }
  buf[tmpcnt] = 0;
}

int
is_in_manlinks (char *in, char *find)
{
  char *copy, *token;
  const char delimiters[] = ":";

  copy = strdup (in);
  if ((strcmp (find, (token = strtok (copy, delimiters))) != 0))
    {
      while ((token = strtok (NULL, delimiters)))
	{
	  if (!strcmp (token, find))
	    {
	      xfree ((void *) copy);
	      return 0;
	    }
	}
      xfree ((void *) copy);
      return 1;
    }
  else
    {
      xfree ((void *) copy);
      return 0;
    }
}
