#include "common_includes.h"

void
freeindirect ()
{
  if (indirect)
    {
      xfree (indirect);
      indirect = 0;
    }
  IndirectEntries = 0;
}
void
freetagtable ()
{
  if (tag_table)
    {
      xfree (tag_table);
      tag_table = 0;
    }
  TagTableEntries = 0;
}

void
getnextnode (char *type, char *node)	/* read the `Next:' header entry */
{
  int i, j, coloncount = 0;
#ifndef ___USE_STATIC___
  char *tmp = xmalloc (strlen (type) + 1);
#else
  static char tmp[1024];
#endif
  strcpy (tmp, type);
  for (i = 0; i < strlen (tmp); i++)
    {
      if (tmp[i] == ':')
	{
	  coloncount++;
	  if (coloncount == 3)
	    {
	      for (j = i + 1; j < strlen (tmp); j++)
		{
		  if (tmp[j] == ',')
		    {
		      tmp[j] = 0;
		      sprintf (node, "%s", tmp + i + 2);
#ifndef ___USE_STATIC___
		      xfree (tmp);
#endif
		      return;
		    }
		}
	    }
	}
    }
#ifndef ___USE_STATIC___
  xfree (tmp);
#endif
}

void
getprevnode (char *type, char *node)	/* read the `Prev:' header entry */
{
  int i, j, coloncount = 0;
#ifndef ___USE_STATIC___
  char *tmp = xmalloc (strlen (type) + 1);
#else
  static char tmp[1024 + 1];
#endif
  strcpy (tmp, type);
  for (i = 0; i < strlen (tmp); i++)
    {
      if (tmp[i] == ':')
	{
	  coloncount++;
	  if (coloncount == 4)
	    {
	      for (j = i + 1; j < strlen (tmp); j++)
		{
		  if (tmp[j] == ',')
		    {
		      tmp[j] = 0;
		      strcpy (node, tmp + i + 2);
#ifndef ___USE_STATIC___
		      xfree (tmp);
#endif
		      return;
		    }
		}
	    }
	}
    }
#ifndef ___USE_STATIC___
  xfree (tmp);
#endif
}

void
getupnode (char *type, char *node)	/* read the `Up:' header entry */
{
  int i, j, coloncount = 0;
#ifndef ___USE_STATIC___
  char *tmp = xmalloc (strlen (type) + 1);
#else
  static char tmp[1024];
#endif
  strcpy (tmp, type);
  for (i = 0; i < strlen (tmp); i++)
    {
      if (tmp[i] == ':')
	{
	  coloncount++;
	  if (coloncount == 5)
	    {
	      for (j = i + 1; j < strlen (tmp); j++)
		{
		  if (tmp[j] == ',' || tmp[j] == '\n')
		    {
		      tmp[j] = 0;
		      sprintf (node, "%s", tmp + i + 2);
#ifndef ___USE_STATIC___
		      xfree (tmp);
#endif
		      return;
		    }
		}
	    }
	}
    }
#ifndef ___USE_STATIC___
  xfree (tmp);
#endif
}
