#ifndef __PARSE_CONFIG_H
#define __PARSE_CONFIG_H

#define BOLD 1
#define NO_BOLD 0

typedef struct keybindings
  {
    int totalsearch_1, totalsearch_2;
    int search_1, search_2;
    int goto_1, goto_2;
    int prevnode_1, prevnode_2;
    int nextnode_1, nextnode_2;
    int upnode_1, upnode_2;
    int up_1, up_2;
    int end_1, end_2;
    int pgdn_1, pgdn_2;
    int home_1, home_2;
    int pgup_1, pgup_2;
    int down_1, down_2;
    int top_1, top_2;
    int back_1, back_2;
    int followlink_1, followlink_2;
    int quit_1, quit_2;
    int refresh_1, refresh_2;
    int shellfeed_1, shellfeed_2;
    int dirpage_1, dirpage_2;
    int pgdn_auto_1, pgdn_auto_2;
    int pgup_auto_1, pgup_auto_2;
    int search_again_1, search_again_2;
  }
keybindings;

#ifndef NO_COLOR_CURSES
typedef struct colours
  {
    int normal_fore, normal_back, normal_bold;
    int menuselected_fore, menuselected_back, menuselected_bold;
    int menu_fore, menu_back, menu_bold;
    int noteselected_fore, noteselected_back, noteselected_bold;
    int note_fore, note_back, note_bold;
    int topline_fore, topline_back, topline_bold;
    int bottomline_fore, bottomline_back, bottomline_bold;
    int manualbold_fore, manualbold_back, manualbold_bold;
    int manualitalic_fore, manualitalic_back, manualitalic_bold;
    int url_fore, url_back, url_bold;
    int urlselected_fore, urlselected_back, urlselected_bold;
    int infohighlight_fore, infohighlight_back, infohighlight_bold;
  }
colours;
#endif /* NO_COLOR_CURSES */

int parse_config (void);
int parse_line (char *line);
char *str_toupper (char *s);
char *skip_whitespace (char *s);
char *remove_quotes (char *str);
#endif
