#include "common_includes.h"
#include <termios.h>
#include <sys/ioctl.h>

void
handle_crash (int signum)
{
  closeprogram ();
  fprintf (stderr, "catched signal %d\n", signum);
  perror ("pinfo: crash with");
  exit (1);
}

void
handle_window_resize (int signum)
{
#ifdef	USE_NCURSES
  struct winsize winsz;
  endwin ();
  ioctl (0, TIOCGWINSZ, &winsz);
  COLS = winsz.ws_col;
  LINES = winsz.ws_row;
  init_curses ();
#ifdef getmaxyx
  getmaxyx (stdscr, maxy, maxx);
#endif /* getmaxyx */
  ungetch (keys.refresh_1);
#endif /* getmaxyx */
  signal (SIGWINCH, handle_window_resize);
}

void
signal_handler ()
{
  signal (SIGINT, handle_crash);	/* handle ^C */
  signal (SIGTERM, handle_crash);	/* handle soft kill */
  signal (SIGSEGV, handle_crash);	/* handle seg. fault */
  signal (SIGHUP, handle_crash);	/* handle hup signal */
#ifdef SIGWINCH
  signal (SIGWINCH, handle_window_resize);
#endif
  sigblock (sigmask (SIGPIPE));	/* block broken pipe signal */
}
