#include "common_includes.h"

#ifdef ___DONT_USE_REGEXP_SEARCH___
char *pinfo_re_pattern = 0;
#endif

/*
 * Readline does not work well here. VT100 screen is ruined then.
 *
 * But if you want enable readline at compile time
 * [ ./configure --with-readline ]
 * 
 */

#ifdef HAS_READLINE
#include <readline.h>
#include <history.h>
#endif /* HAS_READLINE */


/* the bellow define enables malloc/realloc/free logging to stderr.
 * They start to log their argument values.
 *
 * #define ___DEBUG___
 *
 */

#ifdef ___DEBUG___
unsigned long malloc_addr[1000];
unsigned long msizes[1000];
long addrescount = 0;
#endif /* ___DEBUG___ */


int curses_open = 0;

void
xfree (void *ptr)
{
#ifdef ___DEBUG___
  int i, j;
  int flag = 0;
  unsigned long msize = 0;
  for (i = 0; i < addrescount; i++)
    msize += msizes[i];
  fprintf (stderr, "Size: %lu, count: %ld, freeing %lu\n", msize, addrescount, (unsigned long) ptr);
  for (i = 0; i < addrescount; i++)
    if (malloc_addr[i] == (unsigned long) ptr)
      {
	flag = 1;
	for (j = i + 1; j < addrescount; j++)
	  {
	    malloc_addr[j - 1] = malloc_addr[j];
	    msizes[j - 1] = msizes[j];
	  }
	addrescount--;
	break;
      }
  if (flag == 0)
    {
      fprintf (stderr, "ERROR!!!\n");
      getchar ();
    }
#endif /* ___DEBUG___ */
  free (ptr);
}

void *
xmalloc (size_t size)
{
  register void *value = malloc (size);
  memset (value, 0, size);
#ifdef ___DEBUG___
  unsigned long msize = 0;
  int i;
#endif /* ___DEBUG___ */
  if (value == 0)
    {
      closeprogram ();
      printf (_ ("Virtual memory exhausted\n"));
      exit (1);
    }
#ifdef ___DEBUG___
  for (i = 0; i < addrescount; i++)
    msize += msizes[i];
  fprintf (stderr, "Size %lu, count: %ld, allocated %lu\n", msize, addrescount, (unsigned long) value);
  malloc_addr[addrescount] = (unsigned long) value;
  msizes[addrescount] = size;
  if (addrescount < 1000)
    addrescount++;
  else
    {
      fprintf (stderr, "trace buffer exhausted\n");
    }
#endif /* ___DEBUG___ */
  return value;
}

void *
xrealloc (void *ptr, size_t size)
{
#ifdef ___DEBUG___
  int i, j, flag = 0;
  register void *value;
  unsigned long msize = 0;
  for (i = 0; i < addrescount; i++)
    msize += msizes[i];
  fprintf (stderr, "Size: %lu, count: %ld, reallocating %lu to ", msize, addrescount, (unsigned long) ptr);
  for (i = 0; i < addrescount; i++)
    if (malloc_addr[i] == (unsigned long) ptr)
      {
	flag = 1;
	for (j = i + 1; j < addrescount; j++)
	  {
	    malloc_addr[j - 1] = malloc_addr[j];
	    msizes[j - 1] = msizes[j];
	  }
	addrescount--;
	break;
      }
  if (flag == 0)
    {
      fprintf (stderr, "ERROR!!!\n");
      getchar ();
    }
  value = realloc (ptr, size + 1024);
#else
  register void *value = realloc (ptr, size + 1024);
#endif /* ___DEBUG___ */
  if (value == 0)
    {
      closeprogram ();
      printf (_ ("Virtual memory exhausted\n"));
      exit (1);
    }
#ifdef ___DEBUG___
  fprintf (stderr, "%lu, with size %lu\n", (unsigned long) value, (unsigned long) size);
  malloc_addr[addrescount] = (unsigned long) value;
  msizes[addrescount] = size;
  if (addrescount < 1000)
    addrescount++;
  else
    {
      fprintf (stderr, "trace buffer exhausted\n");
    }
#endif /* ___DEBUG___ */
  return value;
}

inline void
initlocale ()
{
#ifdef ___DEBUG___
  int i;
  for (i = 0; i < 1000; i++)
    malloc_addr[i] = 0;
#endif /* ___DEBUG___ */
  sbrk (100000);
  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
}

void
mymvhline (int y, int x, char ch, int len)
{
  int i;
  for (i = 0; i < len; i++)
    mvaddch (y, x + i, ch);
}

void
checkfilename (char *filename)
{
  if ((strchr (filename, '<')) ||
      (strchr (filename, '>')) ||
      (strchr (filename, '|')) ||
      (strchr (filename, '(')) ||
      (strchr (filename, ')')) ||
      (strchr (filename, '!')) ||
      (strchr (filename, '`')) ||
      (strchr (filename, '&')) ||
      (strchr (filename, ';')))
    {
      printf (_ ("Illegal characters in filename!\n*** %s\n"), filename);
      exit (1);
    }
}

char *
getstring (char *prompt)
{
/*
 * As above -- readline is dangerous ;)
 * But if you want enable readline at compile time 
 * [ ./configure --with-readline ]
 *
 */

#ifndef HAS_READLINE

  move (maxy - 1, 0);
  return readlinewrapper (prompt);

#else

  char *buf;
  leaveok (stdscr, FALSE);
  clrtoeol ();
  move (maxy - 1, 0);
  refresh ();
  sigblock (sigmask (SIGINT) | sigmask (SIGPIPE));
  endwin ();

  buf = readline (prompt);

  sigblock (sigmask (SIGPIPE));
  doupdate ();
  add_history (buf);
  return buf;
#endif

}

void
init_curses ()
{
  initscr ();
  noecho ();
  cbreak ();
  keypad (stdscr, TRUE);
/*  meta (stdscr, TRUE); */
  initcolors ();
  if (has_colors ())
    leaveok (stdscr, HIDECURSOR);
#ifdef NCURSES_MOUSE_VERSION
  mousemask (BUTTON1_CLICKED | BUTTON1_DOUBLE_CLICKED, NULL);
#endif /* NCURSES_MOUSE_VERSION */
  curses_open = 1;
}


void
closeprogram ()
{
  char str[1024];
  if (curses_open)
    endwin ();
  system ("clear");
  if (tmpfilename1)
    {
      unlink (tmpfilename1);
      xfree (tmpfilename1);
    }
  if (tmpfilename2)
    {
      unlink (tmpfilename2);
      xfree (tmpfilename2);
    }
}
int
gettagtablepos (char *node)
{
  int i;
  while (1)			/* strip spaces from the beginning */
    {
      if ((*node != ' ') && (*node != '\t'))
	break;
      node++;
    }
  for (i = 1; i <= TagTableEntries; i++)
    {
      if (strcmp (node, tag_table[i].nodename) == 0)
	return i;
    }
  return -1;
}
int
pinfo_getch ()
{
  int key = getch ();
  if (key == META_KEY)		/* following key will be alt's value */
    {
      key = getch ();
      key |= 0x200;
    }
  return key;
}
void 
pinfo_re_comp (char *name)
{
#ifdef ___DONT_USE_REGEXP_SEARCH___
  if (pinfo_re_pattern)
    {
      free (pinfo_re_pattern);
      pinfo_re_pattern = 0;
    }
  pinfo_re_pattern = strdup (name);
#else
  re_comp (name);
#endif
}
int 
pinfo_re_exec (char *name)
{
#ifdef ___DONT_USE_REGEXP_SEARCH___
  char *found;
  if (pinfo_re_pattern)
    {
      found = strstr (name, pinfo_re_pattern);
      if (found != NULL)
	return 1;
      else
	return 0;
    }
#else
  return re_exec (name);
#endif
}
