
#include "common_includes.h"

void info_add_highlights (int pos, int cursor);

void
substitutestr (char *src, char *dest, char *from, char *to)
/*
 * Utility for substituting strings in given string.
 * Used for internationalization of info headers.
 */
{
  char *start = strstr (src, from);
  char tmp;
  if (!start)
    strcpy (dest, src);
  else
    {
      tmp = *start;
      *start = 0;
      strcpy (dest, src);
      strcat (dest, to);
      *start = tmp;
      start += strlen (from);
      strcat (dest, start);
    }
}

void
addtopline (char *type)
{
  char *buf1 = xmalloc (strlen (type) + 50);
  char *buf2 = xmalloc (strlen (type) + 50);
  strcpy (buf1, type);

  substitutestr (buf1, buf2, "File:", _ ("File:"));
  substitutestr (buf2, buf1, "Node:", _ ("Node:"));
  substitutestr (buf1, buf2, "Next:", _ ("Next:"));
  substitutestr (buf2, buf1, "Prev:", _ ("Prev:"));
  substitutestr (buf1, buf2, "Up:", _ ("Up:"));
  attrset (topline);
  mymvhline (0, 0, ' ', maxx);	/* pads line with spaces -- estetic */
  if (strlen (buf2))
    buf2[strlen (buf2) - 1] = '\0';
  mvaddstr (0, 0, buf2);
  attrset (normal);
  xfree (buf1);
  xfree (buf2);
}

void
showscreen (char **message, char *type, long lines, long pos, long cursor)
{
  long i;
  for (i = pos; (i < lines - 1) && (i < pos + maxy - 1); i++)
    {
      mvaddstr (i + 1 - pos, 0, message[i]);
      clrtoeol ();
    }
  clrtobot ();
  attrset (bottomline);
  mymvhline (maxy - 1, 0, ' ', maxx);
  move (maxy - 1, 0);
  if ((pos < lines - 1) && (lines > maxy - 2))
    printw (_ ("Viewing line %d/%d, %d%%"), pos + maxy - 1, lines, ((pos + maxy - 1) * 100) / lines);
  else
    printw (_ ("Viewing line %d/%d, 100%%"), lines, lines);
  info_add_highlights (pos, cursor);
  attrset (normal);
  move (0, 0);
  refresh ();
}
void
info_add_highlights (int pos, int cursor)
{
  int i;
  for (i = 0; i < hyperobjectcount; i++)
    {
      if ((hyperobjects[i].line >= pos) &&
	  (hyperobjects[i].line < pos + (maxy - 2)))
	{
	  if (hyperobjects[i].type < 2)		/* menu */
	    {
	      if (i == cursor)
		attrset (menuselected);
	      else
		attrset (menu);
	    }
	  else if (hyperobjects[i].type < 4)	/* note */
	    {
	      if (i == cursor)
		attrset (noteselected);
	      else
		attrset (note);
	    }
	  else if (hyperobjects[i].type < HIGHLIGHT)	/* url */
	    {
	      if (i == cursor)
		attrset (urlselected);
	      else
		attrset (url);
	    }
	  else
	    /* quoted text -- highlight it */
	    {
	      attrset (infohighlight);
	    }
	  if (hyperobjects[i].file[0] == 0)
	    {
	      if (hyperobjects[i].breakpos == -1)
		{
		  mvaddstr (1 + hyperobjects[i].line - pos,
			    hyperobjects[i].row,
			    hyperobjects[i].node);
		}
	      else
		{
		  char tmp = hyperobjects[i].node[hyperobjects[i].breakpos];
		  hyperobjects[i].node[hyperobjects[i].breakpos] = 0;
		  mvaddstr (1 + hyperobjects[i].line - pos,
			    hyperobjects[i].row,
			    hyperobjects[i].node);
		  hyperobjects[i].node[hyperobjects[i].breakpos] = tmp;
		  if (hyperobjects[i].line - pos + 3 < maxy)
		    mvaddstr (1 + hyperobjects[i].line - pos + 1,
			      0,
			   hyperobjects[i].node + hyperobjects[i].breakpos);
		}
	    }
	  else
	    {
	      if (hyperobjects[i].breakpos == -1)
		{
		  move (1 + hyperobjects[i].line - pos,
			hyperobjects[i].row);
		  addstr ("(");
		  addstr (hyperobjects[i].file);
		  addstr (")");
		  addstr (hyperobjects[i].node);
		}
	      else
		{
		  static char buf[1024];
		  char tmp;
		  strcpy (buf, "(");
		  strcat (buf, hyperobjects[i].file);
		  strcat (buf, ")");
		  strcat (buf, hyperobjects[i].node);
		  tmp = buf[hyperobjects[i].breakpos];
		  buf[hyperobjects[i].breakpos] = 0;
		  mvaddstr (1 + hyperobjects[i].line - pos,
			    hyperobjects[i].row,
			    buf);
		  buf[hyperobjects[i].breakpos] = tmp;
		  if (hyperobjects[i].line - pos + 3 < maxy)
		    mvaddstr (1 + hyperobjects[i].line - pos + 1,
			      0,
			      buf + hyperobjects[i].breakpos);
		}
	    }
	  attrset (normal);
	}
    }
}
