	{ Ce schema decrit la presentation des paragraphes.

	  V. Quint	Novembre 1986 }

#ifdef DOUBLE
#define Paragraph_Skip 1.2
#define List_Skip 1.5
#else
#define Paragraph_Skip 0.3
#define List_Skip 0.6
#endif

PRESENTATION Paragraphe;

COUNTERS

   CptItemEnum : Rank of Item_\351num\351ration;

DEFAULT

   BEGIN
   HorizRef : Enclosed . HRef;
   VertRef : * . Left;
   Width : Enclosed . Width;
   Height : Enclosed . Height;
   VertPos : Top = Previous . Bottom;
   HorizPos : Left = Enclosing . Left;
   Justify : Enclosing =;
   LineSpacing : Enclosing =;
   Visibility: Enclosing =;
   Font : Enclosing =;
   Style : Enclosing =;
   Size : Enclosing =;
   Adjust : Enclosing =;
   Indent : Enclosing =;
   Depth : 0;
   UnderLine: Enclosing =;
   Thickness: Enclosing =;
   LineStyle: Enclosing =;
   LineWeight: Enclosing =;
   Background: Enclosing =;
   Foreground: Enclosing =;
   FillPattern: Enclosing =; 
   Hyphenate: Enclosing =; 
   END;

BOXES

   BoitePuce :
	BEGIN
	Content : text Greek '\267';	{ puce ou boulet }
	VertPos : HRef = Next . HRef;
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   BoiteTiret :
        BEGIN
        Content : text Greek '-';
        VertPos : HRef = Next . HRef;
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoitePlus :
        BEGIN
        Content : text '+';
        VertPos : HRef = Next . HRef;
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteDoublePlus :
        BEGIN
        Content : text '++';
        VertPos : HRef = Next . HRef;
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteEtoile :
        BEGIN
        Content : text '*';
        VertPos : HRef = Next . HRef;
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteDiamant :
        BEGIN
        Content : text Greek '\250';
        VertPos : HRef = Next . HRef;
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
        END;

   BoiteEnumArabe:
	BEGIN
	Content : (Value(CptItemEnum, Arabic) text '.');
	VertPos : HRef = Next . HRef;
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   BoiteEnumRomain:
	BEGIN
	Content : (Value(CptItemEnum, URoman));
	VertPos : HRef = Next . HRef;
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   BoiteEnumRomainMin:
	BEGIN
	Content : (Value(CptItemEnum, LRoman));
	VertPos : HRef = Next . HRef;
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   BoiteEnumMaj:
	BEGIN
	Content : (Value(CptItemEnum, Uppercase));
	VertPos : HRef = Next . HRef;
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   BoiteEnumMin:
	BEGIN
	Content : (Value(CptItemEnum, Lowercase) text ')');
	VertPos : HRef = Next . HRef;
	Font : Creator =;
	Size : Creator =;
	Style: Creator =;
	Foreground: Creator =;
	Background: Creator =;
	END;

   CadreFin:
	BEGIN
	Width : Enclosing . Width;
	VertPos : Top = Creator . Top - 1;
	Height : Creator . Height + 2;
	Content : Graphics 'R';
	LineWeight : 0.5 pt;
	LineStyle : Solid;
	Depth : Creator + 1;
	Foreground: Creator =;
	END;

   CadreEpais:
	BEGIN
	Width : Enclosing . Width;
	VertPos : Top = Creator . Top - 0.8;
	Height : Creator . Height + 1.6;
	Content : Graphics 'R';
	LineWeight : 2 pt;
	LineStyle : Solid;
	Depth : Creator + 1;
	Foreground: Creator =;
	END;

   CadrePointille:
	BEGIN
	Width : Enclosing . Width;
	VertPos : Top = Creator . Top - 1;
	Height : Creator . Height + 2;
	Content : Graphics 'R';
	LineWeight : 0.5 pt;
	LineStyle : Dashed;
	Depth : Creator + 1;
	Foreground: Creator =;
	END;

   CadreTrame:
	BEGIN
	Width : Enclosing . Width;
	VertPos : Top = Creator . Top - 1;
	Height : Creator . Height + 2;
	Content : Graphics 'R';
	FillPattern : backgroundcolor;
	Background : Creator =;
	Foreground: Creator =;
        LineWeight : 0.5 pt;
        LineStyle : Solid;
	Depth : Creator + 1;
	END;

   FiletVert1:
	BEGIN
	VertPos : Top = Creator . Top;
	Height : Creator . Height;
	Content : Graphics 'v';
        LineWeight : 0.5 pt;
        LineStyle : Solid;
	Foreground: Creator =;
	END;

   FiletVert2:
	BEGIN
	HorizPos : Left = Enclosing . Left + 0.5;
	VertPos : Top = Creator . Top;
	Height : Creator . Height;
	Content : Graphics 'v';
        LineWeight : 0.5 pt;
        LineStyle : Solid;
	Foreground: Creator =;
	END;

   FiletHaut1:
	BEGIN
	Width : Enclosing . Width;
	VertPos : Top = Enclosing . Top + 0.5;
	Height : 0.5;
	Content : Graphics 't';
        LineWeight : 3 pt;
        LineStyle : Solid;
	Foreground: Creator =;
	END;

   FiletHaut2:
	BEGIN
	Width : Enclosing . Width;
	VertPos : Top = FiletHaut1 . Top + 0.2;
	Height : 0.3;
	Content : Graphics 't';
        LineWeight : 0.5 pt;
        LineStyle : Solid;
	Foreground: Creator =;
	END;

   FiletBas1:
	BEGIN
	Width : Enclosing . Width;
	VertPos : Top = Previous . Bottom + 0.8;
	Height : 0.6;
	Content : Graphics 't';
        LineWeight : 3 pt;
        LineStyle : Solid;
	Foreground: Creator =;
	END;

   FiletBas2:
	BEGIN
	Width : Enclosing . Width;
	VertPos : Bottom = FiletBas1 . Top;
	Height : 0.3;
	Content : Graphics 'h';
        LineWeight : 0.5 pt;
        LineStyle : Solid;
	Foreground: Creator =;
	END;

RULES

   Paragraphe :
	BEGIN
	Width : Enclosing . Width;
	NoBreak1: 2;
	NoBreak2: 2;
	VertPos : Top = Previous . Bottom + Paragraph_Skip;
#ifdef DOUBLE
	LineSpacing : 2.2;
#else
	LineSpacing : 1.1;
#endif
	END;

   Simple_paragraphe :
	BEGIN
	Line;
	Width : Enclosing . Width;
	VertPos : Top = Previous . Bottom + Paragraph_Skip;
	NoBreak1 : 2;
	NoBreak2 : 2;
	END;

   Citation :
	BEGIN
	Line;
	Width : Enclosing . Width - 6;
	HorizPos : Left = Enclosing . Left + 3;
	VertPos : Top = Previous . Bottom + Paragraph_Skip;
	Indent : 1;
	NoBreak1 : 2;
	NoBreak2 : 2;
	END;

   Exemple :
	BEGIN
	Hyphenate : No; 
	Width : Enclosing . Width - 3;
	HorizPos : Right = Enclosing . Right;
	VertPos : Top = Previous . Bottom + Paragraph_Skip;
	Font : Courrier;
	NoBreak1 : 2;
	NoBreak2 : 2;
	END;

   Ligne_exemple :
	BEGIN
	Width : Enclosing . Width;
	Justify : No;
	Line;
	Indent : -2;
	END;

   Enum\351ration :
	BEGIN
	IF within Liste
	   Width : Enclosing . Width;
	IF within Enum\351ration
	   Width : Enclosing . Width;
	IF within Paragraphe_titr\351
	   Width : Enclosing . Width;
	IF not within Liste and not within Enum\351ration and not within Paragraphe_titr\351
	   Width : Enclosing . Width - 1;
	HorizPos : Right = Enclosing . Right;
	VertPos : Top = Previous . Bottom + List_Skip;
	Indent : 0;
	END;

   Item_\351num\351ration :
	BEGIN
	Width : Enclosing . Width - 1.5;
	HorizPos : Right = Enclosing . Right;
	VertPos : Top = Previous AnyElem . Bottom + Paragraph_Skip;
	NoBreak1 : 2;
	NoBreak2 : 2;
	END;

   Liste :
	BEGIN
	IF within Liste
	   Width : Enclosing . Width;
	IF within Enum\351ration
	   Width : Enclosing . Width;
	IF not within Liste and not within Enum\351ration
	   Width : Enclosing . Width - 1;
	HorizPos : Right = Enclosing . Right;
	VertPos : Top = Previous . Bottom + List_Skip;
	Indent : 0;
	END;

   Item_liste :
	BEGIN
	Width : Enclosing . Width - 1.5;
	HorizPos : Right = Enclosing . Right;
	VertPos : Top = Previous AnyElem . Bottom + Paragraph_Skip;
	NoBreak1 : 2;
	NoBreak2 : 2;
	END;

   Description :
	BEGIN
	Width : Enclosing . Width;
	VertPos : Top = Previous . Bottom + List_Skip;
	Indent : 0;
	END;

   Element_Description :
	BEGIN
	Width : Enclosing . Width;
	VertPos : Top = Previous . Bottom + Paragraph_Skip;
	NoBreak1 : 2;
	NoBreak2 : 2;
	END;

   Intitul\351_descr :
	BEGIN
	Hyphenate : No; 
	Line;
	PageBreak : No;
	Justify : No;
	Width : 9.3;
	Style: Bold;
	VertPos : HRef = Texte_description . HRef;
	END;

   Texte_description :
	BEGIN
	Width : Enclosing . Width - 10;
	HorizPos : Right = Enclosing . Right;
	VertPos : Top = Enclosing . Top;
	END;

   Paragraphe_titr\351 :
	BEGIN
	Width : Enclosing . Width;
	VertPos : Top = Previous . Bottom + 2.5;
	Indent : 0;
	NoBreak1 : 2;
	NoBreak2 : 2;
	END;

   Titre_parag :
	BEGIN
	Hyphenate : No; 
	Style : Bold;
	Line;
	Justify : No;
	Indent : -3;
	Width : Enclosing . Width;
	VertPos : Top = Enclosing . Top + Paragraph_Skip;
	END;

   Contenu_parag :
	BEGIN
	Width : Enclosing . Width - 2.5;
	HorizPos : Right = Enclosing . Right;
	VertPos : Top = Previous . Bottom + Paragraph_Skip;
	NoBreak1 : 2;
	NoBreak2 : 2;
	END;

   Programme_indent\351 :
	BEGIN
	Hyphenate : No; 
	Indent : 0;
	Font : Courier;
	Width : Enclosing . Width - 2.5;
	HorizPos : Right = Enclosing . Right;
	VertPos : Top = Previous . Bottom + 0.5;
	END;

   El\351ment_de_pgm :
	BEGIN
	Width : Enclosing . Width;
	END;

   Instruction :
	BEGIN
	Line;
	Width : Enclosing . Width;
	END;

   Bloc_instructions :
	BEGIN
	Width : Enclosing . Width - 2;
	HorizPos : Right = Enclosing . Right;
	END;

   Cote_a_cote :
	BEGIN
	Width : Enclosing . Width;
	PageBreak: No;
	Gather: Yes;
	END;

   A_droite :
	BEGIN
	Width : Enclosing . Width * 48%;
	VertPos : Top = Enclosing . Top;
	HorizPos : Right = Enclosing . Right;
	END;

   A_gauche :
	BEGIN
	Width : Enclosing . Width * 48%;
	VertPos : Top = Enclosing . Top;
	END;

   Paragraphes_group\351s :
	BEGIN
	VertPos : Top = Enclosing . Top + Paragraph_Skip;
	Width : Enclosing . Width - 2;
	HorizPos : Left = Enclosing . Left + 1;
	END;

   GRAPHICS_UNIT:
	BEGIN
	Width : 2;
	Height : 1;
	END;

   SYMBOL_UNIT:
	BEGIN
	Width : 1;
	Height : 1;
	END;
	
ATTRIBUTES

   Marque_item(Item_liste) = Puce:
	BEGIN
	CreateBefore(BoitePuce);
	END;
   Marque_item(Item_liste) = Tiret:
	BEGIN
	CreateBefore(BoiteTiret);
	END;
   Marque_item(Item_liste) = Plus:
	BEGIN
	CreateBefore(BoitePlus);
	END;
   Marque_item(Item_liste) = DoublePlus:
	BEGIN
	CreateBefore(BoiteDoublePlus);
	END;
   Marque_item(Item_liste) = Etoile:
	BEGIN
	CreateBefore(BoiteEtoile);
	END;
   Marque_item(Item_liste) = Diamant:
	BEGIN
	CreateBefore(BoiteDiamant);
	END;
   Marque_item(Item_liste) = D\351faut:
	BEGIN
	IF within 1 Liste
	   CreateBefore(BoitePuce);
	IF within 2 Liste
	   CreateBefore(BoiteTiret);
	IF within >2 Liste
	   CreateBefore(BoitePlus);
	END;

   Numero_item(Item_\351num\351ration) = Chiffre_arabe:
	BEGIN
	CreateBefore (BoiteEnumArabe);
	END;
   Numero_item(Item_\351num\351ration) = Romain_majuscule:
	BEGIN
	CreateBefore (BoiteEnumRomain);
	END;
   Numero_item(Item_\351num\351ration) = Romain_minuscule:
	BEGIN
	CreateBefore (BoiteEnumRomainMin);
	END;
   Numero_item(Item_\351num\351ration) = Lettre_majuscule:
	BEGIN
	CreateBefore (BoiteEnumMaj);
	END;
   Numero_item(Item_\351num\351ration) = Lettre_minuscule:
	BEGIN
	CreateBefore (BoiteEnumMin);
	END;

   Valeur_Indentation(Bloc_instructions):
	Width : Enclosing . Width - Valeur_Indentation;

   Mise_en_valeur = Cadre_fin:
	BEGIN
	CreateAfter(CadreFin);
	VertPos : Top = Enclosing . Top + 1.3;
	END;

   Mise_en_valeur = Cadre_\351pais :
	BEGIN
	CreateAfter(CadreEpais);
	VertPos : Top = Enclosing . Top + 1.3;
	END;

   Mise_en_valeur = Cadre_pointill\351:
	BEGIN
	CreateAfter(CadrePointille);
	VertPos : Top = Enclosing . Top + 1.3;
	END;

   Mise_en_valeur = Fond_couleur:
	BEGIN
	CreateAfter(CadreTrame);
	VertPos : Top = Enclosing . Top + 1.3;
	END;

   Mise_en_valeur = Filet_gauche_simple:
	BEGIN
	CreateAfter(FiletVert1);
	Width : Enclosing . Width - 1;
	HorizPos : Left = Enclosing . Left + 1;
	END;

   Mise_en_valeur = Filet_gauche_double:
	BEGIN
	CreateAfter(FiletVert1);
	CreateAfter(FiletVert2);
	Width : Enclosing . Width - 1;
	HorizPos : Left = Enclosing . Left + 1;
	END;

   Mise_en_valeur = Filet_horiz_simple:
	BEGIN
	CreateFirst(FiletHaut1);
	CreateLast(FiletBas1);
	VertPos : Top = Enclosing . Top + 0.5;
	Width : Enclosing . Width - 2;
	HorizPos : Left = Enclosing . Left + 1;
	END;

   Mise_en_valeur = Filet_horiz_double:
	BEGIN
	CreateFirst(FiletHaut1);
	CreateFirst(FiletHaut2);
	CreateLast(FiletBas1);
	CreateLast(FiletBas2);
	VertPos : Top = Enclosing . Top + 0.5;
	Width : Enclosing . Width - 2;
	HorizPos : Left = Enclosing . Left + 1;
	END;

END
