/*
 *
 *  (c) COPYRIGHT MIT and INRIA, 1996.
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */

#ifndef STYLE_CSS_H
#define STYLE_CSS_H

/* included headers */
#include "thot_gui.h"
#include "thot_sys.h"

#include "document.h"
#include "pschema.h"
#include "constint.h"


#define EOS     '\0'	/* various chars */
#define EOL     '\n'
#define TAB     '\t'
#define SPACE    ' '

#define MAX_LENGTH     512
#define DocumentTableLength MAX_DOCUMENTS

#define SHEET_ATTR_NAME "StyleSheets"  /* schema extension related names */
#define SHEET_EXT_NAME "ExtCss"
#define PRES_NAME "ExtCssP"
#define CSS_FILE_EXTENSION ".css"

/*
 * A macro needed to help building the parser.
 */

typedef char    StyleReadChar();

#define SKIP_BLANK(ptr) \
     { while (((*(ptr)) == SPACE) || ((*(ptr)) == '\b') || \
              ((*(ptr)) == EOL  ) || ((*(ptr)) == '\r') || \
	      ((*(ptr)) == '\t')) ptr++; }



/************************************************************************
 *                                                                      *
 *                         STRUCTURES DEFINITION                        *
 *                                                                      *
 ************************************************************************/

/*
 * The CSSInfo structure
 */

typedef enum
{
  CSS_BROWSE_None,		/* No browsing operation current */
  CSS_BROWSE_SaveAll,	        /* Saving all modified CSS files */
  CSS_BROWSE_SaveAs,		/* Saving one CSS file to local filesystem */
  CSS_BROWSE_Loading		/* Browsing local filesystem to find CSS files */
}
CSSBrowseStatus;

typedef struct CSSRuleSchemas
{
  struct CSSRuleSchemas  *NextSchemas;
  PSchema             CssPSchema;
  SSchema             CssSSchema;
}
CSSRuleSchemas         , *CSSRuleSchemasPtr;

typedef struct CSSRule
{
  struct CSSRule     *nextrule;
  char               *rule;
  SSchema             cssSSchema;
  int                 eltype;
}
CSSRule                , *CSSRulePtr;

typedef struct CSSInfo
{
  struct CSSInfo     *nextcss;   /* ptr on next sheet in list */
  char               *name;      /* the CSS name */
  char               *filename;  /* the CSS filename with complete path */
  CSSRuleSchemasPtr   schemas;   /* the sheet associated schemas */
  boolean             documents[DocumentTableLength + 1];
                                 /* documents using this CSS. !!!!! unused */
  char               *css_rule;  /* The original CSS text. Needed for 
				    the Dismiss function */
  CSSRulePtr          ruleslist; /* The list of rules of this sheet. */
  CSSRulePtr          badruleslist;  /* The list of rules found when reading 
				       this sheet, but not recognised. */
  int                 modified;  /* tells whether the image file of this 
				    css is up to date */
  /*
   * Extra informations needed to support presentation not
   * currently available at the P level.
   */
  int                 view_background_color;
  int                 magnification;
}
CSSInfo            , *CSSInfoPtr;


#endif /* STYLE_CSS_H */
