/* ---------------------------------------------------------------------
   fonctions de pattern matching 
   ---------------------------------------------------------------------- */
/* Included headerfiles */
#include "thot_gui.h"
#include "thot_sys.h"
#include "application.h"
#include "content.h"
#include "tree.h"
#include "browser.h"
#include "interface.h"
#include "selection.h"
#include "dialog.h"
#include "app.h"
#include "message.h"
#define VSTATUS extern
#include "trans.h"
#define MAX_CAR 100
/* fonctions du  parser trans utilisees ici */
#ifdef __STDC__
extern void freelist(ListSymb *pl);
#else
extern void freelist(ListSymb *pl);
#endif

/* variables du pattern matching)*/

/*pile */
static struct _stack
{
  Tagnode *Node;
  ListSymb *Val;
}pile[MAXSTACK];

static int taillepile;

/* ----------------------------------------------------------------------
   compatibletagtype 
   retourne vrai si tag est compatible avec elemType
  ---------------------------------------------------------------------- */
#ifdef __STDC__
boolean compatibletagtype (char *tag, ElementType elemType)
#else /*__STDC__*/
boolean compatibletagtype (tag, elemType)
char *tag;
ElementType elemType;
#endif /*__STDC__*/
{
  if (strcmp (TtaGetElementTypeOriginalName (elemType), tag) == 0)
    return TRUE;
  if (strcmp (tag, "*") == 0)
    return TRUE;
  return FALSE;
}

/* ----------------------------------------------------------------------
   intersectmatch  
   construit la liste res intersection dedes listes l1 et l2
   ---------------------------------------------------------------------- */ 
#ifdef __STDC__
static void intersectmatch (ListSymb **res,ListSymb *LS, strmatch *MS)
#else /*__STDC__*/
static void intersectmatch (res,LS,MS)
ListSymb **res;
ListSymb *LS;
strmatch *MS;
#endif /*__STDC__*/
{
  ListSymb *pLS, *pres;
  strmatch *pMS;
  boolean found;
  
  if(*res!=NULL)
    {
      freelist(*res);
      *res=NULL;
    }
  pres=NULL;
  pLS=LS;
  while(pLS!=NULL)
    {  
      pMS=MS;
      found =False;
      while(!found && pMS!=NULL)
	{  
	  found = (pMS->patsymb==pLS->symb);
	  pMS=pMS->next;
	}
      if(found)
	{
	  if(pres==NULL)
	    {
	      *res = (ListSymb *)TtaGetMemory(sizeof(ListSymb));
	      pres=*res;
	    }
	  else
	    {
	      pres->next= (ListSymb *)TtaGetMemory(sizeof(ListSymb));
	      pres=pres->next;
	    }
	  pres->next=NULL;
	  pres->symb=pLS->symb;
	}
      pLS=pLS->next;
    }
}




/* pile de noeuds  pour l'algo de pattern matching (children_match)*/
void init_pile()
{
  int i;
  for (i=0;i<MAXSTACK;i++) 
    {
      pile[i].Node=NULL;
      pile[i].Val =NULL;
    }
  taillepile=0;
}

void empile(Tagnode *t,ListSymb *v)
{
  if (taillepile<MAXSTACK)
    {	
      pile[taillepile].Node=t;
      pile[taillepile++].Val=v;
    }
  else
    {
      printf ("Stack overflow \n");
    }
}



void depile(Tagnode **t,ListSymb **v)
{
  if (taillepile>0)
    {
      *t=pile[--taillepile].Node;
      *v=pile[taillepile].Val;
      pile[taillepile].Node=NULL;
      pile[taillepile].Val=NULL;
    }
  else
    {
      *t=NULL;
      *v=NULL;
    }
}

/* ---------------------------------------------------------------------- */
/*       constlistmatch(node,symb) ajoute symb a la liste des matches du noeud  node	*/
/*	la liste des fils est mise a jour avec le contenu de la pile */
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
static void constlistmatch(Tagnode *node,SymbDesc *symb) 
#else /*__STDC__*/
static void constlistmatch(node,symb) 
Tagnode *node;
SymbDesc *symb;
#endif /*__STDC__*/
{
  strmatch *sm;
  strmatchchildren *smc;
  Tagnode *n;
  ListSymb *dl;

  sm=node->matches;
  if(sm==NULL)
    {
      node->matches=(strmatch *)TtaGetMemory(sizeof(strmatch));
      sm=node->matches;
    }
  else
    {
      while(sm->next!=NULL && sm->patsymb!=symb)
	sm=sm->next;
      if(sm->patsymb!=symb)
	{
	  sm->next=(strmatch *)TtaGetMemory(sizeof(strmatch));
	  sm=sm->next;
	}
      else
	return;
    }
  sm->patsymb=symb;
  sm->node=node;
  sm->next=NULL;
  sm->childmatches=NULL;
  depile(&n,&dl);
  while(n!=NULL)
    {
      smc=(strmatchchildren *)TtaGetMemory(sizeof(strmatchchildren));
      smc->next=sm->childmatches;
      sm->childmatches=smc;
      smc->patsymb=dl->symb;
      smc->node=n;
      depile(&n,&dl);
    }
}

/* ---------------------------------------------------------------------- */
/* children_match retourne True si les fils du noeud n sont compatibles avec ceux de p*/
/* ---------------------------------------------------------------------- */

#ifdef __STDC__
static boolean children_match(Tagnode *n,SymbDesc *p)
#else /*__STDC__*/
static boolean children_match(n,p)
Tagnode *n;
SymbDesc *p;
#endif /*__STDC__*/
{
  Tagnode *child, *childmatched;
  ListSymb *candidat, *ms;
  boolean matchfound,matchfailed;

  matchfound = False;
  matchfailed = False;

/*   candidat = match_env.TabChild[p][0]; */
  candidat = p->Children;
  if (candidat == NULL)
    /* s'il n'y a pas de fils possible pour n dans la pattern, on retourne vrai */
    {
      constlistmatch(n,p);
      return True;
    }
  if (n->child == NULL)
    /* s'il y a un fils possible dans la pattern et n est une feuille */
    {
      if(p->OptChild)
	{
	  constlistmatch(n,p);
	  return True;
	}
      else
	return False;
    }
  /* on cherche un match pour chacun des fils possibles de la pattern (candidat) */
  /* child est initialise avec le premier fils de n */
  child = n->child;
  childmatched=child;
  intersectmatch(&(child->inter), p->Children,child->matches);
  candidat=child->inter;
  if (candidat==NULL)
    {
      return False;
    }
  init_pile();
  while (!matchfailed && !matchfound)
    {
      if (child == NULL && (candidat!=NULL && candidat->symb==NULL))
	{ 
	  /* tous les fils matchent, il faut depiler en gardant les relations */ 
	  /* on construit la liste des symboles matche's par les fils sur le noeud pere */
	  constlistmatch(n,p);
	  matchfound = True;
	}
      else if (child == NULL || candidat ==NULL || candidat->symb == NULL)/* && candidat !=0*/
	{
	  /* on est sur une mauvaise branche */
	  /* on depile tant qu'on a pas une autre alternative */
	  depile(&child,&ms);
	  while(child!=NULL && 
		ms->next==NULL)
	    depile(&child,&ms);
	  if(child==NULL)
	    {
	      matchfailed=True;
	      /* aucun matching n'a ete trouve (fond de la pile) */
	      /*on sort de la boucle avec matchfailed */
	    }
	  else
	    {/* un autre candidat n'a pas encore pu etre essaye */
	      candidat = ms->next;
	    }
	}      
      else 
	{ /* inv :  child!=NULL && candidat != -1*/	  
	  /* il faut comparer le noeud suivant avec les successeurs possibles */
	  /* du candidat  */

	  /* on empile le noeud, et le candidat */
	
	  empile(child,candidat);
	  /* s'il existe un fils suivant */
	  if(child->next!=NULL)
	    {
	      /* on determine l'ensemble des candidats du suivant */
	      intersectmatch(&(child->next->inter),
			     candidat->symb->Nexts,
			     child->next->matches);			     
	      /* on commence par le premier */
	      candidat = child->next->inter;
	    }
	  else /* inv : child->next==NULL */
	    {
	      /* candidat = (rankintabdesc(match_env.TabNext[candidat],0,MaxWidthPat)!=-1?0:-1); */ 
	      ms = candidat->symb->Nexts;
	      while (ms!=NULL && ms->symb!=NULL)
		ms=ms->next;
	      if (ms!=NULL)
		candidat=ms;
	    }
	  child=child->next;
	}
    }
  /* match_env.TabChild[p][0] est nul si les fils du symbole p sont optionnels */
  if(!matchfound && p->OptChild)
    {
      constlistmatch(n,p);
      matchfound=True;
    }
  return matchfound;
}

/* ---------------------------------------------------------------------- */
#ifdef __STDC__
static boolean matchattr(SymbDesc *pSymb,Element elem)
#else /* __STDC__*/
static boolean matchattr(pSymb, elem)
SymbDesc *pSymb;
Element elem;
#endif /* __STDC__*/
{
  boolean result;
  AttrDesc *pAttr;
  AttributeType AttrType;
  Attribute attr;
  char * buf;
  int AttrKind, length;

  buf = TtaGetMemory(MAX_CAR);
  AttrType.AttrSSchema=TtaGetElementType(elem).ElSSchema;
  result=True;
  pAttr=pSymb->Attributes;
  while(pAttr!=NULL && result)
    {
      TtaGiveAttributeTypeFromName(pAttr->NameAttr, elem,&AttrType,&AttrKind);
      if(AttrType.AttrTypeNum!=0)
	{
	  attr=TtaGetAttribute(elem,AttrType);
	  result=(attr!=(Attribute)NULL);
	}
      if (result)
	{ 
	  TtaGiveAttributeType(attr,&AttrType,&AttrKind);
	  switch(AttrKind)
	    {
	    case 0:	/* enumere */
	    case 1:	/* entier */
	      result = (TtaGetAttributeValue(attr)==atoi(pAttr->Value));
	      break;
	    case 2:	/* texte */
	      length = MAX_CAR;
	      TtaGiveTextAttributeValue(attr, buf, &length);
	      result =  !strcmp(pAttr->Value,buf);
	      break;
	    case 3:
	      result = False;
	      break;
	    }
	}
      pAttr=pAttr->next;
    }
  TtaFreeMemory(buf);
  return result;
}


/* ---------------------------------------------------------------------- */
/*matchnode : construit la liste des pointeurs sur la pattern correspondant aux	*/
/* matching possibles du noeud. Cette liste est calculee en fonction des		*/
/* du noeud et du constructeur dans la pattern				*/
/* ---------------------------------------------------------------------- */
#ifdef __STDC__
static boolean matchnode(Tagnode *n)
#else /* __STDC__*/
static boolean matchnode(n)
Tagnode *n;
#endif /* __STDC__*/
{
  TransDesc *td;
  SymbDesc *sd;
  trans_sch* transSch;

  transSch = match_env.transSet;
  while (transSch!=NULL)
    {
      if(transSch->active)
	{
	  td= transSch->Transformations;
	  while(td!=NULL)
	    {
	      if(td->ActiveTrans)
		{
		  sd=td->PatSymbs;
		  /* pour chaque occurence du tag dans la pattern, */
		  /*ou pour une etoile */
		  /* on regarde si les fils de n sont compatibles avec */
		  /* les tags des fils possibles de la pattern  */
		  while (sd!=NULL)
		    {
		      if (sd->ActiveSymb)
			if(n->depth - sd->depth <= match_env.maxSelDepth && n->depth - sd->depth >=0)
			  if (!strcmp (sd->Tag,"*") || 
			      compatibletagtype (sd->Tag,n->eltype))
			    if (sd->Attributes == NULL || matchattr(sd,n->element))
			      children_match(n,sd);
		      sd=sd->next;
		    }     
		  children_match(n,td->rootdesc);
		}
	      td=td->next;
	    }
	}
      transSch=transSch->next;
    }
  return True;
}

/* ---------------------------------------------------------------------- */
/* parcours postfixe de l'arbre, applicant la fonction booleenne f a tous les	*/
/* noeuds de l'arbre t							*/
/* cond ition d'arret sur un noeud n : f(n) = False				*/
/* retourne le noeud sur lequel le parcours s'est arrete, NULL si l'arbre entier a 	*/
/* ete parcouru								*/
/* ---------------------------------------------------------------------- */
static Tagnode *ppostfix(TagTree t,boolean (*f)(Tagnode *));
#ifdef __STDC__
static Tagnode * parcours_postfix(TagTree t,boolean (*f)(Tagnode *))
#else /* __STDC__*/
static Tagnode * parcours_postfix(t,f)
TagTree t;
boolean (*f)(Tagnode *);
#endif /* __STDC__*/
{
  Tagnode *res;

  res = ppostfix(t,f);
  if (res==NULL)
    {
       if (f(t))
	return NULL;
      else
	return t;
    }
  else
    return res;
}

/* ---------------------------------------------------------------------- */
#ifdef __STDC__
static Tagnode *ppostfix(TagTree t,boolean (*f)(Tagnode *))
#else /* __STDC__*/
static Tagnode *ppostfix(t,f)
TagTree t;
boolean (*f)(Tagnode *);
#endif /* __STDC__*/
{
  Tagnode *n, *res;

  n = t->child;
  while(n!=NULL)
    {
      res = ppostfix(n,f);
      if (res==NULL)
	{
	  if (f(n))
	    n=n->next;
	  else
	    return n;
	}
      else
	return res;
    }
  return NULL;
}
/* ---------------------------------------------------------------------- */
/* export de la fonction de pattern matching */
#ifdef __STDC__
 void PatternMatching(TagTree t)
#else /* __STDC__*/
 void PatternMatching(t)
TagTree t;
#endif /* __STDC__*/
{
  parcours_postfix(t,matchnode);
}
