#include "riskview.h"

main(int argc,char** argv)
{
  int n,otype,stype,itype,ctype,ostyle;
  double spot,strike,r,correlation,sigma,
  delta,T,q,oprice,income;
  char* b = new char[80];
  char* c = new char[80];
  ifstream s(argv[1]);
  s.getline(b,80);
  if (strcmp(b,"option")==0) {
    while(1==1) {
      s.getline(b,80);
      c = strtok(b,":");
      if (c==NULL) break;
      n = strlen(c);
      for(int i=0; i<n; ++i) {
        c[i] = tolower(c[i]);
      }
      if (strcmp(c,"spot price")==0) {
        c = strtok(NULL,":");
        spot = atof(c);
      }
      else if(strcmp(c,"strike price")==0) {
        c = strtok(NULL,":");
        strike = atof(c);
      }
      else if(strcmp(c,"style")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          c[i] = tolower(c[i]);
        }
        if (strcmp(c,"european")==0) {
	  ostyle = 0;
	}
        else {
          ostyle = 1;
        }
      }
      else if(strcmp(c,"type")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          c[i] = tolower(c[i]);
        }
        if (strcmp(c,"call")==0) {
	  otype = 0;
	}
        else {
          otype = 1;
        }
      }
      else if (strcmp(c,"calculation")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          c[i] = tolower(c[i]);
        }
        if (strcmp(c,"price")==0) {
	  ctype = 0;
	}
        else {
          ctype = 1;
        }
      }
      else if(strcmp(c,"annual dividend")==0) {
        c = strtok(NULL,":");
	delta = atof(c)/100.0;
      }
      else if(strcmp(c,"correlation")==0) {
        c = strtok(NULL,":");
        if (c != NULL) correlation = atof(c);
      }
      else if(strcmp(c,"volatility")==0) {
        c = strtok(NULL,":");
        if (c != NULL) sigma = atof(c);
      }
      else if(strcmp(c,"expiry")==0) {
        c = strtok(NULL,":");
        T = atof(c);
      }
      else if(strcmp(c,"option price")==0) {
        c = strtok(NULL,":");
        if (c != NULL) oprice = atof(c);
      }
      else if(strcmp(c,"risk-free interest rate")==0) {
        c = strtok(NULL,":");
        r = atof(c)/100.0;
      }
      else if(strcmp(c,"stochastic interest rates")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          c[i] = tolower(c[i]);
        }
        if (strcmp(c,"no")==0) {
	  itype = 0;
	}
        else {
          itype = 1;
        }
      }
      else if(strcmp(c,"stochastic volatility")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          c[i] = tolower(c[i]);
        }
        if (strcmp(c,"no")==0) {
	  stype = 0;
	}
        else {
          stype = 1;
        }
      }
    }
    // Now do the calculations by calling the right function and
    // outputting its return value(s) to the display screen
    if (ostyle==0) {
      // It's a European-style option
      if (stype==0 && itype==0) {
        // The basic Black-Scholes model
        if (ctype==0) {
          // OK, calculate the price and hedge sensitivity
	  // parameters
          euro(spot,strike,r,delta,T,sigma,otype);
	}
        else {
	  // It's an implied volatility calculation...
          euro_implied(spot,strike,r,delta,T,oprice,otype);
	}
      }
      else {
	// We need to use the Monte Carlo methods here
        if (ctype==0) {
          // OK, calculate the price and hedge sensitivity
	  // parameters
          mcarlo1(spot,strike,r,delta,T,sigma,otype,itype,correlation,
          stype);
	}
        else {
	  // It's an implied volatility calculation...
          mcarlo_implied(spot,strike,r,delta,T,oprice,otype,itype,
          correlation,stype);
	}
      }
    }
    else {
      // It's an American option
      if (ctype==0) {
        // OK, calculate the price and hedge sensitivity
	// parameters
        usa(spot,strike,r,delta,T,sigma,otype);
      }
      else {
	// It's an implied volatility calculation...
        usa_implied(spot,strike,r,delta,T,oprice,otype);
      }
    }
  }
  else if (strcmp(b,"future")==0) {
    while(1==1) {
      s.getline(b,80);
      c = strtok(b,":");
      if (c==NULL) break;
      n = strlen(c);
      for(int i=0; i<n; ++i) {
        c[i] = tolower(c[i]);
      }
      if (strcmp(c,"spot price")==0) {
        c = strtok(NULL,":");
        spot = atof(c);
      }
      else if(strcmp(c,"delivery price")==0) {
        c = strtok(NULL,":");
        strike = atof(c);
      }
      else if(strcmp(c,"risk-free interest rate")==0) {
        c = strtok(NULL,":");
        r = atof(c);
      }
      else if(strcmp(c,"time to expiry")==0) {
        c = strtok(NULL,":");
        T = atof(c);
      }
      else if(strcmp(c,"annual yield")==0) {
        c = strtok(NULL,":");
        q = atof(c);
      }
      else if(strcmp(c,"present value of known income")==0) {
        c = strtok(NULL,":");
        income = atof(c);
      }
    }
    futures(r,strike,spot,T,q,income);
  }
  else if (strcmp(b,"warrant")==0) {
    while(1==1) {
      s.getline(b,80);
      c = strtok(b,":");
      if (c==NULL) break;
      n = strlen(c);
      for(int i=0; i<n; ++i) {
        c[i] = tolower(c[i]);
      }
      if (strcmp(c,"share price")==0) {
        c = strtok(NULL,":");
        spot = atof(c);
      }
      else if(strcmp(c,"exercise price")==0) {
        c = strtok(NULL,":");
        strike = atof(c);
      }
      else if(strcmp(c,"warrant price")==0) {
        c = strtok(NULL,":");
        r = atof(c);
      }
      else if(strcmp(c,"time to maturity")==0) {
        c = strtok(NULL,":");
        T = atof(c);
      }
    }
    warrants(spot,strike,r,T);
  }
  else if (strcmp(b,"bond")==0) {
    double pvalue,coupon;
    int ptype,cbond,conv;
    
    while(1==1) {
      s.getline(b,80);
      c = strtok(b,":");
      if (c==NULL) break;
      n = strlen(c);
      for(int i=0; i<n; ++i) {
        c[i] = tolower(c[i]);
      }
      if (strcmp(c,"par value")==0) {
        c = strtok(NULL,":");
        pvalue = atof(c);
      }
      else if(strcmp(c,"coupon")==0) {
        c = strtok(NULL,":");
        coupon = atof(c);
      }
      else if(strcmp(c,"style")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          c[i] = tolower(c[i]);
        }
        if (strcmp(c,"convertible")==0) {
          cbond = 0;
        }
	else {
          cbond = 1;
	}
      }
      else if(strcmp(c,"payment type")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          c[i] = tolower(c[i]);
        }
        if (strcmp(c,"annual")==0) {
          ptype = 0;
        }
	else {
          ptype = 1;
	}
      }
      else if(strcmp(c,"time to maturity")==0) {
        c = strtok(NULL,":");
        T = atof(c);
      }
      else if(strcmp(c,"conversion ratio")==0) {
        c = strtok(NULL,":");
        if (c != NULL) conv = atoi(c);
      }
      else if(strcmp(c,"share price")==0) {
        c = strtok(NULL,":");
        if (c != NULL) spot = atof(c);
      }
      else if(strcmp(c,"volatility")==0) {
        c = strtok(NULL,":");
        if (c != NULL) sigma = atof(c);
      }
      else if(strcmp(c,"dividend")==0) {
        c = strtok(NULL,":");
        if (c != NULL) delta = atof(c);
      }
      else if(strcmp(c,"risk-free interest rate")==0) {
        c = strtok(NULL,":");
        r = atof(c);
      }
    }
    if (cbond==0) {
      cbond1(pvalue,coupon,spot,T,r,sigma,delta,conv,ptype);
    }
    else {
      sbond(pvalue,coupon,T,r,ptype);
    }
  }
  else if (strcmp(b,"neural net creation")==0) {
    int nin,nout,nhidden,al_type,nexem,npop,ngen;
    char* tfile = new char[20];
    char* ofile = new char[20];
    while(1==1) {
      s.getline(b,80);
      c = strtok(b,":");
      if (c==NULL) break;
      n = strlen(c);
      for(int i=0; i<n; ++i) {
        c[i] = tolower(c[i]);
      }
      if (strcmp(c,"input nodes")==0) {
        c = strtok(NULL,":");
        nin = atoi(c);
      }
      else if(strcmp(c,"output nodes")==0) {
        c = strtok(NULL,":");
        nout = atoi(c);
      }
      else if(strcmp(c,"hidden layer nodes")==0) {
        c = strtok(NULL,":");
        nhidden = atoi(c);
      }
      else if(strcmp(c,"learning algorithm")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          c[i] = tolower(c[i]);
        }
        if (strcmp(c,"genetic")==0) {
          al_type = 0;
        }
	else {
          al_type = 1;
	}
      }
      else if(strcmp(c,"number of examples")==0) {
        c = strtok(NULL,":");
        nexem = atoi(c);
      }
      else if(strcmp(c,"population")==0) {
        c = strtok(NULL,":");
        npop = atoi(c);
      }
      else if(strcmp(c,"generations")==0) {
        c = strtok(NULL,":");
        ngen = atoi(c);
      }
      else if(strcmp(c,"training file")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          tfile[i] = c[i];
	}
      }
      else if(strcmp(c,"output file")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          ofile[i] = c[i];
	}
      }
    }
    neural_create(nin,nout,nhidden,nexem,tfile,al_type,npop,
    ngen,ofile);
    delete[] tfile;
    delete[] ofile;
  }
  else if (strcmp(b,"neural net prediction")==0) {
    char* nfile = new char[20];
    char* ifile = new char[20];
    while(1==1) {
      s.getline(b,80);
      c = strtok(b,":");
      if (c==NULL) break;
      n = strlen(c);
      for(int i=0; i<n; ++i) {
        c[i] = tolower(c[i]);
      }
      if (strcmp(c,"input file")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          ifile[i] = c[i];
	}
      }
      else if(strcmp(c,"net file")==0) {
        c = strtok(NULL," ");
        n = strlen(c);
        for(int i=0; i<n; ++i) {
          nfile[i] = c[i];
	}
      }
    }
    neural_predict(ifile,nfile);
  }
  else {
    cerr << "incorrect file format, exiting..." << endl;
    exit(2);
  }
}  




