#include "riskview.h"

double* neural_commence(int nin,int nout,int nhidden,int nexem,int ngen,
int npool,int al_type,double* exemplar)
{
  double* weights = new double[nhidden*(nout+nin)];
    
  if (al_type==0) {
    learn_genetic(nin, nhidden, nout, nexem, exemplar, weights, 
    ngen, npool);
  }
  else {
    learn_agoric(nin, nhidden, nout, nexem, exemplar, weights, 
    ngen, npool);
  }
  return weights;
}

double mcarlo(double t,double sigma,double r,double K,double S,
double delta,int optype,int itype,double rho,int vtype)
{
  double output;
  if (itype == 1) {
    if (vtype == 1) {
      output = mcarlo_vv(K,S,r,delta,t,sigma,optype,rho);
    }
    else {
      output = mcarlo_vc(K, S, r, delta, t, sigma, optype, rho);
    }
  }
  else {
    output = mcarlo_cv(K, S, r, delta, t, sigma, optype);
  }
  return output;
}

double mcarlo_cv(double K,double S,double r,double delta,double 
t,double sigma,int i)
{
  double dt,error,zeta,nudt,sdt,avg1,avg2,result1,c1,c2,
  result2,test,payout,stdev,temp,ct,eps1,eps2,temp2;
  int N,m,k1,j,flag,count;
  
  dt = 0.005;
  zeta = 0.2;
  error = 0.05;
  m = 100;
  N = (int) (t/dt);

  double* S1 = new double[N+1];
  double* S2 = new double[N+1];
  double* Sigma = new double[N+1];

  flag = 0;
  count = 0;
  S1[0] = S;
  S2[0] = S;
  Sigma[0] = sigma;
  nudt = exp((r - delta) * dt);
  sdt = sqrt(dt);
  c1 = exp(-r * t);
  c2 = exp(-2.0 * r * t);
  avg1 = 0.0;
  avg2 = 0.0;
  
  while (flag == 0) {
    count++;
    for(k1=0; k1<m; ++k1) {
      for(j=0; j<N; ++j) { 
        eps1 = snorm();
        eps2 = snorm();
        Sigma[j + 1] = exp(zeta * eps2 * sdt) * Sigma[j];
        temp = exp(Sigma[j + 1] * sdt * eps1);
        temp2 = exp(-0.5 * Sigma[j + 1] * Sigma[j + 1] * dt);
        S1[j + 1] = S1[j] * nudt * temp2 * temp;
        S2[j + 1] = S2[j] * nudt * temp2 / temp;
      }
      result1 = payoff(S1[N], K, i);
      result2 = payoff(S2[N], K, i);
      ct = 0.5 * (result1 + result2);
      avg1 = avg1 + ct;
      avg2 = avg2 + ct * ct;
    }
    payout = avg1/double(m*count)*c1;
    stdev = sqrt((avg2 - avg1 * avg1 /double(m * count)) * 
            c2 /double(m * count - 1));
    test = stdev/sqrt(m * count);
    if (test < error) {
      flag = 1;
    }
  }
  delete[] S1;
  delete[] S2;
  delete[] Sigma;
  return payout;
}

double mcarlo_vv(double K,double S,double r,double delta,double
t,double sigma,int i,double rho)
{
  double dt,error,zeta,nudt,sdt,avg1,avg2,result1,c1,r2,
  result2,test,payout,stdev,temp1,ct,eps1,eps2,temp2,eps3,temp3;
  int N,m,k1,j,flag,count;

  dt = 0.005;
  zeta = 0.2;
  error = 0.05;
  m = 100;
  N = (int) (t/dt);
  
  double* S1 = new double[N+1];
  double* S2 = new double[N+1];
  double* Sigma = new double[N+1];
  double* ir = new double[N+1];

  flag = 0;
  count = 0;
  S1[0] = S;
  S2[0] = S;
  Sigma[0] = sigma;
  ir[0] = r;
  nudt = exp(-delta*dt);
  sdt = sqrt(dt);
  r2 = sqrt(1.0-rho*rho);
  avg1 = 0.0;
  avg2 = 0.0;

  while(flag == 0) {
    count++;
    for(k1=0; k1<m; ++k1) {
      c1 = 1.0; 
      for(j=0; j<N; ++j) { 
        eps1 = snorm();
        eps2 = snorm();
        eps3 = snorm();
        temp1 = rho * eps1 + r2 * eps3;
        Sigma[j + 1] = exp(zeta * eps2 * sdt) * Sigma[j];
        ir[j + 1] = ir[j]+sig2*sqrt(dt*ir[j])*temp1+alpha*(r-ir[j])*dt;
        temp1 = exp(Sigma[j + 1] * sdt * eps1);
        temp2 = exp(ir[j + 1] * dt);
        temp3 = exp(-0.5 * Sigma[j + 1] * Sigma[j + 1] * dt);
        S1[j + 1] = S1[j] * nudt * temp3 * temp2 * temp1;
        S2[j + 1] = S2[j] * nudt * temp3 * temp2 / temp1;
        c1 = c1 * temp2;
      }
      result1 = payoff(S1[N], K, i);
      result2 = payoff(S2[N], K, i);
      ct = 0.5 * (result1 + result2);
      avg1 = avg1 + ct/c1;
      avg2 = avg2 + ct * ct/(c1*c1);
    }
    payout = avg1/(m*count);
    stdev = sqrt((avg2-avg1*avg1/(count*m)) * 
            1.0/ (m*count - 1));
    test = stdev/sqrt(m*count);
    if (test<error) {
      flag = 1;
    }
  }
  delete[] S1;
  delete[] S2;
  delete[] Sigma;
  delete[] ir;
  return payout;
}

double mcarlo_vc(double K,double S,double r,double delta,double t,
double sigma,int i,double rho)
{
  double dt,error,zeta,nudt,sdt,avg1,avg2,result1,c1,sigsdt,
  result2,test,payout,stdev,temp1,ct,eps1,eps2,temp2,r2;
  int N,m,k1,j,flag,count;
  
  dt = 0.005;
  zeta = 0.2;
  error = 0.05;
  m = 100;
  N = (int) (t/dt);
  
  double* S1 = new double[N+1];
  double* S2 = new double[N+1];
  double* ir = new double[N+1];

  flag = 0;
  count = 0;
  S1[0] = S;
  S2[0] = S;
  ir[0] = r;
  sigsdt = sigma*sdt;
  nudt = exp(-(delta+0.5*sigma*sigma)*dt);
  sdt = sqrt(dt);
  r2 = sqrt(1.0-rho*rho);
  avg1 = 0.0;
  avg2 = 0.0;

  while (flag == 0) {
    count++;
    for(k1=0; k1<m; ++k1) {
      c1 = 1.0; 
      for(j=0; j<N; ++j) { 
        eps1 = snorm();
        eps2 = snorm();
        temp1 = rho*eps1+r2*eps2;
        ir[j + 1] = ir[j]+sig2*sqrt(dt*ir[j])*temp1+alpha*(r-ir[j])*dt;
        temp1 = exp(sigsdt*eps1);
        temp2 = exp(ir[j+1] * dt);
        S1[j + 1] = S1[j] * nudt * temp2 * temp1;
        S2[j + 1] = S2[j] * nudt * temp2 / temp1;
        c1 = c1*temp2;
      }
      result1 = payoff(S1[N], K, i);
      result2 = payoff(S2[N], K, i);
      ct = 0.5 * (result1 + result2);
      avg1 = avg1 + ct/c1;
      avg2 = avg2 + ct * ct/(c1*c1);
    }
    payout = avg1/(m*count);
    stdev = sqrt((avg2 - avg1 * avg1 / (m * count)) * 
            1.0/ (m * count - 1));
    test = stdev/sqrt(m * count);
    if (test < error) {
      flag = 1;
    }
  }
  delete[] S1;
  delete[] S2;
  delete[] ir;
  return payout;
}

void euro(double K,double S,double r,double dividend,double T,double
sigma,int otype)
{
  double output[6],ds,dT,dS,dr,temp1;
  double val1,val2,val3,val4,val5,val6;

  dS = eps*S;
  dr = eps*r;
  dT = eps*T;
  ds = eps*sigma;
  temp1 = S-dS;

  val1 = solver_euro(T,sigma,r,K,S,dividend,otype);
  val2 = solver_euro(T,sigma,r,K,temp1,dividend,otype);
  temp1 = S+dS;
  val3 = solver_euro(T,sigma,r,K,temp1,dividend,otype);
  temp1 = T-dT;
  val4 = solver_euro(temp1,sigma,r,K,S,dividend,otype);
  temp1 = sigma-ds;
  val5 = solver_euro(T,temp1,r,K,S,dividend,otype);
  temp1 = r-dr;
  val6 = solver_euro(T,sigma,temp1,K,S,dividend,otype);

  output[0] = val1;   
  output[1] = (val3-val2)/(2.0*dS);
  output[2] = (val3-2.0*val1+val2)/(dS*dS);
  output[3] = (val1-val4)/dT;
  output[4] = (val1-val5)/ds;
  output[5] = (val1-val6)/dr;

  cout << "The theoretical value of the option is " << output[0] << endl;
  cout << "The gamma is " << output[1] << endl;
  cout << "The delta is " << output[2] << endl;
  cout << "The theta is " << output[3] << endl;
  cout << "The vega is " << output[4] << endl;
  cout << "The rho is " << output[5] << endl;
}

void euro_implied(double K,double S,double r,double dividend,double T,
double oprice,int otype)
{
  double ds,vol1,temp1,temp2,test,d1;
  int flag,count;

  flag = 0;
  vol1 = 0.2;
  count = 0;
  ds = eps*vol1;

  while(flag==0) {
     count++;
     temp1 = solver_euro(T,vol1,r,K,S,dividend,
             otype)-oprice;
     temp2 = solver_euro(T,vol1-ds,r,K,S,dividend,
             otype)-oprice;
     d1 = (temp1-temp2)/ds;
     test = vol1 - temp1/d1;
     if (fabs(test-vol1) < eps) {
       flag = 1;
     }
     if (count > 10) {
       flag = 1;
       cerr << "Unable to solve equation for volatility" << endl;
       exit(2);
     }
     vol1 = test;
  }
  cout << "The implied volatility is " << vol1 << endl;
}

void usa(double K,double S,double r,double dividend,double T,double
sigma,int otype)
{
  double output[6],ds,dT,dS,dr;
  double val1,val2,val3,val4,val5,val6;

  dS = eps*S;
  dr = eps*r;
  dT = eps*T;
  ds = eps*sigma;

  val1 = solver_usa(T,sigma,r,K,S,dividend,otype);
  val2 = solver_usa(T,sigma,r,K,S-dS,dividend,otype);
  val3 = solver_usa(T,sigma,r,K,S+dS,dividend,otype);
  val4 = solver_usa(T-dT,sigma,r,K,S,dividend,otype);
  val5 = solver_usa(T,sigma-ds,r,K,S,dividend,otype);
  val6 = solver_usa(T,sigma,r-dr,K,S,dividend,otype);

  output[0] = val1;   
  output[1] = (val3-val2)/(2.0*dS);
  output[2] = (val3-2.0*val1+val2)/(dS*dS);
  output[3] = (val1-val4)/dT;
  output[4] = (val1-val5)/ds;
  output[5] = (val1-val6)/dr;

  cout << "The theoretical value of the option is " << output[0] << endl;
  cout << "The gamma is " << output[1] << endl;
  cout << "The delta is " << output[2] << endl;
  cout << "The theta is " << output[3] << endl;
  cout << "The vega is " << output[4] << endl;
  cout << "The rho is " << output[5] << endl;

}

void usa_implied(double K,double S,double r,double dividend,double T,
double oprice,int otype)
{
  double ds,vol1,temp1,temp2,test,d1;
  int flag,count;

  flag = 0;
  vol1 = 0.2;
  count = 0;
  ds = eps*vol1;

  while(flag==0) {
     count++;
     temp1 = solver_usa(T,vol1,r,K,S,dividend,
             otype)-oprice;
     temp2 = solver_usa(T,vol1-ds,r,K,S,dividend,
             otype)-oprice;
     d1 = (temp1-temp2)/ds;
     test = vol1 - temp1/d1;
     if (fabs(test-vol1) < eps) {
       flag = 1;
     }
     if (count > 10) {
       flag = 1;
       cerr << "Unable to solve equation for volatility" << endl;
       exit(2);
     }
     vol1 = test;
  }
  cout << "The implied volatility is " << vol1 << endl;
}

void mcarlo1(double K,double S,double r,double dividend,double T,double
sigma,int otype,int itype,double cor,int vtype)
{
  double output[6],ds,dT,dS,dr;
  double val1,val2,val3,val4,val5,val6;
  long seed1,seed2;

  dS = eps*S;
  dr = eps*r;
  dT = eps*T;
  ds = eps*sigma;

  seed1 = 31415926;
  seed2 = time(NULL);
  setall(seed1,seed2);

  val1 = mcarlo(T,sigma,r,K,S,dividend,otype,itype,cor,vtype);
  val2 = mcarlo(T,sigma,r,K,S-dS,dividend,otype,itype,cor,vtype);
  val3 = mcarlo(T,sigma,r,K,S+dS,dividend,otype,itype,cor,vtype);
  val4 = mcarlo(T-dT,sigma,r,K,S,dividend,otype,itype,cor,vtype);
  val5 = mcarlo(T,sigma-ds,r,K,S,dividend,otype,itype,cor,vtype);
  val6 = mcarlo(T,sigma,r-dr,K,S,dividend,otype,itype,cor,vtype);

  output[0] = val1;   
  output[1] = (val3-val2)/(2.0*dS);
  output[2] = (val3-2.0*val1+val2)/(dS*dS);
  output[3] = (val1-val4)/dT;
  output[4] = (val1-val5)/ds;
  output[5] = (val1-val6)/dr;

  cout << "The theoretical value of the option is " << output[0] << endl;
  cout << "The gamma is " << output[1] << endl;
  cout << "The delta is " << output[2] << endl;
  cout << "The theta is " << output[3] << endl;
  cout << "The vega is " << output[4] << endl;
  cout << "The rho is " << output[5] << endl;

}

void mcarlo_implied(double K,double S,double r,double dividend,double T,
double oprice,int otype,int itype,double cor,int vtype)
{
  double ds,vol1,temp1,temp2,test,d1;
  int flag,count;

  flag = 0;
  vol1 = 0.2;
  count = 0;
  ds = eps*vol1;

  long seed1 = time(NULL);
  long seed2 = 31415926;
  setall(seed1,seed2);

  while(flag==0) {
     count++;
     temp1 = mcarlo(T,vol1,r,K,S,dividend,
             otype,itype,cor,vtype)-oprice;
     temp2 = mcarlo(T,vol1-ds,r,K,S,dividend,
             otype,itype,cor,vtype)-oprice;
     d1 = (temp1-temp2)/ds;
     test = vol1 - temp1/d1;
     if (fabs(test-vol1) < eps) {
       flag = 1;
     }
     if (count > 10) {
       flag = 1;
       cerr << "Unable to solve equation for volatility" << endl;
       exit(2);
     }
     vol1 = test;
  }
  cout << "The implied volatility is " << vol1 << endl;
}

void neural_create(int nin,int nout,int nhidden,int nexem,char* training_file,
int al_type,int npop,int ngen,char* ofile)
{
  double* exemplar = new double[nexem*(nin+nout)];
  double* weights = new double[nhidden*(nout+nin)];
  double* maxin = new double[nin];
  double* minin = new double[nin];
  double* maxout = new double[nout];
  double* minout = new double[nout];
  int i,j;
  char* b = new char[80];
  char* c = new char[80];
  double err;

  ifstream s(training_file);
  if (s.bad()) {
    cerr << "Training file not found, exiting..." << endl;
    exit(8);
  }

  for(i=0; i<nin; ++i) {
    s.getline(b,80);
    c = strtok(b,",");
    maxin[i] = atof(c);
    c = strtok(NULL,",");
    minin[i] = atof(c);
  }

  for(i=0; i<nout; ++i) {
    s.getline(b,80);
    c = strtok(b,",");
    maxout[i] = atof(c);
    c = strtok(NULL,",");
    minout[i] = atof(c);
  }

  for(i=0; i<nexem; ++i) {
    s.getline(b,80);
    c = strtok(b,",");
    for(j=0; j<(nin+nout); ++j) {
      exemplar[i*(nin + nout)+j] = atof(c);
      strtok(NULL,",");
    }
  }
  s.close();

  for(i=0; i<nexem; ++i) {
    for(j=0; j<nin; ++j) {
      exemplar[i*(nin + nout)+j] = (exemplar[i*(nin + nout)+j]-
                                   minin[j])/(maxin[j]-minin[j]); 
    }
    for(j=nin; j<(nin+nout); ++j) {
      exemplar[i*(nin + nout)+j] = (exemplar[i*(nin + nout)+j]-
                                   minout[j-nin])/(maxout[j-nin]-
                                   minout[j-nin]); 
    }
  }

  weights = neural_commence(nin,nout,nhidden,nexem,ngen,
            npop,al_type,exemplar);

  ofstream r(ofile);
  r << nin << endl;
  r << nhidden << endl;
  r << nout << endl;
  for(i=0; i<nin; ++i) {
    r << maxin[i] << endl;
    r << minin[i] << endl;
  }
  for(i=0; i<nout; ++i) {
    r << maxout[i] << endl;
    r << minout[i] << endl;
  }
  for(i=0; i<nin; ++i) {
    for(j=0; j<nhidden; ++j) {
      r << weights[i * nhidden + j] << endl;
    }
  }
  for(i=0; i<nhidden; ++i) {
    for(j=0; j<nout; ++j) {
      r << weights[nin * nhidden + i * nout + j] << endl;;
    }
  }
  err = fitness(weights, exemplar, nin, nout, nhidden, nexem);
  r.close();
  cout << "Evolution complete, average error remaining is " << err << endl;
  delete[] exemplar;
  delete[] weights;
  delete[] maxin;
  delete[] minin;
  delete[] maxout;
  delete[] minout;
  delete[] b;
  delete[] c;
}

/*
double tanh(double x)
{
  double output,temp;
  temp = exp(x);
  output = (temp - 1.0/temp)/(temp + 1.0/temp);
  return output;
}
*/

void praedicere(int nin,int nhidden,int nout,double* weights,
double* input1,double* out)
{
  int kount,i,j,maxrow,index,layer[3],lower[2];
  double lambda,accum_input;
  lambda = 0.5;
  
  if (nin >= nout) {
    if (nin >= nhidden) {
      maxrow = nin;
    }
    else {
      maxrow = nhidden;
    }
  }
  else {
    if (nout >= nhidden) {
      maxrow = nout;
    }
    else {
      maxrow = nhidden;
    }
  }
  double stimulus[3][maxrow];
  for(i=0; i<nin; ++i) {
    stimulus[0][i] = input1[i];
  }
  layer[0] = nin;
  layer[1] = nhidden;
  layer[2] = nout;
  lower[0] = 0;
  lower[1] = nin * nhidden;
  
  for(kount=0; kount<2; ++kount) {
    for(i=0; i<layer[kount]; ++i) {
      accum_input = 0.0;
      for(j=0; j<layer[kount+1]; ++j) {
         index = j + layer[kount + 1]*i + lower[kount];
         accum_input = accum_input + 
                       weights[index]*stimulus[kount][j];
      }
      stimulus[kount + 1][i] = tanh(lambda*accum_input);
    }
  }
   
  for(i=0; i<nout; ++i) {
     out[i] = stimulus[2][i];
  }
}

void neural_predict(char* ifile,char* nfile)
{
  int i,j,nout,nin,nhidden;
  char* c = new char[80];

  ifstream s(nfile);
  if (s.bad()) {
    cerr << "Neural net file not found" << endl;
    exit(8);
  }

  s >> nin;
  s >> nhidden;
  s >> nout;

  double* maxin = new double[nin];
  double* maxout = new double[nout];
  double* minin = new double[nin];
  double* minout = new double[nout];
  double* weights = new double[nhidden*(nout+nin)];
  double* input1 = new double[nin];
  double* out = new double[nout];
  
  for(i = 0; i<nin; ++i) {
    s >> maxin[i];
    s >> minin[i];
  }

  for(i = 0; i<nout; ++i) {
    s >> maxout[i];
    s >> minout[i];
  }
  
  for(i=0; i<nin; ++i) {
    for(j=0; j<nhidden; ++j) {
      s >> weights[i * nhidden + j];
    }
  }
  for(i=0; i<nhidden; ++i) {
    for(j=0; j<nout; ++j) {
      s >> weights[nin * nhidden + i * nout + j];
    }
  }
  s.close();
  
  ifstream r(ifile);
  if (r.bad()) {
    cerr << "Input file not found, exiting..." << endl;
    exit(8);
  }
  for(i=0; i<nin; ++i) {
    r >> input1[i];
  }
  r.close();

  for(i = 0; i<nin; ++i) {
    input1[i] = (input1[i] - minin[i]) / (maxin[i] - minin[i]);
  }
  praedicere(nin, nhidden, nout, weights, input1, out);
  
  for(i=0; i<nout; ++i) {
    out[i] = ((maxout[i] - minout[i]) * out[i]) + minout[i];
  }
  
  for(i=0; i<nout; ++i) {
    cout << "The result for output node " << i << " is " << out[i] << endl;
  } 
  delete[] out;
  delete[] input1;
  delete[] c;
  delete[] weights;
  delete[] maxin;
  delete[] maxout;
  delete[] minin;
  delete[] minout;
}

double solver_euro(double t,double sigma,double r,double x,
double S,double delta,int optype)
{
  double d1,d2,output;
  
  d1 = 1.0 / (sigma * sqrt(t)) * (log(S / x) + (r - delta + 0.5 * 
       sigma * sigma) * t);
  d2 = d1 - sigma * sqrt(t);
  if (optype == 0) {
    output = S * exp(-delta * t) * N(d1) - x * exp(-r * t) * 
             N(d2);
  }
  else {
    output = -S * exp(-delta * t) * N(-d1) + x * exp(-r * t) * 
              N(-d2);
  }
  return output;
}

double payoff(double S,double K,int op_type)
{
  double output;
  if (op_type == 0) {
    // It's a call
    if ((S - K) > 0.0) {
      output = S - K;
    }
    else {
      output = 0.0;
    }
  }
  else {
    // It's a put
    if ((K - S) > 0.0) {
      output = K - S;
    }
    else {
      output = 0.0;
    }
  }
  return output;
}

double solver_usa(double t,double sigma,double r,double x,
double S,double delta,int optype)
{
  int m,N,i,j;
  m = 50;
  double c[2][101],St[101],pu,pd,pm,nu,dx,dt,edx,output;

  dx = 6.0 * sigma * sqrt(t) / (2.0 * m + 1.0);
  dt = 0.5 * dx * dx / (3.0 * sigma * sigma);
  edx = exp(dx);
  N = (int) (t/dt);
  nu = r - delta - 0.5 * sigma * sigma;
  pu = 0.5 * dt * ((sigma * sigma / (dx * dx)) + nu / dx);
  pd = 0.5 * dt * ((sigma * sigma / (dx * dx)) - nu / dx);
  pm = 1.0 - dt * sigma * sigma / (dx * dx) - r * dt;
  St[0] = S * exp(-m * dx);
  for(j=-m+1; j<=m; ++j) {
    St[m + j] = St[m + j - 1] * edx;
  }
  for(j=-m; j<=m; ++j) { 
    if (optype == 0) { 
      c[0][m + j] = maximum(0.0, St[m + j] - x);
    }
    else {
      c[0][m + j] = maximum(0.0, x - St[m + j]);
    }
  }
  for(i=N-1; i>=0; --i) {
    for(j=-m+1; j<=m-1; ++j) {
      c[1][m + j] = pu * c[0][m + j + 1] + pm * c[0][m + j] + 
                    pd * c[0][m + j - 1];
    }
    c[1][0] = c[0][0] + St[1] - St[0];
    c[1][2 * m] = c[1][2 * m - 1];
    for(j=-m; j<=m-1; ++j) {
      if (optype == 0) {
        c[0][m + j] = maximum(c[1][j + m], St[m + j] - x);
      }
      else {
        c[0][m + j] = maximum(c[1][j + m], x - St[m + j]);
      }
    }
  }
  output = c[0][m];
  return output;
}

double maximum(double x,double y)
{
  double output;
  if ((x - y) >= 0.0) {
    output = x;
  }
  else {
    output = y;
  }
  return output;
}

double N(double x)
{
  double a1,a2,a3,K,output;
  a1 = 0.4361836;
  a2 = -0.1201676;
  a3 = 0.937298;
  K = 1.0 / (1.0 + 0.33267 * x);
  if (x >= 0.0) {
    output = 1.0 - (a1 * K + a2 * K * K + a3 * K * K * K) * 
             exp(-x * x / 2.0) / sqrt(2.0 * 3.1419527);
  }
  else {
    output = 1.0 - N(-x);
  }
  return output;
}

void futures(double r,double K,double S,double t,double q,
double i)
{
  double output[2];

  output[0] = S * exp(-q * t / 100.0) - K * exp(r * t / 100.0);
  output[1] = S * exp((r - q) * t / 100.0);
  cout << "The value of the forward contract is " << output[0] << endl;
  cout << "The forward price is " << output[1] << endl;
}

void warrants(double sprice,double eprice,double wprice,double 
t)
{
  double* output = new double[4];

  output[0] = maximum(sprice-eprice,0.0);    // intrinsic value
  output[1] = maximum(wprice-output[0],0.0); // time value
  output[2] = sprice/wprice;                 // leverage
  output[3] = maximum(wprice+eprice-sprice,0.0)/sprice; // premium
  cout << "The intrinsic value is " << output[0] << endl;
  cout << "The time value is " << output[1] << endl;
  cout << "The leverage is " << output[2] << endl;
  cout << "The premium is " << output[3] << endl;
}
  
void cbond1(double par,double coupon,double spot,double t,double 
r,double sigma,double delta,int c_ratio,int ptype)
{
  double rmod,sum,bprice,wp,bterm,cbfinal;
  int i,N;

  if (ptype==1) coupon = coupon/2.0;
   
  bterm = par/double(c_ratio);
  wp = solver_euro(t, sigma, r, bterm, spot, delta, 0);
  sum = 0.0;
  N = (int) (t * (ptype + 1));
  if (ptype == 0) {
    rmod = r;
  }
  else {
    rmod = r / 2.0;
  }
  
  for(i=1; i<=N; ++i) {
    sum = sum + 1.0/pow(1.0 + rmod,i);
  }
    
  bprice = (coupon * par * sum) + (par /pow(1.0 + rmod,N));
  cbfinal = wp + (bprice / par) * 100.0;
  cout << "The theoretical price of the bond is " << cbfinal << endl;
}

void sbond(double par,double coupon,double t,double r,int ptype)
{
  int i,N;
  double sum,rmod,cbfinal,bprice;
  if (ptype == 1) coupon = coupon / 2.0;
 
  sum = 0.0;
  N = (int) (t*(ptype+1));
   
  if (ptype == 0) {
    rmod = r;
  }
  else {
    rmod = r / 2.0;
  }
   
  for(i=1; i<=N; ++i) {
    sum = sum + 1.0 /pow(1.0 + rmod,i);
  }
    
  bprice = (coupon * par * sum) + (par /pow(1.0 + rmod,N));
  cbfinal = (bprice / par) * 100.0;
  cout << "The theoretical price of the bond is " << cbfinal << endl;
}

void predict1(double* weights,double* input1,double** stimulus,
int nin,int nout,int nhidden)
{

  int index,i,j,kount,layer[3],lower[2];
  double lambda,accum_input;

  lambda = 0.5;
  
  for(i=0; i<nin; ++i) {
    stimulus[0][i] = input1[i];
  }
  layer[0] = nin;
  layer[1] = nhidden;
  layer[2] = nout;
  lower[0] = 0;
  lower[1] = nin * nhidden;
  for(kount=0; kount<2; ++kount) {
    for(i=0; i<layer[kount]; ++i) {
      accum_input = 0.0;
      for(j=0; j<layer[kount + 1]; ++j) {
         index = j + layer[kount + 1] * i + lower[kount];
         accum_input = accum_input + weights[index] * 
                       stimulus[kount][j];
      }
      stimulus[kount + 1][i] = tanh(lambda * accum_input);
    }
  }
}

void correct(double** stimulus,double* true1,double* error,
int nout)
{
  int i;
  double temp,delta;
  
  temp = 0.0;
  
  for(i=0; i<nout; ++i) {
    delta = true1[i] - stimulus[2][i];
    temp = temp + delta * delta;
  }
  *error = sqrt(temp);
}

double fitness(double* x,double* exemplar,int nin,int nout,
int nhidden,int nexem)
{
  double output,error,total_error;
  int i,j,maxrow;

  double* true1 = new double[nout];
  double* input1 = new double[nin];
  double** stimulus = new double*[3];
  
  if(nin >= nout) {
    if(nin >= nhidden) {
      maxrow = nin;
    }
    else {
      maxrow = nhidden;
    }
  }
  else {
    if(nout >= nhidden) {
      maxrow = nout;
    }
    else {
      maxrow = nhidden;
    }
  }
  for(i=0; i<3; ++i) {
    stimulus[i] = new double[maxrow];
  }
  
  total_error = 0.0;
  error = 0.0;
  for(i=0; i<nexem; ++i) {
    for(j=0; j<nin; ++j) {
      input1[j] = exemplar[i * (nin + nout) + j];
    }
    for(j=0; j<nout; ++j) {
      true1[j] = exemplar[i * (nin + nout) + nin + j];
    }
    predict1(x, input1, stimulus, nin, nout, nhidden);
    correct(stimulus,true1,&error,nout);
    total_error = total_error + error;
  }
  output = total_error/double(nexem);
  delete[] true1;
  delete[] input1;
  for(i=0; i<2; ++i) {
    delete[] stimulus[i];
  }
  delete[] stimulus;
  return output;
}  

void shuffle(int* order,int npop) {
  int i,j,temp[npop];

  for(i=0; i<npop; ++i) {
    temp[i] = i;
  }
  for(i=npop-1; i>=0; --i) {
    j = (int) (i * genunf(0.0,1.0));
    order[i] = temp[j];
    temp[j] = temp[i];
  }
}

void minimize(double* a,int* rank,int npop)
{
  double min,vestige[2*npop];
  int i,j,index;

  for(i=0; i<2*npop; ++i) {
    vestige[i] = a[i];
  }
  for(j=0; j<2*npop; ++j) {
    min = 1000.0;
    for(i=0; i<2*npop; ++i) {
      if(min > vestige[i]) {
        index = i;
        min = vestige[i];
      }
    }
    rank[j] = index;
    vestige[index] = 0.0;
  }
}

void maximize(double* a,int* rank,int npop)
{
  double max,vestige[2*npop];
  int i,j,index;

  for(i=0; i<2*npop; ++i) {
    vestige[i] = a[i];
  }
  for(j=0; j<2*npop; ++j) {
    max = 0.0;
    for(i=0; i<2*npop; ++i) {
      if(max < vestige[i]) {
        index = i;
        max = vestige[i];
      }
    }
    rank[j] = index;
    vestige[index] = 0.0;
  }
}

void breed(double** weights_pool,double** children,int links,int npop)
{
  int i,j,K;
  int* order = new int[npop];
  K = 1 + (int) ((links - 1) * genunf(0.0,1.0));
 
  shuffle(order, npop);
  for(i=0; i<npop/2; ++i) {
    for(j=0; j<K; ++j) {
      children[i][j] = weights_pool[order[i]][j];
      children[npop/2+i][j] = weights_pool[order[npop/2+i]][j];
    }
    for(j=K; j<links; ++j) {
      children[i][j] = weights_pool[order[npop/2+i]][j];
      children[npop/2+i][j] = weights_pool[order[i]][j];
    }
  }
  delete[] order;
}

void cull(double** weights_pool,double** children,double* exemplar,
int nin,int nout,int nhidden,int nexem,int npop)
{
  int j,i,links;
  double* a = new double[2*npop];
  int* rank = new int[2*npop];
  links = nhidden*(nin+nout);
  double* temp = new double[links];

  for(i=0; i<npop; ++i) {
    for(j=0; j<links; ++j) {
      temp[j] = weights_pool[i][j];
    }
    a[i] = fitness(temp, exemplar, nin, nout, nhidden, nexem);
    for(j=0; j<links; ++j) {
      temp[j] = children[i][j];
    }
    a[npop + i] = fitness(temp, exemplar, nin, nout, nhidden, nexem);
  }

  minimize(a, rank, npop);
  for(i=0; i<npop; ++i) {
    if(rank[i] < (npop - 1)) {
      for(j=0; j<links; ++j) {
        weights_pool[i][j] = weights_pool[rank[i]][j];
      }
    }
    else {
      for(j=0; j<links; ++j) {
        weights_pool[i][j] = children[rank[i]-npop/2][j];
      }
    }
  }
  delete[] a;
  delete[] rank;
  delete[] temp;
}

void mutate(double** weights_pool,int links,int npop)
{
  int i,j;
  double r;

  for(i=0; i<npop; ++i) {
    r = genunf(0.0,1.0);
    if(r <= 0.08) {
      j = (int) ((links - 1) * genunf(0.0,1.0));
      weights_pool[i][j] = genunf(0.0,1.0);
    }
  }
}

double amortize(double principal,double r,int N)
{
  double output;
  output = (principal * r * pow(1.0 + r,N)) / (pow(1.0 + r,N) - 1.0);
  return output;
}

void borrow(double* money,double* debt_payment,double irate,int* maturity,
int npop,int ngen)
{
  int br,i,term;
  double r,test;
    
  br = 0;
  term = ngen/3;
  if (term > 0) {
    for(i=0; i<npop; ++i) {
      test = amortize(money[i]/4.0,irate,term);
      r = genunf(0.0,1.0);
      if ((test < money[i]/10.0) && r < 0.2) {
        br = 1;
      }
      if (debt_payment[i] == 0.0) {
        if (br == 1) {
          debt_payment[i] = test;
          maturity[i] = term;
        }
      }
    }
  }
}

void settle(double* money,double* debt_payment,int* maturity,int npop) 
{
  int i;
  for(i=0; i<npop; ++i) {
    if (maturity[i] > 0) {
      money[i] = money[i] - debt_payment[i];
      maturity[i] = maturity[i] - 1;
    }
  }
}

void do_work(double** weights_agents,double* bids,double* money, 
double* exemplar,int nhidden,int nin,int nout,int nexem,int npop,
int* workload)
{
  double Eold,eold2,temp;
  int i,j,K,r,ntotal,ntrials; 
  ntotal = nhidden * (nin + nout);
  double* x = new double[ntotal];
  double* xnew = new double[ntotal];
  
  for(i=0; i<npop; ++i) {
    ntrials = workload[i];
    if (ntrials == 0) {
      break;
    }
    for(j=0; j<ntotal; ++j) {
      x[j] = weights_agents[i][j];
    }
    eold2 = fitness(x, exemplar, nin, nout, nhidden, nexem);
    Eold = eold2;
    money[i] = money[i] - bids[i] * double(ntrials);
    for(j=1; j<=ntrials; ++j) {
      r = int(ntotal * genunf(0.0,1.0));
      for(K=0; K<ntotal; ++K) {
        xnew[K] = x[K];
      }
      xnew[r] = genunf(0.0,1.0);
      temp = fitness(xnew, exemplar, nin, nout, nhidden, nexem);
      if (temp < eold2) {
        eold2 = temp;
        for(K=0; K<ntotal; ++K) {
          x[K] = xnew[K];
        }
      }
    }
    if (eold2 != Eold) {
      money[i] = money[i] + 100.0 * (Eold - eold2);
    }
  }
  delete[] x;
  delete[] xnew;
}

void set_bids(double* bids,double* money,int* trials_req,int* trials_recv,
int npop) 
{
  double epsilon,r;
  int i;
  
  for(i=0; i<npop; ++i) {
    epsilon = bids[i]/10.0;
    if (trials_recv[i] == trials_req[i]) {
      r = genunf(0.0,1.0);
      if (r < 0.5) {
        bids[i] = bids[i] - epsilon;
      }
    }
    else {
      r = genunf(0.0,1.0);
      if (r < 0.5) {
        bids[i] = bids[i] + epsilon;
      }
    }
    trials_req[i] = (int) (genunf(0.0,1.0) * money[i] / bids[i]);
  }
}

void learn_agoric(int nin,int nhidden,int nout,int nexem, double* 
exemplar,double* weights,int ngen,int npop)
{
  int i,j,ntemp,ntrials,remainder,flag,K;
  double bid_avge,old_bid,irate,test1;

  double** weights_agents = new double*[npop];
  for(i=0; i<npop; ++i) {
    weights_agents[i] = new double[nhidden*(nout+nin)];
  }
  double* bids = new double[npop];
  double* money = new double[npop];
  int* ranks = new int[npop];
  int* trials_req = new int[npop];
  int* trials_recv = new int[npop];
  double* debt_payment = new double[npop];
  int* maturity = new int[npop];
  int* workload = new int[npop];
  int* orders = new int[npop];
  ntemp = nhidden * (nin + nout);
  ntrials = 50 * npop;
  
  irate = 0.05;
  old_bid = 0.0;
  for(i = 0; i<npop; ++i) {
    money[i] = 100.0;
    bids[i] = 5.0 + genunf(0.0,1.0);
    debt_payment[i] = 0.0;
    maturity[i] = 0;
    old_bid = old_bid + bids[i];
    for(j = 0; j<ntemp; ++j) {
      weights_agents[i][j] = genunf(0.0,1.0);
    }
    trials_req[i] = int(2.0 * genunf(0.0,1.0));
    trials_recv[i] = (1 + trials_req[i]) % 2;
  }
  old_bid = old_bid / npop;
  
  for(i = 1; i<=ngen; ++i) {
    
    settle(money, debt_payment, maturity, npop);
    set_bids(bids, money, trials_req, trials_recv, npop);
    maximize(bids, ranks, npop);
    
    remainder = ntrials;
    bid_avge = 0.0;
    j = 0;
    flag = 0;
    while (flag == 0) {
      if (remainder >= trials_req[ranks[j]]) {
        workload[j] = trials_req[ranks[j]];
        bid_avge = bid_avge + trials_req[ranks[j]] * bids[ranks[j]];
        remainder = remainder - workload[j];
      }
      else {
        workload[j] = remainder;
        bid_avge = bid_avge + remainder * bids[ranks[j]];
        remainder = 0;
      }
      if ((remainder == 0) || (j == npop - 1)) {
        flag = 1;
      }
      ++j;
    }
    bid_avge = bid_avge / ntrials;
    for(K = j; K<npop; ++K) {
      workload[K] = 0;
    }
    
    do_work(weights_agents, bids, money, exemplar, nhidden, nin, 
    nout, nexem, npop, workload);
    
    test1 = bid_avge / old_bid;
    if (test1 >= 1.25) {
      irate = irate + 0.01;
    }
    else if (test1 < 0.75) {
      if (irate > 0.01) {
        irate = irate - 0.01;
      }
    }
    
    borrow(money, debt_payment, irate, maturity, npop, ngen - i);

    for(j = 0; j<npop; ++j) {
      if (money[j] < 1.0) {
        money[j] = 100.0;
        bids[j] = 5.0 + genunf(0.0,1.0);
        for(K = 0; K<ntemp; ++K) {
          weights_agents[j][K] = genunf(0.0,1.0);
        }
        trials_req[j] = int(2.0 * genunf(0.0,1.0));
        trials_recv[j] = (1 + trials_req[i]) % 2;
      }
    }
  }
  delete[] bids;
  delete[] money;
  delete[] ranks;
  delete[] trials_req;
  delete[] trials_recv;
  delete[] debt_payment;
  delete[] maturity;
  delete[] workload;
  delete[] orders;
  for(i=0; i<npop; ++i) {
    delete[] weights_agents[i];
  }
  delete[] weights_agents;
}

void learn_genetic(int nin,int nhidden,int nout,int nexem,double* 
exemplar,double* weights,int ngen,int npop)
{
  double test1,minimum;
  int i,j,maxrow,links,best;
  double** children = new double*[npop];
  double** weights_pool = new double*[npop];
  for(i=0; i<npop; ++i) {
    children[i] = new double[nhidden*(nout+nin)];
    weights_pool[i] = new double[nhidden*(nout+nin)];
  }
  links = nhidden * (nin + nout);
  double* temp1 = new double[links];
  double* true1 = new double[nout];
  double* input1 = new double[nin];
  for(i=0; i<links; ++i) {
    for(j=0; j<npop; ++j) { 
      weights_pool[j][i] = genunf(0.0,1.0);
    }
  }

  if (nin >= nout) {
    if (nin >= nhidden) {
      maxrow = nin;
    }
    else {
      maxrow = nhidden;
    }
  }  
  else {
    if (nout >= nhidden) {
      maxrow = nout;
    }
    else {
      maxrow = nhidden;
    }
  }    
  
  for(i=1; i<=ngen; ++i) {
    breed(weights_pool, children, links, npop);
    cull(weights_pool, children, exemplar, nin, nout, nhidden, 
    nexem, npop);
    mutate(weights_pool, links, npop);
  }
  minimum = 10000.0;
  for(i = 0; i<npop; ++i) {
    for(j = 0; j<links; ++j) {
      temp1[j] = weights_pool[i][j];
    }
    test1 = fitness(temp1, exemplar, nin, nout, nhidden, nexem);
    if (test1 <= minimum) {
      best = i;
    }
  }
  for(i = 0; i<links; ++i) {
    weights[i] = weights_pool[best][i];
  }
  delete[] temp1;
  delete[] true1;
  delete[] input1;
  for(i=0; i<npop; ++i) {
    delete[] weights_pool[i];
    delete[] children[i];
  }
  delete[] weights_pool;
  delete[] children;
}











